/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.tydic.commodity.base.bo.EstoreSkuInfoImageBo;
import com.tydic.commodity.base.bo.UccBrandAddReqBO;
import com.tydic.commodity.base.bo.UccBrandAddRspBO;
import com.tydic.commodity.base.bo.UccSpuImageBO;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.busi.api.UccBrandAddBusiService;
import com.tydic.commodity.common.ability.bo.UccSkuEditDetailInfoBo;
import com.tydic.commodity.common.atom.api.UccGoodssubjectEditAtomService;
import com.tydic.commodity.common.atom.api.UccItemEditAtomService;
import com.tydic.commodity.common.atom.bo.UccGoodssubjectEditAtomReqBO;
import com.tydic.commodity.common.atom.bo.UccGoodssubjectEditAtomRspBO;
import com.tydic.commodity.common.atom.bo.UccItemEditAtomReqBO;
import com.tydic.commodity.common.atom.bo.UccItemEditAtomRspBO;
import com.tydic.commodity.common.busi.api.UccSpuManagingeditorBusiService;
import com.tydic.commodity.common.busi.bo.UccSpuManagingeditorBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccSpuManagingeditorBusiRspBO;
import com.tydic.commodity.dao.UccBrandExtMapper;
import com.tydic.commodity.po.UccMallBrandDetaillListPO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class UccSpuManagingeditorBusiServiceImpl
implements UccSpuManagingeditorBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccSpuManagingeditorBusiServiceImpl.class);
    @Autowired
    private UccGoodssubjectEditAtomService uccGoodssubjectEditAtomService;
    @Autowired
    private UccItemEditAtomService uccItemEditAtomService;
    @Autowired
    private UccBrandExtMapper uccBrandExtMapper;
    @Autowired
    private UccBrandAddBusiService uccBrandAddBusiService;

    @Override
    public UccSpuManagingeditorBusiRspBO dealSpuManagingeditor(UccSpuManagingeditorBusiReqBO reqBO) {
        UccSpuManagingeditorBusiRspBO rspBO = new UccSpuManagingeditorBusiRspBO();
        if (!ObjectUtils.isEmpty((Object)reqBO.getEditSpuInfo().getBrandName())) {
            Long brandId = this.dealValidateBrand(reqBO.getEditSpuInfo().getBrandName(), reqBO);
            reqBO.getEditSpuInfo().setBrandId(brandId);
        }
        UccGoodssubjectEditAtomReqBO spuBusiReqBO = new UccGoodssubjectEditAtomReqBO();
        BeanUtils.copyProperties((Object)reqBO.getEditSpuInfo(), (Object)((Object)spuBusiReqBO));
        spuBusiReqBO.setOrgId(reqBO.getOrgId());
        spuBusiReqBO.setOrgName(reqBO.getOrgName());
        spuBusiReqBO.setUserId(reqBO.getUserId());
        spuBusiReqBO.setUsername(reqBO.getUsername());
        UccGoodssubjectEditAtomRspBO uccGoodssubjectEditAtomRspBO = null;
        try {
            uccGoodssubjectEditAtomRspBO = this.uccGoodssubjectEditAtomService.dealUccGoodssubjectEdit(spuBusiReqBO);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new BusinessException("8888", e2.getMessage());
        }
        if (!uccGoodssubjectEditAtomRspBO.getRespCode().equals("0000")) {
            throw new BusinessException("8888", uccGoodssubjectEditAtomRspBO.getRespDesc());
        }
        String spuMainPic = null;
        Map<Integer, List<UccSpuImageBO>> spuImgMap = null;
        if (!CollectionUtils.isEmpty((Collection)reqBO.getEditSpuInfo().getSpuImages())) {
            for (Object spuImage : reqBO.getEditSpuInfo().getSpuImages()) {
                if (spuImage.getCommodityPicType() != 1) continue;
                spuMainPic = spuImage.getCommodityPicUrl();
            }
            spuImgMap = reqBO.getEditSpuInfo().getSpuImages().stream().collect(Collectors.groupingBy(UccSpuImageBO::getCommodityPicType));
        }
        if (reqBO.getEditSpuInfo().getSkuEditInfo() != null && !reqBO.getEditSpuInfo().getSkuEditInfo().isEmpty()) {
            UccItemEditAtomReqBO skuBusiReqBO = new UccItemEditAtomReqBO();
            for (UccSkuEditDetailInfoBo each : reqBO.getEditSpuInfo().getSkuEditInfo()) {
                each.setCommodityId(reqBO.getEditSpuInfo().getCommodityId());
                each.setPreDeliverDay(reqBO.getEditSpuInfo().getPreDeliverDay());
                each.setPreOnShelveDay(reqBO.getEditSpuInfo().getPreOnShelveDay());
                each.setBrandId(reqBO.getEditSpuInfo().getBrandId());
                each.setBrandName(reqBO.getEditSpuInfo().getBrandName());
                if (CollectionUtils.isEmpty((Collection)each.getSkuImages()) || StringUtils.isEmpty((Object)spuMainPic)) continue;
                for (EstoreSkuInfoImageBo skuImage : each.getSkuImages()) {
                    if (skuImage.getCommodityPicType() != 1 || !StringUtils.isEmpty((Object)skuImage.getSkuPicUrl())) continue;
                    skuImage.setSkuPicUrl(spuMainPic);
                }
                if (CollectionUtils.isEmpty((Collection)each.getSkuImages()) || MapUtils.isEmpty(spuImgMap)) continue;
                for (EstoreSkuInfoImageBo skuImage : each.getSkuImages()) {
                    if (skuImage.getCommodityPicType() != 1 || !StringUtils.isEmpty((Object)skuImage.getSkuPicUrl())) continue;
                    skuImage.setSkuPicUrl(spuMainPic);
                }
                List detailPics = each.getSkuImages().stream().filter(e -> e.getCommodityPicType() == 2 && !StringUtils.isEmpty((Object)e.getSkuPicUrl())).collect(Collectors.toList());
                if (detailPics.size() > 0) continue;
                List<UccSpuImageBO> supDetailImages = spuImgMap.get(2);
                int i = 0;
                for (EstoreSkuInfoImageBo skuImage : each.getSkuImages()) {
                    if (skuImage.getCommodityPicType() != 2) continue;
                    skuImage.setSkuPicUrl(supDetailImages.get(i).getCommodityPicUrl());
                    ++i;
                }
            }
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)skuBusiReqBO));
            skuBusiReqBO.setSkuEditInfo(reqBO.getEditSpuInfo().getSkuEditInfo());
            skuBusiReqBO.setUserId(reqBO.getUserId());
            skuBusiReqBO.setUsername(reqBO.getUsername());
            skuBusiReqBO.setOrgId(reqBO.getEditSpuInfo().getVendorId());
            skuBusiReqBO.setOrgName(reqBO.getEditSpuInfo().getVendorName());
            UccItemEditAtomRspBO uccItemEditAtomRspBO = null;
            try {
                uccItemEditAtomRspBO = this.uccItemEditAtomService.dealUccItemEdit(skuBusiReqBO);
            }
            catch (Exception e3) {
                e3.printStackTrace();
                throw new BusinessException("8888", e3.getMessage());
            }
            if (!uccItemEditAtomRspBO.getRespCode().equals("0000")) {
                throw new BusinessException("8888", uccItemEditAtomRspBO.getRespDesc());
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private Long dealValidateBrand(String brandName, UccSpuManagingeditorBusiReqBO reqBO) {
        List mallBrandListAccurate = this.uccBrandExtMapper.getMallBrandListAccurate(brandName);
        if (CollectionUtils.isEmpty((Collection)mallBrandListAccurate)) {
            UccBrandAddReqBO brandAddReqBO = new UccBrandAddReqBO();
            brandAddReqBO.setBrandName(brandName);
            brandAddReqBO.setBrandStatus(Integer.valueOf(1));
            brandAddReqBO.setCreateOperId(reqBO.getUsername());
            UccBrandAddRspBO uccBrandAddRspBO = this.uccBrandAddBusiService.addBrand(brandAddReqBO);
            if (!"0000".equals(uccBrandAddRspBO.getRespCode())) {
                throw new BusinessException("8888", "\u5904\u7406\u54c1\u724c\u5931\u8d25\uff01" + uccBrandAddRspBO.getRespDesc());
            }
            return uccBrandAddRspBO.getBrandId();
        }
        return ((UccMallBrandDetaillListPO)mallBrandListAccurate.get(0)).getBrandId();
    }
}

