/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccCatalogsQryListAbilityService;
import com.tydic.commodity.common.ability.bo.UccCatalogsQryListAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccCatalogsQryListAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccSkuCatalogBO;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccEMdmCatalogLevelPO;
import com.tydic.commodity.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccCatalogsQryListAbilityService"})
public class UccCatalogsQryListAbilityServiceImpl
implements UccCatalogsQryListAbilityService {
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @PostMapping(value={"catalogsQry"})
    public UccCatalogsQryListAbilityRspBO catalogsQry(@RequestBody UccCatalogsQryListAbilityReqBO reqBO) {
        UccCatalogsQryListAbilityRspBO rspBO = new UccCatalogsQryListAbilityRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
            throw new BusinessException("8888", "\u5165\u53c2 skuIds \u4e0d\u80fd\u4e3a\u7a7a");
        }
        List uccSkuPoList = this.uccSkuMapper.getSkuTypeByIds(reqBO.getSkuIds());
        if (CollectionUtils.isEmpty((Collection)uccSkuPoList)) {
            throw new BusinessException("8888", "\u5165\u53c2\u5355\u54c1id\u4e0d\u5b58\u5728" + JSON.toJSONString((Object)reqBO.getSkuIds()));
        }
        ArrayList<UccSkuCatalogBO> results = new ArrayList<UccSkuCatalogBO>();
        Iterator iterator = uccSkuPoList.iterator();
        while (iterator.hasNext()) {
            UccSkuPo skuPo = (UccSkuPo)iterator.next();
            if (!ObjectUtils.isEmpty((Object)skuPo.getCommodityTypeId())) continue;
            UccSkuCatalogBO catalogBO = new UccSkuCatalogBO();
            catalogBO.setSkuId(skuPo.getSkuId());
            results.add(catalogBO);
            iterator.remove();
        }
        if (CollectionUtils.isEmpty((Collection)uccSkuPoList)) {
            rspBO.setSkuCatalogBOList(results);
            rspBO.setRespCode("0000");
            return rspBO;
        }
        List catalogIds = uccSkuPoList.stream().map(UccSkuPo::getCatalogId).distinct().collect(Collectors.toList());
        List catalogPOS = this.uccEMdmCatalogMapper.qryStrBylevel3(catalogIds);
        if (CollectionUtils.isEmpty((Collection)catalogPOS)) {
            for (UccSkuPo skuPo : uccSkuPoList) {
                UccSkuCatalogBO catalogBO = new UccSkuCatalogBO();
                catalogBO.setSkuId(skuPo.getSkuId());
                results.add(catalogBO);
            }
            rspBO.setSkuCatalogBOList(results);
            rspBO.setRespCode("0000");
            return rspBO;
        }
        Map<Long, UccEMdmCatalogLevelPO> mdmCatalogLevelPOMap = catalogPOS.stream().collect(Collectors.toMap(UccEMdmCatalogLevelPO::getL3Id, uccEMdmCatalogLevelPO -> uccEMdmCatalogLevelPO));
        for (UccSkuPo skuPo : uccSkuPoList) {
            if (!mdmCatalogLevelPOMap.containsKey(skuPo.getCatalogId())) continue;
            UccEMdmCatalogLevelPO levelPO = mdmCatalogLevelPOMap.get(skuPo.getCatalogId());
            UccSkuCatalogBO catalogBO = new UccSkuCatalogBO();
            catalogBO.setSkuId(skuPo.getSkuId());
            catalogBO.setCatalogsStr(levelPO.getL1Name() + "-" + levelPO.getL2Name() + "-" + levelPO.getL3Name());
            catalogBO.setThirdCatalogId(levelPO.getL3Id());
            results.add(catalogBO);
        }
        rspBO.setSkuCatalogBOList(results);
        rspBO.setRespCode("0000");
        return rspBO;
    }
}

