/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccInquirySpuCreateAbilityService;
import com.tydic.commodity.common.ability.bo.UccInquirySpuBO;
import com.tydic.commodity.common.ability.bo.UccInquirySpuCreateAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccInquirySpuCreateAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccInquirySpuCreateBusiService;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccInquirySpuCreateAbilityService"})
public class UccInquirySpuCreateAbilityServiceImpl
implements UccInquirySpuCreateAbilityService {
    @Autowired
    private UccInquirySpuCreateBusiService uccInquirySpuCreateBusiService;

    @PostMapping(value={"inquirySpuCreate"})
    public UccInquirySpuCreateAbilityRspBO inquirySpuCreate(@RequestBody UccInquirySpuCreateAbilityReqBO reqBO) {
        this.validate(reqBO);
        return this.uccInquirySpuCreateBusiService.dealSpuCreate(reqBO);
    }

    private void validate(UccInquirySpuCreateAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getInquirySpuBOList())) {
            throw new BusinessException("8888", "\u5165\u53c2\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UccInquirySpuBO spuBO : reqBO.getInquirySpuBOList()) {
            if (ObjectUtils.isEmpty((Object)spuBO.getAgreementPrice())) {
                throw new BusinessException("8888", "\u5165\u53c2 agreementPrice \u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)spuBO.getSalePrice())) {
                throw new BusinessException("8888", "\u5165\u53c2 salePrice \u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)spuBO.getCommodityName())) {
                throw new BusinessException("8888", "\u5165\u53c2 commodityName \u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)spuBO.getInquirySheetDetailId())) {
                throw new BusinessException("8888", "\u5165\u53c2 inquirySheetDetailId \u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!ObjectUtils.isEmpty((Object)spuBO.getSalesUnit())) continue;
            throw new BusinessException("8888", "\u5165\u53c2 salesUnit \u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

