/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccQuickOrderTypeChangeAbilityService;
import com.tydic.commodity.common.ability.bo.UccQuickOrderTypeChangeAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccQuickOrderTypeChangeAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccQuickOrderTypeChangeBusiService;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccQuickOrderTypeChangeAbilityService"})
public class UccQuickOrderTypeChangeAbilityServiceImpl
implements UccQuickOrderTypeChangeAbilityService {
    @Autowired
    private UccQuickOrderTypeChangeBusiService uccQuickOrderTypeChangeBusiService;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @PostMapping(value={"typeChange"})
    public UccQuickOrderTypeChangeAbilityRspBO typeChange(@RequestBody UccQuickOrderTypeChangeAbilityReqBO reqBO) {
        this.validate(reqBO);
        return this.uccQuickOrderTypeChangeBusiService.dealTypeChange(reqBO);
    }

    private void validate(UccQuickOrderTypeChangeAbilityReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getSkuId())) {
            throw new BusinessException("8888", "\u5165\u53c2 skuId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getGuideCatalogId())) {
            throw new BusinessException("8888", "\u5165\u53c2 guideCatalogId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        UccSkuPo uccSkuPo = this.uccSkuMapper.checkSKuById(reqBO.getSkuId());
        if (ObjectUtils.isEmpty((Object)uccSkuPo)) {
            throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u5355\u54c1\u4fe1\u606f\uff01");
        }
        reqBO.setCommodityId(uccSkuPo.getCommodityId());
    }
}

