/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.common.ability.api.UccTempSkuListAbilityService;
import com.tydic.commodity.common.ability.bo.UccTempSkuBO;
import com.tydic.commodity.common.ability.bo.UccTempSkuListAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccTempSkuListAbilityRspBO;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.MoneyUtils;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccTempSkuListAbilityService"})
public class UccTempSkuListAbilityServiceImpl
implements UccTempSkuListAbilityService {
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @PostMapping(value={"tempSkuList"})
    public UccTempSkuListAbilityRspBO tempSkuList(@RequestBody UccTempSkuListAbilityReqBO reqBO) {
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        UccSkuPo skuPo = new UccSkuPo();
        skuPo.setBrandName(reqBO.getBrandName());
        skuPo.setModel(reqBO.getModel());
        skuPo.setSpec(reqBO.getSpec());
        skuPo.setSkuName(reqBO.getSkuName());
        skuPo.setMatchStr(reqBO.getMatchStr());
        skuPo.setSkuIds(reqBO.getSkuIds());
        List uccSkuPoList = this.uccSkuMapper.getTempSkuList(skuPo, page);
        UccTempSkuListAbilityRspBO rspBO = new UccTempSkuListAbilityRspBO();
        if (!CollectionUtils.isEmpty((Collection)uccSkuPoList)) {
            List uccTempSkuBOS = uccSkuPoList.stream().map(e -> {
                UccTempSkuBO uccTempSkuBO = (UccTempSkuBO)JSONObject.parseObject((String)JSON.toJSONString((Object)e), UccTempSkuBO.class);
                if (!ObjectUtils.isEmpty((Object)e.getUnsaleNum())) {
                    uccTempSkuBO.setStock(MoneyUtils.haoToYuan((Long)e.getUnsaleNum()));
                }
                if (!ObjectUtils.isEmpty((Object)e.getSalePrice())) {
                    uccTempSkuBO.setSalePrice(MoneyUtils.haoToYuan((Long)e.getSalePrice()));
                }
                if (!ObjectUtils.isEmpty((Object)e.getAgreementPrice())) {
                    uccTempSkuBO.setAgreementPrice(MoneyUtils.haoToYuan((Long)e.getAgreementPrice()));
                }
                return uccTempSkuBO;
            }).collect(Collectors.toList());
            rspBO.setRows(uccTempSkuBOS);
            rspBO.setPageNo(page.getPageNo());
            rspBO.setRecordsTotal(page.getTotalCount());
            rspBO.setTotal(page.getTotalPages());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

