/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccUmcItemCatChangeOffSpuAbilityService;
import com.tydic.commodity.common.ability.bo.UccUmcItemCatChangeOffSpuAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccUmcItemCatChangeOffSpuAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccUmcItemCatChangeOffSpuBusiService;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccUmcItemCatChangeOffSpuAbilityService"})
public class UccUmcItemCatChangeOffSpuAbilityServiceImpl
implements UccUmcItemCatChangeOffSpuAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccUmcItemCatChangeOffSpuAbilityServiceImpl.class);
    @Autowired
    private UccUmcItemCatChangeOffSpuBusiService uccUmcItemCatChangeOffSpuBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    @PostMapping(value={"offSpu"})
    public UccUmcItemCatChangeOffSpuAbilityRspBO offSpu(@RequestBody UccUmcItemCatChangeOffSpuAbilityReqBO reqBO) {
        log.info("\u4f1a\u5458\u8c03\u7528\u5165\u53c2=" + JSON.toJSONString((Object)reqBO));
        this.validate(reqBO);
        UccUmcItemCatChangeOffSpuAbilityRspBO rspBO = this.uccUmcItemCatChangeOffSpuBusiService.dealOffSpu(reqBO);
        if ("0000".equals(rspBO.getRespCode()) && !MapUtils.isEmpty((Map)rspBO.getSkuMap())) {
            for (Long supplierId : rspBO.getSkuMap().keySet()) {
                List skuIds = (List)rspBO.getSkuMap().get(supplierId);
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList((Iterable)skuIds));
                syncSceneCommodityToEsReqBO.setSupplierId(supplierId);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS.intValue());
                try {
                    log.info("\u4f1a\u5458\u7b7e\u7ea6\u7533\u8bf7\u53d8\u52a8\u540c\u6b65\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)syncSceneCommodityToEsReqBO));
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
                }
            }
        }
        return rspBO;
    }

    private void validate(UccUmcItemCatChangeOffSpuAbilityReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getSupplierId())) {
            throw new BusinessException("8888", "\u5165\u53c2 supplierId \u4e3a\u7a7a\uff01");
        }
    }
}

