/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.ExcelNewUtils;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.PoolRelatedTypeEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.UccCommodityPoolSkuImportAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccCommodityPoolSkuImportAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccExcelImportPoolSkuBO;
import com.tydic.commodity.common.busi.api.UccCommodityPoolSkuImportBusiService;
import com.tydic.commodity.dao.UccRelPoolCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccRelPoolCommodityPo;
import com.tydic.commodity.po.UccSkuPo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class UccCommodityPoolSkuImportBusiServiceImpl
implements UccCommodityPoolSkuImportBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccCommodityPoolSkuImportBusiServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccRelPoolCommodityMapper uccRelPoolCommodityMapper;
    private static final Sequence SEQUENCE = Sequence.getInstance();

    @Override
    public UccCommodityPoolSkuImportAbilityRspBO dealSkuRelPool(UccCommodityPoolSkuImportAbilityReqBO reqBO) {
        UccCommodityPoolSkuImportAbilityRspBO rspBO = new UccCommodityPoolSkuImportAbilityRspBO();
        rspBO.setRespCode("8888");
        List<UccExcelImportPoolSkuBO> skuInfoFromExcel = this.getSkuInfoFromExcel(reqBO.getUrl());
        if (CollectionUtils.isEmpty(skuInfoFromExcel)) {
            rspBO.setSuccessCount(Long.valueOf(skuInfoFromExcel.size()));
            rspBO.setRespDesc("\u6a21\u677f\u5185\u5bb9\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        rspBO.setSuccessCount(Long.valueOf(skuInfoFromExcel.size()));
        ArrayList<String> skuCodes = new ArrayList<String>();
        List<UccExcelImportPoolSkuBO> validate = this.validate(skuInfoFromExcel, reqBO.getPoolId(), skuCodes, rspBO);
        if (!CollectionUtils.isEmpty(validate)) {
            rspBO.setSkuCodes(skuCodes);
            rspBO.setUccExcelImportPoolSkuBOS(validate);
            return rspBO;
        }
        List<Long> deleted = this.dealDeleteOld(reqBO);
        String resDes = this.dealRelPool(skuInfoFromExcel, reqBO);
        if (!StringUtils.isEmpty((Object)resDes)) {
            rspBO.setSkuCodes(skuCodes);
            rspBO.setRespDesc(resDes);
            return rspBO;
        }
        ArrayList<Long> list = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty(deleted)) {
            list.addAll(deleted);
        }
        list.addAll(skuInfoFromExcel.stream().map(UccExcelImportPoolSkuBO::getSkuId).collect(Collectors.toList()));
        rspBO.setSkuIds(list);
        rspBO.setUccExcelImportPoolSkuBOS(skuInfoFromExcel);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<Long> dealDeleteOld(UccCommodityPoolSkuImportAbilityReqBO reqBO) {
        List uccSkuPos = this.uccRelPoolCommodityMapper.getSkuInfoByPoolId(reqBO.getPoolId());
        if (!CollectionUtils.isEmpty((Collection)uccSkuPos)) {
            try {
                this.uccRelPoolCommodityMapper.deleteByPoolIds(Collections.singletonList(reqBO.getPoolId()));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BusinessException("8888", "\u6570\u636e\u5904\u7406\u5931\u8d25\uff01\u8bf7\u8054\u7cfb\u8fd0\u8425\u4eba\u5458\uff01");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)uccSkuPos)) {
            return uccSkuPos.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
        }
        return null;
    }

    private String dealRelPool(List<UccExcelImportPoolSkuBO> skuInfoFromExcel, UccCommodityPoolSkuImportAbilityReqBO reqBO) {
        Date time = new Date();
        try {
            List uccRelPoolCommodityPos = skuInfoFromExcel.stream().map(e -> {
                UccRelPoolCommodityPo relPoolCommodityPo = new UccRelPoolCommodityPo();
                relPoolCommodityPo.setPoolRelated(PoolRelatedTypeEnum.RELATED_BY_SKU.getCode());
                relPoolCommodityPo.setPoolId(reqBO.getPoolId());
                relPoolCommodityPo.setCreateOper("import");
                relPoolCommodityPo.setCreateTime(time);
                relPoolCommodityPo.setSource(e.getSkuId());
                relPoolCommodityPo.setId(Long.valueOf(SEQUENCE.nextId()));
                relPoolCommodityPo.setViewOrder(e.getSort());
                return relPoolCommodityPo;
            }).collect(Collectors.toList());
            this.uccRelPoolCommodityMapper.batchInsert(uccRelPoolCommodityPos);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return "\u65b0\u589e\u5546\u54c1\u6c60\u5173\u8054\u5355\u54c1\u5931\u8d25";
        }
        return null;
    }

    private List<UccExcelImportPoolSkuBO> validate(List<UccExcelImportPoolSkuBO> skuInfoFromExcel, Long poolId, List<String> skuCodes, UccCommodityPoolSkuImportAbilityRspBO rspBO) {
        ArrayList<UccExcelImportPoolSkuBO> fails = new ArrayList<UccExcelImportPoolSkuBO>();
        List skus = skuInfoFromExcel.stream().map(UccExcelImportPoolSkuBO::getSkuCode).collect(Collectors.toList());
        Map<String, List<UccExcelImportPoolSkuBO>> distinctMap = skuInfoFromExcel.stream().collect(Collectors.groupingBy(UccExcelImportPoolSkuBO::getSkuCode));
        for (String string : distinctMap.keySet()) {
            if (distinctMap.get(string).size() <= 1) continue;
            skuCodes.add(string);
            rspBO.setOrder(distinctMap.get(string).get(0).getSerialNo());
        }
        if (!CollectionUtils.isEmpty(skuCodes)) {
            for (String skuCode : skuCodes) {
                UccExcelImportPoolSkuBO fail = new UccExcelImportPoolSkuBO();
                fail.setSort(distinctMap.get(skuCode).get(0).getSerialNo());
                fail.setSerialNo(distinctMap.get(skuCode).get(0).getSerialNo());
                fail.setSkuCode(skuCode);
                fail.setDesc("\u5355\u54c1\u7f16\u7801\u91cd\u590d");
                fails.add(fail);
            }
            rspBO.setRespDesc("\u5355\u54c1\u7f16\u7801\u91cd\u590d" + JSON.toJSONString(skuCodes));
            return fails;
        }
        List list = this.uccSkuMapper.getSkuIdByCodes(skus);
        if (CollectionUtils.isEmpty((Collection)list)) {
            skuCodes.addAll(skus);
            rspBO.setOrder(Integer.valueOf(1));
            rspBO.setRespDesc("\u6240\u6709\u5bfc\u5165\u7684\u5355\u54c1\u7f16\u7801\u4e0d\u5b58\u5728" + JSON.toJSONString(skuCodes));
            for (UccExcelImportPoolSkuBO importPoolSkuBO : skuInfoFromExcel) {
                UccExcelImportPoolSkuBO fail = new UccExcelImportPoolSkuBO();
                fail.setSort(distinctMap.get(importPoolSkuBO.getSkuCode()).get(0).getSerialNo());
                fail.setSerialNo(distinctMap.get(importPoolSkuBO.getSkuCode()).get(0).getSerialNo());
                fail.setSkuCode(importPoolSkuBO.getSkuCode());
                fail.setDesc("\u5355\u54c1\u7f16\u7801\u4e0d\u5b58\u5728");
                fails.add(fail);
            }
            return fails;
        }
        List existSkuCodes = list.stream().map(UccSkuPo::getSkuCode).collect(Collectors.toList());
        for (UccExcelImportPoolSkuBO skuBO : skuInfoFromExcel) {
            if (existSkuCodes.contains(skuBO.getSkuCode())) continue;
            skuCodes.add(skuBO.getSkuCode());
        }
        if (!CollectionUtils.isEmpty(skuCodes)) {
            for (String skuCode : skuCodes) {
                UccExcelImportPoolSkuBO fail = new UccExcelImportPoolSkuBO();
                fail.setSort(distinctMap.get(skuCode).get(0).getSerialNo());
                fail.setSerialNo(distinctMap.get(skuCode).get(0).getSerialNo());
                fail.setSkuCode(skuCode);
                fail.setDesc("\u5355\u54c1\u7f16\u7801\u4e0d\u5b58\u5728");
                fails.add(fail);
            }
            rspBO.setRespDesc("\u5355\u54c1\u7f16\u7801\u4e0d\u5b58\u5728" + JSON.toJSONString(skuCodes));
            return fails;
        }
        for (UccSkuPo uccSkuPo : list) {
            if (!ModelRuleConstant.SKU_SOURCE_COMMERCE_IMPORT.equals(uccSkuPo.getSkuSource())) continue;
            skuCodes.add(uccSkuPo.getSkuCode());
        }
        if (!CollectionUtils.isEmpty(skuCodes)) {
            for (String skuCode : skuCodes) {
                UccExcelImportPoolSkuBO fail = new UccExcelImportPoolSkuBO();
                fail.setSort(distinctMap.get(skuCode).get(0).getSerialNo());
                fail.setSerialNo(distinctMap.get(skuCode).get(0).getSerialNo());
                fail.setSkuCode(skuCode);
                fail.setDesc("\u7535\u5546\u5546\u54c1\u7981\u6b62\u5bfc\u5165");
                fails.add(fail);
            }
            rspBO.setRespDesc("\u5355\u54c1\u7f16\u7801\u4e3a" + JSON.toJSONString(skuCodes) + "\u4e3a\u7535\u5546\u5546\u54c1,\u65e0\u6cd5\u5bfc\u5165\uff01");
            return fails;
        }
        Map<String, Long> skuCodeMap = list.stream().collect(Collectors.toMap(UccSkuPo::getSkuCode, UccSkuPo::getSkuId));
        for (UccExcelImportPoolSkuBO skuBO : skuInfoFromExcel) {
            skuBO.setSkuId(skuCodeMap.get(skuBO.getSkuCode()));
            if (!ObjectUtils.isEmpty((Object)skuCodeMap.get(skuBO.getSkuCode()))) {
                skuBO.setCommodityId(skuCodeMap.get(skuBO.getSkuCode()));
                continue;
            }
            skuCodes.add(skuBO.getSkuCode());
            rspBO.setOrder(skuBO.getSerialNo());
            rspBO.setRespDesc("\u5546\u54c1\u7f16\u7801" + skuBO.getSkuCode() + "\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5546\u54c1\uff01");
            UccExcelImportPoolSkuBO fail = new UccExcelImportPoolSkuBO();
            fail.setSort(distinctMap.get(skuBO.getSkuCode()).get(0).getSerialNo());
            fail.setSerialNo(distinctMap.get(skuBO.getSkuCode()).get(0).getSerialNo());
            fail.setSkuCode(skuBO.getSkuCode());
            fail.setDesc("\u5355\u54c1\u7f16\u7801\u91cd\u590d");
            fails.add(fail);
            return fails;
        }
        return null;
    }

    private List<UccExcelImportPoolSkuBO> getSkuInfoFromExcel(String url) {
        List<Object> data = new ArrayList();
        List<String> head = null;
        try {
            List<List<String>> excel = this.dealEcxel(url, 3, 0);
            head = excel.get(0);
            data = this.dealEcxel(url, 3, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZTBusinessException(e.getMessage());
        }
        int rowNum = 2;
        ArrayList<UccExcelImportPoolSkuBO> uccExcelImportPoolSkuBOS = new ArrayList<UccExcelImportPoolSkuBO>();
        try {
            if (CollectionUtils.isNotEmpty(data)) {
                for (List list : data) {
                    String commodityCode;
                    String serialNo;
                    ++rowNum;
                    UccExcelImportPoolSkuBO uccExcelImportPoolSkuBO = new UccExcelImportPoolSkuBO();
                    int i = 0;
                    if (!StringUtils.isEmpty((Object)(serialNo = (String)list.get(i++)))) {
                        uccExcelImportPoolSkuBO.setSerialNo(Integer.valueOf(Integer.parseInt(UccCommodityPoolSkuImportBusiServiceImpl.doubleToInteger(serialNo))));
                    }
                    if (StringUtils.isEmpty((Object)(commodityCode = (String)list.get(i++)))) {
                        throw new BusinessException("8888", "\u5546\u54c1\u7f16\u7801\u5b58\u5728\u7a7a\u7684\u6570\u636e\u884c\uff01");
                    }
                    uccExcelImportPoolSkuBO.setSkuCode(UccCommodityPoolSkuImportBusiServiceImpl.doubleToInteger(commodityCode));
                    uccExcelImportPoolSkuBOS.add(uccExcelImportPoolSkuBO);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            throw new ZTBusinessException("\u7b2c" + rowNum + "\u884c\u6570\u636e\u51fa\u73b0\u95ee\u9898,\u8bf7\u68c0\u67e5\u683c\u5f0f!");
        }
        log.info("==============\u8bfb\u53d6\u7684\u5546\u54c1\u4fe1\u606f===============");
        log.info(JSON.toJSONString(uccExcelImportPoolSkuBOS));
        return uccExcelImportPoolSkuBOS;
    }

    public static String doubleToInteger(String str) {
        if (StringUtils.isEmpty((Object)str)) {
            return "";
        }
        return new BigDecimal(str).stripTrailingZeros().toPlainString();
    }

    private List<List<String>> dealEcxel(String url, Integer startReadLine, Integer sheetAt) {
        if (StringUtils.isEmpty((Object)url)) {
            return new ArrayList<List<String>>();
        }
        ArrayList<List<String>> lines = new ArrayList<List<String>>();
        try {
            ExcelNewUtils.getExcelDate((String)url, lines, (Integer)startReadLine, (Integer)sheetAt);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            throw new ZTBusinessException("\u5904\u7406Excel\u5931\u8d25");
        }
        log.info("\u8bfb\u53d6\u5230\u7684\u6570\u636e\uff1a" + JSONObject.toJSONString(lines));
        if (CollectionUtils.isEmpty(lines)) {
            throw new BusinessException("8888", "\u6a21\u677f\u4fe1\u606f\u4e3a\u7a7a\u6216\u8005\u5e8f\u53f7\u672a\u586b\uff01");
        }
        return lines;
    }
}

