/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.ExcelNewUtils;
import com.tydic.commodity.base.constant.PoolRelatedTypeEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.UccCommodityPoolSpuImportAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccCommodityPoolSpuImportAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccExcelImportPoolSpuBO;
import com.tydic.commodity.common.busi.api.UccCommodityPoolSpuImportBusiService;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccRelPoolCommodityMapper;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccRelPoolCommodityPo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class UccCommodityPoolSpuImportBusiServiceImpl
implements UccCommodityPoolSpuImportBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccCommodityPoolSpuImportBusiServiceImpl.class);
    @Autowired
    private UccRelPoolCommodityMapper uccRelPoolCommodityMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    private static final Sequence SEQUENCE = Sequence.getInstance();

    @Override
    public UccCommodityPoolSpuImportAbilityRspBO dealSpuRelPool(UccCommodityPoolSpuImportAbilityReqBO reqBO) {
        UccCommodityPoolSpuImportAbilityRspBO rspBO = new UccCommodityPoolSpuImportAbilityRspBO();
        rspBO.setRespCode("8888");
        ArrayList<String> commodityCodes = new ArrayList<String>();
        Object order = null;
        List<UccExcelImportPoolSpuBO> spuInfoFromExcel = this.getSpuInfoFromExcel(reqBO.getUrl());
        rspBO.setSuccessCount(Long.valueOf(spuInfoFromExcel.size()));
        if (CollectionUtils.isEmpty(spuInfoFromExcel)) {
            rspBO.setSuccessCount(Long.valueOf(spuInfoFromExcel.size()));
            rspBO.setRespDesc("\u6a21\u677f\u5185\u5bb9\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        String validate = this.validate(spuInfoFromExcel, reqBO.getPoolId(), commodityCodes, rspBO);
        if (!StringUtils.isEmpty((Object)validate)) {
            rspBO.setRespDesc(validate);
            rspBO.setCommodityCodes(commodityCodes);
            return rspBO;
        }
        List<Long> deletes = this.dealDeleteRel(reqBO);
        String resDes = this.dealRelPool(spuInfoFromExcel, reqBO);
        if (!StringUtils.isEmpty((Object)resDes)) {
            rspBO.setCommodityCodes(commodityCodes);
            rspBO.setRespDesc(resDes);
            return rspBO;
        }
        ArrayList<Long> sysns = new ArrayList<Long>();
        sysns.addAll(deletes);
        sysns.addAll(spuInfoFromExcel.stream().map(UccExcelImportPoolSpuBO::getCommodityId).collect(Collectors.toList()));
        rspBO.setSpuIds(sysns);
        rspBO.setUccExcelImportPoolSpuBOS(spuInfoFromExcel);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<Long> dealDeleteRel(UccCommodityPoolSpuImportAbilityReqBO reqBO) {
        List sources = this.uccRelPoolCommodityMapper.querySourceById(reqBO.getPoolId());
        try {
            this.uccRelPoolCommodityMapper.deleteByPoolIds(Collections.singletonList(reqBO.getPoolId()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("8888", "\u6e05\u9664\u5df2\u5173\u8054\u5546\u54c1\u5931\u8d25\uff01\u8bf7\u8054\u7cfb\u8fd0\u8425\u4eba\u5458\u5904\u7406");
        }
        return sources;
    }

    private String dealJudgeRelPool(List<UccExcelImportPoolSpuBO> spuInfoFromExcel, List<UccRelPoolCommodityPo> uccRelPoolCommodityPos, UccCommodityPoolSpuImportAbilityReqBO reqBO, List<String> commodityCodesR, UccCommodityPoolSpuImportAbilityRspBO rspBO) {
        List sorts = spuInfoFromExcel.stream().filter(e -> e.getSort() != 999999).map(UccExcelImportPoolSpuBO::getSort).collect(Collectors.toList());
        for (Integer sort : sorts) {
            UccRelPoolCommodityPo relPoolCommodityPo = new UccRelPoolCommodityPo();
            relPoolCommodityPo.setPoolId(reqBO.getPoolId());
            relPoolCommodityPo.setViewOrder(sort);
            List commodityCodes = this.uccRelPoolCommodityMapper.checkViewOrder(relPoolCommodityPo);
            if (CollectionUtils.isEmpty((Collection)commodityCodes)) continue;
            rspBO.setOrder(sort.toString());
            String commodityCode = this.getCommodityCode(spuInfoFromExcel, sort);
            commodityCodesR.add(commodityCode);
            return "\u5546\u54c1\u6392\u5e8f[" + sort + "]\u4e0e\u5f53\u524d\u5df2\u5173\u8054\u5546\u54c1\u6392\u5e8f\u51b2\u7a81\uff01";
        }
        UccRelPoolCommodityPo relPoolCommodityPo = new UccRelPoolCommodityPo();
        relPoolCommodityPo.setPoolId(reqBO.getPoolId());
        relPoolCommodityPo.setCommodityIds(spuInfoFromExcel.stream().map(UccExcelImportPoolSpuBO::getCommodityId).collect(Collectors.toList()));
        List<Object> relatedCommodityIds = new ArrayList();
        List relPoolCommodityPos = this.uccRelPoolCommodityMapper.getJoinCommoditys(relPoolCommodityPo);
        Map<Long, Integer> sortMap = spuInfoFromExcel.stream().collect(Collectors.toMap(UccExcelImportPoolSpuBO::getCommodityId, UccExcelImportPoolSpuBO::getSort));
        if (!CollectionUtils.isEmpty((Collection)relPoolCommodityPos)) {
            relatedCommodityIds = relPoolCommodityPos.stream().map(UccRelPoolCommodityPo::getCommodityId).collect(Collectors.toList());
            try {
                for (UccRelPoolCommodityPo poolCommodityPo : relPoolCommodityPos) {
                    poolCommodityPo.setViewOrder(sortMap.get(poolCommodityPo.getCommodityId()));
                }
                for (UccRelPoolCommodityPo poolCommodityPo : relPoolCommodityPos) {
                    this.uccRelPoolCommodityMapper.updateOrder(poolCommodityPo);
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return "\u66f4\u65b0\u5df2\u5b58\u5728\u5546\u54c1\u6c60\u5546\u54c1\u6392\u5e8f\u4fe1\u606f\u5931\u8d25";
            }
        }
        ArrayList finalRelatedCommodityIds = relatedCommodityIds;
        List<UccExcelImportPoolSpuBO> notRelPoolSpus = spuInfoFromExcel.stream().filter(e -> !finalRelatedCommodityIds.contains(e.getCommodityId())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(notRelPoolSpus)) {
            return this.dealRelPool(notRelPoolSpus, reqBO);
        }
        return null;
    }

    private String dealRelPool(List<UccExcelImportPoolSpuBO> spuInfoFromExcel, UccCommodityPoolSpuImportAbilityReqBO reqBO) {
        Date time = new Date();
        try {
            List uccRelPoolCommodityPos = spuInfoFromExcel.stream().map(e -> {
                UccRelPoolCommodityPo relPoolCommodityPo = new UccRelPoolCommodityPo();
                relPoolCommodityPo.setPoolRelated(PoolRelatedTypeEnum.RELATED_BY_SPU.getCode());
                relPoolCommodityPo.setPoolId(reqBO.getPoolId());
                relPoolCommodityPo.setCreateOper("import");
                relPoolCommodityPo.setCreateTime(time);
                relPoolCommodityPo.setSource(e.getCommodityId());
                relPoolCommodityPo.setId(Long.valueOf(SEQUENCE.nextId()));
                relPoolCommodityPo.setViewOrder(e.getSort());
                return relPoolCommodityPo;
            }).collect(Collectors.toList());
            this.uccRelPoolCommodityMapper.batchInsert(uccRelPoolCommodityPos);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return "\u65b0\u589e\u5546\u54c1\u6c60\u5173\u8054\u5546\u54c1\u5931\u8d25";
        }
        return null;
    }

    private String validate(List<UccExcelImportPoolSpuBO> spuInfoFromExcel, Long poolId, List<String> commodityCodes, UccCommodityPoolSpuImportAbilityRspBO rspBO) {
        List spus = spuInfoFromExcel.stream().map(UccExcelImportPoolSpuBO::getCommodityCode).distinct().collect(Collectors.toList());
        if (spus.size() != spuInfoFromExcel.size()) {
            Map<String, List<UccExcelImportPoolSpuBO>> listMap = spuInfoFromExcel.stream().collect(Collectors.groupingBy(UccExcelImportPoolSpuBO::getCommodityCode));
            for (String code : listMap.keySet()) {
                if (listMap.get(code).size() <= 1) continue;
                commodityCodes.add(code);
                rspBO.setOrder(listMap.get(code).get(0).getSort() == null ? "" : listMap.get(code).get(0).getSort().toString());
            }
            return "\u5b58\u5728\u5546\u54c1\u7f16\u7801\u91cd\u590d\u7684\u6570\u636e!";
        }
        List commodityPos = this.uccCommodityMapper.getCommodityIdsByCode(spus);
        if (CollectionUtils.isEmpty((Collection)commodityPos)) {
            commodityCodes.addAll(spus);
            rspBO.setOrder("1");
            return "\u5546\u54c1\u7f16\u7801" + JSON.toJSONString(spus) + "\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5546\u54c1\uff01";
        }
        if (commodityPos.size() != spus.size()) {
            List existCodes = commodityPos.stream().map(UccCommodityPo::getCommodityCode).collect(Collectors.toList());
            for (String existCode : existCodes) {
                spus.removeIf(e -> e.equals(existCode));
            }
            commodityCodes.addAll(spus);
            rspBO.setOrder("1");
            return "\u5546\u54c1\u7f16\u7801 " + JSON.toJSONString(spus) + "\u4e0d\u5b58\u5728\uff01";
        }
        List<UccExcelImportPoolSpuBO> sortList = spuInfoFromExcel.stream().filter(e -> !ObjectUtils.isEmpty((Object)e.getSort())).collect(Collectors.toList());
        List sorts = sortList.stream().map(UccExcelImportPoolSpuBO::getSort).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(sorts)) {
            Collections.sort(sorts);
            if ((Integer)sorts.get(0) != 1) {
                String commodityCode = this.getCommodityCode(sortList, (Integer)sorts.get(0));
                commodityCodes.add(commodityCode);
                rspBO.setOrder(((Integer)sorts.get(0)).toString());
                return "0\u4ee5\u4e0a\u6574\u6570\uff08\u4e0d\u5305\u542b0\uff09\uff0c*\u6392\u5e8f\u5fc5\u987b\u4ece1\u5f00\u59cb*\uff0c\u503c\u5fc5\u987b\u8fde\u7eed\uff0c\u6392\u5e8f\u503c\u4e0d\u53ef\u91cd\u590d\uff01";
            }
            for (int i = 0; i < sorts.size() - 1; ++i) {
                int b;
                int a = (Integer)sorts.get(i + 1);
                int c = a - (b = ((Integer)sorts.get(i)).intValue());
                if (c == 1) continue;
                String commodityCode = this.getCommodityCode(sortList, (Integer)sorts.get(i));
                commodityCodes.add(commodityCode);
                rspBO.setOrder(((Integer)sorts.get(i)).toString());
                return "0\u4ee5\u4e0a\u6574\u6570\uff08\u4e0d\u5305\u542b0\uff09\uff0c\u6392\u5e8f\u5fc5\u987b\u4ece1\u5f00\u59cb\uff0c*\u503c\u5fc5\u987b\u8fde\u7eed*\uff0c\u6392\u5e8f\u503c\u4e0d\u53ef\u91cd\u590d\uff01";
            }
        }
        Map<String, Long> commodityCodeMap = commodityPos.stream().collect(Collectors.toMap(UccCommodityPo::getCommodityCode, UccCommodityPo::getCommodityId));
        for (UccExcelImportPoolSpuBO uccExcelImportPoolSpuBO : spuInfoFromExcel) {
            if (ObjectUtils.isEmpty((Object)commodityCodeMap.get(uccExcelImportPoolSpuBO.getCommodityCode()))) {
                commodityCodes.add(uccExcelImportPoolSpuBO.getCommodityCode());
                rspBO.setOrder(uccExcelImportPoolSpuBO.getSort().toString());
                return "\u5546\u54c1\u7f16\u7801" + uccExcelImportPoolSpuBO.getCommodityCode() + "\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5546\u54c1\uff01";
            }
            uccExcelImportPoolSpuBO.setCommodityId(commodityCodeMap.get(uccExcelImportPoolSpuBO.getCommodityCode()));
            if (!ObjectUtils.isEmpty((Object)uccExcelImportPoolSpuBO.getSort())) continue;
            uccExcelImportPoolSpuBO.setSort(Integer.valueOf(999999));
        }
        return null;
    }

    private String getCommodityCode(List<UccExcelImportPoolSpuBO> sortList, Integer sort) {
        for (UccExcelImportPoolSpuBO poolSpuBO : sortList) {
            if (ObjectUtils.isEmpty((Object)poolSpuBO.getSort()) || !sort.equals(poolSpuBO.getSort())) continue;
            return poolSpuBO.getCommodityCode();
        }
        return null;
    }

    private List<UccExcelImportPoolSpuBO> getSpuInfoFromExcel(String url) {
        List<Object> data = new ArrayList();
        List<String> head = null;
        try {
            List<List<String>> excel = this.dealEcxel(url, 3, 0);
            head = excel.get(0);
            data = this.dealEcxel(url, 3, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZTBusinessException(e.getMessage());
        }
        int rowNum = 2;
        ArrayList<UccExcelImportPoolSpuBO> uccExcelImportPoolSpuBOS = new ArrayList<UccExcelImportPoolSpuBO>();
        try {
            if (CollectionUtils.isNotEmpty(data)) {
                for (List list : data) {
                    String sort;
                    String commodityCode;
                    String serialNo;
                    ++rowNum;
                    UccExcelImportPoolSpuBO uccExcelImportPoolSpuBO = new UccExcelImportPoolSpuBO();
                    int i = 0;
                    if (!StringUtils.isEmpty((Object)(serialNo = (String)list.get(i++)))) {
                        uccExcelImportPoolSpuBO.setSerialNo(Integer.valueOf(Integer.parseInt(UccCommodityPoolSpuImportBusiServiceImpl.doubleToInteger(serialNo))));
                    }
                    if (StringUtils.isEmpty((Object)(commodityCode = (String)list.get(i++)))) {
                        throw new BusinessException("8888", "\u5546\u54c1\u7f16\u7801\u5b58\u5728\u7a7a\u7684\u6570\u636e\u884c\uff01");
                    }
                    uccExcelImportPoolSpuBO.setCommodityCode(UccCommodityPoolSpuImportBusiServiceImpl.doubleToInteger(commodityCode));
                    if (list.size() >= 3 && !StringUtils.isEmpty((Object)(sort = (String)list.get(i++)))) {
                        uccExcelImportPoolSpuBO.setSort(Integer.valueOf(Integer.parseInt(UccCommodityPoolSpuImportBusiServiceImpl.doubleToInteger(sort))));
                    }
                    uccExcelImportPoolSpuBOS.add(uccExcelImportPoolSpuBO);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            throw new ZTBusinessException("\u7b2c" + rowNum + "\u884c\u6570\u636e\u51fa\u73b0\u95ee\u9898,\u8bf7\u68c0\u67e5\u683c\u5f0f!");
        }
        log.info("==============\u8bfb\u53d6\u7684\u5546\u54c1\u4fe1\u606f===============");
        log.info(JSON.toJSONString(uccExcelImportPoolSpuBOS));
        return uccExcelImportPoolSpuBOS;
    }

    public static String doubleToInteger(String str) {
        if (StringUtils.isEmpty((Object)str)) {
            return "";
        }
        return new BigDecimal(str).stripTrailingZeros().toPlainString();
    }

    private List<List<String>> dealEcxel(String url, Integer startReadLine, Integer sheetAt) {
        if (StringUtils.isEmpty((Object)url)) {
            return new ArrayList<List<String>>();
        }
        ArrayList<List<String>> lines = new ArrayList<List<String>>();
        try {
            ExcelNewUtils.getExcelDate((String)url, lines, (Integer)startReadLine, (Integer)sheetAt);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            throw new ZTBusinessException("\u5904\u7406Excel\u5931\u8d25");
        }
        log.info("\u8bfb\u53d6\u5230\u7684\u6570\u636e\uff1a" + JSONObject.toJSONString(lines));
        if (CollectionUtils.isEmpty(lines)) {
            throw new BusinessException("8888", "\u6a21\u677f\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        return lines;
    }
}

