/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.google.common.collect.Lists;
import com.tydic.commodity.common.busi.api.UccInquiryQuotationDetailBaseQryBusiService;
import com.tydic.commodity.common.busi.bo.UccInquiryMyQuotationDetailBO;
import com.tydic.commodity.common.busi.bo.UccInquiryQuotationDetailsQryBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccInquiryQuotationDetailsQryBusiRspBO;
import com.tydic.commodity.dao.UccCommodityMeasureMapper;
import com.tydic.commodity.dao.UccInquiryQuotationDetailMapper;
import com.tydic.commodity.po.UccCommodityMeasurePo;
import com.tydic.commodity.po.UccInquiryQuotationDetailPO;
import com.tydic.commodity.po.UccInquiryQuotationDetailQryPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccInquiryQuotationDetailBaseQryBusiServiceImpl
implements UccInquiryQuotationDetailBaseQryBusiService {
    @Autowired
    private UccInquiryQuotationDetailMapper uccInquiryQuotationDetailMapper;
    @Autowired
    private UccCommodityMeasureMapper uccCommodityMeasureMapper;

    @Override
    public UccInquiryQuotationDetailsQryBusiRspBO inquiryQuotationDetailBaseQry(UccInquiryQuotationDetailsQryBusiReqBO reqBO) {
        UccInquiryQuotationDetailsQryBusiRspBO rspBO = new UccInquiryQuotationDetailsQryBusiRspBO();
        UccInquiryQuotationDetailQryPO qryPO = new UccInquiryQuotationDetailQryPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)qryPO);
        List quotationDetailPOList = this.uccInquiryQuotationDetailMapper.queryAll(qryPO);
        ArrayList<UccInquiryMyQuotationDetailBO> dataList = new ArrayList<UccInquiryMyQuotationDetailBO>();
        if (!CollectionUtils.isEmpty((Collection)quotationDetailPOList)) {
            List uccCommodityMeasurePos;
            Map<Object, Object> unitMap = new HashMap();
            Set unitIdSet = quotationDetailPOList.stream().filter(o -> o.getQuotationUnitId() != null).map(UccInquiryQuotationDetailPO::getQuotationUnitId).collect(Collectors.toSet());
            if (unitIdSet.size() > 0 && (uccCommodityMeasurePos = this.uccCommodityMeasureMapper.queryMeasureByMeasureIds((List)Lists.newArrayList(unitIdSet))) != null && uccCommodityMeasurePos.size() > 0) {
                unitMap = uccCommodityMeasurePos.stream().collect(Collectors.toMap(UccCommodityMeasurePo::getMeasureId, UccCommodityMeasurePo::getDecimalLimit));
            }
            for (UccInquiryQuotationDetailPO po : quotationDetailPOList) {
                UccInquiryMyQuotationDetailBO detailBO = new UccInquiryMyQuotationDetailBO();
                BeanUtils.copyProperties((Object)po, (Object)detailBO);
                if (detailBO.getQuotationQuantity() != null && detailBO.getSalesPrice() != null) {
                    detailBO.setSalesPriceTotal(detailBO.getSalesPrice().multiply(new BigDecimal(detailBO.getQuotationQuantity())));
                }
                dataList.add(detailBO);
                if (detailBO.getSalesPrice() != null) {
                    detailBO.setSalesPrice(detailBO.getSalesPrice().divide(new BigDecimal("10000")));
                }
                if (detailBO.getPurchasePrice() != null) {
                    detailBO.setPurchasePrice(detailBO.getPurchasePrice().divide(new BigDecimal("10000")));
                }
                if (detailBO.getSalesPriceTotal() != null) {
                    detailBO.setSalesPriceTotal(detailBO.getSalesPriceTotal().divide(new BigDecimal("10000")).setScale(2, 4));
                }
                detailBO.setDecimalLimit((Integer)unitMap.get(detailBO.getQuotationUnitId()));
            }
        }
        rspBO.setInquiryQuotationDetailList(dataList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

