/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.common.busi.api.UccInquirySheetInfosQryBusiService;
import com.tydic.commodity.common.busi.bo.UccInquirySheetInfosQryBO;
import com.tydic.commodity.common.busi.bo.UccInquirySheetInfosQryBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccInquirySheetInfosQryBusiRspBO;
import com.tydic.commodity.dao.UccInquirySheetDetailMapper;
import com.tydic.commodity.po.UccInquirySheetInfoPO;
import com.tydic.commodity.po.UccInquirySheetInfoQryPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccInquirySheetInfosQryBusiServiceImpl
implements UccInquirySheetInfosQryBusiService {
    @Autowired
    private UccInquirySheetDetailMapper uccInquirySheetDetailMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;

    @Override
    public UccInquirySheetInfosQryBusiRspBO inquirySheetInfosQry(UccInquirySheetInfosQryBusiReqBO reqBO) {
        UccInquirySheetInfosQryBusiRspBO rspBO = new UccInquirySheetInfosQryBusiRspBO();
        UccInquirySheetInfoQryPO qryPO = (UccInquirySheetInfoQryPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), UccInquirySheetInfoQryPO.class);
        List uccInquirySheetInfoPOList = new ArrayList();
        if (reqBO.getPageQueryFlag().booleanValue()) {
            Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
            uccInquirySheetInfoPOList = this.uccInquirySheetDetailMapper.queryInquirySheetInfoList(qryPO, page);
            rspBO.setTotal(page.getTotalPages());
            rspBO.setRecordsTotal(page.getTotalCount());
            rspBO.setPageNo(page.getPageNo());
        } else {
            uccInquirySheetInfoPOList = this.uccInquirySheetDetailMapper.queryInquirySheetInfoList(qryPO);
        }
        ArrayList<UccInquirySheetInfosQryBO> dataList = new ArrayList<UccInquirySheetInfosQryBO>();
        this.buildUccInquirySheetInfosQryBO(uccInquirySheetInfoPOList, dataList);
        this.translateDataToStr(dataList);
        rspBO.setRows(dataList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public UccInquirySheetInfosQryBusiRspBO uccInquiryDownloadCheck(UccInquirySheetInfosQryBusiReqBO reqBO) {
        UccInquirySheetInfosQryBusiRspBO rspBO = new UccInquirySheetInfosQryBusiRspBO();
        UccInquirySheetInfoQryPO qryPO = (UccInquirySheetInfoQryPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), UccInquirySheetInfoQryPO.class);
        qryPO.setCheckQuotationStatus(Integer.valueOf(1));
        int count = this.uccInquirySheetDetailMapper.queryInquirySheetInfoListCount(qryPO);
        if (count > 0) {
            rspBO.setRespCode("\u5931\u8d25");
            rspBO.setRespDesc("\u53ea\u6709\u5df2\u62a5\u4ef7\u5546\u54c1\u624d\u53ef\u4ee5\u5bfc\u51fa\u62a5\u4ef7\u5355\uff01");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public void buildUccInquirySheetInfosQryBO(List<UccInquirySheetInfoPO> uccInquirySheetInfoPOList, List<UccInquirySheetInfosQryBO> dataList) {
        if (uccInquirySheetInfoPOList != null && uccInquirySheetInfoPOList.size() > 0) {
            for (UccInquirySheetInfoPO infoPO : uccInquirySheetInfoPOList) {
                UccInquirySheetInfosQryBO infosQryBO = new UccInquirySheetInfosQryBO();
                BeanUtils.copyProperties((Object)infoPO, (Object)infosQryBO);
                if (infoPO.getSalesPrice() != null && infoPO.getQuotationQuantity() != null) {
                    infosQryBO.setSalesPriceTotal(infoPO.getSalesPrice().multiply(new BigDecimal(infoPO.getQuotationQuantity())));
                }
                if (infoPO.getQuotationDate() != null) {
                    infosQryBO.setQuotedDays(Integer.parseInt(DateUtil.betweenDay((Date)new Date(), (Date)infoPO.getQuotationDate(), (boolean)true) + ""));
                }
                if (infosQryBO.getSalesPrice() != null) {
                    infosQryBO.setSalesPrice(infosQryBO.getSalesPrice().divide(new BigDecimal("10000")));
                }
                if (infosQryBO.getPurchasePrice() != null) {
                    infosQryBO.setPurchasePrice(infosQryBO.getPurchasePrice().divide(new BigDecimal("10000")));
                }
                if (infosQryBO.getSalesPriceTotal() != null) {
                    infosQryBO.setSalesPriceTotal(infosQryBO.getSalesPriceTotal().divide(new BigDecimal("10000")).setScale(2, 4));
                }
                dataList.add(infosQryBO);
            }
        }
    }

    public void translateDataToStr(List<UccInquirySheetInfosQryBO> dataList) {
        if (!CollectionUtils.isEmpty(dataList)) {
            Map<String, String> inquirySourceMap = this.uccDictionaryAtomService.queryBypCodeBackMap("UCC_INQUIRY_SOURCE");
            Map<String, String> inquiryStatusMap = this.uccDictionaryAtomService.queryBypCodeBackMap("INQUIRY_STATUS_MANGER");
            Map<String, String> industryTypeMap = this.uccDictionaryAtomService.queryBypCodeBackMap("UCC_INQUIRY_INDUSTRY_TYPE");
            Map<String, String> quotationStatusMap = this.uccDictionaryAtomService.queryBypCodeBackMap("QUOTATION_STATUS_MANGER");
            for (UccInquirySheetInfosQryBO qryBO : dataList) {
                if (qryBO.getInquirySource() != null) {
                    qryBO.setInquirySourceStr(inquirySourceMap.get(qryBO.getInquirySource().toString()));
                }
                if (qryBO.getInquiryStatus() != null) {
                    qryBO.setInquiryStatusStr(inquiryStatusMap.get(qryBO.getInquiryStatus().toString()));
                }
                if (qryBO.getIndustryType() != null) {
                    qryBO.setIndustryTypeStr(industryTypeMap.get(qryBO.getIndustryType().toString()));
                }
                if (qryBO.getQuotationStatus() == null) continue;
                qryBO.setQuotationStatusStr(quotationStatusMap.get(qryBO.getQuotationStatus().toString()));
            }
        }
    }
}

