/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.google.common.collect.Lists;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.common.busi.api.UccInquirySheetQueryListBusiService;
import com.tydic.commodity.common.busi.bo.UccInquirySheetQryListBO;
import com.tydic.commodity.common.busi.bo.UccInquirySheetQryListBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccInquirySheetQryListBusiRspBO;
import com.tydic.commodity.dao.UccInquirySheetDetailMapper;
import com.tydic.commodity.dao.UccInquirySheetMapper;
import com.tydic.commodity.po.UccInquirySheetDetailPO;
import com.tydic.commodity.po.UccInquirySheetPO;
import com.tydic.commodity.po.UccInquirySheetQryPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccInquirySheetQueryListBusiServiceImpl
implements UccInquirySheetQueryListBusiService {
    @Autowired
    private UccInquirySheetMapper uccInquirySheetMapper;
    @Autowired
    private UccInquirySheetDetailMapper uccInquirySheetDetailMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;

    @Override
    public UccInquirySheetQryListBusiRspBO inquirySheetQueryList(UccInquirySheetQryListBusiReqBO reqBO) {
        UccInquirySheetQryListBusiRspBO rspBO = new UccInquirySheetQryListBusiRspBO();
        UccInquirySheetQryPO sheetPO = new UccInquirySheetQryPO();
        sheetPO.setCreateId(reqBO.getCreateId());
        ArrayList<Integer> inquiryStatusList = new ArrayList<Integer>();
        if (reqBO.getInquiryStatus() != null) {
            inquiryStatusList.add(reqBO.getInquiryStatus());
        }
        if (!CollectionUtils.isEmpty(reqBO.getInquiryStatusList())) {
            inquiryStatusList.addAll(reqBO.getInquiryStatusList());
        }
        sheetPO.setInquiryStatusList(inquiryStatusList);
        sheetPO.setInquirySheetId(reqBO.getInquirySheetId());
        sheetPO.setIsDel(Integer.valueOf(0));
        List rows = new ArrayList();
        if (reqBO.getPageQueryFlag().booleanValue()) {
            Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
            rows = this.uccInquirySheetMapper.queryAllByPage(sheetPO, page);
            rspBO.setTotal(page.getTotalPages());
            rspBO.setRecordsTotal(page.getTotalCount());
            rspBO.setPageNo(page.getPageNo());
        } else {
            rows = this.uccInquirySheetMapper.queryAll(sheetPO);
        }
        ArrayList<UccInquirySheetQryListBO> dataList = new ArrayList<UccInquirySheetQryListBO>();
        if (!CollectionUtils.isEmpty(rows)) {
            ArrayList uccInquirySheetDetailList = new ArrayList();
            List inquirySheetIdList = rows.stream().filter(o -> o.getInquiryStatus() != null && o.getInquiryStatus() == 1).map(UccInquirySheetPO::getInquirySheetId).collect(Collectors.toList());
            if (inquirySheetIdList.size() > 0) {
                if (inquirySheetIdList.size() > 1000) {
                    List listList = Lists.partition(inquirySheetIdList, (int)1000);
                    for (List list : listList) {
                        List quotationDateList = this.uccInquirySheetDetailMapper.getQuotationDateListByInquirySheetId(list);
                        uccInquirySheetDetailList.addAll(quotationDateList);
                    }
                } else {
                    List quotationDateList = this.uccInquirySheetDetailMapper.getQuotationDateListByInquirySheetId(inquirySheetIdList);
                    uccInquirySheetDetailList.addAll(quotationDateList);
                }
            }
            Map<Long, Date> dateMap = uccInquirySheetDetailList.stream().collect(Collectors.toMap(UccInquirySheetDetailPO::getInquirySheetId, UccInquirySheetDetailPO::getQuotationDate, (v1, v2) -> v1.compareTo((Date)v2) > 0 ? v1 : v2));
            for (UccInquirySheetPO row : rows) {
                UccInquirySheetQryListBO sheetQueryListBO = new UccInquirySheetQryListBO();
                BeanUtils.copyProperties((Object)row, (Object)sheetQueryListBO);
                sheetQueryListBO.setQuotationTime(dateMap.get(row.getInquirySheetId()));
                dataList.add(sheetQueryListBO);
            }
        }
        this.translateDataToStr(dataList);
        rspBO.setRows(dataList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public void translateDataToStr(List<UccInquirySheetQryListBO> rows) {
        if (!CollectionUtils.isEmpty(rows)) {
            Map<String, String> inquiryStatusMap = this.uccDictionaryAtomService.queryBypCodeBackMap("INQUIRY_STATUS_MANGER");
            Map<String, String> inquiryStatusPurchaserMap = this.uccDictionaryAtomService.queryBypCodeBackMap("INQUIRY_STATUS_PURCHASER");
            Map<String, String> inquirySourceMap = this.uccDictionaryAtomService.queryBypCodeBackMap("UCC_INQUIRY_SOURCE");
            Map<String, String> enterpriseTypeMap = this.uccDictionaryAtomService.queryBypCodeBackMap("UCC_INQUIRY_ENTERPRISE_TYPE");
            Map<String, String> industryTypeMap = this.uccDictionaryAtomService.queryBypCodeBackMap("UCC_INQUIRY_INDUSTRY_TYPE");
            for (UccInquirySheetQryListBO row : rows) {
                if (row.getInquiryStatus() != null) {
                    row.setInquiryStatusStr(inquiryStatusMap.get(row.getInquiryStatus().toString()));
                    row.setPurchaserInquiryStatusStr(inquiryStatusPurchaserMap.get(row.getInquiryStatus().toString()));
                }
                if (row.getInquirySource() != null) {
                    row.setInquirySourceStr(inquirySourceMap.get(row.getInquirySource().toString()));
                }
                if (row.getEnterpriseType() != null) {
                    row.setEnterpriseTypeStr(enterpriseTypeMap.get(row.getEnterpriseType().toString()));
                }
                if (row.getIndustryType() == null) continue;
                row.setIndustryTypeStr(industryTypeMap.get(row.getIndustryType().toString()));
            }
        }
    }
}

