/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccSkuPutCirAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSkuPutCirReqBO;
import com.tydic.commodity.busibase.atom.bo.UccSkuPutCirRspBO;
import com.tydic.commodity.common.busi.api.UccPricePreventDownCommodBusiService;
import com.tydic.commodity.common.busi.bo.UccPricePreventDownCommodBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccPricePreventDownCommodBusiRspBO;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuExpandMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccPricePreventDownRecordPO;
import com.tydic.commodity.po.UccSkuExpandPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.DateUtils;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class UccPricePreventDownCommodBusiServiceImpl
implements UccPricePreventDownCommodBusiService {
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSkuExpandMapper uccSkuExpandMapper;
    @Autowired
    private UccSkuPutCirAtomService uccSkuPutCirAtomService;

    @Override
    public UccPricePreventDownCommodBusiRspBO dealDownCommod(UccPricePreventDownCommodBusiReqBO reqBO) {
        UccPricePreventDownCommodBusiRspBO rspBO = new UccPricePreventDownCommodBusiRspBO();
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        rspBO.setSyncSkus(null);
        List skuInfoByCodes = this.uccSkuMapper.getSkuInfoByCodes(reqBO.getPricePreventDownRecordPOS().stream().map(UccPricePreventDownRecordPO::getSkuCode).collect(Collectors.toList()));
        if (!CollectionUtils.isEmpty((Collection)skuInfoByCodes)) {
            try {
                this.uccSkuMapper.updatestatusByskuIdsNew(5, skuInfoByCodes.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList()));
                this.dealUpdatePutCir(skuInfoByCodes);
                this.uccCommodityMapper.updateSpuStatusBySpuIds(skuInfoByCodes.stream().map(UccSkuPo::getCommodityId).collect(Collectors.toList()), 5);
                Map<Long, List<Long>> syncSkus = skuInfoByCodes.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId, Collectors.mapping(UccSkuPo::getSkuId, Collectors.toList())));
                rspBO.setSyncSkus(syncSkus);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BusinessException("8888", "\u66f4\u65b0\u5546\u54c1\u72b6\u6001\u5f02\u5e38\uff01" + e.getMessage());
            }
        }
        return rspBO;
    }

    private void dealUpdatePutCir(List<UccSkuPo> skuInfoByCodes) {
        Date date = new Date();
        try {
            for (UccSkuPo skuPo : skuInfoByCodes) {
                UccSkuPutCirReqBO uccSkuPutCirReqBO = new UccSkuPutCirReqBO();
                uccSkuPutCirReqBO.setSkuId(skuPo.getSkuId());
                uccSkuPutCirReqBO.setSupplierShopId(skuPo.getSupplierShopId());
                uccSkuPutCirReqBO.setDownType(Integer.valueOf(1));
                uccSkuPutCirReqBO.setRealDownTime(DateUtils.dateToStr((Date)new Date()));
                UccSkuPutCirRspBO uccSkuPutCirRspBO = this.uccSkuPutCirAtomService.dealSkuPutCir(uccSkuPutCirReqBO);
                if (!"0000".equals(uccSkuPutCirRspBO.getRespCode())) {
                    throw new BusinessException("8888", "\u4e0a\u67b6\u52a0\u5468\u671f\u5904\u7406\u5931\u8d25\uff01" + uccSkuPutCirRspBO.getRespDesc());
                }
                UccSkuExpandPo expandPo = new UccSkuExpandPo();
                expandPo.setSkuId(skuPo.getSkuId());
                expandPo.setExpand16("\u98ce\u63a7\u4e2d\u5fc3\u81ea\u52a8\u4e0b\u67b6");
                expandPo.setExpand15(null);
                expandPo.setExpand24(date);
                UccSkuExpandPo uccSkuExpandPo = this.uccSkuExpandMapper.getModel(expandPo);
                if (ObjectUtils.isEmpty((Object)uccSkuExpandPo)) {
                    expandPo.setSupplierShopId(skuPo.getSupplierShopId());
                    expandPo.setCommodityId(skuPo.getCommodityId());
                    this.uccSkuExpandMapper.insertSkuExpand(expandPo);
                    continue;
                }
                this.uccSkuExpandMapper.updateSkuExpand(expandPo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("8888", "\u5546\u54c1\u4e0a\u4e0b\u67b6\u5468\u671f\u66f4\u65b0\u5931\u8d25\uff01" + e.getMessage());
        }
    }
}

