/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.UccPricePreventByDataBO;
import com.tydic.commodity.common.ability.bo.UccPricePreventByDataRspBO;
import com.tydic.commodity.common.ability.bo.UccRiskPricePreventReqBO;
import com.tydic.commodity.common.ability.bo.UccRiskPricePreventTaskAbilityReqBO;
import com.tydic.commodity.common.busi.api.UccRiskPricePreventTaskBusiService;
import com.tydic.commodity.common.busi.bo.UccRiskPricePreventTaskBusiRspBO;
import com.tydic.commodity.dao.UccPricePreventDownRecordMapper;
import com.tydic.commodity.po.UccPricePreventDownRecordPO;
import com.tydic.commodity.utils.DateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccRiskPricePreventTaskBusiServiceImpl
implements UccRiskPricePreventTaskBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccRiskPricePreventTaskBusiServiceImpl.class);
    @Value(value="${RISK_PRICE_PREVENT_URL:https://www.lsugu.com/smartdata/data/data-service/ads002}")
    private String RISK_PRICE_PREVENT_URL;
    @Value(value="${RISK_APP_CODE:liand}")
    private String RISK_APP_CODE;
    private static final String TJTZ = "\u8c03\u4ef7\u901a\u77e5";
    private static final String ZDXJ = "\u81ea\u52a8\u4e0b\u67b6";
    @Autowired
    private UccPricePreventDownRecordMapper uccPricePreventDownRecordMapper;
    private static final Sequence SEQUENCE = Sequence.getInstance();

    @Override
    public UccRiskPricePreventTaskBusiRspBO dealPricePreventMsg(UccRiskPricePreventTaskAbilityReqBO reqBO) {
        UccRiskPricePreventTaskBusiRspBO rspBO = new UccRiskPricePreventTaskBusiRspBO();
        List<UccPricePreventByDataBO> preventAdjustList = this.dealGetPreventInfo(1);
        rspBO.setAdjustPriceMap(this.assemble(preventAdjustList));
        List<UccPricePreventByDataBO> preventOffList = this.dealGetPreventInfo(2);
        if (!CollectionUtils.isEmpty(preventOffList)) {
            this.dealAddRecordTask(preventOffList);
        }
        rspBO.setOffPriceMap(this.assemble(preventOffList));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealAddRecordTask(List<UccPricePreventByDataBO> preventOffList) {
        Date date = new Date();
        try {
            List preventDownRecordPOS = preventOffList.stream().map(e -> {
                UccPricePreventDownRecordPO prevent = new UccPricePreventDownRecordPO();
                prevent.setCreateTime(date);
                prevent.setExtSkuId(e.getExtSkuId());
                prevent.setStatus(Integer.valueOf(1));
                prevent.setId(Long.valueOf(SEQUENCE.nextId()));
                prevent.setSkuCode(e.getSkuCode());
                return prevent;
            }).collect(Collectors.toList());
            this.uccPricePreventDownRecordMapper.insertBatch(preventDownRecordPOS);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            log.error("=======\u65b0\u589e\u4e0b\u67b6\u5b9a\u65f6\u4efb\u52a1\u8868\u5931\u8d25=======" + e2.getMessage());
        }
    }

    private Map<Long, List<UccPricePreventByDataBO>> assemble(List<UccPricePreventByDataBO> preventAdjustList) {
        if (CollectionUtils.isEmpty(preventAdjustList)) {
            return null;
        }
        Map<Long, List<UccPricePreventByDataBO>> managerMap = preventAdjustList.stream().filter(e -> e.getManagerId() != null).collect(Collectors.groupingBy(UccPricePreventByDataBO::getManagerId));
        if (!MapUtils.isEmpty(managerMap)) {
            return managerMap;
        }
        return null;
    }

    private List<UccPricePreventByDataBO> dealGetPreventInfo(int type) {
        ArrayList<UccPricePreventByDataBO> pricePreventByDataBOS = new ArrayList<UccPricePreventByDataBO>();
        Integer pageNo = 1;
        Integer pageSize = 1000;
        String date = DateUtils.dateToStrAsFormat((Date)DateUtils.getCurrentBeforeDateStartTime((Date)new Date()), (String)"yyyy-MM-dd");
        String ss1 = type == 1 ? TJTZ : ZDXJ;
        boolean g = true;
        while (g) {
            UccRiskPricePreventReqBO preventReqBO = new UccRiskPricePreventReqBO();
            preventReqBO.setPageNo(pageNo);
            preventReqBO.setPageSize(pageSize);
            preventReqBO.setSs1(ss1);
            preventReqBO.setSync_date(date);
            try {
                String result = ((HttpRequest)HttpUtil.createPost((String)this.RISK_PRICE_PREVENT_URL).header("appCode", this.RISK_APP_CODE)).body(JSONUtil.toJsonStr((Object)preventReqBO)).execute().body();
                log.info("\u67e5\u8be2\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)result));
                UccPricePreventByDataRspBO preventByDataRspBO = (UccPricePreventByDataRspBO)JSON.parseObject((String)result, UccPricePreventByDataRspBO.class);
                if ("0".equals(preventByDataRspBO.getCode()) && !CollectionUtils.isEmpty((Collection)preventByDataRspBO.getData().getRows())) {
                    List collect = preventByDataRspBO.getData().getRows().stream().map(e -> {
                        UccPricePreventByDataBO prevent = new UccPricePreventByDataBO();
                        prevent.setExtSkuId(e.getEXT_SKU_ID());
                        prevent.setGuideCatalogId3(e.getGUIDE_CATALOG_ID());
                        prevent.setGuideCatalogName3(e.getCATALOG_NAME3());
                        prevent.setManagerId(e.getMANAGER_ID());
                        prevent.setSkuCode(e.getSKU_CODE());
                        prevent.setManagerName(e.getMANAGER_NAME());
                        return prevent;
                    }).collect(Collectors.toList());
                    pricePreventByDataBOS.addAll(collect);
                    Integer n = pageNo;
                    Integer n2 = pageNo = Integer.valueOf(pageNo + 1);
                    if (pageNo <= preventByDataRspBO.getData().getTotal()) continue;
                    g = false;
                    continue;
                }
                g = false;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                throw new BusinessException("8888", "\u8c03\u7528\u6570\u636e\u4e2d\u5fc3\u67e5\u8be2\u6570\u636e\u5f02\u5e38\uff01" + e2.getMessage());
            }
        }
        return pricePreventByDataBOS;
    }
}

