/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.bo.UccCommodityPicBO;
import com.tydic.commodity.base.constant.ExcelNewUtils;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccBatchImageImportChangeAbilityService;
import com.tydic.commodity.common.ability.bo.UccBatchImageImportChangeAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccBatchImageImportChangeAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccExcelImportImgSpuBO;
import com.tydic.commodity.common.busi.api.UccBatchImageImportChangeBusiService;
import com.tydic.commodity.common.busi.bo.UccBatchImageImportChangeBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccBatchImageImportChangeBusiRspBO;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccImgImportLogDetailMapper;
import com.tydic.commodity.dao.UccImgImportLogMapper;
import com.tydic.commodity.po.UccImgImportLogDetailPO;
import com.tydic.commodity.po.UccImgImportLogPO;
import com.tydic.commodity.utils.PropertiesUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccBatchImageImportChangeAbilityService"})
public class UccBatchImageImportChangeAbilityServiceImpl
implements UccBatchImageImportChangeAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccBatchImageImportChangeAbilityServiceImpl.class);
    @Autowired
    private UccBatchImageImportChangeBusiService uccBatchImageImportChangeBusiService;
    @Autowired
    private UccImgImportLogMapper uccImgImportLogMapper;
    @Autowired
    private UccImgImportLogDetailMapper uccImgImportLogDetailMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    private static final Sequence SEQUENCE = Sequence.getInstance();

    @PostMapping(value={"batchImageImportChange"})
    public UccBatchImageImportChangeAbilityRspBO batchImageImportChange(@RequestBody UccBatchImageImportChangeAbilityReqBO reqBO) {
        this.validate(reqBO);
        List<UccExcelImportImgSpuBO> spuInfoFromExcel = this.getSpuInfoFromExcel(reqBO.getUrl());
        StringBuilder commodityCodes = new StringBuilder();
        StringBuilder commodityNames = new StringBuilder();
        ArrayList<UccImgImportLogDetailPO> uccImgImportLogDetailPOS = new ArrayList<UccImgImportLogDetailPO>();
        String desc = this.validateSpu(spuInfoFromExcel, commodityCodes, commodityNames, uccImgImportLogDetailPOS);
        if (!StringUtils.isEmpty((Object)desc)) {
            this.dealAddLog(commodityCodes.toString(), commodityNames.toString(), desc, 2, reqBO, uccImgImportLogDetailPOS, 0, spuInfoFromExcel.size());
            throw new BusinessException("8888", "\u5546\u54c1\u6821\u9a8c\u5931\u8d25\uff01" + desc);
        }
        UccBatchImageImportChangeBusiReqBO changeBusiReqBO = new UccBatchImageImportChangeBusiReqBO();
        changeBusiReqBO.setPics(reqBO.getPics());
        changeBusiReqBO.setSpuBOS(spuInfoFromExcel);
        UccBatchImageImportChangeBusiRspBO rspBO = this.uccBatchImageImportChangeBusiService.dealBatchImageImport(changeBusiReqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            if (!rspBO.getSysMap().isEmpty()) {
                for (Long supplierShopId : rspBO.getSysMap().keySet()) {
                    SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                    List spuIds = rspBO.getSysMap().get(supplierShopId).stream().distinct().collect(Collectors.toList());
                    syncSceneCommodityToEsReqBO.setCommodityIds(spuIds);
                    syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
                    syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL);
                    syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
                    syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                    try {
                        this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                    }
                    catch (Exception e) {
                        log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
                    }
                }
            }
            this.dealAddLog("-", "-", "\u6210\u529f", 1, reqBO, uccImgImportLogDetailPOS, spuInfoFromExcel.size(), 0);
            return (UccBatchImageImportChangeAbilityRspBO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)rspBO)), UccBatchImageImportChangeAbilityRspBO.class);
        }
        throw new BusinessException("8888", rspBO.getRespDesc());
    }

    private void dealAddLog(String commodityCodes, String commodityNames, String desc, Integer state, UccBatchImageImportChangeAbilityReqBO reqBO, List<UccImgImportLogDetailPO> uccImgImportLogDetailPOS, Integer successCount, Integer falureCount) {
        try {
            UccImgImportLogPO logPO = new UccImgImportLogPO();
            long importId = SEQUENCE.nextId();
            Date time = new Date();
            logPO.setImportId(Long.valueOf(importId));
            logPO.setImportTime(time);
            logPO.setOperId(reqBO.getUserId());
            logPO.setOperName(reqBO.getUsername());
            logPO.setOperType("1");
            logPO.setState(state);
            this.uccImgImportLogMapper.insert(logPO);
            log.info("==================");
            log.info(JSON.toJSONString(uccImgImportLogDetailPOS));
            if (!CollectionUtils.isEmpty(uccImgImportLogDetailPOS)) {
                for (UccImgImportLogDetailPO detailPO : uccImgImportLogDetailPOS) {
                    detailPO.setImportId(Long.valueOf(importId));
                    detailPO.setImportLogDetailId(Long.valueOf(SEQUENCE.nextId()));
                    detailPO.setOperTime(time);
                    detailPO.setState(state);
                    detailPO.setExt1(successCount + "");
                    detailPO.setExt2(falureCount + "");
                }
                log.info("i--------------nsert-------------");
                log.info(JSON.toJSONString(uccImgImportLogDetailPOS));
                this.uccImgImportLogDetailMapper.insertBatch(uccImgImportLogDetailPOS);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("8888", "\u8bb0\u5f55\u5931\u8d25\u65e5\u5fd7\u5f02\u5e38\uff01" + e.getMessage());
        }
    }

    private String validateSpu(List<UccExcelImportImgSpuBO> spuInfoFromExcel, StringBuilder commodityCodes, StringBuilder commodityNames, List<UccImgImportLogDetailPO> uccImgImportLogDetailPOS) {
        UccImgImportLogDetailPO imgImportLogDetailPO;
        if (CollectionUtils.isEmpty(spuInfoFromExcel)) {
            throw new BusinessException("8888", "\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (UccExcelImportImgSpuBO imgSpuBO : spuInfoFromExcel) {
            if (ObjectUtils.isEmpty((Object)imgSpuBO.getCommodityName())) {
                throw new BusinessException("8888", "\u5546\u54c1\u540d\u79f0\u5b58\u5728\u7a7a\u7684\u6570\u636e\u884c\uff01\u8bf7\u68c0\u67e5\u6a21\u677f\u6570\u636e\uff01");
            }
            if (ObjectUtils.isEmpty((Object)imgSpuBO.getCommodityCode())) {
                throw new BusinessException("8888", "\u5546\u54c1\u7f16\u7801\u5b58\u5728\u7a7a\u7684\u6570\u636e\u884c\uff01\u8bf7\u68c0\u67e5\u6a21\u677f\u6570\u636e\uff01");
            }
            Long commodityId = this.uccCommodityMapper.getIdByCode(imgSpuBO.getCommodityCode());
            if (ObjectUtils.isEmpty((Object)commodityId)) {
                imgImportLogDetailPO = new UccImgImportLogDetailPO();
                imgImportLogDetailPO.setOtherCode(imgSpuBO.getCommodityCode());
                imgImportLogDetailPO.setOtherName(imgSpuBO.getCommodityName());
                imgImportLogDetailPO.setRemark("\u5546\u54c1\u7f16\u7801\u4e0d\u5b58\u5728!");
                imgImportLogDetailPO.setResult("\u5546\u54c1\u7f16\u7801\u4e0d\u5b58\u5728!");
                uccImgImportLogDetailPOS.add(imgImportLogDetailPO);
            }
            imgSpuBO.setCommodityId(commodityId);
        }
        if (!CollectionUtils.isEmpty(uccImgImportLogDetailPOS)) {
            return "\u5546\u54c1\u7f16\u7801\u4e0d\u5b58\u5728!";
        }
        Map<String, List<UccExcelImportImgSpuBO>> listMap = spuInfoFromExcel.stream().collect(Collectors.groupingBy(UccExcelImportImgSpuBO::getCommodityCode));
        if (listMap.size() != spuInfoFromExcel.size()) {
            for (String code : listMap.keySet()) {
                if (listMap.get(code).size() <= 1) continue;
                imgImportLogDetailPO = new UccImgImportLogDetailPO();
                imgImportLogDetailPO.setOtherCode(code);
                imgImportLogDetailPO.setOtherName(listMap.get(code).get(0).getCommodityName());
                imgImportLogDetailPO.setRemark("\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u91cd\u590d!");
                imgImportLogDetailPO.setResult("\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u91cd\u590d!");
                uccImgImportLogDetailPOS.add(imgImportLogDetailPO);
            }
            return "\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u91cd\u590d\uff01";
        }
        for (UccExcelImportImgSpuBO imgSpuBO : spuInfoFromExcel) {
            imgImportLogDetailPO = new UccImgImportLogDetailPO();
            imgImportLogDetailPO.setOtherCode(imgSpuBO.getCommodityCode());
            imgImportLogDetailPO.setOtherName(imgSpuBO.getCommodityName());
            imgImportLogDetailPO.setRemark("");
            imgImportLogDetailPO.setResult("");
            uccImgImportLogDetailPOS.add(imgImportLogDetailPO);
        }
        return null;
    }

    private List<UccExcelImportImgSpuBO> getSpuInfoFromExcel(String url) {
        List<Object> data = new ArrayList();
        List<String> head = null;
        try {
            List<List<String>> excel = this.dealEcxel(url, 2, 0);
            head = excel.get(0);
            data = this.dealEcxel(url, 2, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZTBusinessException(e.getMessage());
        }
        int rowNum = 2;
        ArrayList<UccExcelImportImgSpuBO> uccExcelImportImgSpuBOS = new ArrayList<UccExcelImportImgSpuBO>();
        try {
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(data)) {
                for (List list : data) {
                    ++rowNum;
                    UccExcelImportImgSpuBO uccExcelImportImgSpuBO = new UccExcelImportImgSpuBO();
                    int i = 0;
                    String serialNo = (String)list.get(i++);
                    uccExcelImportImgSpuBO.setCommodityName(serialNo);
                    String commodityCode = (String)list.get(i++);
                    if (StringUtils.isEmpty((Object)commodityCode)) {
                        throw new BusinessException("8888", "\u5546\u54c1\u7f16\u7801\u5b58\u5728\u7a7a\u7684\u6570\u636e\u884c\uff01");
                    }
                    uccExcelImportImgSpuBO.setCommodityCode(UccBatchImageImportChangeAbilityServiceImpl.doubleToInteger(commodityCode));
                    uccExcelImportImgSpuBOS.add(uccExcelImportImgSpuBO);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            throw new ZTBusinessException("\u7b2c" + rowNum + "\u884c\u6570\u636e\u51fa\u73b0\u95ee\u9898,\u8bf7\u68c0\u67e5\u683c\u5f0f!");
        }
        log.info("==============\u8bfb\u53d6\u7684\u5546\u54c1\u4fe1\u606f===============");
        log.info(JSON.toJSONString(uccExcelImportImgSpuBOS));
        return uccExcelImportImgSpuBOS;
    }

    public static String doubleToInteger(String str) {
        if (StringUtils.isEmpty((Object)str)) {
            return "";
        }
        return new BigDecimal(str).stripTrailingZeros().toPlainString();
    }

    private List<List<String>> dealEcxel(String url, Integer startReadLine, Integer sheetAt) {
        if (StringUtils.isEmpty((Object)url)) {
            return new ArrayList<List<String>>();
        }
        ArrayList<List<String>> lines = new ArrayList<List<String>>();
        try {
            ExcelNewUtils.getExcelDate((String)url, lines, (Integer)startReadLine, (Integer)sheetAt);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            throw new ZTBusinessException("\u5904\u7406Excel\u5931\u8d25");
        }
        log.info("\u8bfb\u53d6\u5230\u7684\u6570\u636e\uff1a" + JSONObject.toJSONString(lines));
        if (org.apache.commons.collections.CollectionUtils.isEmpty(lines)) {
            throw new BusinessException("8888", "\u6a21\u677f\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        return lines;
    }

    private void validate(UccBatchImageImportChangeAbilityReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getUrl())) {
            throw new BusinessException("8888", "\u5165\u53c2 url \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getPics())) {
            throw new BusinessException("8888", "\u5165\u53c2 pics \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getPics().size() != 5) {
            throw new BusinessException("8888", "\u56fe\u7247\u6570\u91cf\u4e0d\u6b63\u786e\uff01");
        }
        for (UccCommodityPicBO pic : reqBO.getPics()) {
            if (ObjectUtils.isEmpty((Object)pic.getCommodityPicType())) {
                throw new BusinessException("8888", "\u5165\u53c2 commodityPicType \u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (pic.getCommodityPicType() != 1 || !ObjectUtils.isEmpty((Object)pic.getCommodityPicUrl())) continue;
            throw new BusinessException("8888", "\u4e3b\u56fe\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

