/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.bo.UccCommodityPicBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccBatchSpuImageUpdateAbilityService;
import com.tydic.commodity.common.ability.bo.UccBatchSpuImageUpdateAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccBatchSpuImageUpdateAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccBatchSpuImageUpdateBusiService;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccBatchSpuImageUpdateAbilityService"})
public class UccBatchSpuImageUpdateAbilityServiceImpl
implements UccBatchSpuImageUpdateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccBatchSpuImageUpdateAbilityServiceImpl.class);
    @Autowired
    private UccBatchSpuImageUpdateBusiService uccBatchSpuImageUpdateBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    @PostMapping(value={"batchSpuImageUpdate"})
    public UccBatchSpuImageUpdateAbilityRspBO batchSpuImageUpdate(@RequestBody UccBatchSpuImageUpdateAbilityReqBO reqBO) {
        this.validate(reqBO);
        UccBatchSpuImageUpdateAbilityRspBO rspBO = this.uccBatchSpuImageUpdateBusiService.batchSpuImageUpdate(reqBO);
        if ("0000".equals(rspBO.getRespCode()) && !rspBO.getSysMap().isEmpty()) {
            for (Long supplierShopId : rspBO.getSysMap().keySet()) {
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                List spuIds = ((List)rspBO.getSysMap().get(supplierShopId)).stream().distinct().collect(Collectors.toList());
                syncSceneCommodityToEsReqBO.setCommodityIds(spuIds);
                syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                try {
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
                }
            }
        }
        return rspBO;
    }

    private void validate(UccBatchSpuImageUpdateAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getList())) {
            throw new BusinessException("8888", "\u5165\u53c2 list \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getList().size() != 5) {
            throw new BusinessException("8888", "\u5165\u53c2\u96c6\u5408\u56fe\u7247\u6570\u91cf\u5fc5\u987b\u4e3a5\uff01");
        }
        for (UccCommodityPicBO uccCommodityPicBO : reqBO.getList()) {
            if (ObjectUtils.isEmpty((Object)uccCommodityPicBO.getCommodityPicType())) {
                throw new BusinessException("8888", "\u5165\u53c2 commodityPicType \u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (uccCommodityPicBO.getCommodityPicType() != 1 || !ObjectUtils.isEmpty((Object)uccCommodityPicBO.getCommodityPicUrl())) continue;
            throw new BusinessException("8888", "\u4e3b\u56fe \u5165\u53c2 commodityPicUrl \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

