/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.constant.ExcelNewUtils;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccGuideManagerOperAbilityService;
import com.tydic.commodity.common.ability.bo.CatalogRelManagerBO;
import com.tydic.commodity.common.ability.bo.UccExcelImportGuideManageSpuBO;
import com.tydic.commodity.common.ability.bo.UccExcelImportGuideManageSpuLinkUrlBO;
import com.tydic.commodity.common.ability.bo.UccGuideManagerAddAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccGuideManagerAddAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccGuideManagerBO;
import com.tydic.commodity.common.ability.bo.UccGuideManagerDeleteAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccGuideManagerDeleteAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccGuideManagerImportAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccGuideManagerImportAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccGuideManagerLinkUrlBO;
import com.tydic.commodity.common.ability.bo.UccGuideManagerLinkUrlImportAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccGuideManagerLinkUrlImportAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccGuideManagerLinkUrlListAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccGuideManagerLinkUrlListAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccGuideManagerListAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccGuideManagerListAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccGuideManagerUpdateAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccGuideManagerUpdateAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccGuideManagerUpdateBO;
import com.tydic.commodity.common.busi.api.UccGuideManagerAddBusiService;
import com.tydic.commodity.common.busi.api.UccGuideManagerDeleteBusiService;
import com.tydic.commodity.common.busi.api.UccGuideManagerImportBusiService;
import com.tydic.commodity.common.busi.api.UccGuideManagerLinkUrlImportBusiService;
import com.tydic.commodity.common.busi.api.UccGuideManagerUpdateBusiService;
import com.tydic.commodity.common.busi.bo.UccGuideManagerImportBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccGuideManagerImportBusiRspBO;
import com.tydic.commodity.common.busi.bo.UccGuideManagerLinkUrlImportBusiReqBO;
import com.tydic.commodity.dao.UccGuideCatalogExtMapper;
import com.tydic.commodity.dao.UccManagerRelGuideCatalogMapper;
import com.tydic.commodity.dao.UccRiskManageUrlMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccGuideManagerRelPO;
import com.tydic.commodity.po.UccOrgCatalogCandidateListPO;
import com.tydic.commodity.po.UccRiskManageUrlPO;
import com.tydic.dyc.authority.service.user.bo.AuthByRoleAndOrgQryUserInfoBo;
import com.tydic.dyc.umc.service.roleJobGroup.LdAuthGetUserByRoleAndOrgService;
import com.tydic.dyc.umc.service.roleJobGroup.bo.LdAuthGetUserByRoleAndOrgReqBo;
import com.tydic.dyc.umc.service.roleJobGroup.bo.LdAuthGetUserByRoleAndOrgRspBo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccGuideManagerOperAbilityService"})
public class UccGuideManagerOperAbilityServiceImpl
implements UccGuideManagerOperAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccGuideManagerOperAbilityServiceImpl.class);
    @Autowired
    private LdAuthGetUserByRoleAndOrgService ldAuthGetUserByRoleAndOrgService;
    @Autowired
    private UccGuideManagerAddBusiService uccGuideManagerAddBusiService;
    @Autowired
    private UccGuideManagerDeleteBusiService uccGuideManagerDeleteBusiService;
    @Autowired
    private UccGuideManagerUpdateBusiService uccGuideManagerUpdateBusiService;
    @Autowired
    private UccGuideManagerImportBusiService uccGuideManagerImportBusiService;
    @Autowired
    private UccGuideManagerLinkUrlImportBusiService uccGuideManagerLinkUrlImportBusiService;
    @Autowired
    private UccGuideCatalogExtMapper uccGuideCatalogExtMapper;
    @Autowired
    private UccRiskManageUrlMapper uccRiskManageUrlMapper;
    @Autowired
    private UccManagerRelGuideCatalogMapper uccManagerRelGuideCatalogMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @PostMapping(value={"guideManagerAdd"})
    public UccGuideManagerAddAbilityRspBO guideManagerAdd(@RequestBody UccGuideManagerAddAbilityReqBO reqBO) {
        this.validate1(reqBO);
        return this.uccGuideManagerAddBusiService.guideManagerAdd(reqBO);
    }

    private void validate1(UccGuideManagerAddAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getGuideCatalogIds())) {
            throw new BusinessException("8888", "\u5165\u53c2 guideCatalogIds \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getLevel())) {
            throw new BusinessException("8888", "\u5165\u53c2 level \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getManagerId())) {
            throw new BusinessException("8888", "\u5165\u53c2 managerId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getManagerName())) {
            throw new BusinessException("8888", "\u5165\u53c2 managerName \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List catalogInfo = this.uccGuideCatalogExtMapper.getCatalogInfo(reqBO.getLevel(), reqBO.getGuideCatalogIds());
        if (catalogInfo.size() < reqBO.getGuideCatalogIds().size()) {
            throw new BusinessException("8888", "\u5b58\u5728\u4e0d\u5408\u6cd5\u7684\u5165\u53c2\u7c7b\u76ee\u4fe1\u606f\uff01");
        }
    }

    @PostMapping(value={"guideManagerImport"})
    public UccGuideManagerImportAbilityRspBO guideManagerImport(@RequestBody UccGuideManagerImportAbilityReqBO reqBO) {
        this.validate4(reqBO);
        List<UccExcelImportGuideManageSpuBO> uccExcelImportGuideManageSpuBOS = this.getInfoFromExcel(reqBO.getUrl());
        Map<Integer, List<CatalogRelManagerBO>> catalogRelManagerMap = this.validateGuideManageExcel(uccExcelImportGuideManageSpuBOS);
        List<String> managerNames = uccExcelImportGuideManageSpuBOS.stream().map(UccExcelImportGuideManageSpuBO::getManagerName).distinct().collect(Collectors.toList());
        this.filedManagerId(catalogRelManagerMap, managerNames);
        UccGuideManagerImportBusiReqBO busiReqBO = new UccGuideManagerImportBusiReqBO();
        busiReqBO.setCatalogRelManagerMap(catalogRelManagerMap);
        busiReqBO.setUserId(reqBO.getUserId());
        busiReqBO.setName(reqBO.getName());
        UccGuideManagerImportBusiRspBO guideManagerImportBusiRspBO = this.uccGuideManagerImportBusiService.dealImport(busiReqBO);
        if ("0000".equals(guideManagerImportBusiRspBO.getRespCode())) {
            return (UccGuideManagerImportAbilityRspBO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)guideManagerImportBusiRspBO)), UccGuideManagerImportAbilityRspBO.class);
        }
        throw new BusinessException("8888", guideManagerImportBusiRspBO.getRespDesc());
    }

    private void filedManagerId(Map<Integer, List<CatalogRelManagerBO>> catalogRelManagerMap, List<String> managerNames) {
        LdAuthGetUserByRoleAndOrgReqBo umcAuthGetUserByRoleAndOrgReqBo = new LdAuthGetUserByRoleAndOrgReqBo();
        umcAuthGetUserByRoleAndOrgReqBo.setLoginNames(managerNames);
        umcAuthGetUserByRoleAndOrgReqBo.setPageNo(-1);
        umcAuthGetUserByRoleAndOrgReqBo.setPageSize(-1);
        log.info("==\u4f1a\u5458\u4fe1\u606f\u7528\u6237\u67e5\u8be2\u5165\u53c2===");
        log.info(JSON.toJSONString((Object)umcAuthGetUserByRoleAndOrgReqBo));
        LdAuthGetUserByRoleAndOrgRspBo umcAuthGetUserByRoleAndOrgRspBo = this.ldAuthGetUserByRoleAndOrgService.getUserByRoleAndOrg(umcAuthGetUserByRoleAndOrgReqBo);
        log.info("==\u4f1a\u5458\u7528\u6237\u4fe1\u606f\u67e5\u8be2\u51fa\u53c2=");
        log.info(JSON.toJSONString((Object)umcAuthGetUserByRoleAndOrgRspBo));
        if (!"0000".equals(umcAuthGetUserByRoleAndOrgRspBo.getRespCode())) {
            throw new BusinessException("8888", "\u8c03\u7528\u4f1a\u5458\u67e5\u8be2\u5f00\u53d1\u7ecf\u7406\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)umcAuthGetUserByRoleAndOrgRspBo.getRows())) {
            throw new BusinessException("8888", "\u8c03\u7528\u4f1a\u5458\u67e5\u8be2\u5f00\u53d1\u7ecf\u7406\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        Map<String, List<AuthByRoleAndOrgQryUserInfoBo>> umcListMap = umcAuthGetUserByRoleAndOrgRspBo.getRows().stream().collect(Collectors.groupingBy(AuthByRoleAndOrgQryUserInfoBo::getLoginName));
        Iterator<String> iterator = umcListMap.keySet().iterator();
        ArrayList<String> userNames = new ArrayList<String>();
        while (iterator.hasNext()) {
            userNames.add(iterator.next());
        }
        for (String managerName : managerNames) {
            if (userNames.contains(managerName)) continue;
            throw new BusinessException("8888", "\u4f1a\u5458\u67e5\u8be2\u4fe1\u606f\u672a\u8fd4\u56de " + managerName + " \u7528\u6237\u4fe1\u606f!\u8bf7\u68c0\u67e5\u5f00\u53d1\u7ecf\u7406\u8d26\u53f7\u586b\u5199\u662f\u5426\u6b63\u786e\uff01");
        }
        for (Integer level : catalogRelManagerMap.keySet()) {
            if (CollectionUtils.isEmpty((Collection)catalogRelManagerMap.get(level))) continue;
            for (CatalogRelManagerBO managerBO : catalogRelManagerMap.get(level)) {
                managerBO.setManagerId(umcListMap.get(managerBO.getManagerName()).get(0).getUserId());
                managerBO.setManagerName(umcListMap.get(managerBO.getManagerName()).get(0).getCustName());
            }
        }
    }

    private Map<Integer, List<CatalogRelManagerBO>> validateGuideManageExcel(List<UccExcelImportGuideManageSpuBO> uccExcelImportGuideManageSpuBOS) {
        List guideLevel3ManageSpuBOS;
        List guideLevel2ManageSpuBOS;
        List<Object> catalog1RelManagerBOS = new ArrayList();
        List<Object> catalog2RelManagerBOS = new ArrayList();
        List<Object> catalog3RelManagerBOS = new ArrayList();
        List guideLevel1ManageSpuBOS = uccExcelImportGuideManageSpuBOS.stream().filter(e -> StringUtils.isEmpty((Object)e.getCatalogName2()) && StringUtils.isEmpty((Object)e.getCatalogName3())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(guideLevel1ManageSpuBOS)) {
            List catalogName1s = guideLevel1ManageSpuBOS.stream().map(UccExcelImportGuideManageSpuBO::getCatalogName1).collect(Collectors.toList());
            List uccGuide1ManagerRelPOS = this.uccGuideCatalogExtMapper.getListByNames(catalogName1s, Integer.valueOf(1));
            if (uccGuide1ManagerRelPOS.size() != catalogName1s.size()) {
                throw new BusinessException("8888", "\u5b58\u5728\u4e0d\u5408\u6cd5\u7684\u4e00\u7ea7\u7c7b\u76ee\u4fe1\u606f\uff01");
            }
            Map<String, Long> catalogMap1 = uccGuide1ManagerRelPOS.stream().collect(Collectors.toMap(UccOrgCatalogCandidateListPO::getCatalogName, UccOrgCatalogCandidateListPO::getCatalogId));
            catalog1RelManagerBOS = guideLevel1ManageSpuBOS.stream().map(e -> {
                CatalogRelManagerBO managerBO = new CatalogRelManagerBO();
                managerBO.setCatalogId((Long)catalogMap1.get(e.getCatalogName1()));
                managerBO.setCatalogName(e.getCatalogName1());
                managerBO.setManagerName(e.getManagerName());
                return managerBO;
            }).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(guideLevel2ManageSpuBOS = uccExcelImportGuideManageSpuBOS.stream().filter(e -> !StringUtils.isEmpty((Object)e.getCatalogName2()) && StringUtils.isEmpty((Object)e.getCatalogName3())).collect(Collectors.toList()))) {
            List catalogName2s = guideLevel2ManageSpuBOS.stream().map(UccExcelImportGuideManageSpuBO::getCatalogName2).collect(Collectors.toList());
            List uccGuide2ManagerRelPOS = this.uccGuideCatalogExtMapper.getListByNames(catalogName2s, Integer.valueOf(2));
            if (uccGuide2ManagerRelPOS.size() != catalogName2s.size()) {
                throw new BusinessException("8888", "\u5b58\u5728\u4e0d\u5408\u6cd5\u7684\u4e8c\u7ea7\u7c7b\u76ee\u4fe1\u606f\uff01");
            }
            Map<String, Long> catalogMap2 = uccGuide2ManagerRelPOS.stream().collect(Collectors.toMap(UccOrgCatalogCandidateListPO::getCatalogName, UccOrgCatalogCandidateListPO::getCatalogId));
            catalog2RelManagerBOS = guideLevel2ManageSpuBOS.stream().map(e -> {
                CatalogRelManagerBO managerBO = new CatalogRelManagerBO();
                managerBO.setCatalogId((Long)catalogMap2.get(e.getCatalogName2()));
                managerBO.setCatalogName(e.getCatalogName2());
                managerBO.setManagerName(e.getManagerName());
                return managerBO;
            }).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(guideLevel3ManageSpuBOS = uccExcelImportGuideManageSpuBOS.stream().filter(e -> !StringUtils.isEmpty((Object)e.getCatalogName2()) && !StringUtils.isEmpty((Object)e.getCatalogName3())).collect(Collectors.toList()))) {
            List catalogName3s = guideLevel3ManageSpuBOS.stream().map(UccExcelImportGuideManageSpuBO::getCatalogName3).collect(Collectors.toList());
            List uccGuide3ManagerRelPOS = this.uccGuideCatalogExtMapper.getListByNames(catalogName3s, Integer.valueOf(3));
            if (uccGuide3ManagerRelPOS.size() != catalogName3s.size()) {
                throw new BusinessException("8888", "\u5b58\u5728\u4e0d\u5408\u6cd5\u7684\u4e09\u7ea7\u7c7b\u76ee\u4fe1\u606f\uff01");
            }
            Map<String, Long> catalogMap3 = uccGuide3ManagerRelPOS.stream().collect(Collectors.toMap(UccOrgCatalogCandidateListPO::getCatalogName, UccOrgCatalogCandidateListPO::getCatalogId));
            catalog3RelManagerBOS = guideLevel3ManageSpuBOS.stream().map(e -> {
                CatalogRelManagerBO managerBO = new CatalogRelManagerBO();
                managerBO.setCatalogId((Long)catalogMap3.get(e.getCatalogName3()));
                managerBO.setCatalogName(e.getCatalogName3());
                managerBO.setManagerName(e.getManagerName());
                return managerBO;
            }).collect(Collectors.toList());
        }
        HashMap<Integer, List<CatalogRelManagerBO>> catalogMaps = new HashMap<Integer, List<CatalogRelManagerBO>>();
        catalogMaps.put(1, catalog1RelManagerBOS);
        catalogMaps.put(2, catalog2RelManagerBOS);
        catalogMaps.put(3, catalog3RelManagerBOS);
        return catalogMaps;
    }

    private void validate4(UccGuideManagerImportAbilityReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getUrl())) {
            throw new BusinessException("8888", "\u5165\u53c2 url \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private List<UccExcelImportGuideManageSpuBO> getInfoFromExcel(String url) {
        ArrayList<UccExcelImportGuideManageSpuBO> uccExcelImportGuideManageSpuBOS;
        block9: {
            List<Object> data = new ArrayList();
            List<String> head = null;
            try {
                List<List<String>> excel = this.dealEcxel(url, 2, 0);
                head = excel.get(0);
                data = this.dealEcxel(url, 2, 0);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ZTBusinessException(e.getMessage());
            }
            int rowNum = 2;
            uccExcelImportGuideManageSpuBOS = new ArrayList<UccExcelImportGuideManageSpuBO>();
            try {
                if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(data)) break block9;
                for (List list : data) {
                    String catalogName1;
                    ++rowNum;
                    UccExcelImportGuideManageSpuBO uccExcelImportGuideManageSpuBO = new UccExcelImportGuideManageSpuBO();
                    int i = 0;
                    if (StringUtils.isEmpty((Object)(catalogName1 = (String)list.get(i++)))) {
                        throw new BusinessException("8888", "\u6a21\u677f\u5185\u5bb9\u4e00\u7ea7\u7c7b\u76ee\u4fe1\u606f\u5fc5\u586b\uff01");
                    }
                    uccExcelImportGuideManageSpuBO.setCatalogName1(catalogName1);
                    String catalogName2 = (String)list.get(i++);
                    uccExcelImportGuideManageSpuBO.setCatalogName2(catalogName2);
                    String catalogName3 = (String)list.get(i++);
                    uccExcelImportGuideManageSpuBO.setCatalogName3(catalogName3);
                    String managerName = (String)list.get(i++);
                    if (StringUtils.isEmpty((Object)managerName)) {
                        throw new BusinessException("8888", "\u5f00\u53d1\u7ecf\u7406\u4fe1\u606f\u5fc5\u586b!");
                    }
                    try {
                        managerName = UccGuideManagerOperAbilityServiceImpl.doubleToInteger(managerName);
                    }
                    catch (Exception e) {
                        log.error("==\u8f6c\u6362\u5931\u8d25\uff01=====" + managerName);
                    }
                    uccExcelImportGuideManageSpuBO.setManagerName(managerName);
                    uccExcelImportGuideManageSpuBOS.add(uccExcelImportGuideManageSpuBO);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
                e.printStackTrace();
                throw new ZTBusinessException("\u7b2c" + rowNum + "\u884c\u6570\u636e\u51fa\u73b0\u95ee\u9898,\u8bf7\u68c0\u67e5\u683c\u5f0f!");
            }
        }
        log.info("==============\u8bfb\u53d6\u7684\u4fe1\u606f===============");
        log.info(JSON.toJSONString(uccExcelImportGuideManageSpuBOS));
        return uccExcelImportGuideManageSpuBOS;
    }

    public static String doubleToInteger(String str) {
        if (StringUtils.isEmpty((Object)str)) {
            return "";
        }
        return new BigDecimal(str).stripTrailingZeros().toPlainString();
    }

    private List<List<String>> dealEcxel(String url, Integer startReadLine, Integer sheetAt) {
        if (StringUtils.isEmpty((Object)url)) {
            return new ArrayList<List<String>>();
        }
        ArrayList<List<String>> lines = new ArrayList<List<String>>();
        try {
            ExcelNewUtils.getExcelDate((String)url, lines, (Integer)startReadLine, (Integer)sheetAt);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            throw new ZTBusinessException("\u5904\u7406Excel\u5931\u8d25");
        }
        log.info("\u8bfb\u53d6\u5230\u7684\u6570\u636e\uff1a" + JSONObject.toJSONString(lines));
        if (org.apache.commons.collections.CollectionUtils.isEmpty(lines)) {
            throw new BusinessException("8888", "\u6a21\u677f\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        return lines;
    }

    @PostMapping(value={"guideManagerDelete"})
    public UccGuideManagerDeleteAbilityRspBO guideManagerDelete(@RequestBody UccGuideManagerDeleteAbilityReqBO reqBO) {
        this.validate2(reqBO);
        return this.uccGuideManagerDeleteBusiService.guideManagerDelete(reqBO);
    }

    private void validate2(UccGuideManagerDeleteAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getIds())) {
            throw new BusinessException("8888", "\u5165\u53c2 ids \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    @PostMapping(value={"guideManagerUpdate"})
    public UccGuideManagerUpdateAbilityRspBO guideManagerUpdate(@RequestBody UccGuideManagerUpdateAbilityReqBO reqBO) {
        this.validate3(reqBO);
        return this.uccGuideManagerUpdateBusiService.guideManagerUpdate(reqBO);
    }

    private void validate3(UccGuideManagerUpdateAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getManagerUpdates())) {
            throw new BusinessException("8888", "\u5165\u53c2\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (UccGuideManagerUpdateBO update : reqBO.getManagerUpdates()) {
            if (CollectionUtils.isEmpty((Collection)update.getIds())) {
                throw new BusinessException("8888", "\u5165\u53c2 ids \u4e3a\u7a7a\uff01");
            }
            if (ObjectUtils.isEmpty((Object)update.getManagerId())) {
                throw new BusinessException("8888", "\u5165\u53c2 managerId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!ObjectUtils.isEmpty((Object)update.getManagerName())) continue;
            throw new BusinessException("8888", "\u5165\u53c2 managerName \u4e0d\u80fd\u672a\u7a7a\uff01");
        }
    }

    @PostMapping(value={"guideManagerList"})
    public UccGuideManagerListAbilityRspBO guideManagerList(@RequestBody UccGuideManagerListAbilityReqBO reqBO) {
        UccGuideManagerListAbilityRspBO rspBO = new UccGuideManagerListAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        UccGuideManagerRelPO uccGuideManagerRelPO = new UccGuideManagerRelPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)uccGuideManagerRelPO);
        List guideCatalogPOS = this.uccManagerRelGuideCatalogMapper.getRelManagerListByPage(uccGuideManagerRelPO, page);
        if (!CollectionUtils.isEmpty((Collection)guideCatalogPOS)) {
            List boList = guideCatalogPOS.stream().map(e -> {
                UccGuideManagerBO guideManagerBO = (UccGuideManagerBO)JSONObject.parseObject((String)JSON.toJSONString((Object)e), UccGuideManagerBO.class);
                return guideManagerBO;
            }).collect(Collectors.toList());
            rspBO.setRows(boList);
        }
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        return rspBO;
    }

    @PostMapping(value={"importManagerLinkUrl"})
    public UccGuideManagerLinkUrlImportAbilityRspBO importManagerLinkUrl(@RequestBody UccGuideManagerLinkUrlImportAbilityReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getUrl())) {
            throw new BusinessException("8888", "\u5165\u53c2 url \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List<UccExcelImportGuideManageSpuLinkUrlBO> urlInfoFromExcel = this.getUrlInfoFromExcel(reqBO.getUrl());
        if (CollectionUtils.isEmpty(urlInfoFromExcel)) {
            throw new BusinessException("8888", "\u6a21\u677f\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.validateSku(urlInfoFromExcel);
        UccGuideManagerLinkUrlImportBusiReqBO importBusiReqBO = new UccGuideManagerLinkUrlImportBusiReqBO();
        importBusiReqBO.setUserId(reqBO.getUserId());
        importBusiReqBO.setName(reqBO.getName());
        importBusiReqBO.setUsername(reqBO.getUsername());
        importBusiReqBO.setLinkUrlBOS(urlInfoFromExcel);
        return this.uccGuideManagerLinkUrlImportBusiService.dealImoortManagerLinkUrl(importBusiReqBO);
    }

    @PostMapping(value={"managerLinkUrlList"})
    public UccGuideManagerLinkUrlListAbilityRspBO managerLinkUrlList(@RequestBody UccGuideManagerLinkUrlListAbilityReqBO reqBO) {
        UccGuideManagerLinkUrlListAbilityRspBO rspBO = new UccGuideManagerLinkUrlListAbilityRspBO();
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        UccRiskManageUrlPO manageUrlPO = (UccRiskManageUrlPO)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), UccRiskManageUrlPO.class);
        List listPage = this.uccRiskManageUrlMapper.getListPage(manageUrlPO, page);
        if (!CollectionUtils.isEmpty((Collection)listPage)) {
            List collect = listPage.stream().map(e -> {
                UccGuideManagerLinkUrlBO urlBO = new UccGuideManagerLinkUrlBO();
                urlBO.setId(e.getId());
                urlBO.setContrastUrl1(e.getContrastUrl1());
                urlBO.setShopStr(e.getShopStr());
                urlBO.setSkuCode(e.getSkuCode());
                return urlBO;
            }).collect(Collectors.toList());
            rspBO.setRows(collect);
        }
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validateSku(List<UccExcelImportGuideManageSpuLinkUrlBO> urlInfoFromExcel) {
        List skuCodes = urlInfoFromExcel.stream().map(UccExcelImportGuideManageSpuLinkUrlBO::getSkuCode).distinct().collect(Collectors.toList());
        List skuCodeValis = this.uccSkuMapper.validateSkuCode(skuCodes);
        List<Object> fail = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)skuCodeValis)) {
            fail = skuCodes;
        } else if (skuCodeValis.size() != skuCodes.size()) {
            for (String skuCode : skuCodes) {
                if (skuCodeValis.contains(skuCode)) continue;
                fail.add(skuCode);
            }
        }
        if (!CollectionUtils.isEmpty(fail)) {
            throw new BusinessException("8888", "\u5355\u54c1\u7f16\u7801\u4e0d\u5b58\u5728\uff1a" + JSON.toJSONString(fail));
        }
    }

    private List<UccExcelImportGuideManageSpuLinkUrlBO> getUrlInfoFromExcel(String url) {
        ArrayList<UccExcelImportGuideManageSpuLinkUrlBO> uccExcelImportGuideManageSpuLinkUrlBOS;
        block10: {
            List<Object> data = new ArrayList();
            List<String> head = null;
            try {
                List<List<String>> excel = this.dealEcxel(url, 2, 0);
                head = excel.get(0);
                data = this.dealEcxel(url, 2, 0);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ZTBusinessException(e.getMessage());
            }
            int rowNum = 2;
            uccExcelImportGuideManageSpuLinkUrlBOS = new ArrayList<UccExcelImportGuideManageSpuLinkUrlBO>();
            try {
                if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(data)) break block10;
                for (List list : data) {
                    String skuCode;
                    ++rowNum;
                    UccExcelImportGuideManageSpuLinkUrlBO uccExcelImportGuideManageSpuLinkUrlBO = new UccExcelImportGuideManageSpuLinkUrlBO();
                    int i = 0;
                    if (StringUtils.isEmpty((Object)(skuCode = (String)list.get(i++)))) {
                        throw new BusinessException("8888", "\u6a21\u677f\u5185\u5bb9\u5355\u54c1\u7f16\u7801\u4fe1\u606f\u5fc5\u586b\uff01");
                    }
                    try {
                        skuCode = UccGuideManagerOperAbilityServiceImpl.doubleToInteger(skuCode);
                    }
                    catch (Exception e) {
                        log.error("======\u6570\u5b57\u8f6c\u6362\u5f02\u5e38=========" + skuCode);
                    }
                    uccExcelImportGuideManageSpuLinkUrlBO.setSkuCode(skuCode);
                    String shop = (String)list.get(i++);
                    if (StringUtils.isEmpty((Object)shop)) {
                        throw new BusinessException("8888", "\u6a21\u677f\u5185\u5bb9\u5bf9\u6bd4\u5546\u57ce\u4fe1\u606f\u5fc5\u586b\uff01");
                    }
                    uccExcelImportGuideManageSpuLinkUrlBO.setShopStr(shop);
                    String contrastUrl = (String)list.get(i++);
                    if (StringUtils.isEmpty((Object)contrastUrl)) {
                        throw new BusinessException("8888", "\u6a21\u677f\u5185\u5bb9\u94fe\u63a5\u4fe1\u606f\u5fc5\u586b\uff01");
                    }
                    uccExcelImportGuideManageSpuLinkUrlBO.setContrastUrl(contrastUrl);
                    uccExcelImportGuideManageSpuLinkUrlBOS.add(uccExcelImportGuideManageSpuLinkUrlBO);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
                e.printStackTrace();
                throw new ZTBusinessException("\u7b2c" + rowNum + "\u884c\u6570\u636e\u51fa\u73b0\u95ee\u9898,\u8bf7\u68c0\u67e5\u683c\u5f0f!");
            }
        }
        log.info("==============\u8bfb\u53d6\u7684\u4fe1\u606f===============");
        log.info(JSON.toJSONString(uccExcelImportGuideManageSpuLinkUrlBOS));
        return uccExcelImportGuideManageSpuLinkUrlBOS;
    }
}

