/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SelfRunSyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.common.ability.api.UccPricePreventOffShelveTaskAbilityService;
import com.tydic.commodity.common.ability.bo.UccPricePreventOffShelveAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccPricePreventOffShelveAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccPricePreventDownCommodBusiService;
import com.tydic.commodity.common.busi.bo.UccPricePreventDownCommodBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccPricePreventDownCommodBusiRspBO;
import com.tydic.commodity.dao.UccPricePreventDownRecordHistoryMapper;
import com.tydic.commodity.dao.UccPricePreventDownRecordMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccPricePreventDownRecordHistoryPO;
import com.tydic.commodity.po.UccPricePreventDownRecordPO;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccPricePreventOffShelveTaskAbilityService"})
public class UccPricePreventOffShelveAbilityServiceImpl
implements UccPricePreventOffShelveTaskAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccPricePreventOffShelveAbilityServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccPricePreventDownRecordMapper uccPricePreventDownRecordMapper;
    @Autowired
    private UccPricePreventDownRecordHistoryMapper uccPricePreventDownRecordHistoryMapper;
    @Autowired
    private UccPricePreventDownCommodBusiService uccPricePreventDownCommodBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    @PostMapping(value={"offShelve"})
    public UccPricePreventOffShelveAbilityRspBO offShelve(@RequestBody UccPricePreventOffShelveAbilityReqBo reqBo) {
        Page page = new Page(1, 100);
        List pricePreventDownRecordPOS = this.uccPricePreventDownRecordMapper.getListPage(new UccPricePreventDownRecordPO(), page);
        if (!CollectionUtils.isEmpty((Collection)pricePreventDownRecordPOS)) {
            UccPricePreventDownCommodBusiRspBO downCommodBusiRspBO = this.dealOffshelve(pricePreventDownRecordPOS);
            if ("0000".equals(downCommodBusiRspBO.getRespCode()) && !MapUtils.isEmpty(downCommodBusiRspBO.getSyncSkus())) {
                Map<Long, List<Long>> skuMap = downCommodBusiRspBO.getSyncSkus();
                for (Long shopId : skuMap.keySet()) {
                    SelfRunSyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SelfRunSyncSceneCommodityToEsReqBO();
                    syncSceneCommodityToEsReqBO.setSkuIds(skuMap.get(shopId));
                    syncSceneCommodityToEsReqBO.setSupplierId(shopId);
                    syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_UPDATE_TYPE);
                    syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                    syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS.intValue());
                    try {
                        this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        log.error("==\u5e97\u94fa\u540c\u6b65\u4e0b\u67b6\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff01" + e.getMessage());
                    }
                }
            }
            this.dealHistory(pricePreventDownRecordPOS);
        }
        UccPricePreventOffShelveAbilityRspBO rspBO = new UccPricePreventOffShelveAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private UccPricePreventDownCommodBusiRspBO dealOffshelve(List<UccPricePreventDownRecordPO> pricePreventDownRecordPOS) {
        UccPricePreventDownCommodBusiReqBO commodBusiReqBO = new UccPricePreventDownCommodBusiReqBO();
        commodBusiReqBO.setPricePreventDownRecordPOS(pricePreventDownRecordPOS);
        return this.uccPricePreventDownCommodBusiService.dealDownCommod(commodBusiReqBO);
    }

    private void dealHistory(List<UccPricePreventDownRecordPO> pricePreventDownRecordPOS) {
        try {
            this.uccPricePreventDownRecordMapper.deleteByIds(pricePreventDownRecordPOS.stream().map(UccPricePreventDownRecordPO::getId).collect(Collectors.toList()));
            List pricePreventDownRecordHistoryPOS = JSONObject.parseArray((String)JSON.toJSONString(pricePreventDownRecordPOS), UccPricePreventDownRecordHistoryPO.class);
            this.uccPricePreventDownRecordHistoryMapper.insertBatch(pricePreventDownRecordHistoryPOS);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u8fc1\u79fb\u5df2\u5904\u7406\u5386\u53f2\u6570\u636e\u5931\u8d25\uff01" + e.getMessage());
        }
    }
}

