/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.constant.ExcelUtils;
import com.tydic.commodity.common.ability.api.UccIteminstockEditAbilityService;
import com.tydic.commodity.common.ability.api.UccIteminstockModifyAbilityService;
import com.tydic.commodity.common.ability.api.UccSkuImportBatchEditStockAbilityService;
import com.tydic.commodity.common.ability.bo.UccImportInfo;
import com.tydic.commodity.common.ability.bo.UccIteminstockModifyAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccIteminstockModifyAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccIteminstockModifyBO;
import com.tydic.commodity.common.ability.bo.UccSkuImportBatchEditStockAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSkuImportBatchEditStockAbilityRspBO;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSkuImportBatchEditStockAbilityService"})
public class UccSkuImportBatchEditStockAbilityServiceImpl
implements UccSkuImportBatchEditStockAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuImportBatchEditStockAbilityServiceImpl.class);
    private static final int startReadLine = 2;
    @Autowired
    private UccIteminstockEditAbilityService uccIteminstockEditAbilityService;
    @Autowired
    private UccIteminstockModifyAbilityService uccIteminstockModifyAbilityService;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @PostMapping(value={"dealbatchEdit"})
    public UccSkuImportBatchEditStockAbilityRspBO dealbatchEdit(@RequestBody UccSkuImportBatchEditStockAbilityReqBO reqBO) {
        UccSkuImportBatchEditStockAbilityRspBO rspBO = new UccSkuImportBatchEditStockAbilityRspBO();
        List<UccImportInfo> data = this.getData(reqBO.getImportUrl());
        if (data.size() > 1000) {
            throw new ZTBusinessException("\u5bfc\u5165\u5e93\u5b58\u8bb0\u5f55\u603b\u6570\u8d85\u9650\uff01\u5355\u6b21\u5bfc\u5165\u6700\u591a\u652f\u63011000\u6761\u5355\u54c1\u5e93\u5b58\u4fe1\u606f");
        }
        ArrayList<String> failMsgList = new ArrayList<String>();
        UccIteminstockModifyAbilityReqBO uccIteminstockEditAbilityReqBO = new UccIteminstockModifyAbilityReqBO();
        ArrayList<UccIteminstockModifyBO> batchStock = new ArrayList<UccIteminstockModifyBO>();
        for (UccImportInfo uccImportInfo : data) {
            Integer serialNum = uccImportInfo.getSerialNum();
            if (uccImportInfo.getOperTupe() == null) {
                failMsgList.add("\u5e8f\u53f7" + serialNum + "\uff0c\u8c03\u6574\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff08\u586b\u5199\u201c\u589e\u52a0\u201d\u6216\u201c\u51cf\u5c11\u201d\uff09\uff1b");
                continue;
            }
            if (uccImportInfo.getNum() == null) {
                failMsgList.add("\u5e8f\u53f7" + serialNum + "\uff0c\u8c03\u6574\u5e45\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
                continue;
            }
            if (uccImportInfo.getOperTupe() == -1) {
                failMsgList.add("\u5e8f\u53f7" + serialNum + "\uff0c\u8c03\u6574\u7c7b\u578b\u586b\u5199\u9519\u8bef\uff0c\u53ea\u80fd\u586b\u5199\u201c\u589e\u52a0\u201d\u6216\u201c\u51cf\u5c11\u201d\uff1b");
                continue;
            }
            UccIteminstockModifyBO uccIteminstockEditBO = new UccIteminstockModifyBO();
            UccSkuPo uccSkuPo = this.uccSkuMapper.querySkuEntryBySkuCode(uccImportInfo.getSkuCode());
            if (uccSkuPo == null || uccSkuPo.getSkuId() == null) {
                failMsgList.add("\u5e8f\u53f7" + serialNum + "\uff0c\u5355\u54c1\u7f16\u7801\u4e0d\u5b58\u5728\uff1b");
                continue;
            }
            uccIteminstockEditBO.setSerialNum(serialNum);
            uccIteminstockEditBO.setSkuId(uccSkuPo.getSkuId());
            uccIteminstockEditBO.setSupplierShopId(uccSkuPo.getSupplierShopId());
            uccIteminstockEditBO.setOperTupe(uccImportInfo.getOperTupe());
            uccIteminstockEditBO.setNum(uccImportInfo.getNum());
            batchStock.add(uccIteminstockEditBO);
        }
        if (batchStock.size() > 0) {
            uccIteminstockEditAbilityReqBO.setBatchStock(batchStock);
            UccIteminstockModifyAbilityRspBO uccIteminstockEditAbilityRspBO = this.uccIteminstockModifyAbilityService.dealUccIteminstockEdit(uccIteminstockEditAbilityReqBO);
            BeanUtils.copyProperties((Object)uccIteminstockEditAbilityRspBO, (Object)rspBO);
            List fMsgList = rspBO.getFailMsgList();
            if (fMsgList != null && fMsgList.size() > 0) {
                failMsgList.addAll(fMsgList);
            }
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        failMsgList.sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return Integer.valueOf(o1.split("\uff0c")[0].replace("\u5e8f\u53f7", "")).compareTo(Integer.valueOf(o2.split("\uff0c")[0].replace("\u5e8f\u53f7", "")));
            }
        });
        int totalNum = data.size();
        rspBO.setTotalNum(Integer.valueOf(totalNum));
        rspBO.setSuccessNum(Integer.valueOf(totalNum - failMsgList.size()));
        rspBO.setFailNum(Integer.valueOf(failMsgList.size()));
        rspBO.setFailMsgList(failMsgList);
        return rspBO;
    }

    private List<UccImportInfo> getData(String url) {
        if (StringUtils.isEmpty((Object)url)) {
            throw new ZTBusinessException("\u8bf7\u4f20\u5165\u8def\u5f84\u4fe1\u606f");
        }
        List<Object> data = new ArrayList();
        try {
            data = this.dealEcxel(url);
        }
        catch (Exception e) {
            throw new ZTBusinessException(e.getMessage());
        }
        ArrayList<UccImportInfo> uccImportInfos = new ArrayList<UccImportInfo>();
        int rowNum = 1;
        try {
            if (CollectionUtils.isNotEmpty(data)) {
                for (List list : data) {
                    ++rowNum;
                    if (list.size() < 7) continue;
                    int i = 0;
                    UccImportInfo uccImportInfo = new UccImportInfo();
                    uccImportInfo.setSerialNum(Integer.valueOf((String)list.get(i++)));
                    uccImportInfo.setSkuName((String)list.get(i++));
                    uccImportInfo.setSkuId(Long.valueOf((String)list.get(i++)));
                    uccImportInfo.setSkuCode(uccImportInfo.getSkuId().toString());
                    if (!StringUtils.isEmpty(list.get(i))) {
                        uccImportInfo.setTotalNum(BigDecimal.valueOf(Long.parseLong((String)list.get(i++))));
                    } else {
                        ++i;
                    }
                    if (!StringUtils.isEmpty(list.get(i))) {
                        String operTupe;
                        if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)(operTupe = (String)list.get(i++)))) {
                            if ("\u589e\u52a0".equalsIgnoreCase(operTupe.trim())) {
                                uccImportInfo.setOperTupe(Integer.valueOf(1));
                            } else if ("\u51cf\u5c11".equalsIgnoreCase(operTupe.trim())) {
                                uccImportInfo.setOperTupe(Integer.valueOf(0));
                            } else {
                                uccImportInfo.setOperTupe(Integer.valueOf(-1));
                            }
                        }
                    } else {
                        ++i;
                    }
                    if (!StringUtils.isEmpty(list.get(i))) {
                        String s;
                        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(s = (String)list.get(i++)))) {
                            uccImportInfo.setNum(Long.valueOf(Long.parseLong(s)));
                        }
                    } else {
                        ++i;
                    }
                    if (!StringUtils.isEmpty(list.get(i))) {
                        uccImportInfo.setSaledNum(BigDecimal.valueOf(Long.parseLong((String)list.get(i++))));
                    } else {
                        ++i;
                    }
                    if (!StringUtils.isEmpty(list.get(i))) {
                        uccImportInfo.setCancelStock(BigDecimal.valueOf(Long.parseLong((String)list.get(i++))));
                    } else {
                        ++i;
                    }
                    uccImportInfos.add(uccImportInfo);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new ZTBusinessException("\u7b2c" + rowNum + "\u884c\u6570\u636e\u51fa\u73b0\u95ee\u9898,\u8bf7\u68c0\u67e5\u683c\u5f0f!");
        }
        log.info("\u8bfb\u53d6excel\u5230\u5b9e\u4f53\u7c7b\uff1a" + JSONObject.toJSONString(uccImportInfos));
        return uccImportInfos;
    }

    public static String doubleToInteger(String str) {
        if (StringUtils.isEmpty((Object)str)) {
            return "";
        }
        return new BigDecimal(str).stripTrailingZeros().toPlainString();
    }

    private List<List<String>> dealEcxel(String url) {
        if (StringUtils.isEmpty((Object)url)) {
            return new ArrayList<List<String>>();
        }
        ArrayList<List<String>> lines = new ArrayList<List<String>>();
        try {
            ExcelUtils.getExcelDate((String)url, lines, (Integer)2, (Integer)0);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new ZTBusinessException("\u5bfc\u5165\u6587\u6863\u4e0e\u5bfc\u51fa\u6a21\u677f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u5148\u4e0b\u8f7d\u5bfc\u51fa\u6a21\u677f");
        }
        log.info("\u8bfb\u53d6\u5230\u7684\u6570\u636e\uff1a" + JSONObject.toJSONString(lines));
        return lines;
    }
}

