/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.google.common.collect.Lists;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.bo.UccSourceTypeBo;
import com.tydic.commodity.base.constant.FuzzyFieldsEnum;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.common.ability.api.SearchCommodityManageAbilityService;
import com.tydic.commodity.common.ability.api.UccSkuPoolSkuListQryAbilityService;
import com.tydic.commodity.common.ability.bo.SearchCommodityManageAbilityReqBo;
import com.tydic.commodity.common.ability.bo.SearchCommodityManageAbilityRspBo;
import com.tydic.commodity.common.ability.bo.UccSkuPoolRelDataQryListAbilityBo;
import com.tydic.commodity.common.ability.bo.UccSkuPoolSkuListQryAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccSkuPoolSkuListQryAbilityRspBo;
import com.tydic.commodity.dao.UccRelPoolCommodityMapper;
import com.tydic.commodity.po.UccRelPoolCommodityPo;
import com.tydic.commodity.utils.ValidatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSkuPoolSkuListQryAbilityService"})
public class UccSkuPoolSkuListQryAbilityServiceImpl
implements UccSkuPoolSkuListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuPoolSkuListQryAbilityServiceImpl.class);
    @Autowired
    private SearchCommodityManageAbilityService searchCommodityManageAbilityService;
    @Autowired
    private UccRelPoolCommodityMapper uccRelPoolCommodityMapper;

    @PostMapping(value={"qrySkuPoolskuList"})
    public UccSkuPoolSkuListQryAbilityRspBo qrySkuPoolskuList(@RequestBody UccSkuPoolSkuListQryAbilityReqBo reqBo) {
        UccSkuPoolSkuListQryAbilityRspBo rspBo = new UccSkuPoolSkuListQryAbilityRspBo();
        try {
            ValidatorUtil.validator((Object)reqBo);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            rspBo.setRespDesc(e.getMessage());
            rspBo.setRespCode("8888");
            return rspBo;
        }
        switch (reqBo.getSearchType()) {
            case 0: {
                rspBo = this.getNRelSkuList(reqBo);
                break;
            }
            case 1: {
                rspBo = this.getRelSkuList(reqBo);
            }
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private UccSkuPoolSkuListQryAbilityRspBo getRelSkuList(UccSkuPoolSkuListQryAbilityReqBo reqBo) {
        SearchCommodityManageAbilityRspBo searchCommodityManageAbilityRspBo;
        UccSkuPoolSkuListQryAbilityRspBo rspBo = new UccSkuPoolSkuListQryAbilityRspBo();
        ArrayList uccSkuPoolRelDataQryListAbilityBos = new ArrayList();
        Page page = new Page(-1, reqBo.getPageSize());
        UccRelPoolCommodityPo cnncRelPoolCommodityPo = new UccRelPoolCommodityPo();
        cnncRelPoolCommodityPo.setPoolId(reqBo.getPoolId());
        cnncRelPoolCommodityPo.setPoolRelated(UccConstants.PoolRelatedType.relBySku);
        List cnncRelPoolCommodityPos = this.uccRelPoolCommodityMapper.queryPageList(page, cnncRelPoolCommodityPo);
        List<Long> relSkuIds = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty((Collection)cnncRelPoolCommodityPos) && reqBo.getSkuId() == null) {
            relSkuIds = cnncRelPoolCommodityPos.stream().map(a -> a.getSource()).collect(Collectors.toList());
        }
        if (reqBo.getSkuId() != null) {
            relSkuIds.add(reqBo.getSkuId());
        }
        SearchCommodityManageAbilityReqBo searchCommodityManageAbilityReqBo = new SearchCommodityManageAbilityReqBo();
        searchCommodityManageAbilityReqBo.setPoolIds((List)Lists.newArrayList((Object[])new Long[]{reqBo.getPoolId()}));
        searchCommodityManageAbilityReqBo.setCommodityCode(reqBo.getCommodityCode());
        searchCommodityManageAbilityReqBo.setSkuCode(reqBo.getSkuCode());
        searchCommodityManageAbilityReqBo.setCommodityName(reqBo.getCommodityName());
        searchCommodityManageAbilityReqBo.setSkuList(relSkuIds);
        searchCommodityManageAbilityReqBo.setSkuName(reqBo.getSkuName());
        searchCommodityManageAbilityReqBo.setTypeId(reqBo.getCommodityTypeId());
        searchCommodityManageAbilityReqBo.setVendorId(reqBo.getVendorId());
        searchCommodityManageAbilityReqBo.setAgreementIds(reqBo.getAgreementIds());
        searchCommodityManageAbilityReqBo.setBrandId(reqBo.getBrandId());
        searchCommodityManageAbilityReqBo.setPageSize(Integer.valueOf(reqBo.getPageSize()));
        searchCommodityManageAbilityReqBo.setPageNo(Integer.valueOf(reqBo.getPageNo()));
        searchCommodityManageAbilityReqBo.setSkuSource(reqBo.getSkuSource());
        List fuzzyFields = FuzzyFieldsEnum.getAllField();
        fuzzyFields.add("commodityName");
        fuzzyFields.add("commodityCode");
        fuzzyFields.add("skuCode");
        searchCommodityManageAbilityReqBo.setFuzzyFields(fuzzyFields);
        if (reqBo.getType() == 1) {
            searchCommodityManageAbilityReqBo.setIsFieldSku(Boolean.valueOf(false));
        }
        if ("0000".equals((searchCommodityManageAbilityRspBo = this.searchCommodityManageAbilityService.searchCommodity(searchCommodityManageAbilityReqBo)).getRespCode())) {
            if (!CollectionUtils.isEmpty((Collection)searchCommodityManageAbilityRspBo.getResult())) {
                searchCommodityManageAbilityRspBo.getResult().forEach(each -> {
                    UccSkuPoolRelDataQryListAbilityBo uccSkuPoolRelDataQryListAbilityBo = new UccSkuPoolRelDataQryListAbilityBo();
                    BeanUtils.copyProperties((Object)each, (Object)uccSkuPoolRelDataQryListAbilityBo);
                    if (uccSkuPoolRelDataQryListAbilityBo.getAgreementId() != null && uccSkuPoolRelDataQryListAbilityBo.getAgreementId() == 0L) {
                        uccSkuPoolRelDataQryListAbilityBo.setAgreementId(null);
                    }
                    uccSkuPoolRelDataQryListAbilityBo.setPicUrl(each.getComPicUrl());
                    uccSkuPoolRelDataQryListAbilityBos.add(uccSkuPoolRelDataQryListAbilityBo);
                });
            }
            rspBo.setRecordsTotal(searchCommodityManageAbilityRspBo.getRecordsTotal());
            rspBo.setTotal(searchCommodityManageAbilityRspBo.getTotal());
            rspBo.setPageNo(searchCommodityManageAbilityRspBo.getPageNo());
        }
        rspBo.setRows(uccSkuPoolRelDataQryListAbilityBos);
        return rspBo;
    }

    private UccSkuPoolSkuListQryAbilityRspBo getNRelSkuList(UccSkuPoolSkuListQryAbilityReqBo reqBo) {
        SearchCommodityManageAbilityRspBo searchCommodityManageAbilityRspBo;
        UccSkuPoolSkuListQryAbilityRspBo rspBo = new UccSkuPoolSkuListQryAbilityRspBo();
        ArrayList uccSkuPoolRelDataQryListAbilityBos = new ArrayList();
        Page page = new Page(-1, reqBo.getPageSize());
        UccRelPoolCommodityPo cnncRelPoolCommodityPo = new UccRelPoolCommodityPo();
        cnncRelPoolCommodityPo.setPoolId(reqBo.getPoolId());
        switch (reqBo.getOutType()) {
            case 1: {
                cnncRelPoolCommodityPo.setPoolRelated(UccConstants.PoolRelatedType.relByVendor);
                break;
            }
            case 2: {
                cnncRelPoolCommodityPo.setPoolRelated(UccConstants.PoolRelatedType.relByAgr);
                break;
            }
            case 3: {
                cnncRelPoolCommodityPo.setPoolRelated(UccConstants.PoolRelatedType.relByType);
                break;
            }
            case 4: {
                cnncRelPoolCommodityPo.setPoolRelated(UccConstants.PoolRelatedType.relBySku);
                break;
            }
            case 5: {
                cnncRelPoolCommodityPo.setPoolRelated(Integer.valueOf(5));
            }
        }
        List<Object> relDatas = new ArrayList();
        List cnncRelPoolCommodityPos = this.uccRelPoolCommodityMapper.queryPageList(page, cnncRelPoolCommodityPo);
        if (!CollectionUtils.isEmpty((Collection)cnncRelPoolCommodityPos)) {
            relDatas = cnncRelPoolCommodityPos.stream().map(a -> a.getSource()).collect(Collectors.toList());
        }
        SearchCommodityManageAbilityReqBo searchCommodityManageAbilityReqBo = new SearchCommodityManageAbilityReqBo();
        switch (reqBo.getOutType()) {
            case 1: {
                searchCommodityManageAbilityReqBo.setIgnoreVendorIds(relDatas);
                break;
            }
            case 2: {
                searchCommodityManageAbilityReqBo.setIgnoreAgrIds(relDatas);
                break;
            }
            case 3: {
                UccSourceTypeBo uccSourceTypeBo = new UccSourceTypeBo();
                uccSourceTypeBo.setType(relDatas);
                searchCommodityManageAbilityReqBo.setSearchIgnoreTypeList((List)Lists.newArrayList((Object[])new UccSourceTypeBo[]{uccSourceTypeBo}));
                break;
            }
            case 4: {
                searchCommodityManageAbilityReqBo.setIgnoreList(relDatas);
                break;
            }
            case 5: {
                searchCommodityManageAbilityReqBo.setIgnorSpuList(relDatas);
            }
        }
        if (reqBo.getSkuId() != null) {
            searchCommodityManageAbilityReqBo.setSkuList((List)Lists.newArrayList((Object[])new Long[]{reqBo.getSkuId()}));
        }
        searchCommodityManageAbilityReqBo.setCommodityName(reqBo.getCommodityName());
        searchCommodityManageAbilityReqBo.setCommodityCode(reqBo.getCommodityCode());
        searchCommodityManageAbilityReqBo.setSkuCode(reqBo.getSkuCode());
        searchCommodityManageAbilityReqBo.setSkuName(reqBo.getSkuName());
        searchCommodityManageAbilityReqBo.setTypeId(reqBo.getCommodityTypeId());
        searchCommodityManageAbilityReqBo.setVendorId(reqBo.getVendorId());
        searchCommodityManageAbilityReqBo.setAgreementIds(reqBo.getAgreementIds());
        searchCommodityManageAbilityReqBo.setBrandId(reqBo.getBrandId());
        searchCommodityManageAbilityReqBo.setPageSize(Integer.valueOf(reqBo.getPageSize()));
        searchCommodityManageAbilityReqBo.setSkuSource(reqBo.getSkuSource());
        searchCommodityManageAbilityReqBo.setPageNo(Integer.valueOf(reqBo.getPageNo()));
        List fuzzyFields = FuzzyFieldsEnum.getAllField();
        fuzzyFields.add("commodityName");
        fuzzyFields.add("commodityCode");
        fuzzyFields.add("skuCode");
        searchCommodityManageAbilityReqBo.setFuzzyFields(fuzzyFields);
        if (reqBo.getType() == 1) {
            searchCommodityManageAbilityReqBo.setIsFieldSku(Boolean.valueOf(false));
        }
        if ("0000".equals((searchCommodityManageAbilityRspBo = this.searchCommodityManageAbilityService.searchCommodity(searchCommodityManageAbilityReqBo)).getRespCode())) {
            if (!CollectionUtils.isEmpty((Collection)searchCommodityManageAbilityRspBo.getResult())) {
                searchCommodityManageAbilityRspBo.getResult().forEach(each -> {
                    UccSkuPoolRelDataQryListAbilityBo uccSkuPoolRelDataQryListAbilityBo = new UccSkuPoolRelDataQryListAbilityBo();
                    BeanUtils.copyProperties((Object)each, (Object)uccSkuPoolRelDataQryListAbilityBo);
                    if (uccSkuPoolRelDataQryListAbilityBo.getAgreementId() != null && uccSkuPoolRelDataQryListAbilityBo.getAgreementId() == 0L) {
                        uccSkuPoolRelDataQryListAbilityBo.setAgreementId(null);
                    }
                    uccSkuPoolRelDataQryListAbilityBo.setPicUrl(each.getComPicUrl());
                    uccSkuPoolRelDataQryListAbilityBos.add(uccSkuPoolRelDataQryListAbilityBo);
                });
            }
            rspBo.setRecordsTotal(searchCommodityManageAbilityRspBo.getRecordsTotal());
            rspBo.setTotal(searchCommodityManageAbilityRspBo.getTotal());
            rspBo.setPageNo(searchCommodityManageAbilityRspBo.getPageNo());
        }
        rspBo.setRows(uccSkuPoolRelDataQryListAbilityBos);
        return rspBo;
    }
}

