/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.base.bo.UccExcelImportBO;
import com.tydic.commodity.base.constant.FileUpLoad;
import com.tydic.commodity.common.ability.api.UccSkuStockDetailsTemplateImportAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuItemsStockListBO;
import com.tydic.commodity.common.ability.bo.UccSkuStockDetailsTemplateImportAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSkuStockDetailsTemplateImportAbilityRspBO;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSkuStockDetailsTemplateImportAbilityService"})
public class UccSkuStockDetailsTemplateImportAbilityServiceImpl
implements UccSkuStockDetailsTemplateImportAbilityService {
    private static final Logger log = LogManager.getLogger(UccSkuStockDetailsTemplateImportAbilityServiceImpl.class);
    @Autowired
    private FileUpLoad fileUpLoad;
    private static final String DATE_FORMAT = "yyyy/MM/dd";

    @PostMapping(value={"importSkuDetailsTemplate"})
    public UccSkuStockDetailsTemplateImportAbilityRspBO importSkuDetailsTemplate(@RequestBody UccSkuStockDetailsTemplateImportAbilityReqBO reqBO) {
        UccSkuStockDetailsTemplateImportAbilityRspBO rspBO = this.validateParams(reqBO);
        if (rspBO != null && !rspBO.getRespCode().equals("0000")) {
            return rspBO;
        }
        rspBO = new UccSkuStockDetailsTemplateImportAbilityRspBO();
        ArrayList<UccExcelImportBO> skuStockTemplateList = new ArrayList<UccExcelImportBO>();
        UccExcelImportBO commoditySkuTemp = new UccExcelImportBO();
        commoditySkuTemp.setSheet("\u5546\u54c1\u660e\u7ec6(\u5355\u54c1)\u5e93\u5b58\u5bfc\u5165\u6a21\u677f");
        ArrayList<String> skuTitle = new ArrayList<String>();
        skuTitle.add("\u5e8f\u53f7");
        skuTitle.add("\u5355\u54c1\u540d\u79f0");
        skuTitle.add("\u5355\u54c1\u7f16\u7801");
        skuTitle.add("\u539f\u59cb\u5e93\u5b58");
        skuTitle.add("\u8c03\u6574\u7c7b\u578b");
        skuTitle.add("\u8c03\u6574\u5e45\u5ea6");
        skuTitle.add("\u5df2\u552e\u6570\u91cf");
        skuTitle.add("\u9000\u8d27\u548c\u53d6\u6d88\u6570\u91cf");
        commoditySkuTemp.setTitle(skuTitle);
        skuStockTemplateList.add(commoditySkuTemp);
        UccExcelImportBO adjustTypeTemp = new UccExcelImportBO();
        adjustTypeTemp.setSheet("\u8c03\u6574\u7c7b\u578b");
        ArrayList<String> adjustTypeTitle = new ArrayList<String>();
        adjustTypeTitle.add("\u589e\u52a0");
        adjustTypeTitle.add("\u51cf\u5c11");
        adjustTypeTemp.setTitle(adjustTypeTitle);
        skuStockTemplateList.add(adjustTypeTemp);
        String url = this.dealImportTempToXmls(skuStockTemplateList, reqBO.getRows());
        rspBO.setUrl(url);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private UccSkuStockDetailsTemplateImportAbilityRspBO validateParams(UccSkuStockDetailsTemplateImportAbilityReqBO reqBO) {
        UccSkuStockDetailsTemplateImportAbilityRspBO rspBO = new UccSkuStockDetailsTemplateImportAbilityRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getRows())) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u5165\u53c2\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        for (UccSkuItemsStockListBO uccSkuItemsStockListBO : reqBO.getRows()) {
            if (uccSkuItemsStockListBO.getSkuName() == null) {
                rspBO.setRespCode("0001");
                rspBO.setRespDesc("\u5bfc\u51fa\u5355\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            if (uccSkuItemsStockListBO.getSkuCode() != null) continue;
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u5bfc\u51fa\u5355\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public String dealImportTempToXmls(List<UccExcelImportBO> importBOs, List<UccSkuItemsStockListBO> data) {
        log.info("\u5bfc\u5165\u6570\u636e\uff1a" + JSONObject.toJSONString(importBOs));
        String fileUrl = "";
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFCellStyle headlineStyle = workbook.createCellStyle();
        headlineStyle.setAlignment(HorizontalAlignment.CENTER);
        headlineStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        XSSFFont headFontStyle = workbook.createFont();
        headFontStyle.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
        headFontStyle.setFontHeightInPoints((short)18);
        headlineStyle.setFont((Font)headFontStyle);
        headlineStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headlineStyle.setFillForegroundColor(IndexedColors.WHITE.getIndex());
        XSSFCellStyle commonStyle = workbook.createCellStyle();
        XSSFFont commonFontStyle = workbook.createFont();
        XSSFCellStyle titleStyle = workbook.createCellStyle();
        XSSFFont titleFontStyle = workbook.createFont();
        XSSFCellStyle unlockStyle = workbook.createCellStyle();
        unlockStyle.setLocked(false);
        block6: for (int i = 0; i < importBOs.size(); ++i) {
            XSSFSheet sheet = workbook.createSheet(importBOs.get(i).getSheet());
            switch (i) {
                case 0: {
                    XSSFRow skuDetailsRow = sheet.createRow(0);
                    skuDetailsRow.setHeightInPoints(28.0f);
                    XSSFCell cell = skuDetailsRow.createCell(0);
                    XSSFCellStyle bodyStyle = workbook.createCellStyle();
                    bodyStyle.setVerticalAlignment(VerticalAlignment.TOP);
                    bodyStyle.setAlignment(HorizontalAlignment.LEFT);
                    bodyStyle.setWrapText(true);
                    XSSFFont fontStyle = workbook.createFont();
                    fontStyle.setFontName("\u5b8b\u4f53");
                    fontStyle.setFontHeightInPoints((short)11);
                    bodyStyle.setFont((Font)fontStyle);
                    cell.setCellStyle((CellStyle)bodyStyle);
                    sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 7));
                    String title = "\u6a21\u677f\u4f7f\u7528\u6ce8\u610f\u4e8b\u9879\uff1a\r\n       1\uff09\u6570\u636e\u5f55\u5165\u6ce8\u610f\u4e8b\u9879\uff1b\r\n       \uff081\uff09\u7ea2\u8272\u5b57\u4f53\u8868\u5934\u4e3a\u5fc5\u586b\u9879\uff1b\r\n       \uff082\uff09\u6700\u591a\u652f\u63011000\u6761\u5546\u54c1\u5e93\u5b58\u4fe1\u606f\u5bfc\u5165\uff1b\r\n       \uff083\uff09\u5355\u54c1\u540d\u79f0\uff0c\u5355\u54c1\u7f16\u7801\uff0c\u539f\u59cb\u5e93\u5b58\uff0c\u5df2\u552e\u5e93\u5b58\uff0c\u9000\u8d27\u548c\u53d6\u6d88\u5e93\u5b58\u81ea\u52a8\u5e26\u51fa\uff0c\u4e0d\u53ef\u4fee\u6539\uff1b\r\n       \uff084\uff09\u8c03\u6574\u7c7b\u578b\u8f93\u5165\u201c\u589e\u52a0\u201d\u6216\u201c\u51cf\u5c11\u201d\uff1b\u5373\u4ec5\u80fd\u9009\u62e9\u8c03\u6574\u7c7b\u578bsheet\u679a\u4e3e\u8f93\u5165\uff1b\r\n       \uff085\uff09\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9\uff0c\u4ee5\u9632\u65e0\u6cd5\u6b63\u786e\u5bfc\u5165\r\n2)\u6a21\u677f\u8868\u5934\u4f1a\u56fa\u5b9a\u5728\u7b2c2\u884c\uff0c\u8bf7\u52ff\u5220\u9664\u6216\u4fee\u6539\u6a21\u677f\u5185\u5bb9,\u4ee5\u9632\u65e0\u6cd5\u6b63\u786e\u5bfc\u5165\u3002";
                    cell.setCellValue(title);
                    skuDetailsRow = sheet.createRow(1);
                    for (int j = 0; j < importBOs.get(i).getTitle().size(); ++j) {
                        titleStyle = workbook.createCellStyle();
                        titleFontStyle.setFontName("\u9ed1\u4f53");
                        titleFontStyle.setFontHeightInPoints((short)14);
                        titleFontStyle.setBold(true);
                        titleStyle.setFont((Font)titleFontStyle);
                        titleStyle.setVerticalAlignment(VerticalAlignment.BOTTOM);
                        titleStyle.setAlignment(HorizontalAlignment.CENTER);
                        titleStyle.setWrapText(true);
                        titleStyle.setLocked(true);
                        titleStyle.setBorderTop(BorderStyle.THIN);
                        titleStyle.setBorderBottom(BorderStyle.THIN);
                        titleStyle.setBorderLeft(BorderStyle.THIN);
                        titleStyle.setBorderRight(BorderStyle.THIN);
                        titleStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                        titleStyle.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.getIndex());
                        if (j == 3) {
                            titleStyle.setFillForegroundColor(IndexedColors.LIGHT_ORANGE.getIndex());
                        }
                        cell = skuDetailsRow.createCell(j);
                        cell.setCellStyle((CellStyle)titleStyle);
                        cell.setCellValue((String)importBOs.get(i).getTitle().get(j));
                    }
                    XSSFDataValidationHelper dvHelper = new XSSFDataValidationHelper(sheet);
                    String[] textList = new String[]{"\u589e\u52a0", "\u51cf\u5c11"};
                    DataValidationConstraint dvConstraint = dvHelper.createExplicitListConstraint(textList);
                    CellRangeAddressList regions = new CellRangeAddressList(2, 65535, 4, 4);
                    DataValidation dataValidation = dvHelper.createValidation(dvConstraint, regions);
                    dataValidation.createErrorBox("Error", "\u8bf7\u9009\u62e9\u4e0b\u62c9\u6846\u4e2d\u7684\u76f8\u5e94\u503c\u586b\u5165");
                    dataValidation.setShowErrorBox(true);
                    dataValidation.setEmptyCellAllowed(true);
                    dataValidation.setSuppressDropDownArrow(true);
                    dataValidation.setShowPromptBox(true);
                    dataValidation.setErrorStyle(0);
                    sheet.addValidationData(dataValidation);
                    CellRangeAddressList dstAddrList2 = new CellRangeAddressList(2, 65536, 5, 5);
                    DataValidationConstraint dvc = dvHelper.createNumericConstraint(1, 0, "1", "9999999999");
                    DataValidation dataValidation2 = dvHelper.createValidation(dvc, dstAddrList2);
                    dataValidation2.createErrorBox("Error", "\u8bf7\u586b\u51991-9999999999\u4e4b\u95f4\u7684\u6574\u6570");
                    dataValidation2.setShowErrorBox(true);
                    dataValidation2.setEmptyCellAllowed(true);
                    dataValidation2.setSuppressDropDownArrow(true);
                    dataValidation2.setShowPromptBox(true);
                    dataValidation2.setErrorStyle(0);
                    sheet.addValidationData(dataValidation2);
                    int rowIndex = 0;
                    int lastCellIndex = 0;
                    for (UccSkuItemsStockListBO uccSkuItemsStockListBO2 : data) {
                        commonStyle = workbook.createCellStyle();
                        commonFontStyle = workbook.createFont();
                        commonFontStyle.setFontName("\u5b8b\u4f53");
                        commonStyle.setFont((Font)commonFontStyle);
                        commonStyle.setLocked(true);
                        commonStyle.setBorderTop(BorderStyle.THIN);
                        commonStyle.setBorderBottom(BorderStyle.THIN);
                        commonStyle.setBorderLeft(BorderStyle.THIN);
                        commonStyle.setBorderRight(BorderStyle.THIN);
                        commonStyle.setVerticalAlignment(VerticalAlignment.BOTTOM);
                        commonStyle.setAlignment(HorizontalAlignment.CENTER);
                        commonStyle.setFillBackgroundColor(IndexedColors.WHITE.getIndex());
                        unlockStyle = workbook.createCellStyle();
                        unlockStyle.setFont((Font)commonFontStyle);
                        unlockStyle.setLocked(false);
                        unlockStyle.setBorderTop(BorderStyle.THIN);
                        unlockStyle.setBorderBottom(BorderStyle.THIN);
                        unlockStyle.setBorderLeft(BorderStyle.THIN);
                        unlockStyle.setBorderRight(BorderStyle.THIN);
                        unlockStyle.setVerticalAlignment(VerticalAlignment.BOTTOM);
                        unlockStyle.setAlignment(HorizontalAlignment.CENTER);
                        unlockStyle.setFillBackgroundColor(IndexedColors.WHITE.getIndex());
                        int cellIndex = 0;
                        skuDetailsRow = sheet.createRow(2 + rowIndex++);
                        cell = skuDetailsRow.createCell(cellIndex++);
                        cell.setCellStyle((CellStyle)commonStyle);
                        cell.setCellValue(uccSkuItemsStockListBO2.getSerialNumber().toString());
                        cell = skuDetailsRow.createCell(cellIndex++);
                        cell.setCellStyle((CellStyle)commonStyle);
                        cell.setCellValue(uccSkuItemsStockListBO2.getSkuName());
                        cell = skuDetailsRow.createCell(cellIndex++);
                        cell.setCellStyle((CellStyle)commonStyle);
                        cell.setCellValue(uccSkuItemsStockListBO2.getSkuCode());
                        cell = skuDetailsRow.createCell(cellIndex++);
                        cell.setCellStyle((CellStyle)commonStyle);
                        cell.setCellValue(uccSkuItemsStockListBO2.getOrgStock() == null ? String.valueOf(0) : uccSkuItemsStockListBO2.getOrgStock().toString());
                        cell = skuDetailsRow.createCell(cellIndex++);
                        cell.setCellStyle((CellStyle)unlockStyle);
                        cell.setCellValue(uccSkuItemsStockListBO2.getAdjustType());
                        cell = skuDetailsRow.createCell(cellIndex++);
                        cell.setCellStyle((CellStyle)unlockStyle);
                        cell.setCellValue(uccSkuItemsStockListBO2.getAdjustRange());
                        cell = skuDetailsRow.createCell(cellIndex++);
                        cell.setCellStyle((CellStyle)commonStyle);
                        cell.setCellValue(uccSkuItemsStockListBO2.getSaleStock() == null ? String.valueOf(0) : uccSkuItemsStockListBO2.getSaleStock().toString());
                        cell = skuDetailsRow.createCell(cellIndex++);
                        cell.setCellStyle((CellStyle)commonStyle);
                        cell.setCellValue(uccSkuItemsStockListBO2.getCancelStock() == null ? String.valueOf(0) : uccSkuItemsStockListBO2.getCancelStock().toString());
                        lastCellIndex = cellIndex;
                    }
                    for (int begin = 0; begin < lastCellIndex; ++begin) {
                        sheet.setColumnWidth(begin, (int)((double)skuDetailsRow.getCell(begin).getStringCellValue().getBytes().length * 1.2 * 256.0 > 3072.0 ? (double)skuDetailsRow.getCell(begin).getStringCellValue().getBytes().length * 1.2 * 256.0 : 3072.0));
                    }
                    continue block6;
                }
                case 1: {
                    int n;
                    XSSFCell cell;
                    XSSFRow adjustTypeRow = sheet.createRow(0);
                    adjustTypeRow.setHeightInPoints(13.5f);
                    boolean bl = false;
                    while (n < importBOs.get(i).getTitle().size()) {
                        titleStyle = workbook.createCellStyle();
                        titleFontStyle = workbook.createFont();
                        titleFontStyle.setBold(true);
                        titleFontStyle.setFontHeightInPoints((short)13);
                        titleFontStyle.setFontName("\u9ed1\u4f53");
                        titleStyle.setFont((Font)titleFontStyle);
                        titleStyle.setVerticalAlignment(VerticalAlignment.BOTTOM);
                        titleStyle.setAlignment(HorizontalAlignment.CENTER);
                        titleStyle.setWrapText(true);
                        titleStyle.setBorderTop(BorderStyle.THIN);
                        titleStyle.setBorderBottom(BorderStyle.THIN);
                        titleStyle.setBorderLeft(BorderStyle.THIN);
                        titleStyle.setBorderRight(BorderStyle.THIN);
                        titleStyle.setLocked(false);
                        titleStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                        titleStyle.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.getIndex());
                        cell = adjustTypeRow.createCell(n);
                        cell.setCellStyle((CellStyle)titleStyle);
                        cell.setCellValue((String)importBOs.get(i).getTitle().get(n));
                        ++n;
                    }
                    n = 0;
                    for (UccSkuItemsStockListBO uccSkuItemsStockListBO3 : data) {
                        void var30_38;
                        commonStyle = workbook.createCellStyle();
                        commonFontStyle = workbook.createFont();
                        commonFontStyle.setFontName("\u5b8b\u4f53");
                        commonStyle.setFont((Font)commonFontStyle);
                        commonStyle.setLocked(true);
                        commonStyle.setBorderTop(BorderStyle.THIN);
                        commonStyle.setBorderBottom(BorderStyle.THIN);
                        commonStyle.setBorderLeft(BorderStyle.THIN);
                        commonStyle.setBorderRight(BorderStyle.THIN);
                        commonStyle.setVerticalAlignment(VerticalAlignment.BOTTOM);
                        commonStyle.setAlignment(HorizontalAlignment.CENTER);
                        commonStyle.setFillBackgroundColor(IndexedColors.WHITE.getIndex());
                        adjustTypeRow = sheet.createRow(1 + ++var30_38);
                        cell = adjustTypeRow.createCell(0);
                        cell.setCellStyle((CellStyle)commonStyle);
                        cell.setCellValue(uccSkuItemsStockListBO3.getAdjustType());
                        cell = adjustTypeRow.createCell(1);
                        cell.setCellStyle((CellStyle)commonStyle);
                        cell.setCellValue(uccSkuItemsStockListBO3.getAdjustRange());
                    }
                    for (int begin = 0; begin < 2; ++begin) {
                        sheet.setColumnWidth(begin, (int)((double)adjustTypeRow.getCell(begin).getStringCellValue().getBytes().length * 1.2 * 256.0 > 3072.0 ? (double)adjustTypeRow.getCell(begin).getStringCellValue().getBytes().length * 1.2 * 256.0 : 3072.0));
                    }
                    continue block6;
                }
            }
        }
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            workbook.write((OutputStream)outputStream);
            byte[] bytes = outputStream.toByteArray();
            data = data.stream().filter(uccSkuItemsStockListBO -> Objects.equals(uccSkuItemsStockListBO.getMenuCode(), "agrStockList")).collect(Collectors.toList());
            String fileNamePre = "\u5546\u54c1-\u5e93\u5b58\u7ba1\u7406-\u5546\u54c1\u5e93\u5b58\u901a\u7528\u5bfc\u51fa";
            if (data != null && data.size() > 0) {
                fileNamePre = fileNamePre.replace("\u65e0", "");
            }
            fileUrl = this.fileUpLoad.upload(fileNamePre + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()).trim().replace("-", "").replace(":", "").replace(" ", ""), bytes, ".xlsx");
            workbook.close();
            outputStream.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error("\u5bfc\u51faExcel\u51fa\u73b0\u4e25\u91cd\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + ex.getMessage());
        }
        return fileUrl;
    }
}

