/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccSpuCodingexportAbilityService;
import com.tydic.commodity.common.ability.api.UccSpuImageDetailsvalidationAbilityService;
import com.tydic.commodity.common.ability.bo.UccSpuCodingexportAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSpuImageDetailsvalidationAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccSpuImagevalidationAbilityReqBO;
import com.tydic.commodity.common.busi.api.UccSpuImagevalidationBusiService;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.utils.FtpUtils;
import com.tydic.commodity.utils.OssUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSpuImageDetailsvalidationAbilityService"})
public class UccSpuImageDetailsvalidationAbilityServiceImpl
implements UccSpuImageDetailsvalidationAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSpuImageDetailsvalidationAbilityServiceImpl.class);
    @Value(value="${ftp.fileHost}")
    private String fileHost;
    @Value(value="${ftp.fileUser}")
    private String fileUser;
    @Value(value="${ftp.filePwd}")
    private String filePwd;
    @Value(value="${ftp.filePort}")
    private String filePort;
    @Value(value="${ftp.timeOut}")
    private String timeOut;
    @Autowired
    private OssUtils ossUtils;
    private String[] picSuffix = new String[]{"-002", "-003", "-004", "-005"};
    @Autowired
    private FileClient fileClient;
    private static String filedir = "ucc/";
    @Value(value="${oss.accessUrl}")
    private String accessUrl;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccSpuCodingexportAbilityService uccSpuCodingexportAbilityService;
    @Autowired
    private UccSpuImagevalidationBusiService uccSpuImagevalidationBusiService;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"dealUccSpuImageDetailvalidation"})
    public UccSpuImageDetailsvalidationAbilityRspBO dealUccSpuImageDetailvalidation(@RequestBody UccSpuImagevalidationAbilityReqBO reqBO) {
        UccSpuImageDetailsvalidationAbilityRspBO rspBO = new UccSpuImageDetailsvalidationAbilityRspBO();
        if (StringUtils.isEmpty((Object)reqBO.getPath())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u9009\u62e9\u6587\u4ef6\u76ee\u5f55");
            return rspBO;
        }
        UccSpuCodingexportAbilityReqBO uccSpuCodingexportAbilityReqBO = new UccSpuCodingexportAbilityReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)uccSpuCodingexportAbilityReqBO);
        if (reqBO.getOperType() == null) {
            uccSpuCodingexportAbilityReqBO.setOperType(Integer.valueOf(0));
        }
        uccSpuCodingexportAbilityReqBO.setPageSize(10000);
        FtpUtils ftpUtil = new FtpUtils();
        ftpUtil.setFtpAddress(this.fileHost);
        ftpUtil.setFtpPort(Integer.valueOf(this.filePort).intValue());
        ftpUtil.setFtpUsername(this.fileUser);
        ftpUtil.setFtpPassword(this.filePwd);
        try {
            ftpUtil.List(reqBO.getPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        log.info("===\u56fe\u7247\u4fe1\u606f=====" + JSON.toJSONString((Object)ftpUtil.arFiles));
        if (CollectionUtils.isEmpty((Collection)ftpUtil.arFiles)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        ArrayList<String> matchFile = new ArrayList<String>();
        for (String fileName : ftpUtil.arFiles) {
            String[] splits;
            UccCommodityPo uccCommodityPo;
            boolean check = false;
            for (String suffix : this.picSuffix) {
                if (fileName.endsWith(suffix)) continue;
                check = true;
                break;
            }
            if (!check || ObjectUtils.isEmpty((Object)(uccCommodityPo = this.uccCommodityMapper.getCommodityIdByCode((splits = fileName.split("-"))[0])))) continue;
            matchFile.add(fileName);
        }
        if (CollectionUtils.isEmpty(matchFile)) {
            log.info("====\u672a\u5339\u914d\u5230\u56fe\u7247\u6570\u636e======");
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        HashMap<String, File> downFile = new HashMap();
        try {
            downFile = ftpUtil.downloadFilesToMap(reqBO.getPath(), null, matchFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (downFile.isEmpty()) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u56fe\u7247\u4e0b\u8f7d\u5931\u8d25");
            return rspBO;
        }
        Map<Object, Object> picUrl = new HashMap();
        try {
            picUrl = this.upOssFileUrl(downFile);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u56fe\u7247\u6821\u9a8c\u4e0a\u4f20oss\u5931\u8d25");
        }
        if (picUrl.isEmpty()) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("oss\u56fe\u7247\u4e0a\u4f20\u5931\u8d25");
            return rspBO;
        }
        HashMap<Long, ArrayList<Object>> spuDetailPicMap = new HashMap<Long, ArrayList<Object>>();
        for (String string : picUrl.keySet()) {
            String spuOrSkuCode = string.split("-")[0];
            UccCommodityPo spu = this.uccCommodityMapper.getCommodityIdByCode(spuOrSkuCode);
            if (ObjectUtils.isEmpty((Object)spu)) continue;
            if (!spuDetailPicMap.containsKey(spu.getCommodityId())) {
                spuDetailPicMap.put(spu.getCommodityId(), new ArrayList<Object>(Collections.singletonList(picUrl.get(string))));
                continue;
            }
            ((ArrayList)spuDetailPicMap.get(spu.getCommodityId())).add(picUrl.get(string));
        }
        rspBO.setSql(spuDetailPicMap.toString());
        ftpUtil.closeConnect();
        try {
            ftpUtil.deleteFile(reqBO.getPath(), matchFile);
        }
        catch (Exception exception) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("FTP\u56fe\u7247\u5220\u9664\u5931\u8d25");
            UccSpuImageDetailsvalidationAbilityRspBO uccSpuImageDetailsvalidationAbilityRspBO = rspBO;
            return uccSpuImageDetailsvalidationAbilityRspBO;
        }
        finally {
            ftpUtil.closeConnect();
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private Map<String, String> upOssFileUrl(Map<String, File> downFile) {
        Iterator<String> iterator = downFile.keySet().iterator();
        HashMap<String, String> picUrl = new HashMap<String, String>();
        InputStream bis = null;
        while (iterator.hasNext()) {
            String fileName = iterator.next();
            boolean check = false;
            for (String suffix : this.picSuffix) {
                if (!fileName.endsWith(suffix)) continue;
                check = true;
                break;
            }
            if (!check) {
                log.info("\u6587\u4ef6\u540d\u79f0\u540e\u7f00\u4e0d\u5c5e\u4e8e\u5355\u54c1\u6216\u5546\u54c1\u8303\u7574");
                continue;
            }
            File file = downFile.get(fileName);
            try {
                String originalFilename = file.getName();
                bis = new BufferedInputStream(new FileInputStream(file));
                String ossPath = this.fileClient.uploadFileByInputStream(filedir, originalFilename, bis);
                File[] arrayFile = new File[]{file};
                List list = this.ossUtils.upload(arrayFile);
                if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)list)) {
                    ossPath = (String)((Map)list.get(0)).get("url");
                }
                if (!StringUtils.isEmpty((Object)ossPath)) {
                    picUrl.put(fileName, ossPath);
                }
                if (log.isDebugEnabled()) {
                    log.debug("\u56fe\u7247\u4e0a\u4f20\u5b8c\u6210\uff1a \u5220\u9664\u672c\u5730\u6587\u4ef6" + file);
                }
                file.delete();
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u56fe\u7247\u6821\u9a8c\u4e0a\u4f20oss\u5931\u8d25");
            }
            finally {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return picUrl;
    }
}

