/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.base.enumType.ApprovalTypeEnum;
import com.tydic.commodity.base.enumType.CommodityEnum;
import com.tydic.commodity.common.ability.api.UccSpuManagementListQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccEsCommodityBo;
import com.tydic.commodity.common.ability.bo.UccSpuManagementListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSpuManagementListQryAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccSpuManagementListQryBO;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import com.tydic.commodity.dao.EacRuTaskMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuExpandMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.DicDictionaryPo;
import com.tydic.commodity.po.EacRuTaskPO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.MoneyUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSpuManagementListQryAbilityService"})
public class UccSpuManagementListQryAbilityServiceImpl
implements UccSpuManagementListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSpuManagementListQryAbilityServiceImpl.class);
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private EacRuTaskMapper eacRuTaskMapper;
    @Autowired
    private UccSkuExpandMapper uccSkuExpandMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    private Long userId;

    @PostMapping(value={"getSpuManagementListQry"})
    public UccSpuManagementListQryAbilityRspBO getSpuManagementListQry(@RequestBody UccSpuManagementListQryAbilityReqBO reqBO) {
        this.userId = reqBO.getUserId();
        UccSpuManagementListQryAbilityRspBO rspBo = new UccSpuManagementListQryAbilityRspBO();
        BoolQueryBuilder extBoolQueryBuilder = this.buildEsSql(reqBO);
        String queryString = this.excuteEsSql(reqBO, extBoolQueryBuilder);
        String result = this.searchInfo(queryString);
        if (StringUtils.isEmpty((Object)result)) {
            rspBo.setTotal(0);
            rspBo.setRespCode("0000");
            rspBo.setRecordsTotal(0);
            rspBo.setRows(new ArrayList());
            return rspBo;
        }
        rspBo = this.dealSearchData(result, reqBO);
        return rspBo;
    }

    private String searchInfo(String queryString) {
        String endPoint = "/" + this.esConfig.getIndexName() + "/" + this.esConfig.getEsType() + "/_search";
        log.info("source---->" + queryString);
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        try {
            Response response = this.elasticsearchUtil.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (log.isDebugEnabled()) {
                log.debug("result---->" + result);
            }
            return result;
        }
        catch (IOException e) {
            log.error("ioException", (Throwable)e);
            return null;
        }
    }

    private BoolQueryBuilder buildEsSql(UccSpuManagementListQryAbilityReqBO reqBo) {
        WildcardQueryBuilder wildcardQuery;
        WildcardQueryBuilder wildcardQuery2;
        BoolQueryBuilder shouldBuilder;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (reqBo.getSkuSource() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_source", (Object)reqBo.getSkuSource()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getUpcCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"upc", (String)reqBo.getUpcCode()));
        }
        if (reqBo.getSourceAssort() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sourceAssort", (Object)reqBo.getSourceAssort()));
        }
        if (reqBo.getApprovalStatus() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"spu_approval_status", (Object)reqBo.getApprovalStatus()));
        }
        if (reqBo.getBrandId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"brand_id", (Object)reqBo.getBrandId()));
        }
        if (reqBo.getVendorId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendor_id", (Object)reqBo.getVendorId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityTypeId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"type_id", (Object)reqBo.getCommodityTypeId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"commodity_id", (String)reqBo.getCommodityId()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExportCommodityIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"commodity_id", (Collection)reqBo.getExportCommodityIds()));
        }
        if (reqBo.getL4mgCategoryId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"L4mg_category_id", (Object)reqBo.getL4mgCategoryId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCreateOperId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"create_oper_id", (String)reqBo.getCreateOperId()));
        }
        if (reqBo.getSupplierShopId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_shop_id", (Object)reqBo.getSupplierShopId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSupplierOrgId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_org_id", (String)reqBo.getSupplierOrgId()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOperIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operIds", (Collection)reqBo.getOperIds()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOperOrgIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operOrgIds", (Collection)reqBo.getOperOrgIds()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOperRoleIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operRoleIds", (Collection)reqBo.getOperRoleIds()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOperStationCodes())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operStationCodes", (Collection)reqBo.getOperStationCodes()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOtherSourceCodes())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"other_source_code.keyword", (Collection)reqBo.getOtherSourceCodes()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getLimitOrderList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"limit_order", (Collection)reqBo.getLimitOrderList()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getCommodityStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"commodity_status", (Collection)reqBo.getCommodityStatus()));
        }
        if (reqBo.getAgreementId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"agreement_id", (Object)reqBo.getAgreementId()));
        }
        if (reqBo.getAgreementDetailsId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"agreement_details_id", (Object)reqBo.getAgreementDetailsId()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getCommodityTypeNames())) {
            shouldBuilder = QueryBuilders.boolQuery();
            for (String typeName : reqBo.getCommodityTypeNames()) {
                wildcardQuery2 = QueryBuilders.wildcardQuery((String)"type_name.keyword", (String)("*" + typeName + "*"));
                shouldBuilder.should((QueryBuilder)wildcardQuery2);
            }
            boolQueryBuilder.must((QueryBuilder)shouldBuilder);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSkuCodes())) {
            shouldBuilder = QueryBuilders.boolQuery();
            for (String skuCode : reqBo.getSkuCodes()) {
                wildcardQuery2 = QueryBuilders.wildcardQuery((String)"sku_code.keyword", (String)("*" + skuCode + "*"));
                shouldBuilder.should((QueryBuilder)wildcardQuery2);
            }
            boolQueryBuilder.must((QueryBuilder)shouldBuilder);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getCommodityCodes())) {
            shouldBuilder = QueryBuilders.boolQuery();
            for (String commodityCode : reqBo.getCommodityCodes()) {
                wildcardQuery2 = QueryBuilders.wildcardQuery((String)"commodity_code.keyword", (String)("*" + commodityCode + "*"));
                shouldBuilder.should((QueryBuilder)wildcardQuery2);
            }
            boolQueryBuilder.must((QueryBuilder)shouldBuilder);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getBrandName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"brand_name.keyword", (String)("*" + reqBo.getBrandName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_name.keyword", (String)("*" + reqBo.getCommodityName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityExpand1())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_expand1.keyword", (String)("*" + reqBo.getCommodityExpand1() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getVendorName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"vendor_name.keyword", (String)("*" + reqBo.getVendorName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOtherSourceName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"other_source_name.keyword", (String)("*" + reqBo.getOtherSourceName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getModel())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"model.keyword", (String)("*" + reqBo.getModel() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSpec())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"spec.keyword", (String)("*" + reqBo.getSpec() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMaterialCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"material_code.keyword", (String)("*" + reqBo.getMaterialCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMaterialName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"material_name.keyword", (String)("*" + reqBo.getMaterialName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOtherSourceCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"other_source_code.keyword", (String)("*" + reqBo.getOtherSourceCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_code.keyword", (String)("*" + reqBo.getCommodityCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        return boolQueryBuilder;
    }

    private String excuteEsSql(UccSpuManagementListQryAbilityReqBO reqBo, BoolQueryBuilder extBoolQueryBuilder) {
        JSONObject queryJson = new JSONObject();
        queryJson.put("track_total_hits", (Object)true);
        queryJson.put("size", (Object)reqBo.getPageSize());
        queryJson.put("from", (Object)(reqBo.getPageSize() * (reqBo.getPageNo() - 1)));
        String queryString = null;
        queryString = extBoolQueryBuilder.toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        FieldSortBuilder sortQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)"create_time").order(SortOrder.DESC);
        queryJson.put("sort", (Object)JSONObject.parseObject((String)sortQuery.toString()));
        JSONObject collapse = new JSONObject();
        collapse.put("field", (Object)"commodity_id");
        queryJson.put("collapse", (Object)collapse);
        JSONObject aggs = new JSONObject();
        if (reqBo.isCollapse()) {
            JSONObject total = new JSONObject();
            JSONObject cardinality = new JSONObject();
            total.put("field", (Object)"commodity_id");
            total.put("precision_threshold", (Object)40000);
            cardinality.put("cardinality", (Object)total);
            aggs.put("books_count", (Object)cardinality);
        }
        queryJson.put("aggs", (Object)aggs);
        return queryJson.toString();
    }

    private UccSpuManagementListQryAbilityRspBO dealSearchData(String result, UccSpuManagementListQryAbilityReqBO reqBo) {
        UccSpuManagementListQryAbilityRspBO rspBo = new UccSpuManagementListQryAbilityRspBO();
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = 0;
        try {
            total = hitsObj.getInteger("total");
        }
        catch (Exception e) {
            JSONObject totalObj = (JSONObject)hitsObj.get((Object)"total");
            total = totalObj.getInteger("value");
        }
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (log.isDebugEnabled()) {
            log.debug("\u603b\u8bb0\u5f55\u6570:" + total + " \u8fd4\u56de\u8bb0\u5f55\u6570\u636e" + listObject.size());
        }
        ArrayList<UccEsCommodityBo> commodityModels = new ArrayList<UccEsCommodityBo>();
        HashSet<Long> skuIdSet = new HashSet<Long>();
        if (listObject.size() > 0) {
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                UccEsCommodityBo commodity = new UccEsCommodityBo();
                try {
                    commodity = (UccEsCommodityBo)JSON.toJavaObject((JSON)data, UccEsCommodityBo.class);
                    commodityModels.add(commodity);
                    continue;
                }
                catch (Exception e) {
                    log.info("\u641c\u7d22es\u6570\u636e\u662f\u5355\u4e2a\u7684\u60c5\u51b5" + e.getMessage());
                    if (!skuIdSet.contains(commodity.getSku_id())) {
                        commodityModels.add(commodity);
                    }
                    skuIdSet.add(commodity.getSku_id());
                }
            }
        }
        if (reqBo.isCollapse()) {
            String agss = JSONObject.parseObject((String)result).get((Object)"aggregations").toString();
            total = Integer.valueOf(JSONObject.parseObject((String)JSONObject.parseObject((String)agss).get((Object)"books_count").toString()).get((Object)"value").toString());
        }
        rspBo = this.copyData(commodityModels, total, reqBo.getPageNo(), reqBo.getPageSize());
        return rspBo;
    }

    private UccSpuManagementListQryAbilityRspBO copyData(List<UccEsCommodityBo> commodityModels, Integer totalNum, int pageNo, int pageSize) {
        UccSpuManagementListQryAbilityRspBO rspBo = new UccSpuManagementListQryAbilityRspBO();
        ArrayList<UccSpuManagementListQryBO> uccSkuManagementListQryBOs = new ArrayList<UccSpuManagementListQryBO>();
        if (totalNum != null) {
            rspBo.setPageNo(pageNo);
            int size = pageSize;
            int totalPage = 0;
            int add = 0;
            Integer total = 0;
            totalPage = totalNum / size;
            add = totalNum % size == 0 ? 0 : 1;
            total = totalNum;
            rspBo.setTotal(totalPage + add);
            rspBo.setRecordsTotal(total.intValue());
            DicDictionaryPo dicDictionaryPo = null;
            if (!CollectionUtils.isEmpty(commodityModels)) {
                List commodityIds = commodityModels.stream().map(UccEsCommodityBo::getCommodity_id).distinct().collect(Collectors.toList());
                List uccSkuPos = this.uccSkuMapper.queryPreOnShelveDayByCommodityIds(commodityIds);
                Map<Object, Object> preOnShelveDayMap = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)uccSkuPos)) {
                    preOnShelveDayMap = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getCommodityId));
                }
                for (UccEsCommodityBo uccEsCommodityBo : commodityModels) {
                    UccSpuManagementListQryBO uccSpuManagementListQryBO = new UccSpuManagementListQryBO();
                    if (!MapUtils.isEmpty(preOnShelveDayMap) && preOnShelveDayMap.containsKey(uccEsCommodityBo.getCommodity_id())) {
                        uccSpuManagementListQryBO.setPreOnShelveDay(((UccSkuPo)((List)preOnShelveDayMap.get(uccEsCommodityBo.getCommodity_id())).get(0)).getPreOnShelveDay());
                    }
                    uccSpuManagementListQryBO.setCommodityCode(uccEsCommodityBo.getCommodity_code());
                    uccSpuManagementListQryBO.setCommodityId(Long.valueOf(uccEsCommodityBo.getCommodity_id()));
                    uccSpuManagementListQryBO.setCommodityName(uccEsCommodityBo.getCommodity_name());
                    uccSpuManagementListQryBO.setCommodityStatus(uccEsCommodityBo.getCommodity_status());
                    uccSpuManagementListQryBO.setCommodityTypeId(uccEsCommodityBo.getType_id());
                    uccSpuManagementListQryBO.setCommodityTypeName(uccEsCommodityBo.getType_name());
                    uccSpuManagementListQryBO.setApprovalStatus(uccEsCommodityBo.getSpu_approval_status());
                    uccSpuManagementListQryBO.setSkuSource(Integer.valueOf(uccEsCommodityBo.getSku_source()));
                    uccSpuManagementListQryBO.setMaterialName(uccEsCommodityBo.getMaterial_name());
                    uccSpuManagementListQryBO.setSpec(uccEsCommodityBo.getSpec());
                    uccSpuManagementListQryBO.setModel(uccEsCommodityBo.getModel());
                    uccSpuManagementListQryBO.setPicUrl(uccEsCommodityBo.getPicture_url());
                    uccSpuManagementListQryBO.setAgreementId(Long.valueOf(uccEsCommodityBo.getAgreement_id()));
                    if (!ObjectUtils.isEmpty((Object)uccEsCommodityBo.getPre_deliver_day())) {
                        uccSpuManagementListQryBO.setPreDeliverDay(Integer.valueOf(uccEsCommodityBo.getPre_deliver_day().intValue()));
                    }
                    if (this.userId != null && uccSpuManagementListQryBO.getApprovalStatus() != null && uccSpuManagementListQryBO.getApprovalStatus() != 0) {
                        EacRuTaskPO eacRuTaskPO = new EacRuTaskPO();
                        eacRuTaskPO.setBusinessId(uccSpuManagementListQryBO.getCommodityId().toString());
                        eacRuTaskPO.setStatus("ACTIVE");
                        eacRuTaskPO.setObjType(Integer.valueOf(Integer.parseInt(ApprovalTypeEnum.uccEditProcessOrder.getStep())));
                        eacRuTaskPO.setTacheCode(uccEsCommodityBo.getTache_code());
                        eacRuTaskPO.setUserId(this.userId.toString());
                        eacRuTaskPO.setOrderBy("CREATE_TIME");
                        List list = this.eacRuTaskMapper.getList(eacRuTaskPO);
                        if (!CollectionUtils.isEmpty((Collection)list)) {
                            uccSpuManagementListQryBO.setTaskId(((EacRuTaskPO)list.get(0)).getTaskId());
                            uccSpuManagementListQryBO.setIsJoinTransfer(((EacRuTaskPO)list.get(0)).getIsJoinTransfer());
                            uccSpuManagementListQryBO.setSubmitTime(((EacRuTaskPO)list.get(list.size() - 1)).getCreateTime());
                        }
                    }
                    if ((dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(uccEsCommodityBo.getCommodity_status().toString(), CommodityEnum.COMMODITY_STATUS.toString())) != null) {
                        uccSpuManagementListQryBO.setCommodityStatusDesc(dicDictionaryPo.getTitle());
                    }
                    if (uccEsCommodityBo.getSpu_approval_status() != null && (dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(uccEsCommodityBo.getSpu_approval_status()), CommodityEnum.SKU_APPROVAL_STATUS.toString())) != null) {
                        uccSpuManagementListQryBO.setApprovalStatusDesc(dicDictionaryPo.getTitle());
                    }
                    if (!StringUtils.isEmpty((Object)uccEsCommodityBo.getUpc()) && uccEsCommodityBo.getSku_source() == 3 && (dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(uccEsCommodityBo.getUpc(), "UCC_AGR_MODEL_CONFIG")) != null) {
                        uccSpuManagementListQryBO.setAgrModel(uccEsCommodityBo.getUpc());
                        uccSpuManagementListQryBO.setAgrModelStr(dicDictionaryPo.getTitle());
                    }
                    uccSpuManagementListQryBO.setSupplierShopId(uccEsCommodityBo.getSupplier_shop_id());
                    uccSpuManagementListQryBO.setBrandId(Long.valueOf(uccEsCommodityBo.getBrand_id()));
                    uccSpuManagementListQryBO.setBrandName(uccEsCommodityBo.getBrand_name());
                    uccSpuManagementListQryBO.setVendorId(uccEsCommodityBo.getVendor_id());
                    uccSpuManagementListQryBO.setVendorName(uccEsCommodityBo.getVendor_name());
                    uccSpuManagementListQryBO.setMeasureName(uccEsCommodityBo.getMeasure_name());
                    uccSpuManagementListQryBO.setL4mgCategoryId(uccEsCommodityBo.getL4mg_category_id());
                    uccSpuManagementListQryBO.setL4mgCategoryName(uccEsCommodityBo.getL4mg_category_name());
                    uccSpuManagementListQryBO.setOtherSourceCode(uccEsCommodityBo.getOther_source_code());
                    uccSpuManagementListQryBO.setOtherSourceName(uccEsCommodityBo.getOther_source_name());
                    uccSpuManagementListQryBO.setSourceAssort(uccEsCommodityBo.getSourceAssort());
                    uccSpuManagementListQryBO.setCommodityExpand1(uccEsCommodityBo.getCommodity_expand1());
                    uccSpuManagementListQryBO.setSettlementUnit(uccEsCommodityBo.getSettlement_unit());
                    uccSpuManagementListQryBO.setCreateOperName(uccEsCommodityBo.getCreate_oper_name());
                    uccSpuManagementListQryBO.setOrgName(uccEsCommodityBo.getSupplier_org_name());
                    uccSpuManagementListQryBO.setRate(uccEsCommodityBo.getTaxRate());
                    if (!ObjectUtils.isEmpty((Object)uccEsCommodityBo.getAgreement_price())) {
                        uccSpuManagementListQryBO.setAgreementPrice(MoneyUtils.haoToYuan((Long)uccEsCommodityBo.getAgreement_price()));
                    }
                    if (!ObjectUtils.isEmpty((Object)uccEsCommodityBo.getSale_price())) {
                        uccSpuManagementListQryBO.setSalePrice(MoneyUtils.haoToYuan((Long)uccEsCommodityBo.getSale_price()));
                    }
                    uccSkuManagementListQryBOs.add(uccSpuManagementListQryBO);
                }
            }
            rspBo.setRows(uccSkuManagementListQryBOs);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

