/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccWmsStockUpdateAbilityService;
import com.tydic.commodity.common.ability.bo.UccWmsStockOperBO;
import com.tydic.commodity.common.ability.bo.UccWmsStockUpdateAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccWmsStockUpdateAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccWmsStockUpdateBusiService;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccWmsMessageMapper;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccWmsMessagePO;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccWmsStockUpdateAbilityService"})
public class UccWmsStockUpdateAbilityServiceImpl
implements UccWmsStockUpdateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccWmsStockUpdateAbilityServiceImpl.class);
    @Autowired
    private UccWmsStockUpdateBusiService uccWmsStockUpdateBusiService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccWmsMessageMapper uccWmsMessageMapper;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    @PostMapping(value={"wmsStockUpdate"})
    public UccWmsStockUpdateAbilityRspBO wmsStockUpdate(@RequestBody UccWmsStockUpdateAbilityReqBO reqBO) {
        UccWmsStockUpdateAbilityRspBO rspBO = new UccWmsStockUpdateAbilityRspBO();
        Long messageId = this.addMessage(reqBO);
        this.validate(reqBO);
        UccWmsStockUpdateAbilityRspBO uccWmsStockUpdateAbilityRspBO = this.uccWmsStockUpdateBusiService.dealWmsStockUpdate(reqBO);
        SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
        try {
            if (!CollectionUtils.isEmpty((Collection)reqBO.getOperStocks())) {
                HashSet supplierShopIdSet = new HashSet(reqBO.getOperStocks().stream().map(UccWmsStockOperBO::getSupplierShopId).collect(Collectors.toList()));
                for (Long supplierShopId : supplierShopIdSet) {
                    Stream<UccWmsStockOperBO> uccIteminstockEditBOStream = reqBO.getOperStocks().stream().filter(uccIteminstockEditBO -> uccIteminstockEditBO.getSupplierShopId().equals(supplierShopId));
                    syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList((Iterable)uccIteminstockEditBOStream.map(UccWmsStockOperBO::getSkuId).collect(Collectors.toList())));
                    syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
                    syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_UPDATE_TYPE);
                    syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                    syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
                rspBO.setRespDesc("\u6210\u529f");
                rspBO.setRespCode("0000");
                return rspBO;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        this.updateMessage(JSON.toJSONString((Object)uccWmsStockUpdateAbilityRspBO), messageId);
        return uccWmsStockUpdateAbilityRspBO;
    }

    private void updateMessage(String toJSONString, Long messageId) {
        try {
            UccWmsMessagePO messagePO = new UccWmsMessagePO();
            messagePO.setStrDes(toJSONString);
            messagePO.setMessageId(messageId);
            this.uccWmsMessageMapper.updateById(messagePO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u66f4\u65b0\u6d88\u606f\u5904\u7406\u5f02\u5e38\uff01");
        }
    }

    private Long addMessage(UccWmsStockUpdateAbilityReqBO reqBO) {
        try {
            UccWmsMessagePO messagePO = new UccWmsMessagePO();
            messagePO.setStrDes("\u5904\u7406\u4e2d");
            messagePO.setMessageId(Long.valueOf(Sequence.getInstance().nextId()));
            messagePO.setCreateTime(new Date());
            messagePO.setStatus(UccConstants.COST_2);
            messagePO.setContent(JSON.toJSONString((Object)reqBO));
            this.uccWmsMessageMapper.insert(messagePO);
            return messagePO.getMessageId();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u65b0\u589e\u6d88\u606f\u5904\u7406\u5f02\u5e38\uff01");
            return null;
        }
    }

    private void validate(UccWmsStockUpdateAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getOperStocks())) {
            throw new BusinessException("8888", "\u5e93\u5b58\u64cd\u4f5c\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (UccWmsStockOperBO operStock : reqBO.getOperStocks()) {
            if (ObjectUtils.isEmpty((Object)operStock.getSkuCode())) {
                throw new BusinessException("8888", "\u5355\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            UccSkuPo skuPo = this.uccSkuMapper.getSkuInfoByCode(operStock.getSkuCode());
            if (ObjectUtils.isEmpty((Object)skuPo)) {
                throw new BusinessException("8888", "\u5355\u54c1\u7f16\u7801\u3010" + operStock.getSkuCode() + "\u3011\u4e0d\u5b58\u5728\uff01");
            }
            operStock.setSkuId(skuPo.getSkuId());
            operStock.setSupplierShopId(skuPo.getSupplierShopId());
            if (ObjectUtils.isEmpty((Object)operStock.getOperType())) {
                throw new BusinessException("8888", "\u5e93\u5b58\u8c03\u6574\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (operStock.getOperType() != 1 && operStock.getOperType() != 2) {
                throw new BusinessException("8888", "\u7f16\u7801\u4e3a\u3010" + operStock.getSkuCode() + "\u3011\u7684\u5355\u54c1\u4fe1\u606f\u64cd\u4f5c\u7c7b\u578b\u4e0d\u5408\u6cd5\uff01");
            }
            if (!ObjectUtils.isEmpty((Object)operStock.getOperNum())) continue;
            throw new BusinessException("8888", "\u64cd\u4f5c\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

