/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccSpuCodingexportAbilityService;
import com.tydic.commodity.common.ability.bo.UccBatchSpuImageUpdateAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccBatchSpuImageUpdateAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccExprotCodeBo;
import com.tydic.commodity.common.ability.bo.UccSpuCodingexportAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSpuCodingexportAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccBatchSpuImageUpdateBusiService;
import com.tydic.commodity.dao.UccCommodityPicDefaltConfigMapper;
import com.tydic.commodity.dao.UccCommodityPicMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPicMapper;
import com.tydic.commodity.po.UccCommodityPicDefaltConfigPO;
import com.tydic.commodity.po.UccCommodityPicPo;
import com.tydic.commodity.po.UccSkuPicPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccBatchSpuImageUpdateBusiServiceImpl
implements UccBatchSpuImageUpdateBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccBatchSpuImageUpdateBusiServiceImpl.class);
    @Autowired
    private UccCommodityPicDefaltConfigMapper uccCommodityPicDefaltConfigMapper;
    private static final Sequence SEQUENCE = Sequence.getInstance();
    @Autowired
    private UccSpuCodingexportAbilityService uccSpuCodingexportAbilityService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityPicMapper uccCommodityPicMapper;
    @Autowired
    private UccSkuPicMapper uccSkuPicMapper;

    @Override
    public UccBatchSpuImageUpdateAbilityRspBO batchSpuImageUpdate(UccBatchSpuImageUpdateAbilityReqBO reqBO) {
        List<UccCommodityPicDefaltConfigPO> uccCommodityPicDefaltConfigPOS = this.dealConfig(reqBO);
        List<UccExprotCodeBo> uccExprotCodeBos = this.dealUpdatePic(uccCommodityPicDefaltConfigPOS);
        UccBatchSpuImageUpdateAbilityRspBO rspBO = new UccBatchSpuImageUpdateAbilityRspBO();
        if (!CollectionUtils.isEmpty(uccExprotCodeBos)) {
            Map commoditysMap = uccExprotCodeBos.stream().collect(Collectors.groupingBy(UccExprotCodeBo::getSupplierShopId, Collectors.mapping(UccExprotCodeBo::getCommodityId, Collectors.toList())));
            rspBO.setSysMap(commoditysMap);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<UccExprotCodeBo> dealUpdatePic(List<UccCommodityPicDefaltConfigPO> uccCommodityPicDefaltConfigPOS) {
        UccSpuCodingexportAbilityReqBO spuCodingexportAbilityReqBO = new UccSpuCodingexportAbilityReqBO();
        spuCodingexportAbilityReqBO.setSkuSource(Integer.valueOf(3));
        spuCodingexportAbilityReqBO.setCommodityStatus(Integer.valueOf(0));
        spuCodingexportAbilityReqBO.setPageSize(20000);
        spuCodingexportAbilityReqBO.setOperType(Integer.valueOf(1));
        UccSpuCodingexportAbilityRspBO uccSpuCodingexportAbilityRspBO = this.uccSpuCodingexportAbilityService.dealUccSpuCodingexport(spuCodingexportAbilityReqBO);
        log.info("====\u65e0\u56fe\u7247\u5546\u54c1\u51fa\u53c2\u4fe1\u606f====");
        log.info(JSON.toJSONString((Object)uccSpuCodingexportAbilityRspBO));
        if ("0000".equals(uccSpuCodingexportAbilityRspBO.getRespCode())) {
            if (!CollectionUtils.isEmpty((Collection)uccSpuCodingexportAbilityRspBO.getRows())) {
                this.dealUpdatePics(uccSpuCodingexportAbilityRspBO.getRows(), uccCommodityPicDefaltConfigPOS);
                return uccSpuCodingexportAbilityRspBO.getRows();
            }
            return new ArrayList<UccExprotCodeBo>();
        }
        throw new BusinessException("8888", "\u5546\u54c1\u56fe\u7247\u4e3a\u7a7a\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff01" + uccSpuCodingexportAbilityRspBO.getRespDesc());
    }

    private void dealUpdatePics(List<UccExprotCodeBo> rows, List<UccCommodityPicDefaltConfigPO> uccCommodityPicDefaltConfigPOS) {
        List commodityIds = rows.stream().map(UccExprotCodeBo::getCommodityId).distinct().collect(Collectors.toList());
        List skuIds = rows.stream().map(UccExprotCodeBo::getSkuId).distinct().collect(Collectors.toList());
        Map<Integer, List<UccCommodityPicDefaltConfigPO>> configPicMaps = uccCommodityPicDefaltConfigPOS.stream().collect(Collectors.groupingBy(UccCommodityPicDefaltConfigPO::getCommodityPicType));
        List<UccCommodityPicDefaltConfigPO> detailPics = configPicMaps.get(2);
        log.info("\u8be6\u60c5\u56fe\u4fe1\u606f==" + JSON.toJSONString(detailPics));
        this.uccSkuPicMapper.updateSkuPicBySkus(skuIds, configPicMaps.get(1).get(0).getCommodityPicUrl());
        this.uccCommodityPicMapper.updateSkuPicBySpus(commodityIds, configPicMaps.get(1).get(0).getCommodityPicUrl());
        List commodityPicPos = this.uccCommodityPicMapper.getListBySpuIds(commodityIds);
        List skuPicPos = this.uccSkuMapper.getListBySkuIds(skuIds);
        if (CollectionUtils.isEmpty((Collection)commodityPicPos) || CollectionUtils.isEmpty((Collection)skuPicPos)) {
            throw new BusinessException("8888", "\u5546\u54c1\u6216\u8005\u5355\u54c1\u67e5\u8be2\u8be6\u60c5\u56fe\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        Map<Long, List<UccCommodityPicPo>> commPicMap = commodityPicPos.stream().collect(Collectors.groupingBy(UccCommodityPicPo::getCommodityId));
        for (Long commodityId : commPicMap.keySet()) {
            int count = 0;
            for (UccCommodityPicPo commodityPicPo : commPicMap.get(commodityId)) {
                if (count == 0) {
                    commodityPicPo.setCommodityPicUrl(detailPics.get(0).getCommodityPicUrl());
                }
                if (count == 1) {
                    commodityPicPo.setCommodityPicUrl(detailPics.get(1).getCommodityPicUrl());
                }
                if (count == 2) {
                    commodityPicPo.setCommodityPicUrl(detailPics.get(2).getCommodityPicUrl());
                }
                if (count == 3) {
                    commodityPicPo.setCommodityPicUrl(detailPics.get(3).getCommodityPicUrl());
                }
                ++count;
            }
            try {
                this.uccCommodityPicMapper.updateBatchCommodityPicById(commPicMap.get(commodityId), commodityId);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BusinessException("8888", "\u6279\u91cf\u66f4\u65b0\u5546\u54c1\u56fe\u7247\u5931\u8d25\uff01" + e.getMessage());
            }
        }
        Map<Long, List<UccSkuPicPo>> skuPicMap = skuPicPos.stream().collect(Collectors.groupingBy(UccSkuPicPo::getSkuId));
        for (Long skuId : skuPicMap.keySet()) {
            int count = 0;
            log.info("\u5355\u54c1\u4fe1\u606f=" + JSON.toJSONString(skuPicMap.get(skuId)));
            for (UccSkuPicPo skuPicPo : skuPicMap.get(skuId)) {
                if (count == 0) {
                    skuPicPo.setSkuPicUrl(detailPics.get(0).getCommodityPicUrl());
                }
                if (count == 1) {
                    skuPicPo.setSkuPicUrl(detailPics.get(1).getCommodityPicUrl());
                }
                if (count == 2) {
                    skuPicPo.setSkuPicUrl(detailPics.get(2).getCommodityPicUrl());
                }
                if (count == 3) {
                    skuPicPo.setSkuPicUrl(detailPics.get(3).getCommodityPicUrl());
                }
                ++count;
            }
            try {
                this.uccSkuPicMapper.updateBatchskuPicById(skuPicMap.get(skuId), skuId);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BusinessException("8888", "\u6279\u91cf\u66f4\u65b0\u5355\u54c1\u56fe\u7247\u5931\u8d25\uff01" + e.getMessage());
            }
        }
    }

    private List<UccCommodityPicDefaltConfigPO> dealConfig(UccBatchSpuImageUpdateAbilityReqBO reqBO) {
        this.uccCommodityPicDefaltConfigMapper.updateStatus();
        long batchId = SEQUENCE.nextId();
        Date time = new Date();
        List<UccCommodityPicDefaltConfigPO> uccCommodityPicDefaltConfigPOS = reqBO.getList().stream().map(e -> {
            UccCommodityPicDefaltConfigPO po = new UccCommodityPicDefaltConfigPO();
            po.setBatchId(Long.valueOf(batchId));
            po.setId(Long.valueOf(SEQUENCE.nextId()));
            po.setCommodityPicType(e.getCommodityPicType());
            po.setCommodityPicUrl(e.getCommodityPicUrl());
            po.setCreateOperId(reqBO.getUsername());
            po.setCreateTime(time);
            po.setUpdateOperId(reqBO.getUsername());
            po.setUpdateTime(time);
            po.setStatus(Integer.valueOf(0));
            return po;
        }).collect(Collectors.toList());
        try {
            this.uccCommodityPicDefaltConfigMapper.insertBatch(uccCommodityPicDefaltConfigPOS);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new BusinessException("8888", "\u66f4\u65b0 \u9ed8\u8ba4\u56fe\u7247\u914d\u7f6e\u5931\u8d25\uff01" + e2.getMessage());
        }
        return uccCommodityPicDefaltConfigPOS;
    }
}

