/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.UccGuideManagerAddAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccGuideManagerAddAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccGuideManagerAddBusiService;
import com.tydic.commodity.dao.UccGuideCatalogExtMapper;
import com.tydic.commodity.dao.UccManagerRelGuideCatalogMapper;
import com.tydic.commodity.po.UccManagerRelGuideCatalogPO;
import com.tydic.commodity.po.UccOrgCatalogCandidateListPO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccGuideManagerAddBusiServiceImpl
implements UccGuideManagerAddBusiService {
    @Autowired
    private UccManagerRelGuideCatalogMapper uccManagerRelGuideCatalogMapper;
    @Autowired
    private UccGuideCatalogExtMapper uccGuideCatalogExtMapper;
    private static final Sequence SEQUENCE = Sequence.getInstance();

    @Override
    public UccGuideManagerAddAbilityRspBO guideManagerAdd(UccGuideManagerAddAbilityReqBO reqBO) {
        List<Long> catalogIds = this.getEndCatalogIds(reqBO.getLevel(), reqBO.getGuideCatalogIds());
        this.deleteCatalogs(catalogIds);
        this.addCatalogs(reqBO, catalogIds);
        UccGuideManagerAddAbilityRspBO rspBO = new UccGuideManagerAddAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void addCatalogs(UccGuideManagerAddAbilityReqBO reqBO, List<Long> catalogIds) {
        try {
            Date time = new Date();
            List relGuideCatalogPOS = catalogIds.stream().map(catalogId -> {
                UccManagerRelGuideCatalogPO relGuideCatalogPO = new UccManagerRelGuideCatalogPO();
                relGuideCatalogPO.setId(Long.valueOf(SEQUENCE.nextId()));
                relGuideCatalogPO.setLastCatalogId(catalogId);
                relGuideCatalogPO.setManagerId(reqBO.getManagerId());
                relGuideCatalogPO.setManagerName(reqBO.getManagerName());
                relGuideCatalogPO.setCreateTime(time);
                relGuideCatalogPO.setOperId(reqBO.getUserId());
                relGuideCatalogPO.setOperName(reqBO.getName());
                relGuideCatalogPO.setLevel(reqBO.getLevel());
                return relGuideCatalogPO;
            }).collect(Collectors.toList());
            this.uccManagerRelGuideCatalogMapper.insertBatch(relGuideCatalogPOS);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("8888", "\u6279\u91cf\u65b0\u589e \u7c7b\u76ee-\u5f00\u53d1\u7ecf\u7406\u5173\u8054\u4fe1\u606f\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    private void deleteCatalogs(List<Long> catalogIds) {
        UccManagerRelGuideCatalogPO catalogPO = new UccManagerRelGuideCatalogPO();
        catalogPO.setLastCatalogIds(catalogIds);
        try {
            this.uccManagerRelGuideCatalogMapper.deleteBy(catalogPO);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("8888", "\u5220\u9664\u5df2\u5b58\u5728\u7684\u7c7b\u76ee-\u5173\u8054\u4fe1\u606f\u5931\u8d25\uff01");
        }
    }

    private List<Long> getEndCatalogIds(Integer level, List<Long> guideCatalogIds) {
        List catalogPOS = null;
        switch (level) {
            case 1: {
                catalogPOS = this.uccGuideCatalogExtMapper.getEndLevelByCatalog1(level, guideCatalogIds);
                break;
            }
            case 2: {
                catalogPOS = this.uccGuideCatalogExtMapper.getEndLevelByCatalog2(level, guideCatalogIds);
                break;
            }
            case 3: {
                catalogPOS = this.uccGuideCatalogExtMapper.getCatalogInfo(level, guideCatalogIds);
                break;
            }
            default: {
                throw new BusinessException("8888", "level \u4e0d\u5408\u6cd5\uff01");
            }
        }
        if (CollectionUtils.isEmpty((Collection)catalogPOS)) {
            throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u4e09\u7ea7\u7c7b\u76ee\u4fe1\u606f\uff01");
        }
        return catalogPOS.stream().map(UccOrgCatalogCandidateListPO::getCatalogId).collect(Collectors.toList());
    }
}

