/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.common.busi.api.UccInquiryMySheetDetailListQryBusiService;
import com.tydic.commodity.common.busi.bo.UccInquiryMyQuotationDetailBO;
import com.tydic.commodity.common.busi.bo.UccInquiryMySheetDetailListQryBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccInquiryMySheetDetailListQryBusiRspBO;
import com.tydic.commodity.common.busi.bo.UccInquirySheetQryDetailBO;
import com.tydic.commodity.dao.UccInquirySheetDetailMapper;
import com.tydic.commodity.po.UccInquirySheetInfoPO;
import com.tydic.commodity.po.UccInquirySheetInfoQryPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccInquiryMySheetDetailListQryBusiServiceImpl
implements UccInquiryMySheetDetailListQryBusiService {
    @Autowired
    private UccInquirySheetDetailMapper uccInquirySheetDetailMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;

    @Override
    public UccInquiryMySheetDetailListQryBusiRspBO inquiryMySheetDetailListQry(UccInquiryMySheetDetailListQryBusiReqBO reqBO) {
        UccInquiryMySheetDetailListQryBusiRspBO rspBO = new UccInquiryMySheetDetailListQryBusiRspBO();
        UccInquirySheetInfoQryPO qryPO = (UccInquirySheetInfoQryPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)reqBO)), UccInquirySheetInfoQryPO.class);
        List rows = new ArrayList();
        if (reqBO.getPageQueryFlag().booleanValue()) {
            Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
            rows = this.uccInquirySheetDetailMapper.queryInquirySheetInfoList(qryPO, page);
            rspBO.setTotal(page.getTotalPages());
            rspBO.setRecordsTotal(page.getTotalCount());
            rspBO.setPageNo(page.getPageNo());
        } else {
            rows = this.uccInquirySheetDetailMapper.queryInquirySheetInfoList(qryPO);
        }
        ArrayList<UccInquirySheetQryDetailBO> dataList = new ArrayList<UccInquirySheetQryDetailBO>();
        this.buildRspBO(dataList, rows);
        rspBO.setRows(dataList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public void buildRspBO(List<UccInquirySheetQryDetailBO> dataList, List<UccInquirySheetInfoPO> rows) {
        Map<String, String> quotationStatusMap = this.uccDictionaryAtomService.queryBypCodeBackMap("QUOTATION_STATUS_MANGER");
        if (!CollectionUtils.isEmpty(rows)) {
            for (UccInquirySheetInfoPO row : rows) {
                UccInquirySheetQryDetailBO sheetQryDetailBO = new UccInquirySheetQryDetailBO();
                sheetQryDetailBO.setInquirySheetDetailId(row.getInquirySheetDetailId());
                sheetQryDetailBO.setInquirySheetDetailCode(row.getSheetDeliveryPlaceCode());
                sheetQryDetailBO.setInquirySheetId(row.getInquirySheetId());
                sheetQryDetailBO.setSku(row.getSheetSku());
                sheetQryDetailBO.setGoodsName(row.getSheetGoodsName());
                sheetQryDetailBO.setQuantity(row.getSheetQuantity());
                sheetQryDetailBO.setBrand(row.getSheetBrand());
                sheetQryDetailBO.setModel(row.getSheetModel());
                sheetQryDetailBO.setSpec(row.getSheetSpec());
                sheetQryDetailBO.setCategoryId(row.getSheetCategoryId());
                sheetQryDetailBO.setCategoryName(row.getSheetCategoryName());
                sheetQryDetailBO.setUnit(row.getSheetUnit());
                sheetQryDetailBO.setDeliveryPlaceCode(row.getSheetDeliveryPlaceCode());
                sheetQryDetailBO.setDeliveryPlaceName(row.getSheetDeliveryPlaceName());
                sheetQryDetailBO.setReceivingTime(row.getSheetReceivingTime());
                sheetQryDetailBO.setRemark(row.getSheetRemark());
                sheetQryDetailBO.setAttachmentUrl(row.getSheetAttachmentUrl());
                sheetQryDetailBO.setUserRemark(row.getSheetUserRemark());
                sheetQryDetailBO.setQuotationStatus(row.getQuotationStatus());
                sheetQryDetailBO.setInquiryName(row.getInquiryName());
                sheetQryDetailBO.setInquiryPhone(row.getInquiryPhone());
                sheetQryDetailBO.setCustomerName(row.getCustomerName());
                sheetQryDetailBO.setInquiryTime(row.getInquiryTime());
                if (row.getQuotationStatus() != null) {
                    sheetQryDetailBO.setQuotationStatusStr(quotationStatusMap.get(row.getQuotationStatus().toString()));
                }
                sheetQryDetailBO.setQuotationDate(row.getQuotationDate());
                if (row.getQuotationDate() != null) {
                    sheetQryDetailBO.setQuotedDays(Integer.parseInt(DateUtil.betweenDay((Date)new Date(), (Date)sheetQryDetailBO.getQuotationDate(), (boolean)true) + ""));
                }
                if (row.getInquiryQuotationDetailId() != null) {
                    UccInquiryMyQuotationDetailBO quotationDetailBO = new UccInquiryMyQuotationDetailBO();
                    quotationDetailBO.setInquiryQuotationDetailId(row.getInquiryQuotationDetailId());
                    quotationDetailBO.setInquirySheetDetailId(row.getInquirySheetDetailId());
                    quotationDetailBO.setInquirySheetId(row.getInquirySheetId());
                    quotationDetailBO.setQuotationId(row.getQuotationId());
                    quotationDetailBO.setQuotationName(row.getQuotationName());
                    quotationDetailBO.setQuotationSku(row.getQuotationSku());
                    quotationDetailBO.setQuotationSkuId(row.getQuotationSkuId());
                    quotationDetailBO.setSkuType(row.getSkuType());
                    quotationDetailBO.setQuotationGoodsName(row.getQuotationGoodsName());
                    quotationDetailBO.setQuotationQuantity(row.getQuotationQuantity());
                    quotationDetailBO.setQuotationBrand(row.getQuotationBrand());
                    quotationDetailBO.setQuotationModel(row.getQuotationModel());
                    quotationDetailBO.setQuotationSpec(row.getQuotationSpec());
                    quotationDetailBO.setQuotationUnit(row.getQuotationUnit());
                    quotationDetailBO.setQuotationUnitId(row.getQuotationUnitId());
                    quotationDetailBO.setPurchasePrice(row.getPurchasePrice());
                    quotationDetailBO.setSalesPrice(row.getSalesPrice());
                    quotationDetailBO.setExpirationDay(row.getExpirationDay());
                    quotationDetailBO.setExpirationDate(row.getExpirationDate());
                    quotationDetailBO.setDeliveryCycle(row.getDeliveryCycle());
                    quotationDetailBO.setRemark(row.getQuotationRemark());
                    quotationDetailBO.setImgUrl(row.getImgUrl());
                    quotationDetailBO.setTaxRate(row.getTaxRate());
                    quotationDetailBO.setGoodsType(row.getSkuType());
                    quotationDetailBO.setIncludeFreight(row.getIncludeFreight());
                    quotationDetailBO.setActualSalesPrice(row.getActualSalesPrice());
                    quotationDetailBO.setActualQuantity(row.getActualQuantity());
                    quotationDetailBO.setToOrder(row.getToOrder());
                    quotationDetailBO.setIsExpiration(row.getIsExpiration());
                    quotationDetailBO.setSheetQuantity(row.getSheetQuantity());
                    if (row.getSheetQuantity() != null && quotationDetailBO.getSalesPrice() != null) {
                        quotationDetailBO.setSalesPriceTotal(new BigDecimal(quotationDetailBO.getSheetQuantity()).multiply(quotationDetailBO.getSalesPrice()));
                    }
                    if (quotationDetailBO.getSalesPrice() != null) {
                        quotationDetailBO.setSalesPrice(quotationDetailBO.getSalesPrice().divide(new BigDecimal("10000")));
                    }
                    if (quotationDetailBO.getActualSalesPrice() != null) {
                        quotationDetailBO.setActualSalesPrice(quotationDetailBO.getActualSalesPrice().divide(new BigDecimal("10000")));
                    }
                    if (quotationDetailBO.getPurchasePrice() != null) {
                        quotationDetailBO.setPurchasePrice(quotationDetailBO.getPurchasePrice().divide(new BigDecimal("10000")));
                    }
                    if (quotationDetailBO.getSalesPriceTotal() != null) {
                        quotationDetailBO.setSalesPriceTotal(quotationDetailBO.getSalesPriceTotal().divide(new BigDecimal("10000")).setScale(2, 4));
                    }
                    sheetQryDetailBO.setInquiryQuotationDetail(quotationDetailBO);
                }
                dataList.add(sheetQryDetailBO);
            }
        }
    }
}

