/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.client.utils.StringUtils;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.UccInquiryMatchDetailBO;
import com.tydic.commodity.common.busi.api.UccInquirySheetCreateBusiService;
import com.tydic.commodity.common.busi.bo.UccInquirySheetCreateBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccInquirySheetCreateBusiRspBO;
import com.tydic.commodity.dao.UccInquiryQuotationDetailMapper;
import com.tydic.commodity.dao.UccInquirySheetDetailMapper;
import com.tydic.commodity.dao.UccInquirySheetMapper;
import com.tydic.commodity.po.UccInquiryQuotationDetailPO;
import com.tydic.commodity.po.UccInquirySheetDetailPO;
import com.tydic.commodity.po.UccInquirySheetPO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.plugin.encoded.service.CfcRedisSerialService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccInquirySheetCreateBusiServiceImpl
implements UccInquirySheetCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccInquirySheetCreateBusiServiceImpl.class);
    @Autowired
    private UccInquirySheetMapper uccInquirySheetMapper;
    @Autowired
    private UccInquirySheetDetailMapper uccInquirySheetDetailMapper;
    @Autowired
    private UccInquiryQuotationDetailMapper uccInquiryQuotationDetailMapper;
    @Autowired
    private CfcRedisSerialService cfcRedisSerialService;
    private static final Sequence SEQUENCE = Sequence.getInstance();

    @Override
    public UccInquirySheetCreateBusiRspBO createInquirySheet(UccInquirySheetCreateBusiReqBO uccInquirySheetBusiReqBO) {
        UccInquirySheetCreateBusiRspBO uccInquirySheetCreateBusiRspBO = new UccInquirySheetCreateBusiRspBO();
        uccInquirySheetCreateBusiRspBO.setRespCode("0000");
        uccInquirySheetCreateBusiRspBO.setRespDesc("\u6210\u529f");
        Date now = new Date();
        UccInquirySheetPO uccInquirySheetPO = new UccInquirySheetPO();
        BeanUtils.copyProperties((Object)uccInquirySheetBusiReqBO, (Object)uccInquirySheetPO);
        uccInquirySheetPO.setInquirySheetId(Long.valueOf(SEQUENCE.nextId()));
        uccInquirySheetPO.setInquirySheetCode(this.getInquirySheetCode());
        uccInquirySheetPO.setInquiryTime(now);
        uccInquirySheetPO.setInquiryStatus(Integer.valueOf(0));
        uccInquirySheetPO.setCreateId(uccInquirySheetBusiReqBO.getUserId());
        uccInquirySheetPO.setCreateName(uccInquirySheetBusiReqBO.getCustomerName());
        uccInquirySheetPO.setCreatedTime(now);
        uccInquirySheetPO.setIsDel(Integer.valueOf(0));
        int insert = this.uccInquirySheetMapper.insert(uccInquirySheetPO);
        if (insert < 1) {
            throw new BusinessException("8888", "\u8be2\u4ef7\u5355\u521b\u5efa\u5931\u8d25\uff01");
        }
        Integer inquirySource = uccInquirySheetPO.getInquirySource();
        Integer quotationStatus = inquirySource == 2 ? 4 : 0;
        AtomicInteger index = new AtomicInteger(0);
        List<UccInquiryMatchDetailBO> quotationGoods = uccInquirySheetBusiReqBO.getQuotationGoods();
        quotationGoods.forEach(goods -> {
            UccInquirySheetDetailPO uccInquirySheetDetailPO = new UccInquirySheetDetailPO();
            BeanUtils.copyProperties((Object)goods, (Object)uccInquirySheetDetailPO);
            uccInquirySheetDetailPO.setInquirySheetDetailCode(uccInquirySheetPO.getInquirySheetCode() + "-" + String.format("%03d", index.get()));
            index.getAndIncrement();
            uccInquirySheetDetailPO.setInquirySheetDetailId(Long.valueOf(SEQUENCE.nextId()));
            uccInquirySheetDetailPO.setInquirySheetId(uccInquirySheetPO.getInquirySheetId());
            uccInquirySheetDetailPO.setQuotationStatus(quotationStatus);
            int insert1 = this.uccInquirySheetDetailMapper.insert(uccInquirySheetDetailPO);
            if (insert1 < 1) {
                throw new BusinessException("8888", "\u8be2\u4ef7\u660e\u7ec6\u63d2\u5165\u5931\u8d25\uff01");
            }
            UccInquiryMatchDetailBO matchGoods = goods.getMatchGoods();
            if (!Objects.isNull(matchGoods)) {
                UccInquiryQuotationDetailPO uccInquiryQuotationDetailPO = new UccInquiryQuotationDetailPO();
                uccInquiryQuotationDetailPO.setInquiryQuotationDetailId(Long.valueOf(SEQUENCE.nextId()));
                uccInquiryQuotationDetailPO.setInquirySheetDetailId(uccInquirySheetDetailPO.getInquirySheetDetailId());
                uccInquiryQuotationDetailPO.setInquirySheetId(uccInquirySheetDetailPO.getInquirySheetId());
                uccInquiryQuotationDetailPO.setQuotationSku(matchGoods.getSku());
                uccInquiryQuotationDetailPO.setQuotationSkuId(matchGoods.getSkuId());
                uccInquiryQuotationDetailPO.setQuotationGoodsName(matchGoods.getGoodsName());
                uccInquiryQuotationDetailPO.setGoodsType(matchGoods.getGoodsType());
                uccInquiryQuotationDetailPO.setQuotationQuantity(matchGoods.getQuantity());
                uccInquiryQuotationDetailPO.setQuotationBrand(matchGoods.getBrand());
                uccInquiryQuotationDetailPO.setQuotationModel(matchGoods.getModel());
                uccInquiryQuotationDetailPO.setQuotationSpec(matchGoods.getSpec());
                uccInquiryQuotationDetailPO.setImgUrl(matchGoods.getImgUrl());
                uccInquiryQuotationDetailPO.setSkuType(matchGoods.getSkuType());
                uccInquiryQuotationDetailPO.setCommodityId(matchGoods.getCommodityId());
                uccInquiryQuotationDetailPO.setSupplierId(matchGoods.getSupplierId());
                uccInquiryQuotationDetailPO.setSupplierName(matchGoods.getSupplierName());
                uccInquiryQuotationDetailPO.setQuotationUnit(matchGoods.getUnit());
                uccInquiryQuotationDetailPO.setQuotationUnitId(matchGoods.getUnitId());
                uccInquiryQuotationDetailPO.setPurchasePrice(matchGoods.getPurchasePrice() == null ? null : matchGoods.getPurchasePrice().multiply(new BigDecimal("10000")));
                uccInquiryQuotationDetailPO.setSalesPrice(matchGoods.getSalesPrice() == null ? null : matchGoods.getSalesPrice().multiply(new BigDecimal("10000")));
                uccInquiryQuotationDetailPO.setDeliveryCycle(matchGoods.getDeliveryCycle());
                uccInquiryQuotationDetailPO.setIsExpiration(Integer.valueOf(0));
                uccInquiryQuotationDetailPO.setToOrder(Integer.valueOf(0));
                uccInquiryQuotationDetailPO.setTaxRate(matchGoods.getTaxRate());
                uccInquiryQuotationDetailPO.setIncludeFreight(matchGoods.getIncludeFreight());
                uccInquiryQuotationDetailPO.setRemark(matchGoods.getRemark());
                uccInquiryQuotationDetailPO.setCreatedTime(now);
                int insert2 = this.uccInquiryQuotationDetailMapper.insert(uccInquiryQuotationDetailPO);
                if (insert2 < 1) {
                    throw new BusinessException("8888", "\u62a5\u4ef7\u5355\u521b\u5efa\u5931\u8d25\uff01");
                }
            }
        });
        uccInquirySheetPO.setDetailIndex(Integer.valueOf(index.get()));
        this.uccInquirySheetMapper.update(uccInquirySheetPO);
        return uccInquirySheetCreateBusiRspBO;
    }

    private String getInquirySheetCode() {
        CfcEncodedSerialGetServiceReqBO getBo = new CfcEncodedSerialGetServiceReqBO();
        getBo.setCenter("UCC");
        getBo.setEncodedRuleCode("ONLINE_INQUIRY_NO");
        getBo.setOrgType("-1");
        CfcEncodedSerialGetServiceRspBO encodedSerial = this.cfcRedisSerialService.getSerial(getBo);
        log.debug("\u83b7\u53d6\u8be2\u76d8\u5355\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)encodedSerial));
        if (CollectionUtils.isEmpty((Collection)encodedSerial.getSerialNoList()) || StringUtils.isBlank((String)((String)encodedSerial.getSerialNoList().get(0)))) {
            throw new BaseBusinessException("8888", "\u83b7\u53d6\u8be2\u76d8\u5355\u7f16\u53f7\u4e3a\u7a7a");
        }
        return (String)encodedSerial.getSerialNoList().get(0);
    }
}

