/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.UccInquiryMatchGoodsUpdateBO;
import com.tydic.commodity.common.ability.bo.UccInquiryQuotationDetailBO;
import com.tydic.commodity.common.busi.api.UccInquirySheetUpdateBusiService;
import com.tydic.commodity.common.busi.bo.UccInquirySheetUpdateBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccInquirySheetUpdateBusiRspBO;
import com.tydic.commodity.dao.UccInquiryQuotationDetailMapper;
import com.tydic.commodity.dao.UccInquirySheetDetailMapper;
import com.tydic.commodity.dao.UccInquirySheetMapper;
import com.tydic.commodity.po.UccInquiryQuotationDetailPO;
import com.tydic.commodity.po.UccInquirySheetDetailPO;
import com.tydic.commodity.po.UccInquirySheetPO;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccInquirySheetUpdateBusiServiceImpl
implements UccInquirySheetUpdateBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccInquirySheetUpdateBusiServiceImpl.class);
    @Autowired
    private UccInquirySheetMapper uccInquirySheetMapper;
    @Autowired
    private UccInquirySheetDetailMapper uccInquirySheetDetailMapper;
    @Autowired
    private UccInquiryQuotationDetailMapper uccInquiryQuotationDetailMapper;
    private static final Sequence SEQUENCE = Sequence.getInstance();

    @Override
    public UccInquirySheetUpdateBusiRspBO addInquirySheetDetail(UccInquirySheetUpdateBusiReqBO uccInquirySheetUpdateBusiReqBO) {
        Long inquirySheetId = uccInquirySheetUpdateBusiReqBO.getInquirySheetId();
        if (Objects.isNull(inquirySheetId)) {
            throw new ZTBusinessException("\u8be2\u76d8ID\u4e0d\u80fd\u4e3a\u7a7a;");
        }
        List<UccInquiryMatchGoodsUpdateBO> quotationGoods = uccInquirySheetUpdateBusiReqBO.getQuotationGoods();
        if (CollectionUtils.isEmpty(quotationGoods)) {
            throw new BusinessException("8888", "\u8be2\u76d8\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        UccInquiryMatchGoodsUpdateBO uccInquiryMatchGoodsUpdateBO = quotationGoods.get(0);
        if (StringUtils.isBlank((CharSequence)uccInquiryMatchGoodsUpdateBO.getGoodsName())) {
            throw new ZTBusinessException("\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a;");
        }
        if (StringUtils.isBlank((CharSequence)uccInquiryMatchGoodsUpdateBO.getBrand())) {
            throw new ZTBusinessException("\u54c1\u724c\u4e0d\u80fd\u4e3a\u7a7a;");
        }
        if (Objects.isNull(uccInquiryMatchGoodsUpdateBO.getQuantity())) {
            throw new ZTBusinessException("\u9700\u6c42\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a;");
        }
        if (StringUtils.isBlank((CharSequence)uccInquiryMatchGoodsUpdateBO.getModel())) {
            throw new ZTBusinessException("\u578b\u53f7\u4e0d\u80fd\u4e3a\u7a7a;");
        }
        UccInquirySheetPO uccInquirySheetPO = this.uccInquirySheetMapper.queryById(inquirySheetId);
        if (Objects.isNull(uccInquirySheetPO)) {
            throw new BusinessException("8888", "\u8be2\u76d8\u5355\u67e5\u8be2\u5931\u8d25\u3002");
        }
        this.checkStatus(uccInquirySheetPO);
        UccInquirySheetDetailPO uccInquirySheetDetailPO = new UccInquirySheetDetailPO();
        BeanUtils.copyProperties((Object)uccInquiryMatchGoodsUpdateBO, (Object)uccInquirySheetDetailPO);
        Integer detailIndex = uccInquirySheetPO.getDetailIndex();
        uccInquirySheetDetailPO.setInquirySheetDetailCode(uccInquirySheetPO.getInquirySheetCode() + "-" + String.format("%03d", detailIndex));
        uccInquirySheetDetailPO.setInquirySheetDetailId(Long.valueOf(SEQUENCE.nextId()));
        uccInquirySheetDetailPO.setInquirySheetId(uccInquirySheetPO.getInquirySheetId());
        uccInquirySheetDetailPO.setQuotationStatus(Integer.valueOf(0));
        int insert1 = this.uccInquirySheetDetailMapper.insert(uccInquirySheetDetailPO);
        if (insert1 < 1) {
            throw new BusinessException("8888", "\u8be2\u4ef7\u660e\u7ec6\u63d2\u5165\u5931\u8d25\uff01");
        }
        Integer n = detailIndex;
        Integer n2 = detailIndex = Integer.valueOf(detailIndex + 1);
        uccInquirySheetPO.setDetailIndex(detailIndex);
        this.uccInquirySheetMapper.update(uccInquirySheetPO);
        uccInquiryMatchGoodsUpdateBO.setInquirySheetDetailId(uccInquirySheetDetailPO.getInquirySheetDetailId());
        UccInquiryQuotationDetailBO inquiryQuotationDetail = uccInquiryMatchGoodsUpdateBO.getInquiryQuotationDetail();
        if (!Objects.isNull(inquiryQuotationDetail)) {
            inquiryQuotationDetail.setInquirySheetId(inquirySheetId);
            inquiryQuotationDetail.setInquirySheetDetailId(uccInquirySheetDetailPO.getInquirySheetDetailId());
        }
        return this.updateInquirySheet(uccInquirySheetUpdateBusiReqBO);
    }

    @Override
    public UccInquirySheetUpdateBusiRspBO updateInquirySheet(UccInquirySheetUpdateBusiReqBO uccInquirySheetBusiReqBO) {
        UccInquirySheetUpdateBusiRspBO rspBO = new UccInquirySheetUpdateBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        UccInquirySheetPO uccInquirySheetPO = new UccInquirySheetPO();
        Long inquirySheetId = uccInquirySheetBusiReqBO.getInquirySheetId();
        Integer editType = uccInquirySheetBusiReqBO.getEditType();
        switch (editType) {
            case 1: {
                uccInquirySheetPO = this.uccInquirySheetMapper.queryById(inquirySheetId);
                Integer inquirySource = uccInquirySheetPO.getInquirySource();
                if (inquirySource != 2) {
                    throw new BusinessException("8888", "\u5f53\u524d\u8be2\u76d8\u5355\u65e0\u9700\u786e\u8ba4\uff01");
                }
                UccInquirySheetDetailPO po = new UccInquirySheetDetailPO();
                po.setInquirySheetId(inquirySheetId);
                po.setQuotationStatus(Integer.valueOf(0));
                this.uccInquirySheetDetailMapper.updateStatusBySheetId(po);
                break;
            }
            case 2: {
                this.editStatusCheck(uccInquirySheetBusiReqBO);
                uccInquirySheetPO = this.checkSheet(uccInquirySheetBusiReqBO.getInquirySheetId());
                this.save(uccInquirySheetPO, uccInquirySheetBusiReqBO);
                break;
            }
            case 3: {
                this.editStatusCheck(uccInquirySheetBusiReqBO);
                uccInquirySheetPO = this.checkSheet(uccInquirySheetBusiReqBO.getInquirySheetId());
                this.submit(uccInquirySheetPO, uccInquirySheetBusiReqBO);
                break;
            }
            case 4: {
                this.submitBatch(uccInquirySheetBusiReqBO);
                break;
            }
            case 5: {
                this.editStatusCheck(uccInquirySheetBusiReqBO);
                this.reject(uccInquirySheetBusiReqBO);
                break;
            }
            case 6: {
                this.editStatusCheck(uccInquirySheetBusiReqBO);
                this.delete(uccInquirySheetBusiReqBO);
                break;
            }
            case 7: {
                this.lostOrder(uccInquirySheetBusiReqBO);
                break;
            }
            case 8: {
                this.setGoodsCategory(uccInquirySheetBusiReqBO);
                break;
            }
        }
        return rspBO;
    }

    private UccInquirySheetPO checkSheet(Long inquirySheetId) {
        if (null == inquirySheetId) {
            throw new BusinessException("8888", "\u8be2\u76d8\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        UccInquirySheetPO uccInquirySheetPO = this.uccInquirySheetMapper.queryById(inquirySheetId);
        if (Objects.isNull(uccInquirySheetPO)) {
            throw new BusinessException("8888", "\u8be2\u76d8\u5355\u67e5\u8be2\u5931\u8d25\u3002");
        }
        this.checkStatus(uccInquirySheetPO);
        return uccInquirySheetPO;
    }

    private void setGoodsCategory(UccInquirySheetUpdateBusiReqBO uccInquirySheetBusiReqBO) {
        if (StringUtils.isBlank((CharSequence)uccInquirySheetBusiReqBO.getCategoryName()) || Objects.isNull(uccInquirySheetBusiReqBO.getCategoryId())) {
            throw new BusinessException("8888", "\u8be2\u76d8\u5546\u54c1\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        List<UccInquiryMatchGoodsUpdateBO> quotationGoods = uccInquirySheetBusiReqBO.getQuotationGoods();
        List<Long> sheetIds = quotationGoods.stream().map(UccInquiryMatchGoodsUpdateBO::getInquirySheetId).collect(Collectors.toList());
        sheetIds.forEach(this::checkSheet);
        if (CollectionUtils.isEmpty(quotationGoods)) {
            throw new BusinessException("8888", "\u8be2\u76d8\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        List detailIds = quotationGoods.stream().map(UccInquiryMatchGoodsUpdateBO::getInquirySheetDetailId).collect(Collectors.toList());
        if (quotationGoods.size() != detailIds.size()) {
            throw new BusinessException("8888", "\u8be2\u76d8\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        UccInquirySheetDetailPO po = new UccInquirySheetDetailPO();
        po.setCategoryId(uccInquirySheetBusiReqBO.getCategoryId());
        po.setCategoryName(uccInquirySheetBusiReqBO.getCategoryName());
        this.uccInquirySheetDetailMapper.updateBatch(po, detailIds);
    }

    private void submitBatch(UccInquirySheetUpdateBusiReqBO uccInquirySheetBusiReqBO) {
        List<UccInquiryMatchGoodsUpdateBO> quotationGoods = uccInquirySheetBusiReqBO.getQuotationGoods();
        List<Long> sheetIds = quotationGoods.stream().map(UccInquiryMatchGoodsUpdateBO::getInquirySheetId).collect(Collectors.toList());
        sheetIds.forEach(this::checkSheet);
        if (CollectionUtils.isEmpty(quotationGoods)) {
            throw new BusinessException("8888", "\u8be2\u76d8\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        List detailIds = quotationGoods.stream().map(UccInquiryMatchGoodsUpdateBO::getInquirySheetDetailId).collect(Collectors.toList());
        if (quotationGoods.size() != detailIds.size()) {
            throw new BusinessException("8888", "\u8be2\u76d8\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        List detailPOS = this.uccInquirySheetDetailMapper.queryByInquirySheetDetailIds(detailIds);
        List collect = detailPOS.stream().filter(u -> u.getQuotationStatus() != 1).collect(Collectors.toList());
        if (collect.size() > 0) {
            throw new BusinessException("8888", "\u5f85\u63d0\u4ea4\u5546\u54c1\u624d\u53ef\u6279\u91cf\u63d0\u4ea4\u3002");
        }
        List inquiryQuotationDetailPOS = this.uccInquiryQuotationDetailMapper.queryByInquirySheetDetailIds(detailIds);
        inquiryQuotationDetailPOS.forEach(this::submitCheck);
        detailPOS.forEach(p -> p.setQuotationStatus(Integer.valueOf(2)));
        this.uccInquirySheetDetailMapper.insertOrUpdateBatch(detailPOS);
        UccInquiryQuotationDetailPO quotationDetailPO = new UccInquiryQuotationDetailPO();
        quotationDetailPO.setIsExpiration(Integer.valueOf(1));
        this.uccInquiryQuotationDetailMapper.batchUpdateExpiration(quotationDetailPO, detailIds);
    }

    private void delete(UccInquirySheetUpdateBusiReqBO uccInquirySheetBusiReqBO) {
        UccInquiryMatchGoodsUpdateBO uccInquiryMatchGoodsUpdateBO = uccInquirySheetBusiReqBO.getQuotationGoods().get(0);
        Long sheetId = uccInquiryMatchGoodsUpdateBO.getInquirySheetId();
        this.checkSheet(sheetId);
        this.uccInquirySheetDetailMapper.deleteById(uccInquiryMatchGoodsUpdateBO.getInquirySheetDetailId());
        this.uccInquiryQuotationDetailMapper.deleteByInquirySheetDetailId(uccInquiryMatchGoodsUpdateBO.getInquirySheetDetailId());
    }

    private void lostOrder(UccInquirySheetUpdateBusiReqBO uccInquirySheetBusiReqBO) {
        List<UccInquiryMatchGoodsUpdateBO> quotationGoods = uccInquirySheetBusiReqBO.getQuotationGoods();
        List<Long> sheetIds = quotationGoods.stream().map(UccInquiryMatchGoodsUpdateBO::getInquirySheetId).collect(Collectors.toList());
        sheetIds.forEach(this::checkSheet);
        if (CollectionUtils.isEmpty(quotationGoods)) {
            throw new BusinessException("8888", "\u8be2\u76d8\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        List detailIds = quotationGoods.stream().map(UccInquiryMatchGoodsUpdateBO::getInquirySheetDetailId).collect(Collectors.toList());
        if (quotationGoods.size() != detailIds.size()) {
            throw new BusinessException("8888", "\u8be2\u76d8\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        List detailPOS = this.uccInquirySheetDetailMapper.queryByInquirySheetDetailIds(detailIds);
        List collect = detailPOS.stream().filter(u -> u.getQuotationStatus() != 2 && u.getQuotationStatus() != 3).collect(Collectors.toList());
        if (collect.size() > 0) {
            throw new BusinessException("8888", "\u5df2\u62a5\u4ef7\u5546\u54c1\u624d\u53ef\u4ee5\u6807\u8bb0\u672a\u6210\u4ea4\u3002");
        }
        UccInquiryQuotationDetailPO po = new UccInquiryQuotationDetailPO();
        po.setFailureCause(uccInquirySheetBusiReqBO.getFailureCause());
        this.uccInquiryQuotationDetailMapper.batchUpdateFailureCause(po, detailPOS.stream().map(UccInquirySheetDetailPO::getInquirySheetDetailId).collect(Collectors.toList()));
    }

    private void reject(UccInquirySheetUpdateBusiReqBO uccInquirySheetBusiReqBO) {
        UccInquiryMatchGoodsUpdateBO uccInquiryMatchGoodsUpdateBO = uccInquirySheetBusiReqBO.getQuotationGoods().get(0);
        Long sheetId = uccInquiryMatchGoodsUpdateBO.getInquirySheetId();
        this.checkSheet(sheetId);
        Long inquirySheetDetailId = uccInquiryMatchGoodsUpdateBO.getInquirySheetDetailId();
        UccInquirySheetDetailPO detailPO = new UccInquirySheetDetailPO();
        detailPO.setInquirySheetDetailId(inquirySheetDetailId);
        detailPO.setQuotationStatus(Integer.valueOf(3));
        detailPO.setQuotationDate(new Date());
        detailPO.setUserRemark(uccInquiryMatchGoodsUpdateBO.getUserRemark());
        this.uccInquirySheetDetailMapper.update(detailPO);
    }

    private void submit(UccInquirySheetPO uccInquirySheetPO, UccInquirySheetUpdateBusiReqBO uccInquirySheetBusiReqBO) {
        UccInquiryMatchGoodsUpdateBO uccInquiryMatchGoodsUpdateBO = uccInquirySheetBusiReqBO.getQuotationGoods().get(0);
        UccInquiryQuotationDetailBO inquiryQuotationDetail = uccInquiryMatchGoodsUpdateBO.getInquiryQuotationDetail();
        UccInquiryQuotationDetailPO detailPO = new UccInquiryQuotationDetailPO();
        if (Objects.isNull(inquiryQuotationDetail)) {
            throw new BusinessException("8888", "\u62a5\u4ef7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (Objects.isNull(inquiryQuotationDetail.getInquirySheetId())) {
            throw new BusinessException("8888", "\u8be2\u76d8\u5355id\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (Objects.isNull(inquiryQuotationDetail.getInquirySheetDetailId())) {
            throw new BusinessException("8888", "\u8be2\u76d8\u5355\u660e\u7ec6id\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        BeanUtils.copyProperties((Object)inquiryQuotationDetail, (Object)detailPO);
        this.submitCheck(detailPO);
        this.save(uccInquirySheetPO, uccInquirySheetBusiReqBO);
        UccInquirySheetDetailPO uccInquirySheetDetailPO = new UccInquirySheetDetailPO();
        uccInquirySheetDetailPO.setInquirySheetDetailId(inquiryQuotationDetail.getInquirySheetDetailId());
        uccInquirySheetDetailPO.setQuotationStatus(Integer.valueOf(2));
        uccInquirySheetDetailPO.setQuotationDate(new Date());
        this.uccInquirySheetDetailMapper.update(uccInquirySheetDetailPO);
        UccInquiryQuotationDetailPO quotationDetailPO = new UccInquiryQuotationDetailPO();
        quotationDetailPO.setIsExpiration(Integer.valueOf(1));
        this.uccInquiryQuotationDetailMapper.batchUpdateExpiration(quotationDetailPO, Collections.singletonList(inquiryQuotationDetail.getInquirySheetDetailId()));
        UccInquirySheetDetailPO query = new UccInquirySheetDetailPO();
        query.setInquirySheetId(uccInquiryMatchGoodsUpdateBO.getInquirySheetId());
        List uccInquirySheetDetailPOS = this.uccInquirySheetDetailMapper.queryAll(query);
        long count = uccInquirySheetDetailPOS.stream().filter(u -> u.getQuotationStatus() == 2 || u.getQuotationStatus() == 3).count();
        if ((long)uccInquirySheetDetailPOS.size() == count) {
            uccInquirySheetPO.setInquiryStatus(Integer.valueOf(1));
            this.uccInquirySheetMapper.update(uccInquirySheetPO);
        }
    }

    private void submitCheck(UccInquiryQuotationDetailPO detailPO) {
        if (StringUtils.isBlank((CharSequence)detailPO.getQuotationGoodsName())) {
            throw new BusinessException("8888", "\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isBlank((CharSequence)detailPO.getQuotationBrand())) {
            throw new BusinessException("8888", "\u5546\u54c1\u54c1\u724c\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isBlank((CharSequence)detailPO.getQuotationModel())) {
            throw new BusinessException("8888", "\u5546\u54c1\u578b\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isBlank((CharSequence)detailPO.getQuotationUnit())) {
            throw new BusinessException("8888", "\u5546\u54c1\u8ba1\u4ef7\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (Objects.isNull(detailPO.getTaxRate())) {
            throw new BusinessException("8888", "\u5546\u54c1\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (Objects.isNull(detailPO.getPurchasePrice())) {
            throw new BusinessException("8888", "\u542b\u7a0e\u91c7\u8d2d\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (Objects.isNull(detailPO.getSalesPrice())) {
            throw new BusinessException("8888", "\u542b\u7a0e\u9500\u552e\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (Objects.isNull(detailPO.getIncludeFreight())) {
            throw new BusinessException("8888", "\u8bf7\u9009\u62e9\u662f\u5426\u5305\u542b\u8fd0\u8d39\u3002");
        }
        if (Objects.isNull(detailPO.getExpirationDay())) {
            throw new BusinessException("8888", "\u62a5\u4ef7\u6709\u6548\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (Objects.isNull(detailPO.getDeliveryCycle())) {
            throw new BusinessException("8888", "\u9884\u8ba1\u51fa\u8d27\u65e5\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
    }

    private void editStatusCheck(UccInquirySheetUpdateBusiReqBO uccInquirySheetBusiReqBO) {
        List<UccInquiryMatchGoodsUpdateBO> quotationGoods = uccInquirySheetBusiReqBO.getQuotationGoods();
        if (CollectionUtils.isEmpty(quotationGoods)) {
            throw new BusinessException("8888", "\u8be2\u4ef7\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        UccInquiryMatchGoodsUpdateBO uccInquiryMatchGoodsUpdateBO = quotationGoods.get(0);
        Long inquirySheetDetailId = uccInquiryMatchGoodsUpdateBO.getInquirySheetDetailId();
        if (Objects.isNull(inquirySheetDetailId)) {
            throw new BusinessException("8888", "\u8be2\u4ef7\u5546\u54c1\u660e\u7ec6Id\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        UccInquirySheetDetailPO uccInquirySheetDetailPO = this.uccInquirySheetDetailMapper.queryById(inquirySheetDetailId);
        Integer quotationStatus = uccInquirySheetDetailPO.getQuotationStatus();
        if (quotationStatus == 4) {
            UccInquirySheetPO uccInquirySheetPO = this.uccInquirySheetMapper.queryById(uccInquirySheetDetailPO.getInquirySheetId());
            if (uccInquirySheetPO.getInquirySource() != 2) {
                throw new BusinessException("8888", "\u8be5\u8be2\u76d8\u5546\u54c1\u9700\u5ba2\u670d\u786e\u8ba4\u3002");
            }
        } else if (quotationStatus != 1 && quotationStatus != 0) {
            throw new BusinessException("8888", "\u8be5\u8be2\u76d8\u5546\u54c1\u72b6\u6001\u65e0\u6cd5\u64cd\u4f5c\u3002");
        }
    }

    private void save(UccInquirySheetPO uccInquirySheetPO, UccInquirySheetUpdateBusiReqBO uccInquirySheetBusiReqBO) {
        Date now = new Date();
        List<UccInquiryMatchGoodsUpdateBO> quotationGoods = uccInquirySheetBusiReqBO.getQuotationGoods();
        UccInquiryMatchGoodsUpdateBO uccInquiryMatchGoodsUpdateBO = quotationGoods.get(0);
        Long inquirySheetDetailId = uccInquiryMatchGoodsUpdateBO.getInquirySheetDetailId();
        UccInquirySheetDetailPO uccInquirySheetDetailPO = new UccInquirySheetDetailPO();
        uccInquirySheetDetailPO.setInquirySheetDetailId(inquirySheetDetailId);
        uccInquirySheetDetailPO.setUserRemark(uccInquiryMatchGoodsUpdateBO.getUserRemark());
        UccInquiryQuotationDetailBO inquiryQuotationDetail = uccInquiryMatchGoodsUpdateBO.getInquiryQuotationDetail();
        if (!Objects.isNull(inquiryQuotationDetail)) {
            Integer includeFreight;
            Long inquiryQuotationDetailId = inquiryQuotationDetail.getInquiryQuotationDetailId();
            UccInquiryQuotationDetailPO quotationDetail = new UccInquiryQuotationDetailPO();
            BeanUtils.copyProperties((Object)inquiryQuotationDetail, (Object)quotationDetail);
            if (null == inquiryQuotationDetailId) {
                UccInquiryQuotationDetailPO query = new UccInquiryQuotationDetailPO();
                query.setInquirySheetDetailId(inquirySheetDetailId);
                long count = this.uccInquiryQuotationDetailMapper.count(query);
                if (count > 0L) {
                    throw new BusinessException("8888", "\u8be5\u8be2\u76d8\u5546\u54c1\u5df2\u6709\u62a5\u4ef7\uff0c\u65e0\u6cd5\u91cd\u590d\u62a5\u4ef7\u3002");
                }
                quotationDetail.setInquiryQuotationDetailId(Long.valueOf(SEQUENCE.nextId()));
            }
            if (inquiryQuotationDetail.getSalesPrice() != null) {
                quotationDetail.setSalesPrice(inquiryQuotationDetail.getSalesPrice().multiply(new BigDecimal("10000")));
            }
            if (inquiryQuotationDetail.getPurchasePrice() != null) {
                quotationDetail.setPurchasePrice(inquiryQuotationDetail.getPurchasePrice().multiply(new BigDecimal("10000")));
            }
            if (uccInquirySheetPO.getInquirySource() == 1) {
                quotationDetail.setActualSalesPrice(quotationDetail.getSalesPrice());
            }
            quotationDetail.setGoodsType(Integer.valueOf((includeFreight = inquiryQuotationDetail.getIncludeFreight()) == 1 ? 2 : 1));
            quotationDetail.setSkuType(inquiryQuotationDetail.getSkuType());
            quotationDetail.setCommodityId(inquiryQuotationDetail.getCommodityId());
            quotationDetail.setSupplierName(inquiryQuotationDetail.getSupplierName());
            quotationDetail.setSupplierId(inquiryQuotationDetail.getSupplierId());
            quotationDetail.setCreatedTime(now);
            quotationDetail.setIsExpiration(Integer.valueOf(0));
            quotationDetail.setToOrder(Integer.valueOf(0));
            quotationDetail.setQuotationName(uccInquirySheetBusiReqBO.getUserName());
            quotationDetail.setQuotationId(uccInquirySheetBusiReqBO.getUserId());
            Integer expirationDay = Objects.isNull(quotationDetail.getExpirationDay()) ? 1 : quotationDetail.getExpirationDay();
            quotationDetail.setExpirationDate(this.getExpirationDate(now, expirationDay));
            this.uccInquiryQuotationDetailMapper.insertOrUpdateBatch(Collections.singletonList(quotationDetail));
            uccInquirySheetDetailPO.setQuotationStatus(Integer.valueOf(1));
        }
        this.uccInquirySheetDetailMapper.update(uccInquirySheetDetailPO);
    }

    private Date getExpirationDate(Date date, Integer expirationDay) {
        Calendar calendar1 = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date);
        calendar1.set(calendar2.get(1), calendar2.get(2), calendar2.get(5), 23, 59, 59);
        calendar1.add(5, expirationDay);
        return calendar1.getTime();
    }

    private void checkStatus(UccInquirySheetPO uccInquirySheetPO) {
        Integer inquiryStatus = uccInquirySheetPO.getInquiryStatus();
        if (inquiryStatus == 4) {
            throw new BusinessException("8888", "\u5f53\u524d\u8be2\u76d8\u5355\u5df2\u8fc7\u671f\uff01");
        }
    }
}

