/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.UccInquirySpuBO;
import com.tydic.commodity.common.ability.bo.UccInquirySpuCreateAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccQuickOrderSpuBO;
import com.tydic.commodity.common.ability.bo.UccQuickOrderSpuCreateAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccQuickOrderSpuCreateAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccQuickOrderSpuInfoBO;
import com.tydic.commodity.common.busi.api.UccQuickOrderSpuCreateBusiService;
import com.tydic.commodity.dao.SupplierMapper;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccBrandExtMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityMeasureMapper;
import com.tydic.commodity.dao.UccCommodityServiceMapper;
import com.tydic.commodity.dao.UccSaleNumMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPicMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.UccSmcsdkSkuStockInfoMapper;
import com.tydic.commodity.dao.UccVendorMapper;
import com.tydic.commodity.po.BrandInfoPO;
import com.tydic.commodity.po.SupplierBusiPo;
import com.tydic.commodity.po.SupplierShopPo;
import com.tydic.commodity.po.UccBrandDealPO;
import com.tydic.commodity.po.UccCommodityMeasurePo;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccCommodityServicePO;
import com.tydic.commodity.po.UccSaleNumPo;
import com.tydic.commodity.po.UccSkuPicPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.po.UccSmcsdkSkuStockInfoPO;
import com.tydic.commodity.po.UccVendorPo;
import com.tydic.commodity.utils.MoneyUtils;
import java.math.BigDecimal;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class UccQuickOrderSpuCreateBusiServiceImpl
implements UccQuickOrderSpuCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccQuickOrderSpuCreateBusiServiceImpl.class);
    @Value(value="${QUICK_ORDER_SUPPLIER:111}")
    private String INQUIRY_SUPPLIER;
    @Value(value="${QUICK_ORDER_SUPPLIER_NAME:\u8be2\u76d8\u4f9b\u5e94\u5546}")
    private String INQUIRY_SUPPLIER_NAME;
    @Value(value="${QUICK_ORDER_SKU_IMAGE:http://}")
    private String DEFAULT_SKU_IMAGE;
    @Value(value="${QUICK_ORDER_AGR_ID:11111}")
    private String INQUIRY_AGR_ID;
    private Sequence SEQUENCE = Sequence.getInstance();
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private UccBrandExtMapper uccBrandExtMapper;
    @Autowired
    private UccBrandDealMapper uccBrandDealMapper;
    @Autowired
    private UccVendorMapper uccVendorMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private SupplierMapper supplierMapper;
    @Autowired
    private UccCommodityMeasureMapper uccCommodityMeasureMapper;
    @Autowired
    private UccSaleNumMapper uccSaleNumMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSmcsdkSkuStockInfoMapper uccSmcsdkSkuStockInfoMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccSkuPicMapper uccSkuPicMapper;
    @Autowired
    private UccCommodityServiceMapper uccCommodityServiceMapper;

    @Override
    public UccQuickOrderSpuCreateAbilityRspBO dealOrderSpuCreate(UccQuickOrderSpuCreateAbilityReqBO reqBO) {
        long supplierId = Long.parseLong(this.INQUIRY_SUPPLIER);
        ArrayList<UccSkuPo> uccSkuPos = new ArrayList<UccSkuPo>();
        ArrayList<UccSkuPricePo> pricePos = new ArrayList<UccSkuPricePo>();
        ArrayList<UccSkuPicPo> uccSkuPicPos = new ArrayList<UccSkuPicPo>();
        ArrayList<UccSmcsdkSkuStockInfoPO> smcsdkSkuStockInfoPOS = new ArrayList<UccSmcsdkSkuStockInfoPO>();
        ArrayList<UccSaleNumPo> uccSaleNumPos = new ArrayList<UccSaleNumPo>();
        ArrayList<UccCommodityServicePO> servicePOS = new ArrayList<UccCommodityServicePO>();
        ArrayList<UccCommodityPo> uccCommodityPos = new ArrayList<UccCommodityPo>();
        Map<String, List<BrandInfoPO>> brandMap = this.brandValidate(reqBO);
        this.validateVendor(supplierId);
        this.dealData(uccSkuPos, pricePos, smcsdkSkuStockInfoPOS, uccSkuPicPos, uccSaleNumPos, uccCommodityPos, servicePOS, brandMap, reqBO);
        this.dealAddData(uccSkuPos, pricePos, smcsdkSkuStockInfoPOS, uccSkuPicPos, uccSaleNumPos, servicePOS, uccCommodityPos);
        this.dealStockRedis(smcsdkSkuStockInfoPOS);
        UccQuickOrderSpuCreateAbilityRspBO rspBO = new UccQuickOrderSpuCreateAbilityRspBO();
        List spuBOS = uccSkuPos.stream().map(e -> {
            UccQuickOrderSpuInfoBO orderSpuInfoBO = new UccQuickOrderSpuInfoBO();
            orderSpuInfoBO.setSkuId(e.getSkuId());
            orderSpuInfoBO.setCommodityId(e.getCommodityId());
            orderSpuInfoBO.setSkuName(e.getSkuName());
            orderSpuInfoBO.setSupplierId(e.getVendorId());
            orderSpuInfoBO.setQuickOrderSpuDetailId(e.getAgreementDetailsId());
            orderSpuInfoBO.setSalePrice(MoneyUtils.haoToYuan((Long)e.getSalePrice()));
            orderSpuInfoBO.setNum(e.getNum());
            orderSpuInfoBO.setAgreementId(e.getAgreementId());
            return orderSpuInfoBO;
        }).collect(Collectors.toList());
        rspBO.setQuickOrderSpuInfoBOList(spuBOS);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealStockRedis(List<UccSmcsdkSkuStockInfoPO> smcsdkSkuStockInfoPOS) {
        for (UccSmcsdkSkuStockInfoPO po : smcsdkSkuStockInfoPOS) {
            String redisKey = "STOCK_SALE_NUM_" + po.getStockhouseId();
            Long count = this.cacheClient.incrBy(redisKey + "_" + po.getSkuId(), po.getTotalNum().longValue());
            log.info("\u5165\u5e93\u66f4\u65b0\u540e\u7684\u53ef\u552e\u6570\u91cf\u4e3a" + count);
        }
    }

    private void dealAddData(List<UccSkuPo> uccSkuPos, List<UccSkuPricePo> pricePos, List<UccSmcsdkSkuStockInfoPO> smcsdkSkuStockInfoPOS, List<UccSkuPicPo> uccSkuPicPos, List<UccSaleNumPo> uccSaleNumPos, List<UccCommodityServicePO> servicePOS, List<UccCommodityPo> uccCommodityPos) {
        try {
            this.uccCommodityMapper.batchInsert(uccCommodityPos);
            this.uccSkuMapper.insertBatch(uccSkuPos);
            this.uccSaleNumMapper.insertBatch(uccSaleNumPos);
            this.uccSmcsdkSkuStockInfoMapper.insertBatch(smcsdkSkuStockInfoPOS);
            this.uccSkuPriceMapper.batchInsert(pricePos);
            this.uccSkuPicMapper.batchInsert(uccSkuPicPos);
            this.uccCommodityServiceMapper.insertBatch(servicePOS);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("8888", "\u6279\u91cf\u751f\u6210\u5546\u54c1\u5f02\u5e38\uff01");
        }
    }

    private void dealData(List<UccSkuPo> uccSkuPos, List<UccSkuPricePo> pricePos, List<UccSmcsdkSkuStockInfoPO> smcsdkSkuStockInfoPOS, List<UccSkuPicPo> uccSkuPicPos, List<UccSaleNumPo> uccSaleNumPos, ArrayList<UccCommodityPo> uccCommodityPos, List<UccCommodityServicePO> servicePOS, Map<String, List<BrandInfoPO>> brandMap, UccQuickOrderSpuCreateAbilityReqBO reqBO) {
        long supplierId = Long.parseLong(this.INQUIRY_SUPPLIER);
        int sNum = 1;
        for (UccQuickOrderSpuBO spuBO : reqBO.getOrderSpuInfoBOList()) {
            Date TIME = new Date();
            String TIMESTR = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            Long skuId = this.SEQUENCE.nextId();
            Long commodityId = this.SEQUENCE.nextId();
            Long brandId = null;
            if (!ObjectUtils.isEmpty((Object)spuBO.getBrandName())) {
                brandId = brandMap.get(spuBO.getBrandName()).get(0).getBrandId();
            }
            UccCommodityPo commodityPo = new UccCommodityPo();
            commodityPo.setAgreementId(this.INQUIRY_AGR_ID);
            commodityPo.setCommodityId(commodityId);
            commodityPo.setSupplierShopId(Long.valueOf(supplierId));
            commodityPo.setOrgId(this.INQUIRY_SUPPLIER);
            commodityPo.setVendorId(Long.valueOf(supplierId));
            commodityPo.setOrgName(this.INQUIRY_SUPPLIER_NAME);
            commodityPo.setShopName(this.INQUIRY_SUPPLIER_NAME);
            commodityPo.setCommoditySource(ModelRuleConstant.SKU_SOURCE_PROTOCOL_GENERATION);
            commodityPo.setCommodityStatus(ModelRuleConstant.SKU_STATUS_ON_SHELF);
            commodityPo.setCommodityCode(UccQuickOrderSpuCreateBusiServiceImpl.codeGeneral(new Date(), sNum));
            commodityPo.setCommodityTypeId(Long.valueOf(1L));
            commodityPo.setStoreGetType(Integer.valueOf(1));
            commodityPo.setCreateOperId(reqBO.getUserId().toString());
            commodityPo.setCreateOperName(reqBO.getName());
            commodityPo.setCreateTime(TIME);
            commodityPo.setUpdateTime(TIME);
            commodityPo.setViewOrder(Integer.valueOf(0));
            commodityPo.setFreeShipping(Integer.valueOf(0));
            commodityPo.setRate(spuBO.getRate());
            commodityPo.setCommodityLinkChar(spuBO.getRate() + "");
            commodityPo.setBrandId(brandId);
            commodityPo.setBrandName(spuBO.getBrandName());
            commodityPo.setCommodityName(spuBO.getCommodityName());
            commodityPo.setAgreementDetailsId(spuBO.getQuickOrderSpuDetailId().toString());
            commodityPo.setExtSpuId("QUICK_ORDER");
            uccCommodityPos.add(commodityPo);
            UccSkuPo skuPo = new UccSkuPo();
            BeanUtils.copyProperties((Object)commodityPo, (Object)skuPo);
            skuPo.setPreDeliverDay(spuBO.getPreDeliverDay());
            skuPo.setAgreementId(Long.valueOf(Long.parseLong(this.INQUIRY_AGR_ID)));
            skuPo.setAgreementDetailsId(spuBO.getQuickOrderSpuDetailId());
            skuPo.setSkuId(skuId);
            skuPo.setCommodityId(commodityId);
            skuPo.setSkuName(commodityPo.getCommodityName());
            skuPo.setSkuSource(ModelRuleConstant.SKU_SOURCE_PROTOCOL_GENERATION);
            skuPo.setSkuName(spuBO.getCommodityName());
            skuPo.setSkuStatus(ModelRuleConstant.SKU_STATUS_ON_SHELF);
            skuPo.setSpec(spuBO.getSpec());
            skuPo.setBrandName(spuBO.getBrandName());
            skuPo.setBrandId(brandId);
            skuPo.setModel(spuBO.getSpecModel());
            skuPo.setSalesUnitName(spuBO.getSalesUnit());
            skuPo.setMeasureId(spuBO.getSalesUnitId());
            skuPo.setMeasureName(spuBO.getSalesUnit());
            skuPo.setSettlementUnit(spuBO.getSalesUnit());
            skuPo.setSalesUnitId(spuBO.getSalesUnitId());
            skuPo.setSkuCode(UccQuickOrderSpuCreateBusiServiceImpl.codeGeneral(TIME, sNum));
            skuPo.setOrgId(Long.valueOf(supplierId));
            skuPo.setMoq(new BigDecimal("1"));
            skuPo.setExtSpuId("QUICK_ORDER");
            skuPo.setSalePrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)spuBO.getSalePrice())));
            skuPo.setNum(spuBO.getNum());
            uccSkuPos.add(skuPo);
            UccSkuPricePo skuPricePo = new UccSkuPricePo();
            skuPricePo.setSkuPriceId(Long.valueOf(this.SEQUENCE.nextId()));
            skuPricePo.setSkuId(skuId);
            skuPricePo.setSupplierShopId(Long.valueOf(supplierId));
            skuPricePo.setAgreementPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)spuBO.getSalePrice())));
            skuPricePo.setSalePrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)spuBO.getSalePrice())));
            skuPricePo.setMarketPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)spuBO.getSalePrice())));
            skuPricePo.setCreateTime(TIME);
            skuPricePo.setCreateOperId(reqBO.getName());
            pricePos.add(skuPricePo);
            for (int i = 0; i < 5; ++i) {
                UccSkuPicPo skuPicPo = new UccSkuPicPo();
                skuPicPo.setSkuId(skuId);
                skuPicPo.setSupplierShopId(Long.valueOf(supplierId));
                skuPicPo.setSkuPicId(Long.valueOf(this.SEQUENCE.nextId()));
                if (i == 0) {
                    skuPicPo.setCommodityPicType(Integer.valueOf(1));
                    skuPicPo.setSkuPicUrl(this.DEFAULT_SKU_IMAGE);
                } else {
                    skuPicPo.setSkuPicUrl("");
                    skuPicPo.setCommodityPicType(Integer.valueOf(2));
                }
                skuPicPo.setCreateOperId(reqBO.getName());
                skuPicPo.setCreateTime(TIME);
                uccSkuPicPos.add(skuPicPo);
            }
            UccSmcsdkSkuStockInfoPO smcsdkSkuStockInfoPO = new UccSmcsdkSkuStockInfoPO();
            smcsdkSkuStockInfoPO.setSkuStockId(Long.valueOf(this.SEQUENCE.nextId()));
            smcsdkSkuStockInfoPO.setStockhouseId("1");
            smcsdkSkuStockInfoPO.setSkuId(skuId.toString());
            smcsdkSkuStockInfoPO.setTotalNum(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)spuBO.getNum().multiply(new BigDecimal("10000")))));
            smcsdkSkuStockInfoPO.setUnsaleNum(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)spuBO.getNum().multiply(new BigDecimal("10000")))));
            smcsdkSkuStockInfoPO.setSaledNum(Long.valueOf(0L));
            smcsdkSkuStockInfoPO.setLockNum(Long.valueOf(0L));
            smcsdkSkuStockInfoPO.setCreateNo(reqBO.getUsername());
            smcsdkSkuStockInfoPO.setCreateTime(TIME);
            smcsdkSkuStockInfoPOS.add(smcsdkSkuStockInfoPO);
            UccSaleNumPo saleNumPo = new UccSaleNumPo();
            saleNumPo.setSkuId(skuId);
            saleNumPo.setSupplierShopId(Long.valueOf(supplierId));
            saleNumPo.setSoldNumber(new BigDecimal(0));
            saleNumPo.setSaleId(Long.valueOf(this.SEQUENCE.nextId()));
            uccSaleNumPos.add(saleNumPo);
            UccCommodityServicePO uccCommodityServicePO = new UccCommodityServicePO();
            uccCommodityServicePO.setCommodityId(commodityId);
            uccCommodityServicePO.setSupplierShopId(Long.valueOf(supplierId));
            uccCommodityServicePO.setServiceId(Long.valueOf(this.SEQUENCE.nextId()));
            uccCommodityServicePO.setCreateTime(TIME);
            uccCommodityServicePO.setCreateOperId(reqBO.getName());
            uccCommodityServicePO.setRemark("QUICK_ORDER");
            uccCommodityServicePO.setRejectAllow(Integer.valueOf(0));
            uccCommodityServicePO.setMaintainAllow(Integer.valueOf(0));
            uccCommodityServicePO.setExchangeAllow(Integer.valueOf(0));
            uccCommodityServicePO.setRejectAllowDate(Integer.valueOf(0));
            uccCommodityServicePO.setMaintainAllowDate(Integer.valueOf(0));
            uccCommodityServicePO.setRejectAllowDate(Integer.valueOf(0));
            servicePOS.add(uccCommodityServicePO);
            ++sNum;
        }
    }

    private Map<String, List<UccCommodityMeasurePo>> checkUnitName(UccInquirySpuCreateAbilityReqBO reqBO) {
        List measures = reqBO.getInquirySpuBOList().stream().map(UccInquirySpuBO::getSalesUnit).distinct().collect(Collectors.toList());
        ArrayList<String> notExistsMeasureNames = new ArrayList<String>();
        List uccCommodityMeasurePos = this.uccCommodityMeasureMapper.getMeasureInfoByNammes(measures);
        if (!CollectionUtils.isEmpty((Collection)uccCommodityMeasurePos)) {
            List exist = uccCommodityMeasurePos.stream().map(UccCommodityMeasurePo::getMeasureName).collect(Collectors.toList());
            for (String measure : measures) {
                if (exist.contains(measure)) continue;
                notExistsMeasureNames.add(measure);
            }
        } else {
            notExistsMeasureNames.addAll(measures);
        }
        if (!CollectionUtils.isEmpty(notExistsMeasureNames)) {
            List commodityMeasurePos = notExistsMeasureNames.stream().map(e -> {
                UccCommodityMeasurePo measurePo = new UccCommodityMeasurePo();
                measurePo.setMeasureId(Long.valueOf(this.SEQUENCE.nextId()));
                measurePo.setIsDelete(Integer.valueOf(0));
                measurePo.setMeasureName(e);
                measurePo.setCreateLoginId(reqBO.getName());
                measurePo.setMeasureType(Integer.valueOf(0));
                return measurePo;
            }).collect(Collectors.toList());
            try {
                this.uccCommodityMeasureMapper.insertBatch(commodityMeasurePos);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                throw new BusinessException("8888", "\u5904\u7406\u8ba1\u91cf\u5355\u4f4d\u5931\u8d25\uff01");
            }
            uccCommodityMeasurePos.addAll(commodityMeasurePos);
        }
        Map<String, List<UccCommodityMeasurePo>> map = uccCommodityMeasurePos.stream().collect(Collectors.groupingBy(UccCommodityMeasurePo::getMeasureName));
        return map;
    }

    private void validateVendor(Long supplierId) {
        SupplierBusiPo supplierBusiPo;
        SupplierShopPo supplierShopPo = this.supplierShopMapper.queryPoBySupplierShopId(supplierId);
        if (ObjectUtils.isEmpty((Object)supplierShopPo)) {
            supplierShopPo = new SupplierShopPo();
            supplierShopPo.setSupplierId(supplierId);
            supplierShopPo.setSupplierName(this.INQUIRY_SUPPLIER_NAME);
            supplierShopPo.setSupplierShopId(supplierId);
            supplierShopPo.setSupplierName(this.INQUIRY_SUPPLIER_NAME);
            supplierShopPo.setShopStatus(Integer.valueOf(1));
            supplierShopPo.setContacts("\u4eba");
            supplierShopPo.setRelaPhone1("111");
            supplierShopPo.setRelaPhone2("2222");
            this.supplierShopMapper.addSupplierShop(supplierShopPo);
        }
        if ((supplierBusiPo = this.supplierMapper.selectSupplierById(supplierId)) == null) {
            supplierBusiPo = new SupplierBusiPo();
            supplierBusiPo.setSupplierId(supplierId);
            supplierBusiPo.setSupplierName(this.INQUIRY_SUPPLIER_NAME);
            supplierBusiPo.setSupplierCode(this.INQUIRY_SUPPLIER);
            this.supplierMapper.addSupplier(supplierBusiPo);
        }
        UccVendorPo uccVendorPo = new UccVendorPo();
        uccVendorPo.setVendorId(supplierId);
        List vendorPoList = this.uccVendorMapper.queryVerdor(uccVendorPo);
        if (CollectionUtils.isEmpty((Collection)vendorPoList)) {
            uccVendorPo = new UccVendorPo();
            uccVendorPo.setVendorId(supplierId);
            uccVendorPo.setId(supplierId);
            uccVendorPo.setVendorName(this.INQUIRY_SUPPLIER_NAME);
            uccVendorPo.setVendorCode(this.INQUIRY_SUPPLIER);
            this.uccVendorMapper.insert(uccVendorPo);
        }
    }

    private Map<String, List<BrandInfoPO>> brandValidate(UccQuickOrderSpuCreateAbilityReqBO reqBO) {
        List brandNames = reqBO.getOrderSpuInfoBOList().stream().map(UccQuickOrderSpuBO::getBrandName).filter(e -> !StringUtils.isEmpty((Object)e)).distinct().collect(Collectors.toList());
        ArrayList<String> notExistsBrandNames = new ArrayList<String>();
        List brandExes = this.uccBrandExtMapper.getBrandInfoByNames(brandNames);
        if (!CollectionUtils.isEmpty((Collection)brandExes)) {
            List exist = brandExes.stream().map(BrandInfoPO::getBrandName).collect(Collectors.toList());
            for (String newBrand : brandNames) {
                if (exist.contains(newBrand)) continue;
                notExistsBrandNames.add(newBrand);
            }
        } else {
            notExistsBrandNames.addAll(brandNames);
        }
        if (!CollectionUtils.isEmpty(notExistsBrandNames)) {
            List uccBrandDealPOS = notExistsBrandNames.stream().map(e -> {
                Date TIME = new Date();
                String TIMESTR = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
                Long brandId = this.SEQUENCE.nextId();
                UccBrandDealPO brandDealPO = new UccBrandDealPO();
                brandDealPO.setBrandType(UccConstants.BrandType.MALL_BRAND);
                brandDealPO.setRelId(null);
                brandDealPO.setBrandId(brandId);
                brandDealPO.setBrandCode("brand_code");
                brandDealPO.setBrandStatus(Integer.valueOf(1));
                brandDealPO.setBrandEnName(null);
                brandDealPO.setBrandName(e);
                brandDealPO.setBrandLogo(null);
                brandDealPO.setEffTime(new Date());
                brandDealPO.setExpTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse("2099-12-31 23:59:59", new ParsePosition(0)));
                brandDealPO.setBrandDesc(null);
                brandDealPO.setTrademarkNum(null);
                brandDealPO.setBrandOwner(null);
                brandDealPO.setCreateTime(TIMESTR);
                brandDealPO.setBrandStatusTranslation(null);
                brandDealPO.setUpdateTime(TIMESTR);
                brandDealPO.setUpdateOperId(reqBO.getName());
                brandDealPO.setCreateOperId(reqBO.getName());
                brandDealPO.setRemark("QUICK_ORDER");
                brandDealPO.setTrademarkCard(null);
                return brandDealPO;
            }).collect(Collectors.toList());
            this.uccBrandDealMapper.addBrands(uccBrandDealPOS);
            List brandInfoPOS = uccBrandDealPOS.stream().map(e -> {
                BrandInfoPO brandInfoPO = new BrandInfoPO();
                brandInfoPO.setBrandId(e.getBrandId());
                brandInfoPO.setBrandName(e.getBrandName());
                return brandInfoPO;
            }).collect(Collectors.toList());
            brandExes.addAll(brandInfoPOS);
        }
        return brandExes.stream().collect(Collectors.groupingBy(BrandInfoPO::getBrandName));
    }

    public static String codeGeneral(Date date, Integer number) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        String format = formatter.format(date);
        String code = "L" + format;
        String num = number + "";
        if (num.length() == 1) {
            code = code + "000" + num;
        }
        if (num.length() == 2) {
            code = code + "00" + num;
        }
        if (num.length() == 3) {
            code = code + "0" + num;
        }
        if (num.length() == 4) {
            code = code + num;
        }
        return code;
    }
}

