/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccSkuPutCirAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSkuPutCirReqBO;
import com.tydic.commodity.busibase.atom.bo.UccSkuPutCirRspBO;
import com.tydic.commodity.common.ability.bo.UccUmcItemCatChangeOffSpuAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccUmcItemCatChangeOffSpuAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccUmcItemCatChangeOffSpuBusiService;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuExpandMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuExpandPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.DateUtils;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class UccUmcItemCatChangeOffSpuBusiServiceImpl
implements UccUmcItemCatChangeOffSpuBusiService {
    @Value(value="${ITEM_CHANGE_OFF_REASON:\u4f9b\u5e94\u5546\u672a\u7b7e\u7ea6\u8be5\u54c1\u7c7b(\u5546\u54c1\u7c7b\u578b)\u6216\u8be5\u54c1\u7c7b\u5df2\u88ab\u5220\u9664}")
    private String ITEM_CHANGE_OFF_REASON;
    @Autowired
    private UccSkuPutCirAtomService uccSkuPutCirAtomService;
    @Autowired
    private UccSkuExpandMapper uccSkuExpandMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;

    @Override
    public UccUmcItemCatChangeOffSpuAbilityRspBO dealOffSpu(UccUmcItemCatChangeOffSpuAbilityReqBO reqBO) {
        UccUmcItemCatChangeOffSpuAbilityRspBO rspBO = new UccUmcItemCatChangeOffSpuAbilityRspBO();
        List uccSkuPos = CollectionUtils.isEmpty((Collection)reqBO.getItemCateIds()) ? this.uccSkuMapper.getSkuInfoExcludeTypes(reqBO.getSupplierId(), reqBO.getItemCateIds()) : this.uccSkuMapper.getSkuInfoExcludeTypes(reqBO.getSupplierId(), reqBO.getItemCateIds());
        if (!CollectionUtils.isEmpty((Collection)uccSkuPos)) {
            this.uccSkuMapper.updatestatusByskuIdsItem(Integer.valueOf(5), uccSkuPos.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList()));
            this.dealUpdatePutCir(uccSkuPos);
            this.uccCommodityMapper.updatestatusByskuIdsItem(5, uccSkuPos.stream().map(UccSkuPo::getCommodityId).distinct().collect(Collectors.toList()));
            Map syncSkus = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId, Collectors.mapping(UccSkuPo::getSkuId, Collectors.toList())));
            rspBO.setSkuMap(syncSkus);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getItemCateIds())) {
            this.dealExist(reqBO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealExist(UccUmcItemCatChangeOffSpuAbilityReqBO reqBO) {
        try {
            List uccSkuPos1 = this.uccSkuMapper.getSkuIdBysupAndtypes(reqBO.getSupplierId(), reqBO.getItemCateIds(), this.ITEM_CHANGE_OFF_REASON);
            if (!CollectionUtils.isEmpty((Collection)uccSkuPos1)) {
                List skuIds = uccSkuPos1.stream().map(e -> e.getSkuId()).collect(Collectors.toList());
                this.uccSkuExpandMapper.updateBatchBySkuIds(skuIds, this.ITEM_CHANGE_OFF_REASON + "-");
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new BusinessException("8888", "\u66f4\u65b0\u5df2\u5b58\u5728\u54c1\u7c7b\u5bf9\u5e94\u5546\u54c1\u6269\u5c55\u5931\u8d25\uff01");
        }
    }

    private void dealUpdatePutCir(List<UccSkuPo> skuInfoByCodes) {
        Date time = new Date();
        try {
            for (UccSkuPo skuPo : skuInfoByCodes) {
                UccSkuPutCirReqBO uccSkuPutCirReqBO = new UccSkuPutCirReqBO();
                uccSkuPutCirReqBO.setSkuId(skuPo.getSkuId());
                uccSkuPutCirReqBO.setSupplierShopId(skuPo.getSupplierShopId());
                uccSkuPutCirReqBO.setDownType(Integer.valueOf(1));
                uccSkuPutCirReqBO.setRealDownTime(DateUtils.dateToStr((Date)time));
                UccSkuPutCirRspBO uccSkuPutCirRspBO = this.uccSkuPutCirAtomService.dealSkuPutCir(uccSkuPutCirReqBO);
                if (!"0000".equals(uccSkuPutCirRspBO.getRespCode())) {
                    throw new BusinessException("8888", "\u4e0a\u67b6\u52a0\u5468\u671f\u5904\u7406\u5931\u8d25\uff01" + uccSkuPutCirRspBO.getRespDesc());
                }
                UccSkuExpandPo expandPo = new UccSkuExpandPo();
                expandPo.setSkuId(skuPo.getSkuId());
                expandPo.setExpand16(this.ITEM_CHANGE_OFF_REASON);
                expandPo.setExpand15(null);
                expandPo.setExpand24(time);
                UccSkuExpandPo uccSkuExpandPo = this.uccSkuExpandMapper.getModel(expandPo);
                if (ObjectUtils.isEmpty((Object)uccSkuExpandPo)) {
                    expandPo.setCommodityId(skuPo.getCommodityId());
                    expandPo.setSupplierShopId(skuPo.getSupplierShopId());
                    this.uccSkuExpandMapper.insertSkuExpand(expandPo);
                    continue;
                }
                this.uccSkuExpandMapper.updateSkuExpand(expandPo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("8888", "\u5546\u54c1\u4e0a\u4e0b\u67b6\u5468\u671f\u66f4\u65b0\u5931\u8d25\uff01" + e.getMessage());
        }
    }
}

