/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.controller;

import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.RedisUtils;
import com.tydic.commodity.zone.ability.api.UccTheZoneSpuImportTemplateCreateNewAbilityService;
import com.tydic.commodity.zone.ability.bo.UccRedisResultRspBO;
import com.tydic.commodity.zone.busi.api.UccRedisService;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ucc"})
public class DycRedisController {
    private static final Logger log = LoggerFactory.getLogger(DycRedisController.class);
    @Autowired
    private UccRedisService uccRedisService;
    @Autowired
    private UccTheZoneSpuImportTemplateCreateNewAbilityService uccTheZoneSpuImportTemplateCreateNewAbilityService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private RedisUtils redisUtils;

    @PostMapping(value={"/delKeys"})
    public Object delKeys(@RequestParam String dateStr) {
        return this.uccRedisService.delkeys(dateStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/delStockKeys"})
    public Object delStockKeys(@RequestParam String skuId, @RequestParam String supplierId, @RequestParam Integer skuSource) {
        if (StringUtils.isNotBlank((CharSequence)skuId) && StringUtils.isNotBlank((CharSequence)supplierId)) {
            String skuKey = "SKU_TOTAL_STOCK_NUM_KEY_" + skuId;
            String supplyKey = "SUPPLY_STOCK_NUM_KEY_" + skuId + "_" + supplierId;
            this.redisUtils.del(skuKey);
            this.redisUtils.del(supplyKey);
            return "\u6839\u636e\u5165\u53c2\u5220\u9664\u7f13\u5b58\u6210\u529f";
        }
        String setSkuKey = "STOCK_CACHE_SET_SKU_ID";
        int totalCount = 0;
        int cacheNum = 1000;
        long start = System.currentTimeMillis();
        try {
            long count = this.uccSkuMapper.queryCount(skuSource);
            if (count > 0L) {
                totalCount = (int)(count % (long)cacheNum == 0L ? count / (long)cacheNum : count / (long)cacheNum + 1L) + 1;
            }
            log.info("delStockKeys \u5f00\u59cb \u603b\u6570\uff1a{}\uff0c\u5faa\u73af\u6b21\u6570\uff1a{}\uff0c", (Object)count, (Object)totalCount);
            while (totalCount > 0) {
                List uccSkuPos;
                long base = 0L;
                String cacheSeId = (String)this.redisUtils.get(setSkuKey);
                if (null != cacheSeId && !cacheSeId.equals("")) {
                    base = Long.valueOf(cacheSeId);
                }
                if (CollectionUtils.isNotEmpty((Collection)(uccSkuPos = this.uccSkuMapper.queryTotalData(skuSource, Long.valueOf(base), cacheNum)))) {
                    String indexSkuId = ((UccSkuPo)uccSkuPos.get(uccSkuPos.size() - 1)).getSkuId().toString();
                    this.redisUtils.set(setSkuKey, (Object)indexSkuId);
                    for (UccSkuPo uccSkuPo : uccSkuPos) {
                        String skuKey = "SKU_TOTAL_STOCK_NUM_KEY_" + uccSkuPo.getSkuId();
                        String supplyKey = "SUPPLY_STOCK_NUM_KEY_" + uccSkuPo.getSkuId() + "_" + uccSkuPo.getSupplierShopId();
                        this.redisUtils.del(skuKey);
                        this.redisUtils.del(supplyKey);
                    }
                    --totalCount;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            log.error("executeTaskCache job \u5f02\u5e38{}", (Throwable)e);
        }
        finally {
            this.redisUtils.del(setSkuKey);
            log.info("\u5168\u90e8\u5220\u9664\u7f13\u5b58\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - start));
        }
        return "\u5168\u90e8\u5220\u9664\u7f13\u5b58\u6210\u529f";
    }

    @GetMapping(value={"/newDelKeys"})
    public Object newDelKeys(@RequestParam String dateStr) {
        return this.uccRedisService.newDelKeys(dateStr);
    }

    @GetMapping(value={"/executeSkuRepeatTask"})
    public void executeSkuRepeatTask(Integer skuSource) {
        this.uccTheZoneSpuImportTemplateCreateNewAbilityService.executeSkuRepeatTask(skuSource);
    }

    @PostMapping(value={"/delGoodsDetailKeys"})
    @BusiResponseBody
    public UccRedisResultRspBO delGoodsDetailKeys(@RequestBody List<Long> skuIds) {
        return this.uccRedisService.delGoodsDetailKeys(skuIds);
    }

    @GetMapping(value={"/getThreadPoolMonitor"})
    public Object getThreadPoolMonitor() {
        return this.uccTheZoneSpuImportTemplateCreateNewAbilityService.getThreadPoolMonitor();
    }
}

