/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SelfRunSyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.commodity.zone.ability.api.UccAgrGoodsPriceCalculateAbilityService;
import com.tydic.commodity.zone.ability.bo.UccAgrGoodsPriceCalculateAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccAgrGoodsPriceCalculateAbilityRspBO;
import com.tydic.commodity.zone.busi.api.UccAgrGoodsPriceMarkupRateUpdateBusiService;
import com.tydic.commodity.zone.busi.bo.UccAgrGoodsPriceMarkupRateUpdateBusiServiceReqBO;
import com.tydic.commodity.zone.busi.bo.UccAgrGoodsPriceMarkupRateUpdateBusiServiceRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.zone.ability.api.UccAgrGoodsPriceCalculateAbilityService"})
public class UccAgrGoodsPriceCalculateAbilityServiceImpl
implements UccAgrGoodsPriceCalculateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccAgrGoodsPriceCalculateAbilityServiceImpl.class);
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccAgrGoodsPriceMarkupRateUpdateBusiService uccAgrGoodsPriceMarkupRateUpdateBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    @PostMapping(value={"priceCalculate"})
    public UccAgrGoodsPriceCalculateAbilityRspBO priceCalculate(@RequestBody UccAgrGoodsPriceCalculateAbilityReqBO reqBO) {
        this.validate(reqBO);
        UccAgrGoodsPriceCalculateAbilityRspBO rspBO = new UccAgrGoodsPriceCalculateAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setAgreementPrice(reqBO.getAgreementPrice());
        switch (reqBO.getType()) {
            case 1: {
                BigDecimal addCoefficient2 = new BigDecimal(reqBO.getMarkupRate()).divide(new BigDecimal(100), 8, 5);
                BigDecimal salePrice = this.uccSkuPriceMapper.getPrice(addCoefficient2.add(new BigDecimal("1")), reqBO.getAgreementPrice().multiply(new BigDecimal("10000"))).divide(new BigDecimal("10000"));
                rspBO.setSalePrice(salePrice);
                rspBO.setMarkupRate(reqBO.getMarkupRate());
                break;
            }
            case 2: {
                BigDecimal addCoefficient = reqBO.getSalePrice().divide(reqBO.getAgreementPrice(), 2, RoundingMode.HALF_UP).subtract(new BigDecimal("1")).multiply(new BigDecimal("100"));
                rspBO.setMarkupRate(addCoefficient.toString());
                rspBO.setSalePrice(reqBO.getSalePrice());
                break;
            }
            default: {
                throw new BusinessException("8888", "\u5165\u53c2 type \u4e0d\u5408\u6cd5\uff01");
            }
        }
        this.dealUpdatePrice(rspBO, reqBO.getSkuId());
        this.dealSysEs(reqBO.getSkuId(), reqBO.getSupplierShopId());
        return rspBO;
    }

    private void dealSysEs(Long skuId, Long shopId) {
        SelfRunSyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SelfRunSyncSceneCommodityToEsReqBO();
        syncSceneCommodityToEsReqBO.setSkuIds(Collections.singletonList(skuId));
        syncSceneCommodityToEsReqBO.setSupplierId(shopId);
        syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_UPDATE_TYPE);
        syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
        syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_PRICE.intValue());
        try {
            log.info("\u534f\u8bae\u5546\u54c1\u52a0\u4ef7\u540c\u6b65es:" + JSON.toJSONString((Object)syncSceneCommodityToEsReqBO));
            this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u53d1\u9001mq\u6d88\u606f\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    private void dealUpdatePrice(UccAgrGoodsPriceCalculateAbilityRspBO rspBO, Long skuId) {
        UccAgrGoodsPriceMarkupRateUpdateBusiServiceReqBO busiServiceReqBO = new UccAgrGoodsPriceMarkupRateUpdateBusiServiceReqBO();
        UccAgrGoodsPriceMarkupRateUpdateBusiServiceReqBO.UccAgrGoodsPriceMarkupRateUpdateBO uccAgrGoodsPriceMarkupRateUpdateBO = new UccAgrGoodsPriceMarkupRateUpdateBusiServiceReqBO.UccAgrGoodsPriceMarkupRateUpdateBO();
        uccAgrGoodsPriceMarkupRateUpdateBO.setMarkupRate(rspBO.getMarkupRate());
        uccAgrGoodsPriceMarkupRateUpdateBO.setSalePrice(rspBO.getSalePrice());
        uccAgrGoodsPriceMarkupRateUpdateBO.setSkuId(skuId);
        uccAgrGoodsPriceMarkupRateUpdateBO.setAgreementPrice(rspBO.getAgreementPrice());
        busiServiceReqBO.setUpdateBOList(Collections.singletonList(uccAgrGoodsPriceMarkupRateUpdateBO));
        UccAgrGoodsPriceMarkupRateUpdateBusiServiceRspBO busiServiceRspBO = this.uccAgrGoodsPriceMarkupRateUpdateBusiService.dealUpdatePriceMarkUpRate(busiServiceReqBO);
        if (!"0000".equals(busiServiceRspBO.getRespCode())) {
            throw new BusinessException("8888", "\u66f4\u65b0\u5355\u54c1\u4ef7\u683c\u5931\u8d25\uff01" + busiServiceRspBO.getRespDesc());
        }
    }

    private void validate(UccAgrGoodsPriceCalculateAbilityReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getType())) {
            throw new BusinessException("8888", "\u5165\u53c2 type  \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getAgreementPrice())) {
            throw new BusinessException("8888", "  \u5165\u53c2 agreementPrice \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getType() == 1 && ObjectUtils.isEmpty((Object)reqBO.getMarkupRate())) {
            throw new BusinessException("8888", "type \u4e3a 1 \u65f6 \u5165\u53c2 salePrice \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getType() == 2 && ObjectUtils.isEmpty((Object)reqBO.getSalePrice())) {
            throw new BusinessException("8888", "type \u4e3a 2 \u65f6 \u5165\u53c2 markupRate \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

