/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SelfRunSyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ExcelNewUtils;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.commodity.zone.ability.api.UccAgrGoodsPriceCalculateImportAbilityService;
import com.tydic.commodity.zone.ability.bo.UccAgrGoodsPriceCalculateImportAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccAgrGoodsPriceCalculateImportAbilityRspBO;
import com.tydic.commodity.zone.ability.bo.UccExcelPriceMarkUpRateUpdateBO;
import com.tydic.commodity.zone.busi.api.UccAgrGoodsPriceMarkupRateUpdateBusiService;
import com.tydic.commodity.zone.busi.bo.UccAgrGoodsPriceMarkupRateUpdateBusiServiceReqBO;
import com.tydic.commodity.zone.busi.bo.UccAgrGoodsPriceMarkupRateUpdateBusiServiceRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.zone.ability.api.UccAgrGoodsPriceCalculateImportAbilityService"})
public class UccAgrGoodsPriceCalculateImportAbilityServiceImpl
implements UccAgrGoodsPriceCalculateImportAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccAgrGoodsPriceCalculateImportAbilityServiceImpl.class);
    @Autowired
    private UccAgrGoodsPriceMarkupRateUpdateBusiService uccAgrGoodsPriceMarkupRateUpdateBusiService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    @PostMapping(value={"priceCalculateImport"})
    public UccAgrGoodsPriceCalculateImportAbilityRspBO priceCalculateImport(@RequestBody UccAgrGoodsPriceCalculateImportAbilityReqBO reqBO) {
        List<UccExcelPriceMarkUpRateUpdateBO> skuAdjustBOList = null;
        if (StringUtils.isEmpty((Object)reqBO.getUrl())) {
            throw new BusinessException("8888", "\u5165\u53c2 url \u4e3a\u7a7a\uff01");
        }
        if (!ObjectUtils.isEmpty((Object)reqBO.getType())) {
            if (reqBO.getType() == 2) {
                skuAdjustBOList = this.getSkuAdjustBOListYunying(reqBO.getUrl());
            }
            if (reqBO.getType() == 1) {
                skuAdjustBOList = this.getSkuAdjustBOListSanfang(reqBO.getUrl());
            }
        } else {
            skuAdjustBOList = this.getSkuAdjustBOList(reqBO.getUrl());
        }
        this.validate(skuAdjustBOList);
        List<UccAgrGoodsPriceMarkupRateUpdateBusiServiceReqBO.UccAgrGoodsPriceMarkupRateUpdateBO> updateBOList = skuAdjustBOList.stream().map(e -> {
            UccAgrGoodsPriceMarkupRateUpdateBusiServiceReqBO.UccAgrGoodsPriceMarkupRateUpdateBO uccAgrGoodsPriceMarkupRateUpdateBO = new UccAgrGoodsPriceMarkupRateUpdateBusiServiceReqBO.UccAgrGoodsPriceMarkupRateUpdateBO();
            uccAgrGoodsPriceMarkupRateUpdateBO.setSkuId(e.getSkuId());
            uccAgrGoodsPriceMarkupRateUpdateBO.setAgreementPrice(e.getAgreementPrice());
            if (!ObjectUtils.isEmpty((Object)e.getSalePrice())) {
                BigDecimal markUpRate = e.getSalePrice().divide(e.getAgreementPrice(), 2, RoundingMode.HALF_UP).subtract(new BigDecimal("1")).multiply(new BigDecimal("100"));
                uccAgrGoodsPriceMarkupRateUpdateBO.setMarkupRate(markUpRate.toString());
                uccAgrGoodsPriceMarkupRateUpdateBO.setSalePrice(e.getSalePrice());
            } else {
                BigDecimal addCoefficient2 = e.getMarkUpRate().divide(new BigDecimal(100), 8, 5);
                BigDecimal salePrice = this.uccSkuPriceMapper.getPrice(addCoefficient2.add(new BigDecimal("1")), e.getAgreementPrice().multiply(new BigDecimal("10000")));
                uccAgrGoodsPriceMarkupRateUpdateBO.setSalePrice(salePrice.divide(new BigDecimal("10000")));
                uccAgrGoodsPriceMarkupRateUpdateBO.setMarkupRate(e.getMarkUpRate().toString());
            }
            return uccAgrGoodsPriceMarkupRateUpdateBO;
        }).collect(Collectors.toList());
        UccAgrGoodsPriceMarkupRateUpdateBusiServiceReqBO busiServiceReqBO = new UccAgrGoodsPriceMarkupRateUpdateBusiServiceReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiServiceReqBO));
        busiServiceReqBO.setUpdateBOList(updateBOList);
        UccAgrGoodsPriceMarkupRateUpdateBusiServiceRspBO rateUpdateBusiServiceRspBO = this.uccAgrGoodsPriceMarkupRateUpdateBusiService.dealUpdatePriceMarkUpRate(busiServiceReqBO);
        if (!"0000".equals(rateUpdateBusiServiceRspBO.getRespCode())) {
            throw new BusinessException("8888", "\u5904\u7406\u52a0\u4ef7\u6bd4\u7387\u9500\u552e\u4ef7\u5931\u8d25\uff01" + rateUpdateBusiServiceRspBO.getRespDesc());
        }
        this.dealSyncPrice(skuAdjustBOList);
        UccAgrGoodsPriceCalculateImportAbilityRspBO rspBO = new UccAgrGoodsPriceCalculateImportAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<UccExcelPriceMarkUpRateUpdateBO> getSkuAdjustBOListSanfang(String url) {
        ArrayList<UccExcelPriceMarkUpRateUpdateBO> uccExcelPriceMarkUpRateUpdateBOS;
        block13: {
            List<Object> data = new ArrayList();
            List<String> head = null;
            try {
                List<List<String>> excel = this.dealEcxel(url, 1, 0);
                head = excel.get(0);
                data = this.dealEcxel(url, 2, 0);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ZTBusinessException(e.getMessage());
            }
            int rowNum = 2;
            uccExcelPriceMarkUpRateUpdateBOS = new ArrayList<UccExcelPriceMarkUpRateUpdateBO>();
            try {
                if (!CollectionUtils.isNotEmpty(data)) break block13;
                for (List list : data) {
                    String salePrice;
                    ++rowNum;
                    UccExcelPriceMarkUpRateUpdateBO uccExcelPriceMarkUpRateUpdateBO = new UccExcelPriceMarkUpRateUpdateBO();
                    int i = 0;
                    String skuName = (String)list.get(i++);
                    uccExcelPriceMarkUpRateUpdateBO.setSkuName(skuName);
                    String skuCode = (String)list.get(i++);
                    try {
                        skuCode = UccAgrGoodsPriceCalculateImportAbilityServiceImpl.doubleToInteger(skuCode);
                    }
                    catch (Exception e) {
                        log.error("======\u6570\u5b57\u8f6c\u6362\u5f02\u5e38=========" + skuCode);
                    }
                    uccExcelPriceMarkUpRateUpdateBO.setSkuCode(skuCode);
                    String commodityName = (String)list.get(i++);
                    uccExcelPriceMarkUpRateUpdateBO.setCommodityName(commodityName);
                    String commodityCode = (String)list.get(i++);
                    try {
                        commodityCode = UccAgrGoodsPriceCalculateImportAbilityServiceImpl.doubleToInteger(commodityCode);
                    }
                    catch (Exception e) {
                        log.error("======\u6570\u5b57\u8f6c\u6362\u5f02\u5e38=========" + commodityCode);
                    }
                    uccExcelPriceMarkUpRateUpdateBO.setCommodityCode(commodityCode);
                    String agreementPrice = (String)list.get(i++);
                    if (!StringUtils.isEmpty((Object)agreementPrice)) {
                        uccExcelPriceMarkUpRateUpdateBO.setAgreementPrice(new BigDecimal(agreementPrice));
                    }
                    try {
                        salePrice = (String)list.get(i++);
                    }
                    catch (Exception e) {
                        log.info("===\u9500\u552e\u4ef7\u7a7a===");
                        salePrice = null;
                    }
                    if (!StringUtils.isEmpty((Object)salePrice)) {
                        BigDecimal bigDecimal = new BigDecimal(salePrice).setScale(2, RoundingMode.HALF_UP);
                        uccExcelPriceMarkUpRateUpdateBO.setSalePrice(bigDecimal);
                    }
                    uccExcelPriceMarkUpRateUpdateBOS.add(uccExcelPriceMarkUpRateUpdateBO);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
                e.printStackTrace();
                throw new ZTBusinessException("\u7b2c" + rowNum + "\u884c\u6570\u636e\u51fa\u73b0\u95ee\u9898,\u8bf7\u68c0\u67e5\u683c\u5f0f!");
            }
        }
        return uccExcelPriceMarkUpRateUpdateBOS;
    }

    private List<UccExcelPriceMarkUpRateUpdateBO> getSkuAdjustBOListYunying(String url) {
        ArrayList<UccExcelPriceMarkUpRateUpdateBO> uccExcelPriceMarkUpRateUpdateBOS;
        block16: {
            List<Object> data = new ArrayList();
            List<String> head = null;
            try {
                List<List<String>> excel = this.dealEcxel(url, 1, 0);
                head = excel.get(0);
                data = this.dealEcxel(url, 2, 0);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ZTBusinessException(e.getMessage());
            }
            int rowNum = 2;
            uccExcelPriceMarkUpRateUpdateBOS = new ArrayList<UccExcelPriceMarkUpRateUpdateBO>();
            try {
                if (!CollectionUtils.isNotEmpty(data)) break block16;
                for (List list : data) {
                    String salePrice;
                    BigDecimal bigDecimal;
                    String markUpRate;
                    ++rowNum;
                    UccExcelPriceMarkUpRateUpdateBO uccExcelPriceMarkUpRateUpdateBO = new UccExcelPriceMarkUpRateUpdateBO();
                    int i = 0;
                    String skuName = (String)list.get(i++);
                    uccExcelPriceMarkUpRateUpdateBO.setSkuName(skuName);
                    String skuCode = (String)list.get(i++);
                    try {
                        skuCode = UccAgrGoodsPriceCalculateImportAbilityServiceImpl.doubleToInteger(skuCode);
                    }
                    catch (Exception e) {
                        log.error("======\u6570\u5b57\u8f6c\u6362\u5f02\u5e38=========" + skuCode);
                    }
                    uccExcelPriceMarkUpRateUpdateBO.setSkuCode(skuCode);
                    String commodityName = (String)list.get(i++);
                    uccExcelPriceMarkUpRateUpdateBO.setCommodityName(commodityName);
                    String commodityCode = (String)list.get(i++);
                    try {
                        commodityCode = UccAgrGoodsPriceCalculateImportAbilityServiceImpl.doubleToInteger(commodityCode);
                    }
                    catch (Exception e) {
                        log.error("======\u6570\u5b57\u8f6c\u6362\u5f02\u5e38=========" + commodityCode);
                    }
                    uccExcelPriceMarkUpRateUpdateBO.setCommodityCode(commodityCode);
                    String agreementPrice = (String)list.get(i++);
                    if (!StringUtils.isEmpty((Object)agreementPrice)) {
                        uccExcelPriceMarkUpRateUpdateBO.setAgreementPrice(new BigDecimal(agreementPrice));
                    }
                    try {
                        markUpRate = (String)list.get(i++);
                    }
                    catch (Exception e) {
                        log.info("===\u52a0\u4ef7\u6bd4\u7387\u7a7a===");
                        markUpRate = null;
                    }
                    if (!StringUtils.isEmpty((Object)markUpRate)) {
                        BigDecimal decimal = new BigDecimal(markUpRate);
                        bigDecimal = decimal.setScale(6, RoundingMode.HALF_UP);
                        uccExcelPriceMarkUpRateUpdateBO.setMarkUpRate(bigDecimal);
                    }
                    try {
                        salePrice = (String)list.get(i++);
                    }
                    catch (Exception e) {
                        log.info("===\u9500\u552e\u4ef7\u7a7a===");
                        salePrice = null;
                    }
                    if (!StringUtils.isEmpty((Object)salePrice)) {
                        bigDecimal = new BigDecimal(salePrice).setScale(2, RoundingMode.HALF_UP);
                        uccExcelPriceMarkUpRateUpdateBO.setSalePrice(bigDecimal);
                    }
                    uccExcelPriceMarkUpRateUpdateBOS.add(uccExcelPriceMarkUpRateUpdateBO);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
                e.printStackTrace();
                throw new ZTBusinessException("\u7b2c" + rowNum + "\u884c\u6570\u636e\u51fa\u73b0\u95ee\u9898,\u8bf7\u68c0\u67e5\u683c\u5f0f!");
            }
        }
        return uccExcelPriceMarkUpRateUpdateBOS;
    }

    private void dealSyncPrice(List<UccExcelPriceMarkUpRateUpdateBO> skuAdjustBOList) {
        Map skuMap = skuAdjustBOList.stream().collect(Collectors.groupingBy(UccExcelPriceMarkUpRateUpdateBO::getSupplierShopId, Collectors.mapping(UccExcelPriceMarkUpRateUpdateBO::getSkuId, Collectors.toList())));
        for (Long shopId : skuMap.keySet()) {
            SelfRunSyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SelfRunSyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setSkuIds(skuMap.get(shopId));
            syncSceneCommodityToEsReqBO.setSupplierId(shopId);
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_UPDATE_TYPE);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_PRICE.intValue());
            try {
                this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("==\u5e97\u94fa\u540c\u6b65\u4e0b\u67b6\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff01" + e.getMessage());
            }
        }
    }

    private void validate(List<UccExcelPriceMarkUpRateUpdateBO> skuAdjustBOList) {
        log.info("==\u5bfc\u5165\u4fe1\u606f==" + JSON.toJSONString(skuAdjustBOList));
        if (CollectionUtils.isEmpty(skuAdjustBOList)) {
            throw new BusinessException("8888", "\u6a21\u677f\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a,\u8bf7\u52ff\u5bfc\u5165\u7a7a\u6a21\u677f");
        }
        List validateNullList = skuAdjustBOList.stream().filter(e -> StringUtils.isEmpty((Object)e.getSkuCode())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(validateNullList)) {
            throw new BusinessException("8888", "\u8868\u683c\u5b58\u5728\u5355\u54c1\u7f16\u7801\u4e3a\u7a7a\u7684\u6570\u636e\u884c\uff01");
        }
        List repeatList = skuAdjustBOList.stream().map(UccExcelPriceMarkUpRateUpdateBO::getSkuCode).distinct().collect(Collectors.toList());
        if (repeatList.size() != skuAdjustBOList.size()) {
            ArrayList<String> skuCodes = new ArrayList<String>();
            Map<String, List<UccExcelPriceMarkUpRateUpdateBO>> groupListMap = skuAdjustBOList.stream().collect(Collectors.groupingBy(UccExcelPriceMarkUpRateUpdateBO::getSkuCode));
            for (String skuCode : groupListMap.keySet()) {
                if (groupListMap.get(skuCode).size() <= 1) continue;
                skuCodes.add(skuCode);
            }
            throw new BusinessException("8888", "\u5b58\u5728\u5355\u54c1\u7f16\u7801\u91cd\u590d\u7684\u6570\u636e\u884c\uff01\u5355\u54c1\u7f16\u7801" + JSON.toJSONString(skuCodes));
        }
        List validatePriceList = skuAdjustBOList.stream().filter(e -> StringUtils.isEmpty((Object)e.getSalePrice()) && StringUtils.isEmpty((Object)e.getMarkUpRate())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(validatePriceList)) {
            List skuCodes = validatePriceList.stream().map(UccExcelPriceMarkUpRateUpdateBO::getSkuCode).collect(Collectors.toList());
            throw new BusinessException("8888", "\u5355\u54c1\u7f16\u7801\u4e3a " + JSON.toJSONString(skuCodes) + " \u7684\u4ef7\u683c\u548c\u52a0\u4ef7\u6bd4\u7387\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        List skuIdByCodes = this.uccSkuMapper.getSkuIdByCodes(repeatList);
        Map<String, List<UccSkuPo>> skuCodeMap = skuIdByCodes.stream().collect(Collectors.groupingBy(UccSkuPo::getSkuCode));
        for (UccExcelPriceMarkUpRateUpdateBO bo : skuAdjustBOList) {
            bo.setSkuId(skuCodeMap.get(bo.getSkuCode()).get(0).getSkuId());
            bo.setSupplierShopId(skuCodeMap.get(bo.getSkuCode()).get(0).getSupplierShopId());
        }
    }

    private List<UccExcelPriceMarkUpRateUpdateBO> getSkuAdjustBOList(String url) {
        ArrayList<UccExcelPriceMarkUpRateUpdateBO> uccExcelPriceMarkUpRateUpdateBOS;
        block17: {
            List<Object> data = new ArrayList();
            List<String> head = null;
            try {
                List<List<String>> excel = this.dealEcxel(url, 1, 0);
                head = excel.get(0);
                data = this.dealEcxel(url, 2, 0);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ZTBusinessException(e.getMessage());
            }
            int rowNum = 2;
            uccExcelPriceMarkUpRateUpdateBOS = new ArrayList<UccExcelPriceMarkUpRateUpdateBO>();
            try {
                if (!CollectionUtils.isNotEmpty(data)) break block17;
                for (List list : data) {
                    String salePrice;
                    BigDecimal bigDecimal;
                    String markUpRate;
                    String agreementPrice;
                    ++rowNum;
                    UccExcelPriceMarkUpRateUpdateBO uccExcelPriceMarkUpRateUpdateBO = new UccExcelPriceMarkUpRateUpdateBO();
                    int i = 0;
                    String skuName = (String)list.get(i++);
                    uccExcelPriceMarkUpRateUpdateBO.setSkuName(skuName);
                    String skuCode = (String)list.get(i++);
                    try {
                        skuCode = UccAgrGoodsPriceCalculateImportAbilityServiceImpl.doubleToInteger(skuCode);
                    }
                    catch (Exception e) {
                        log.error("======\u6570\u5b57\u8f6c\u6362\u5f02\u5e38=========" + skuCode);
                    }
                    uccExcelPriceMarkUpRateUpdateBO.setSkuCode(skuCode);
                    String commodityName = (String)list.get(i++);
                    uccExcelPriceMarkUpRateUpdateBO.setCommodityName(commodityName);
                    String commodityCode = (String)list.get(i++);
                    try {
                        commodityCode = UccAgrGoodsPriceCalculateImportAbilityServiceImpl.doubleToInteger(commodityCode);
                    }
                    catch (Exception e) {
                        log.error("======\u6570\u5b57\u8f6c\u6362\u5f02\u5e38=========" + commodityCode);
                    }
                    uccExcelPriceMarkUpRateUpdateBO.setCommodityCode(commodityCode);
                    String typeName = (String)list.get(i++);
                    uccExcelPriceMarkUpRateUpdateBO.setCommodityTypeName(typeName);
                    String stock = (String)list.get(i++);
                    if (!StringUtils.isEmpty((Object)stock)) {
                        uccExcelPriceMarkUpRateUpdateBO.setStock(new BigDecimal(stock));
                    }
                    if (!StringUtils.isEmpty((Object)(agreementPrice = (String)list.get(i++)))) {
                        uccExcelPriceMarkUpRateUpdateBO.setAgreementPrice(new BigDecimal(agreementPrice));
                    }
                    try {
                        markUpRate = (String)list.get(i++);
                    }
                    catch (Exception e) {
                        log.info("===\u52a0\u4ef7\u6bd4\u7387\u7a7a===");
                        markUpRate = null;
                    }
                    if (!StringUtils.isEmpty((Object)markUpRate)) {
                        BigDecimal decimal = new BigDecimal(markUpRate);
                        bigDecimal = decimal.setScale(6, RoundingMode.HALF_UP);
                        uccExcelPriceMarkUpRateUpdateBO.setMarkUpRate(bigDecimal);
                    }
                    try {
                        salePrice = (String)list.get(i++);
                    }
                    catch (Exception e) {
                        log.info("===\u9500\u552e\u4ef7\u7a7a===");
                        salePrice = null;
                    }
                    if (!StringUtils.isEmpty((Object)salePrice)) {
                        bigDecimal = new BigDecimal(salePrice).setScale(2, RoundingMode.HALF_UP);
                        uccExcelPriceMarkUpRateUpdateBO.setSalePrice(bigDecimal);
                    }
                    uccExcelPriceMarkUpRateUpdateBOS.add(uccExcelPriceMarkUpRateUpdateBO);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
                e.printStackTrace();
                throw new ZTBusinessException("\u7b2c" + rowNum + "\u884c\u6570\u636e\u51fa\u73b0\u95ee\u9898,\u8bf7\u68c0\u67e5\u683c\u5f0f!");
            }
        }
        return uccExcelPriceMarkUpRateUpdateBOS;
    }

    public static String doubleToInteger(String str) {
        if (StringUtils.isEmpty((Object)str)) {
            return "";
        }
        return new BigDecimal(str).stripTrailingZeros().toPlainString();
    }

    private List<List<String>> dealEcxel(String url, Integer startReadLine, Integer sheetAt) {
        if (StringUtils.isEmpty((Object)url)) {
            return new ArrayList<List<String>>();
        }
        ArrayList<List<String>> lines = new ArrayList<List<String>>();
        try {
            ExcelNewUtils.getExcelDate((String)url, lines, (Integer)startReadLine, (Integer)sheetAt);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            throw new ZTBusinessException("\u5904\u7406Excel\u5931\u8d25");
        }
        log.info("\u8bfb\u53d6\u5230\u7684\u6570\u636e\uff1a" + JSONObject.toJSONString(lines));
        return lines;
    }
}

