/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.ability.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.bo.UccBatchSkuBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.enumType.ApprovalTodoEnum;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.busi.api.UccUpAndOffApprovalBusiService;
import com.tydic.commodity.busibase.busi.bo.ExtReqBO;
import com.tydic.commodity.busibase.busi.bo.UccUpAndOffApprovalAbilityReqBO;
import com.tydic.commodity.busibase.busi.bo.UccUpAndOffApprovalAbilityRspBO;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.commodity.zone.ability.api.UccAgrItemBatchOnapprovalAbilityService;
import com.tydic.commodity.zone.ability.bo.UccAgrItemBatchOnapprovalAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccAgrItemBatchOnapprovalAbilityRspBO;
import com.tydic.commodity.zone.ability.bo.UccAgrItemBatchOnapprovalResultBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.zone.ability.api.UccAgrItemBatchOnapprovalAbilityService"})
public class UccAgrItemBatchOnapprovalAbilityServiceImpl
implements UccAgrItemBatchOnapprovalAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccAgrItemBatchOnapprovalAbilityServiceImpl.class);
    @Autowired
    private UccUpAndOffApprovalBusiService uccUpAndOffApprovalBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @PostMapping(value={"dealArgSkuOnapproval"})
    public UccAgrItemBatchOnapprovalAbilityRspBO dealArgSkuOnapproval(@RequestBody UccAgrItemBatchOnapprovalAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getBatchSkuList())) {
            throw new BusinessException("8888", "\u5165\u53c2 batchSkuList \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        UccAgrItemBatchOnapprovalAbilityRspBO rspBO = new UccAgrItemBatchOnapprovalAbilityRspBO();
        Map<Object, Object> skuIdCodeMap = new HashMap();
        if (reqBO.getAuditResult() == 0) {
            skuIdCodeMap = this.validatePriceMarkUp(reqBO.getBatchSkuList(), rspBO);
            if (CollectionUtils.isEmpty((Collection)reqBO.getBatchSkuList())) {
                rspBO.setRespCode("0000");
                return rspBO;
            }
        }
        UccUpAndOffApprovalAbilityReqBO busiReqBO = new UccUpAndOffApprovalAbilityReqBO();
        UccUpAndOffApprovalAbilityRspBO busiRspBO = new UccUpAndOffApprovalAbilityRspBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)busiReqBO);
        busiReqBO.setBatchSkuList(reqBO.getBatchSkuList());
        ExtReqBO extReqBO = new ExtReqBO();
        extReqBO.setAuditObjType(ModelRuleConstant.UAC_APPROVAL_TYPE_ON_SHELF);
        ArrayList<Integer> oldStatus = new ArrayList<Integer>();
        oldStatus.add(SkuStatusEnum.PENDING_SHELF_STATUS.getStatus());
        extReqBO.setStatusOld(oldStatus);
        extReqBO.setNoChangeStatus(true);
        extReqBO.setStatusApproval(SkuStatusEnum.ON_SHELVES_STATUS.getStatus());
        extReqBO.setAuditStatusReject(ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_ON_SHELF_REJECT.toString());
        extReqBO.setAuditStatusCheck(ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_ON_SHELF_GO.toString());
        busiReqBO.setTodoCode(ApprovalTodoEnum.ARG_ON_SHELF_PROCESS.code());
        extReqBO.setRemark("\u624b\u5de5\u4e0a\u67b6");
        try {
            busiRspBO = this.uccUpAndOffApprovalBusiService.dealUpAndOffApproval(busiReqBO, extReqBO);
            BeanUtils.copyProperties((Object)busiRspBO, (Object)rspBO);
        }
        catch (Exception e2) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e2.getMessage());
            return rspBO;
        }
        if (!"0000".equals(rspBO.getRespCode())) {
            return rspBO;
        }
        Map<Long, List<UccBatchSkuBO>> mapSku = reqBO.getBatchSkuList().stream().collect(Collectors.groupingBy(UccBatchSkuBO::getSupplierShopId));
        for (Long supplierShopId : mapSku.keySet()) {
            List skus = mapSku.get(supplierShopId).stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList(skus));
            syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS.intValue());
            try {
                this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
            }
            catch (Exception e3) {
                log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
            }
        }
        if (reqBO.getAuditResult() == 0) {
            Map<Object, Object> finalSkuIdCodeMap = skuIdCodeMap;
            List successList = reqBO.getBatchSkuList().stream().map(e -> {
                UccAgrItemBatchOnapprovalResultBO resultBO = new UccAgrItemBatchOnapprovalResultBO();
                resultBO.setSkuCode(((UccSkuPricePo)((List)finalSkuIdCodeMap.get(e.getSkuId())).get(0)).getSkuCode());
                resultBO.setDesc("\u6210\u529f");
                resultBO.setResult("\u6210\u529f");
                return resultBO;
            }).collect(Collectors.toList());
            rspBO.setSuccessList(successList);
        }
        return rspBO;
    }

    private Map<Long, List<UccSkuPricePo>> validatePriceMarkUp(List<UccBatchSkuBO> batchSkuList, UccAgrItemBatchOnapprovalAbilityRspBO onapprovalResultBO) {
        List filterList;
        List<Object> failList = new ArrayList();
        List skuIds = batchSkuList.stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
        List uccSkuPricePos = this.uccSkuPriceMapper.getPriceMarkUpBySkuIds(skuIds);
        if (CollectionUtils.isEmpty((Collection)uccSkuPricePos)) {
            List skuPos = this.uccSkuMapper.getSkuCodeByIds(skuIds);
            Map<Long, List<UccSkuPo>> skuListMap = skuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSkuId));
            failList = batchSkuList.stream().map(e -> {
                UccAgrItemBatchOnapprovalResultBO resultBO = new UccAgrItemBatchOnapprovalResultBO();
                resultBO.setSkuCode(((UccSkuPo)((List)skuListMap.get(e.getSkuId())).get(0)).getSkuCode());
                resultBO.setDesc("\u672a\u67e5\u8be2\u5230\u4ef7\u683c\u4fe1\u606f");
                resultBO.setResult("\u5931\u8d25");
                return resultBO;
            }).collect(Collectors.toList());
            batchSkuList = new ArrayList<UccBatchSkuBO>();
        }
        if (!CollectionUtils.isEmpty(filterList = uccSkuPricePos.stream().filter(e -> e.getAddCoefficient() == null && e.getAgrModel() != null && e.getAgrModel() == 1).collect(Collectors.toList()))) {
            failList = filterList.stream().map(e -> {
                UccAgrItemBatchOnapprovalResultBO resultBO = new UccAgrItemBatchOnapprovalResultBO();
                resultBO.setSkuCode(e.getSkuCode());
                resultBO.setResult("\u5931\u8d25");
                resultBO.setDesc("\u52a0\u4ef7\u6bd4\u4f8b\u4e3a\u7a7a");
                return resultBO;
            }).collect(Collectors.toList());
            List removeIds = filterList.stream().map(UccSkuPricePo::getSkuId).collect(Collectors.toList());
            Iterator<UccBatchSkuBO> iterator = batchSkuList.iterator();
            while (iterator.hasNext()) {
                Long skuId = iterator.next().getSkuId();
                if (!removeIds.contains(skuId)) continue;
                iterator.remove();
            }
        }
        onapprovalResultBO.setFailList(failList);
        Map<Long, List<UccSkuPricePo>> skuIdCodeMap = uccSkuPricePos.stream().collect(Collectors.groupingBy(UccSkuPricePo::getSkuId));
        return skuIdCodeMap;
    }
}

