/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.constant.ExcelNewUtils;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccCommodityPropDefMapper;
import com.tydic.commodity.dao.UccCommodityPropGrpMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccPropValueListMapper;
import com.tydic.commodity.po.UccCommdPropDefPo;
import com.tydic.commodity.po.UccCommodityPropGrpPo;
import com.tydic.commodity.po.UccCommodityTypePo;
import com.tydic.commodity.po.UccPropValueListPo;
import com.tydic.commodity.zone.ability.api.UccBatchImportAgrComInfoAbilityService;
import com.tydic.commodity.zone.ability.bo.UccBatchImportAgrComInfoAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccBatchImportAgrComInfoAbilityRspBO;
import com.tydic.commodity.zone.ability.bo.UccExcelCommodityAttrButesBO;
import com.tydic.commodity.zone.ability.bo.UccExcelForAgrCommodityBO;
import com.tydic.commodity.zone.ability.bo.UccExcelForAgrSkuBO;
import com.tydic.commodity.zone.ability.bo.UccExcelForAgrTypeGroupBO;
import com.tydic.commodity.zone.ability.bo.UccExcelGrpPropBO;
import com.tydic.commodity.zone.ability.bo.UccExcelSkuAttrButesBO;
import com.tydic.commodity.zone.busi.api.UccBatchImportAgrComInfoBusiService;
import com.tydic.commodity.zone.busi.api.UccBatchImportAgrCommodityTypeGrpPropBusiService;
import com.tydic.commodity.zone.busi.bo.UccBatchImportAgrComInfoBusiReqBO;
import com.tydic.commodity.zone.busi.bo.UccBatchImportAgrComInfoBusiRspBO;
import com.tydic.commodity.zone.busi.bo.UccBatchImportAgrCommodityTypeGrpPropBusiReqBO;
import com.tydic.commodity.zone.busi.bo.UccBatchImportAgrCommodityTypeGrpPropBusiRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.zone.ability.api.UccBatchImportAgrComInfoAbilityService"})
public class UccBatchImportAgrComInfoAbilityServiceImpl
implements UccBatchImportAgrComInfoAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccBatchImportAgrComInfoAbilityServiceImpl.class);
    @Autowired
    private UccBatchImportAgrComInfoBusiService uccBatchImportAgrComInfoBusiService;
    @Autowired
    private UccBatchImportAgrCommodityTypeGrpPropBusiService uccBatchImportAgrCommodityTypeGrpPropBusiService;
    @Autowired
    private UccCommodityPropGrpMapper uccCommodityPropGrpMapper;
    @Autowired
    private UccCommodityPropDefMapper uccCommodityPropDefMapper;
    @Autowired
    private UccPropValueListMapper uccPropValueListMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;

    @PostMapping(value={"batchImportAgrComInfo"})
    public UccBatchImportAgrComInfoAbilityRspBO batchImportAgrComInfo(@RequestBody UccBatchImportAgrComInfoAbilityReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getUrl())) {
            throw new BusinessException("8888", "\u5165\u53c2 url \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List<UccExcelForAgrCommodityBO> spuCreateInfoBOS = this.getSpuInfoFromExcel(reqBO.getUrl());
        log.info("-------------------\u8bfb\u53d6\u7684\u5546\u54c1\u6570\u636e------------------------");
        log.info(JSON.toJSONString(spuCreateInfoBOS));
        List<UccExcelForAgrSkuBO> skuCreateInfoBOS = this.getSkuInfoFromExcel(reqBO.getUrl());
        log.info("-------------------\u8bfb\u53d6\u7684\u5355\u54c1\u6570\u636e-------------------------");
        log.info(JSON.toJSONString(skuCreateInfoBOS));
        List<UccExcelCommodityAttrButesBO> spuPropInfo = this.getSpuPropInfo(reqBO.getUrl());
        log.info("-------------------\u8bfb\u53d6\u7684\u5546\u54c1\u5c5e\u6027\u6570\u636e-------------------------");
        log.info(JSON.toJSONString(spuPropInfo));
        List<UccExcelSkuAttrButesBO> skuAttrGroups = this.getSkuPropInfo(reqBO.getUrl());
        log.info("-------------------\u8bfb\u53d6\u7684\u5355\u54c1\u5c5e\u6027\u6570\u636e-------------------------");
        log.info(JSON.toJSONString(skuAttrGroups));
        UccBatchImportAgrCommodityTypeGrpPropBusiRspBO uccBatchImportAgrCommodityTypeGrpPropBusiRspBO = this.getGrpPropTypeInfo();
        this.validateSpu(spuCreateInfoBOS, skuCreateInfoBOS, uccBatchImportAgrCommodityTypeGrpPropBusiRspBO, spuPropInfo);
        this.validateSku(skuCreateInfoBOS, spuCreateInfoBOS, skuAttrGroups, uccBatchImportAgrCommodityTypeGrpPropBusiRspBO);
        this.validateSpuRelSku(skuCreateInfoBOS, spuCreateInfoBOS);
        UccBatchImportAgrComInfoBusiReqBO busiReqBO = new UccBatchImportAgrComInfoBusiReqBO();
        busiReqBO.setSkuCreateInfoBOS(skuCreateInfoBOS);
        busiReqBO.setSpuCreateInfoBOS(spuCreateInfoBOS);
        UccBatchImportAgrComInfoBusiRspBO uccBatchImportAgrComInfoBusiRspBO = this.uccBatchImportAgrComInfoBusiService.dealBatchImportAgrComInfo(busiReqBO);
        UccBatchImportAgrComInfoAbilityRspBO abilityRspBO = (UccBatchImportAgrComInfoAbilityRspBO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)uccBatchImportAgrComInfoBusiRspBO)), UccBatchImportAgrComInfoAbilityRspBO.class);
        return abilityRspBO;
    }

    private UccBatchImportAgrCommodityTypeGrpPropBusiRspBO getGrpPropTypeInfo() {
        UccCommodityPropGrpPo propGrpPo = new UccCommodityPropGrpPo();
        propGrpPo.setCreateOperId("sys");
        List uccCommodityPropGrpPos = this.uccCommodityPropGrpMapper.queryGroupByPO(propGrpPo);
        if (CollectionUtils.isEmpty((Collection)uccCommodityPropGrpPos)) {
            throw new BusinessException("8888", "\u67e5\u8be2\u5c5e\u6027\u7ec4\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        Map<String, List<UccCommodityPropGrpPo>> commodityPropGrpMap = uccCommodityPropGrpPos.stream().collect(Collectors.groupingBy(UccCommodityPropGrpPo::getCommodityPropGrpName));
        UccCommdPropDefPo propDefPo = new UccCommdPropDefPo();
        propDefPo.setCreateOperId("sys");
        List propDefPos = this.uccCommodityPropDefMapper.getList(propDefPo);
        if (CollectionUtils.isEmpty((Collection)propDefPos)) {
            throw new BusinessException("8888", "\u67e5\u8be2\u5546\u54c1\u5c5e\u6027\u4e3a\u7a7a\uff01");
        }
        Map<String, List<UccCommdPropDefPo>> commodityPropMap = propDefPos.stream().collect(Collectors.groupingBy(UccCommdPropDefPo::getPropName));
        UccPropValueListPo valueListPo = new UccPropValueListPo();
        valueListPo.setCreateOperId("sys");
        List valueListPos = this.uccPropValueListMapper.getList(valueListPo);
        if (CollectionUtils.isEmpty((Collection)valueListPos)) {
            throw new BusinessException("8888", "\u67e5\u8be2\u5c5e\u6027\u503c\u4e3a\u7a7a\uff01");
        }
        Map<String, List<UccPropValueListPo>> propValueMap = valueListPos.stream().collect(Collectors.groupingBy(e -> e.getPropName() + "-" + e.getPropValue()));
        UccCommodityTypePo commodityTypePo = new UccCommodityTypePo();
        commodityTypePo.setCreateOperId("sys");
        List commodityTypePos = this.uccCommodityTypeMapper.getList(commodityTypePo);
        if (CollectionUtils.isEmpty((Collection)commodityTypePos)) {
            throw new BusinessException("8888", "\u5546\u54c1\u7c7b\u578b\u67e5\u8be2\u4e3a\u7a7a\uff01");
        }
        Map<String, List<UccCommodityTypePo>> commodityTypeNameMap = commodityTypePos.stream().collect(Collectors.groupingBy(UccCommodityTypePo::getCommodityTypeName));
        UccBatchImportAgrCommodityTypeGrpPropBusiRspBO uccBatchImportAgrCommodityTypeGrpPropBusiRspBO = new UccBatchImportAgrCommodityTypeGrpPropBusiRspBO();
        uccBatchImportAgrCommodityTypeGrpPropBusiRspBO.setPropValueMap(propValueMap);
        uccBatchImportAgrCommodityTypeGrpPropBusiRspBO.setCommodityTypeNameMap(commodityTypeNameMap);
        uccBatchImportAgrCommodityTypeGrpPropBusiRspBO.setCommodityPropGrpMap(commodityPropGrpMap);
        uccBatchImportAgrCommodityTypeGrpPropBusiRspBO.setCommodityPropMap(commodityPropMap);
        return uccBatchImportAgrCommodityTypeGrpPropBusiRspBO;
    }

    @PostMapping(value={"batchImportAgrPropGrpInfo"})
    public UccBatchImportAgrComInfoAbilityRspBO batchImportAgrPropGrpInfo(@RequestBody UccBatchImportAgrComInfoAbilityReqBO reqBO) {
        UccBatchImportAgrCommodityTypeGrpPropBusiRspBO uccBatchImportAgrCommodityTypeGrpPropBusiRspBO;
        List<UccExcelForAgrTypeGroupBO> typeGroupBOS = this.getTypeGroupInfo(reqBO.getUrl());
        List<UccExcelGrpPropBO> grpPropBOS = this.getGrpPropInfo(reqBO.getUrl());
        List<UccPropValueListPo> propValueListPos = this.getPropValueInfo(reqBO.getUrl());
        UccBatchImportAgrCommodityTypeGrpPropBusiReqBO commodityTypeGrpPropBusiReqBO = new UccBatchImportAgrCommodityTypeGrpPropBusiReqBO();
        commodityTypeGrpPropBusiReqBO.setGrpPropBOS(grpPropBOS);
        commodityTypeGrpPropBusiReqBO.setPropValueListPos(propValueListPos);
        commodityTypeGrpPropBusiReqBO.setTypeGroupBOS(typeGroupBOS);
        commodityTypeGrpPropBusiReqBO.setUserId(1L);
        commodityTypeGrpPropBusiReqBO.setUsername("sys");
        try {
            log.info("---------------------------------\u5f00\u59cb\u5bfc\u5165\u7c7b\u578b\u5c5e\u6027\u4fe1\u606f--------------------------------------------------");
            log.info(JSON.toJSONString((Object)((Object)commodityTypeGrpPropBusiReqBO)));
            log.info("-----------------------------------------------------------------------------------");
            log.info("-----------------------------------------------------------------------------------");
            log.info("-----------------------------------------------------------------------------------");
            uccBatchImportAgrCommodityTypeGrpPropBusiRspBO = this.uccBatchImportAgrCommodityTypeGrpPropBusiService.dealBatchImportAgrCommodityTypeGrpProp(commodityTypeGrpPropBusiReqBO);
        }
        catch (Exception e) {
            throw new BusinessException("8888", e.getMessage());
        }
        return (UccBatchImportAgrComInfoAbilityRspBO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)uccBatchImportAgrCommodityTypeGrpPropBusiRspBO)), UccBatchImportAgrComInfoAbilityRspBO.class);
    }

    private List<UccPropValueListPo> getPropValueInfo(String url) {
        List<Object> data = new ArrayList();
        List<String> head = null;
        try {
            List<List<String>> excel = this.dealEcxel(url, 2, 6);
            head = excel.get(0);
            data = this.dealEcxel(url, 2, 6);
        }
        catch (Exception e) {
            throw new ZTBusinessException(e.getMessage());
        }
        int rowNum = 2;
        ArrayList<UccPropValueListPo> propValueListPos = new ArrayList<UccPropValueListPo>();
        try {
            if (CollectionUtils.isNotEmpty(data)) {
                for (List list : data) {
                    ++rowNum;
                    UccPropValueListPo propValueListPo = new UccPropValueListPo();
                    int i = 0;
                    String propName = (String)list.get(i++);
                    propValueListPo.setPropName(propName);
                    String propValue = (String)list.get(i++);
                    propValueListPo.setPropValue(propValue);
                    propValueListPos.add(propValueListPo);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            throw new ZTBusinessException("\u7b2c" + rowNum + "\u884c\u6570\u636e\u51fa\u73b0\u95ee\u9898,\u8bf7\u68c0\u67e5\u683c\u5f0f!");
        }
        return propValueListPos;
    }

    private List<UccExcelGrpPropBO> getGrpPropInfo(String url) {
        List<Object> data = new ArrayList();
        Object head = null;
        try {
            List<List<String>> excel = this.dealEcxel(url, 2, 5);
            data = this.dealEcxel(url, 2, 5);
        }
        catch (Exception e) {
            throw new ZTBusinessException(e.getMessage());
        }
        int rowNum = 2;
        ArrayList<UccExcelGrpPropBO> grpPropBOS = new ArrayList<UccExcelGrpPropBO>();
        try {
            if (CollectionUtils.isNotEmpty(data)) {
                for (List list : data) {
                    ++rowNum;
                    UccExcelGrpPropBO grpPropBO = new UccExcelGrpPropBO();
                    int i = 0;
                    String grpName = (String)list.get(i++);
                    grpPropBO.setCommodityPropGrpName(grpName);
                    String ss = (String)list.get(i++);
                    grpPropBO.setPropName(ss);
                    grpPropBO.setPropShowName(ss);
                    String ss1 = (String)list.get(i++);
                    grpPropBOS.add(grpPropBO);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            throw new ZTBusinessException("\u7b2c" + rowNum + "\u884c\u6570\u636e\u51fa\u73b0\u95ee\u9898,\u8bf7\u68c0\u67e5\u683c\u5f0f!");
        }
        return grpPropBOS;
    }

    private List<UccExcelForAgrTypeGroupBO> getTypeGroupInfo(String url) {
        List<Object> data = new ArrayList();
        List<String> head = null;
        try {
            List<List<String>> excel = this.dealEcxel(url, 2, 2);
            head = excel.get(0);
            data = this.dealEcxel(url, 2, 2);
        }
        catch (Exception e) {
            throw new ZTBusinessException(e.getMessage());
        }
        int rowNum = 2;
        ArrayList<UccExcelForAgrTypeGroupBO> typeGroupBOS = new ArrayList<UccExcelForAgrTypeGroupBO>();
        try {
            if (CollectionUtils.isNotEmpty(data)) {
                for (List list : data) {
                    ++rowNum;
                    UccExcelForAgrTypeGroupBO typeGroupBO = new UccExcelForAgrTypeGroupBO();
                    int i = 0;
                    String typeName = (String)list.get(i++);
                    typeGroupBO.setCommodityTypeName(typeName);
                    String grpName = (String)list.get(i++);
                    typeGroupBO.setCommodityPropGrpName(grpName);
                    String type = (String)list.get(i++);
                    typeGroupBO.setCommodityPropGrpType(Integer.valueOf(Double.valueOf(type).intValue()));
                    typeGroupBOS.add(typeGroupBO);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            throw new ZTBusinessException("\u7b2c" + rowNum + "\u884c\u6570\u636e\u51fa\u73b0\u95ee\u9898,\u8bf7\u68c0\u67e5\u683c\u5f0f!");
        }
        return typeGroupBOS;
    }

    private List<UccExcelSkuAttrButesBO> getSkuPropInfo(String url) {
        List<Object> data = new ArrayList();
        List<String> head = null;
        try {
            List<List<String>> excel = this.dealEcxel(url, 2, 4);
            head = excel.get(0);
            data = this.dealEcxel(url, 2, 4);
        }
        catch (Exception e) {
            throw new ZTBusinessException(e.getMessage());
        }
        int rowNum = 2;
        ArrayList<UccExcelSkuAttrButesBO> attrButesBOS = new ArrayList<UccExcelSkuAttrButesBO>();
        try {
            if (CollectionUtils.isNotEmpty(data)) {
                for (List list : data) {
                    ++rowNum;
                    UccExcelSkuAttrButesBO attrButesBO = new UccExcelSkuAttrButesBO();
                    int i = 0;
                    String commodityName = (String)list.get(i++);
                    String skuId = (String)list.get(i++);
                    attrButesBO.setSkuId(UccBatchImportAgrComInfoAbilityServiceImpl.scientificCountToLong(skuId));
                    String skuCode = (String)list.get(i++);
                    String skuName = (String)list.get(i++);
                    attrButesBO.setSkuName(skuName);
                    String grpName = (String)list.get(i++);
                    attrButesBO.setCommodityPropGrpName(grpName);
                    String propName = (String)list.get(i++);
                    attrButesBO.setPropName(propName);
                    attrButesBO.setPropShowName(propName);
                    String propName1 = (String)list.get(i++);
                    String propValue = (String)list.get(i++);
                    attrButesBO.setPropValue(propValue);
                    attrButesBOS.add(attrButesBO);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            throw new ZTBusinessException("\u7b2c" + rowNum + "\u884c\u6570\u636e\u51fa\u73b0\u95ee\u9898,\u8bf7\u68c0\u67e5\u683c\u5f0f!");
        }
        return attrButesBOS;
    }

    private List<UccExcelCommodityAttrButesBO> getSpuPropInfo(String url) {
        List<Object> data = new ArrayList();
        Object head = null;
        try {
            List<List<String>> excel = this.dealEcxel(url, 2, 3);
            data = this.dealEcxel(url, 2, 3);
        }
        catch (Exception e) {
            throw new ZTBusinessException(e.getMessage());
        }
        int rowNum = 2;
        ArrayList<UccExcelCommodityAttrButesBO> attrButesBOS = new ArrayList<UccExcelCommodityAttrButesBO>();
        try {
            if (CollectionUtils.isNotEmpty(data)) {
                for (List list : data) {
                    ++rowNum;
                    UccExcelCommodityAttrButesBO attrButesBO = new UccExcelCommodityAttrButesBO();
                    int i = 0;
                    String spuId = (String)list.get(i++);
                    attrButesBO.setCommodityId(UccBatchImportAgrComInfoAbilityServiceImpl.scientificCountToLong(spuId));
                    String spuCode = (String)list.get(i++);
                    String commodityName = (String)list.get(i++);
                    attrButesBO.setCommodityName(commodityName);
                    String grpName = (String)list.get(i++);
                    attrButesBO.setCommodityPropGrpName(grpName);
                    String propName = (String)list.get(i++);
                    attrButesBO.setPropName(propName);
                    attrButesBO.setPropShowName(propName);
                    String propValue = (String)list.get(i++);
                    attrButesBO.setPropValue(propValue);
                    attrButesBOS.add(attrButesBO);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            throw new ZTBusinessException("\u7b2c" + rowNum + "\u884c\u6570\u636e\u51fa\u73b0\u95ee\u9898,\u8bf7\u68c0\u67e5\u683c\u5f0f!");
        }
        return attrButesBOS;
    }

    private void validateSpuRelSku(List<UccExcelForAgrSkuBO> skuCreateInfoBOS, List<UccExcelForAgrCommodityBO> spuCreateInfoBOS) {
        ArrayList<String> notValidatedLists = new ArrayList<String>();
        List skuSpuCodes = skuCreateInfoBOS.stream().map(UccExcelForAgrSkuBO::getCommodityCode).distinct().collect(Collectors.toList());
        List spuCodes = spuCreateInfoBOS.stream().map(UccExcelForAgrCommodityBO::getCommodityCode).collect(Collectors.toList());
        for (String spuCode : spuCodes) {
            if (skuSpuCodes.contains(spuCode)) continue;
            notValidatedLists.add(spuCode);
        }
        if (!CollectionUtils.isEmpty(notValidatedLists)) {
            throw new BusinessException("8888", "\u5546\u54c1\u7f16\u7801\u3010" + JSON.toJSONString(notValidatedLists) + "\u3011\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5355\u54c1\u4fe1\u606f");
        }
    }

    private void validateSku(List<UccExcelForAgrSkuBO> skuCreateInfoBOS, List<UccExcelForAgrCommodityBO> spuCreateInfoBOS, List<UccExcelSkuAttrButesBO> skuAttrGroups, UccBatchImportAgrCommodityTypeGrpPropBusiRspBO uccBatchImportAgrCommodityTypeGrpPropBusiRspBO) {
        if (CollectionUtils.isEmpty(skuCreateInfoBOS)) {
            throw new BusinessException("8888", "\u8bfb\u53d6\u7684\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        Map<String, List<UccPropValueListPo>> propValueMap = uccBatchImportAgrCommodityTypeGrpPropBusiRspBO.getPropValueMap();
        Map<String, List<UccCommdPropDefPo>> commodityPropMap = uccBatchImportAgrCommodityTypeGrpPropBusiRspBO.getCommodityPropMap();
        Map<String, List<UccCommodityPropGrpPo>> commodityPropGrpMap = uccBatchImportAgrCommodityTypeGrpPropBusiRspBO.getCommodityPropGrpMap();
        Map<Long, List<UccExcelSkuAttrButesBO>> skuAttrMap = skuAttrGroups.stream().collect(Collectors.groupingBy(UccExcelSkuAttrButesBO::getSkuId));
        for (UccExcelForAgrSkuBO uccExcelSkuBO : skuCreateInfoBOS) {
            if (ObjectUtils.isEmpty((Object)uccExcelSkuBO.getCommodityCode())) {
                throw new BusinessException("8888", "\u5b58\u5728\u5546\u54c1\u7f16\u7801\u4e3a\u7a7a\u7684\u5546\u54c1!");
            }
            if (ObjectUtils.isEmpty((Object)uccExcelSkuBO.getSkuCode())) {
                throw new BusinessException("8888", "\u5546\u54c1\u7f16\u7801\u4e3a\u3010" + uccExcelSkuBO.getCommodityCode() + "\u3011\u7684\u5355\u54c1\u7f16\u7801\u4e3a\u7a7a\uff01");
            }
            if (ObjectUtils.isEmpty((Object)uccExcelSkuBO.getSkuCode())) {
                throw new BusinessException("8888", "\u5546\u54c1\u7f16\u7801\u4e3a\u3010" + uccExcelSkuBO.getCommodityCode() + "\u3011\u7684\u5355\u54c1\u7f16\u7801\u4e3a\u7a7a\uff01");
            }
            if (ObjectUtils.isEmpty((Object)uccExcelSkuBO.getSkuName())) {
                throw new BusinessException("8888", "\u5355\u54c1\u7f16\u7801\u4e3a\u3010" + uccExcelSkuBO.getSkuCode() + "\u3011\u5355\u54c1\u540d\u79f0\u672a\u4e3a\u7a7a\uff01");
            }
            if (ObjectUtils.isEmpty((Object)uccExcelSkuBO.getBrandName())) {
                throw new BusinessException("8888", "\u5355\u54c1\u7f16\u7801\u4e3a\u3010" + uccExcelSkuBO.getSkuCode() + "\u3011\u54c1\u724c\u4e3a\u7a7a\uff01\uff01");
            }
            if (ObjectUtils.isEmpty((Object)uccExcelSkuBO.getAgreementId())) {
                throw new BusinessException("8888", "\u5355\u54c1\u7f16\u7801\u4e3a\u3010" + uccExcelSkuBO.getSkuCode() + "\u3011\u534f\u8baeid\u7a7a\uff01");
            }
            if (ObjectUtils.isEmpty((Object)uccExcelSkuBO.getAgreementName())) {
                throw new BusinessException("8888", "\u5355\u54c1\u7f16\u7801\u4e3a\u3010" + uccExcelSkuBO.getSkuCode() + "\u3011\u534f\u8bae\u540d\u79f0\u7a7a\uff01");
            }
            if (ObjectUtils.isEmpty((Object)uccExcelSkuBO.getAgreementDetailId())) {
                throw new BusinessException("8888", "\u5355\u54c1\u7f16\u7801\u4e3a\u3010" + uccExcelSkuBO.getSkuCode() + "\u3011\u660e\u7ec6id\u7a7a\uff01");
            }
            if (ObjectUtils.isEmpty((Object)uccExcelSkuBO.getVendorName())) {
                throw new BusinessException("8888", "\u5355\u54c1\u7f16\u7801\u4e3a\u3010" + uccExcelSkuBO.getSkuCode() + "\u3011\u7684\u4f9b\u5e94\u5546\u540d\u79f0\u7a7a\uff01");
            }
            if (ObjectUtils.isEmpty((Object)uccExcelSkuBO.getVendorId())) {
                throw new BusinessException("8888", "\u5355\u54c1\u7f16\u7801\u4e3a\u3010" + uccExcelSkuBO.getSkuCode() + "\u3011\u4f9b\u5e94\u5546id\u7a7a\uff01");
            }
            if (ObjectUtils.isEmpty((Object)uccExcelSkuBO.getMarketPrice())) {
                throw new BusinessException("8888", "\u5355\u54c1\u7f16\u7801\u4e3a\u3010" + uccExcelSkuBO.getSkuCode() + "\u3011\u7684\u5e02\u573a\u4ef7\u7a7a\uff01");
            }
            if (ObjectUtils.isEmpty((Object)uccExcelSkuBO.getAgreementPrice())) {
                throw new BusinessException("8888", "\u5355\u54c1\u7f16\u7801\u4e3a\u3010" + uccExcelSkuBO.getSkuCode() + "\u3011\u7684\u534f\u8bae\u4ef7\u7a7a\uff01");
            }
            if (ObjectUtils.isEmpty((Object)uccExcelSkuBO.getSalePrice())) {
                throw new BusinessException("8888", "\u5355\u54c1\u7f16\u7801\u4e3a\u3010" + uccExcelSkuBO.getSkuCode() + "\u3011\u9500\u552e\u4ef7\u7a7a\uff01");
            }
            if (ObjectUtils.isEmpty((Object)uccExcelSkuBO.getCommodityTypeName())) {
                throw new BusinessException("8888", "\u5355\u54c1\u7f16\u7801\u4e3a\u3010" + uccExcelSkuBO.getSkuCode() + "\u3011\u7684\u7c7b\u578b\u7a7a\uff01");
            }
            if (!skuAttrMap.containsKey(Long.parseLong(uccExcelSkuBO.getSkuId()))) {
                throw new BusinessException("8888", "\u5355\u54c1\u7f16\u7801\u4e3a\uff1a\u3010" + uccExcelSkuBO.getSkuCode() + "\u3011\u4e0d\u5b58\u5728\u5c5e\u6027\u4fe1\u606f\uff01");
            }
            List collect = skuAttrMap.get(Long.parseLong(uccExcelSkuBO.getSkuId())).stream().map(attr -> {
                UccExcelCommodityAttrButesBO attrButesBO = (UccExcelCommodityAttrButesBO)JSONObject.parseObject((String)JSON.toJSONString((Object)attr), UccExcelCommodityAttrButesBO.class);
                attrButesBO.setCommodityPropGrpId(((UccCommodityPropGrpPo)((List)commodityPropGrpMap.get(attr.getCommodityPropGrpName())).get(0)).getCommodityPropGrpId());
                attrButesBO.setPropShowName(attr.getPropName());
                attrButesBO.setPropName(attr.getPropName());
                attrButesBO.setCommodityPropDefId(((UccCommdPropDefPo)((List)commodityPropMap.get(attr.getPropName())).get(0)).getCommodityPropDefId());
                try {
                    System.err.println(attr.getPropName() + "-" + attr.getPropValue());
                    System.err.println(((UccPropValueListPo)((List)propValueMap.get(attr.getPropName() + "-" + attr.getPropValue())).get(0)).getPropValueListId());
                    attrButesBO.setPropValueListId(((UccPropValueListPo)((List)propValueMap.get(attr.getPropName() + "-" + attr.getPropValue())).get(0)).getPropValueListId());
                }
                catch (Exception e) {
                    log.error(JSON.toJSONString((Object)propValueMap));
                    throw new BusinessException("8888", attr.getPropName() + attr.getPropValue());
                }
                attrButesBO.setPropValue(attr.getPropValue());
                return attrButesBO;
            }).collect(Collectors.toList());
            uccExcelSkuBO.setSkuAttrGroups(collect);
        }
    }

    private void validateSpu(List<UccExcelForAgrCommodityBO> spuCreateInfoBOS, List<UccExcelForAgrSkuBO> skuCreateInfoBOS, UccBatchImportAgrCommodityTypeGrpPropBusiRspBO uccBatchImportAgrCommodityTypeGrpPropBusiRspBO, List<UccExcelCommodityAttrButesBO> spuPropInfo) {
        if (CollectionUtils.isEmpty(spuCreateInfoBOS)) {
            throw new BusinessException("8888", "\u8bfb\u53d6\u7684\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        Map<Long, List<UccExcelCommodityAttrButesBO>> commodityAttrMap = spuPropInfo.stream().collect(Collectors.groupingBy(UccExcelCommodityAttrButesBO::getCommodityId));
        Map<String, List<UccPropValueListPo>> propValueMap = uccBatchImportAgrCommodityTypeGrpPropBusiRspBO.getPropValueMap();
        Map<String, List<UccCommdPropDefPo>> commodityPropMap = uccBatchImportAgrCommodityTypeGrpPropBusiRspBO.getCommodityPropMap();
        Map<String, List<UccCommodityPropGrpPo>> commodityPropGrpMap = uccBatchImportAgrCommodityTypeGrpPropBusiRspBO.getCommodityPropGrpMap();
        for (UccExcelForAgrCommodityBO spuCreateInfoBO : spuCreateInfoBOS) {
            if (ObjectUtils.isEmpty((Object)spuCreateInfoBO.getCommodityCode())) {
                throw new BusinessException("8888", "\u5b58\u5728\u5546\u54c1\u7f16\u7801\u4e3a\u7a7a\u7684\u5546\u54c1!");
            }
            if (ObjectUtils.isEmpty((Object)spuCreateInfoBO.getCommodityName())) {
                throw new BusinessException("8888", "\u5546\u54c1\u7f16\u7801\u4e3a\u3010" + spuCreateInfoBO.getCommodityCode() + "\u3011\u7684\u540d\u79f0\u4e3a\u7a7a\uff01");
            }
            if (ObjectUtils.isEmpty((Object)spuCreateInfoBO.getCommodityId())) {
                throw new BusinessException("8888", "\u5b58\u5728\u5546\u54c1ID\u4e3a\u7a7a\u7684\u5546\u54c1![" + spuCreateInfoBO.getCommodityCode());
            }
            if (ObjectUtils.isEmpty((Object)spuCreateInfoBO.getBrandName())) {
                throw new BusinessException("8888", "\u54c1\u724c\u540d\u79f0\u4e3a\u7a7a![" + spuCreateInfoBO.getCommodityCode());
            }
            if (ObjectUtils.isEmpty((Object)spuCreateInfoBO.getAgreementId())) {
                throw new BusinessException("8888", "\u534f\u8baeid\u4e3a\u7a7a![" + spuCreateInfoBO.getCommodityCode());
            }
            if (ObjectUtils.isEmpty((Object)spuCreateInfoBO.getOtherSourceCode())) {
                throw new BusinessException("8888", "\u534f\u8bae\u7f16\u7801\u7a7a![" + spuCreateInfoBO.getCommodityCode());
            }
            if (ObjectUtils.isEmpty((Object)spuCreateInfoBO.getAgreementName())) {
                throw new BusinessException("8888", "\u534f\u8bae\u540d\u79f0\u7a7a![" + spuCreateInfoBO.getCommodityCode());
            }
            if (ObjectUtils.isEmpty((Object)spuCreateInfoBO.getAgreementDetailsId())) {
                throw new BusinessException("8888", "\u534f\u8bae\u660e\u7ec6id\u7a7a![" + spuCreateInfoBO.getCommodityCode());
            }
            if (ObjectUtils.isEmpty((Object)spuCreateInfoBO.getRate())) {
                throw new BusinessException("8888", "\u7a0e\u7387\u7a7a![" + spuCreateInfoBO.getCommodityCode());
            }
            if (ObjectUtils.isEmpty((Object)spuCreateInfoBO.getVendorId())) {
                throw new BusinessException("8888", "\u4f9b\u5e94\u5546id![" + spuCreateInfoBO.getCommodityCode());
            }
            if (ObjectUtils.isEmpty((Object)spuCreateInfoBO.getVendorName())) {
                throw new BusinessException("8888", "\u4f9b\u5e94\u5546\u540d\u79f0\u5f00\u7a7a![" + spuCreateInfoBO.getCommodityCode());
            }
            if (ObjectUtils.isEmpty((Object)spuCreateInfoBO.getCommodityTypeName())) {
                throw new BusinessException("8888", "\u7c7b\u578b\u7a7a![" + spuCreateInfoBO.getCommodityCode());
            }
            List<UccExcelCommodityAttrButesBO> attrButesBOS = commodityAttrMap.get(spuCreateInfoBO.getCommodityId());
            if (CollectionUtils.isEmpty(attrButesBOS)) continue;
            List commodityAttrButesBOS = attrButesBOS.stream().map(e -> {
                UccExcelCommodityAttrButesBO attrButesBO = new UccExcelCommodityAttrButesBO();
                attrButesBO.setPropValueListId(((UccPropValueListPo)((List)propValueMap.get(e.getPropName() + "-" + e.getPropValue())).get(0)).getPropValueListId());
                attrButesBO.setPropName(e.getPropName());
                attrButesBO.setCommodityId(e.getCommodityId());
                attrButesBO.setPropValue(e.getPropValue());
                attrButesBO.setCommodityPropDefId(((UccCommdPropDefPo)((List)commodityPropMap.get(e.getPropName())).get(0)).getCommodityPropDefId());
                attrButesBO.setPropShowName(e.getPropName());
                attrButesBO.setCommodityPropGrpName(((UccCommodityPropGrpPo)((List)commodityPropGrpMap.get(e.getCommodityPropGrpName())).get(0)).getCommodityPropGrpName());
                attrButesBO.setCommodityPropGrpId(((UccCommodityPropGrpPo)((List)commodityPropGrpMap.get(e.getCommodityPropGrpName())).get(0)).getCommodityPropGrpId());
                return attrButesBO;
            }).collect(Collectors.toList());
            spuCreateInfoBO.setCommdAttrGroups(commodityAttrButesBOS);
        }
    }

    private List<UccExcelForAgrSkuBO> getSkuInfoFromExcel(String url) {
        ArrayList<UccExcelForAgrSkuBO> uccExcelSkuBOList;
        block10: {
            List<Object> data = new ArrayList();
            List<String> head = null;
            try {
                List<List<String>> excel = this.dealEcxel(url, 2, 8);
                head = excel.get(0);
                data = this.dealEcxel(url, 2, 8);
            }
            catch (Exception e) {
                throw new ZTBusinessException(e.getMessage());
            }
            int rowNum = 2;
            uccExcelSkuBOList = new ArrayList<UccExcelForAgrSkuBO>();
            try {
                if (!CollectionUtils.isNotEmpty(data)) break block10;
                for (List list : data) {
                    ++rowNum;
                    UccExcelForAgrSkuBO uccExcelSkuBO = new UccExcelForAgrSkuBO();
                    int i = 0;
                    String commodityId = (String)list.get(i++);
                    uccExcelSkuBO.setCommodityId(UccBatchImportAgrComInfoAbilityServiceImpl.doubleToInteger(commodityId));
                    String commodityCode = (String)list.get(i++);
                    try {
                        commodityCode = UccBatchImportAgrComInfoAbilityServiceImpl.doubleToInteger(commodityCode);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    uccExcelSkuBO.setCommodityCode(commodityCode);
                    String skuId = (String)list.get(i++);
                    uccExcelSkuBO.setSkuId(UccBatchImportAgrComInfoAbilityServiceImpl.doubleToInteger(skuId));
                    String skuCode = (String)list.get(i++);
                    try {
                        skuCode = UccBatchImportAgrComInfoAbilityServiceImpl.doubleToInteger(skuCode);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    uccExcelSkuBO.setSkuCode(skuCode);
                    String skuName = (String)list.get(i++);
                    uccExcelSkuBO.setSkuName(skuName);
                    String brand = (String)list.get(i++);
                    uccExcelSkuBO.setBrandName(brand);
                    String agrCode = (String)list.get(i++);
                    String agreementId = (String)list.get(i++);
                    uccExcelSkuBO.setAgreementId(UccBatchImportAgrComInfoAbilityServiceImpl.scientificCountToLong(agreementId));
                    String agreementName = (String)list.get(i++);
                    uccExcelSkuBO.setAgreementName(agreementName);
                    String agreementDetailCode = (String)list.get(i++);
                    String agreementDetailId = (String)list.get(i++);
                    uccExcelSkuBO.setAgreementDetailId(UccBatchImportAgrComInfoAbilityServiceImpl.scientificCountToLong(agreementDetailId));
                    String measuerName = (String)list.get(i++);
                    uccExcelSkuBO.setSaleUnitName(measuerName);
                    String skuDesc = (String)list.get(i++);
                    uccExcelSkuBO.setRemark(skuDesc);
                    String model = (String)list.get(i++);
                    uccExcelSkuBO.setModel(model);
                    String model1 = (String)list.get(i++);
                    String rate = (String)list.get(i++);
                    uccExcelSkuBO.setRate(rate);
                    String stockNum = (String)list.get(i++);
                    uccExcelSkuBO.setStockNum(new BigDecimal(stockNum));
                    String moq = (String)list.get(i++);
                    uccExcelSkuBO.setMoq(new BigDecimal(moq));
                    String preDeliverDay = (String)list.get(i++);
                    if (!StringUtils.isEmpty((Object)preDeliverDay)) {
                        Double aDouble = Double.parseDouble(preDeliverDay);
                        uccExcelSkuBO.setPreDeliverDay(Integer.valueOf(aDouble.intValue()));
                    }
                    String vendorName = (String)list.get(i++);
                    uccExcelSkuBO.setVendorName(vendorName);
                    String vendorId = (String)list.get(i++);
                    uccExcelSkuBO.setVendorId(UccBatchImportAgrComInfoAbilityServiceImpl.scientificCountToLong(vendorId));
                    BigDecimal m = new BigDecimal("10000");
                    String marketPrice = (String)list.get(i++);
                    uccExcelSkuBO.setMarketPrice(Long.valueOf(new BigDecimal(marketPrice).multiply(m).longValue()));
                    BigDecimal a = new BigDecimal("10000");
                    String agreementPrice = (String)list.get(i++);
                    uccExcelSkuBO.setAgreementPrice(Long.valueOf(new BigDecimal(agreementPrice).multiply(a).longValue()));
                    BigDecimal s = new BigDecimal("10000");
                    String salePrice = (String)list.get(i++);
                    uccExcelSkuBO.setSalePrice(Long.valueOf(new BigDecimal(salePrice).multiply(s).longValue()));
                    String typeName = (String)list.get(i++);
                    uccExcelSkuBO.setCommodityTypeName(typeName);
                    uccExcelSkuBOList.add(uccExcelSkuBO);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
                e.printStackTrace();
                throw new ZTBusinessException("\u7b2c" + rowNum + "\u884c\u6570\u636e\u51fa\u73b0\u95ee\u9898,\u8bf7\u68c0\u67e5\u683c\u5f0f!" + e.getMessage());
            }
        }
        return uccExcelSkuBOList;
    }

    private List<UccExcelForAgrCommodityBO> getSpuInfoFromExcel(String url) {
        ArrayList<UccExcelForAgrCommodityBO> uccExcelCommodityBOList;
        block9: {
            List<Object> data = new ArrayList();
            List<String> head = null;
            try {
                List<List<String>> excel = this.dealEcxel(url, 2, 7);
                head = excel.get(0);
                data = this.dealEcxel(url, 2, 7);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ZTBusinessException(e.getMessage());
            }
            int rowNum = 2;
            uccExcelCommodityBOList = new ArrayList<UccExcelForAgrCommodityBO>();
            try {
                if (!CollectionUtils.isNotEmpty(data)) break block9;
                for (List list : data) {
                    ++rowNum;
                    UccExcelForAgrCommodityBO uccExcelCommodityBO = new UccExcelForAgrCommodityBO();
                    int i = 0;
                    String commodityId = (String)list.get(i++);
                    uccExcelCommodityBO.setCommodityId(UccBatchImportAgrComInfoAbilityServiceImpl.scientificCountToLong(commodityId));
                    String commodityCode = (String)list.get(i++);
                    try {
                        commodityCode = UccBatchImportAgrComInfoAbilityServiceImpl.doubleToInteger(commodityCode);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    uccExcelCommodityBO.setCommodityCode(commodityCode);
                    String commodityName = (String)list.get(i++);
                    uccExcelCommodityBO.setCommodityName(commodityName);
                    String commodityBanner = (String)list.get(i++);
                    if (!StringUtils.isEmpty((Object)commodityBanner)) {
                        uccExcelCommodityBO.setCommodityBanner(commodityBanner);
                    }
                    String brandName = (String)list.get(i++);
                    uccExcelCommodityBO.setBrandName(brandName);
                    String agreementCode = (String)list.get(i++);
                    uccExcelCommodityBO.setOtherSourceCode(agreementCode);
                    String agreementId = (String)list.get(i++);
                    uccExcelCommodityBO.setAgreementId(UccBatchImportAgrComInfoAbilityServiceImpl.scientificCountToLong(agreementId));
                    String agreementName = (String)list.get(i++);
                    uccExcelCommodityBO.setAgreementName(agreementName);
                    String agreementDetailId = (String)list.get(i++);
                    uccExcelCommodityBO.setAgreementDetailsId(Long.valueOf(Long.parseLong(new BigDecimal(agreementDetailId).toPlainString())));
                    String agreementDetailCode = (String)list.get(i++);
                    String desc = (String)list.get(i++);
                    if (!StringUtils.isEmpty((Object)desc)) {
                        uccExcelCommodityBO.setRemark(desc);
                    }
                    String saleUnitName = (String)list.get(i++);
                    uccExcelCommodityBO.setSaleUnitName(saleUnitName);
                    String rate = (String)list.get(i++);
                    uccExcelCommodityBO.setRate(rate);
                    String vendorName = (String)list.get(i++);
                    uccExcelCommodityBO.setVendorName(vendorName);
                    String commodityTypeName = (String)list.get(i++);
                    uccExcelCommodityBO.setCommodityTypeName(commodityTypeName);
                    String vendorId = (String)list.get(i++);
                    uccExcelCommodityBO.setVendorId(UccBatchImportAgrComInfoAbilityServiceImpl.scientificCountToLong(vendorId));
                    uccExcelCommodityBOList.add(uccExcelCommodityBO);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
                e.printStackTrace();
                throw new ZTBusinessException("\u7b2c" + rowNum + "\u884c\u6570\u636e\u51fa\u73b0\u95ee\u9898,\u8bf7\u68c0\u67e5\u683c\u5f0f!");
            }
        }
        return uccExcelCommodityBOList;
    }

    private List<List<String>> dealEcxel(String url, Integer startReadLine, Integer sheetAt) {
        if (StringUtils.isEmpty((Object)url)) {
            return new ArrayList<List<String>>();
        }
        ArrayList<List<String>> lines = new ArrayList<List<String>>();
        try {
            ExcelNewUtils.getExcelDate((String)url, lines, (Integer)startReadLine, (Integer)sheetAt);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            throw new ZTBusinessException("\u5904\u7406Excel\u5931\u8d25");
        }
        return lines;
    }

    public static Long scientificCountToLong(String str) {
        if (StringUtils.isEmpty((Object)str)) {
            return 0L;
        }
        BigDecimal bigDecimal = new BigDecimal(str.toString());
        return bigDecimal.longValue();
    }

    public static String doubleToInteger(String str) {
        if (StringUtils.isEmpty((Object)str)) {
            return "";
        }
        return new BigDecimal(str).stripTrailingZeros().toPlainString();
    }
}

