/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccCostContractMessageAtomService;
import com.tydic.commodity.busibase.atom.bo.UccCostContractMessageAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccCostContractMessageAtomRspBO;
import com.tydic.commodity.dao.UccCostContractDetailMapper;
import com.tydic.commodity.dao.UccCostContractMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccCostContractDetailPO;
import com.tydic.commodity.po.UccCostContractPO;
import com.tydic.commodity.zone.ability.api.UccCostContractAddAbilityService;
import com.tydic.commodity.zone.ability.bo.UccCostContractAddAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccCostContractAddAbilityRspBO;
import com.tydic.commodity.zone.ability.bo.UccCostContractDetailBO;
import com.tydic.commodity.zone.busi.api.UccCostContractAddBusiService;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.zone.ability.api.UccCostContractAddAbilityService"})
public class UccCostContractAddAbilityServiceImpl
implements UccCostContractAddAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccCostContractAddAbilityServiceImpl.class);
    @Autowired
    private UccCostContractMessageAtomService uccCostContractMessageAtomService;
    @Autowired
    private UccCostContractAddBusiService uccCostContractAddBusiService;
    @Autowired
    private UccCostContractMapper uccCostContractMapper;
    @Autowired
    private UccCostContractDetailMapper uccCostContractDetailMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @PostMapping(value={"dealCostContractAdd"})
    public UccCostContractAddAbilityRspBO dealCostContractAdd(@RequestBody UccCostContractAddAbilityReqBO reqBO) {
        Long messageId = this.addMessage(reqBO);
        this.validate(reqBO);
        UccCostContractAddAbilityRspBO abilityRspBO = this.uccCostContractAddBusiService.dealCostContractAdd(reqBO);
        UccCostContractMessageAtomReqBO update = new UccCostContractMessageAtomReqBO();
        update.setStrDes(JSON.toJSONString((Object)abilityRspBO));
        update.setMessageId(messageId);
        this.uccCostContractMessageAtomService.costContractMessageUpdate(update);
        return abilityRspBO;
    }

    private void validate(UccCostContractAddAbilityReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getEntAgreementCode())) {
            throw new BusinessException("8888", "\u5165\u53c2 entAgreementCode \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getAmount())) {
            throw new BusinessException("8888", "\u5165\u53c2 amount \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getCreateTime())) {
            throw new BusinessException("8888", "\u5165\u53c2 createTime \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getUpperProductId())) {
            throw new BusinessException("8888", "\u5165\u53c2 upperProductId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getUpperProductName())) {
            throw new BusinessException("8888", "\u5165\u53c2 upperProductName \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getProducerId())) {
            throw new BusinessException("8888", "\u5165\u53c2 producerId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getProducerName())) {
            throw new BusinessException("8888", "\u5165\u53c2 producerName \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getProductId())) {
            throw new BusinessException("8888", "\u5165\u53c2 productId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getProductName())) {
            throw new BusinessException("8888", "\u5165\u53c2 productName \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getProducerOrgId())) {
            throw new BusinessException("8888", "\u5165\u53c2 producerOrgId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getProducerOrgName())) {
            throw new BusinessException("8888", "\u5165\u53c2 producerOrgName \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getStatus())) {
            throw new BusinessException("8888", "\u5165\u53c2 status \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getSpuContractCode())) {
            throw new BusinessException("8888", "\u5165\u53c2 spuContractCode \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        UccCostContractPO contractPO = new UccCostContractPO();
        contractPO.setSpuContractCode(reqBO.getSpuContractCode());
        int checkBy = this.uccCostContractMapper.getCheckBy(contractPO);
        if (checkBy > 0) {
            throw new BusinessException("8888", "\u5408\u540c\u7f16\u53f7\u4e3a\u3010" + reqBO.getEntAgreementCode() + "\u3011\u7684\u5408\u540c\u4fe1\u606f\u5df2\u7ecf\u5b58\u5728\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getSpuContractName())) {
            throw new BusinessException("8888", "\u5165\u53c2 spuContractName \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getContractDetailBOList())) {
            throw new BusinessException("8888", "\u5165\u53c2 contractDetailBOList \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (UccCostContractDetailBO detailBO : reqBO.getContractDetailBOList()) {
            if (ObjectUtils.isEmpty((Object)detailBO.getAgreementPrice())) {
                throw new BusinessException("8888", "\u5165\u53c2 agreementPrice \u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (ObjectUtils.isEmpty((Object)detailBO.getNum())) {
                throw new BusinessException("8888", "\u5165\u53c2 num \u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (ObjectUtils.isEmpty((Object)detailBO.getSalePrice())) {
                throw new BusinessException("8888", "\u5165\u53c2 salePrice \u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (ObjectUtils.isEmpty((Object)detailBO.getSkuCode())) {
                throw new BusinessException("8888", "\u5165\u53c2 skuCode \u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (ObjectUtils.isEmpty((Object)detailBO.getSpuContractDetailCode())) {
                throw new BusinessException("8888", "\u5165\u53c2 spuContractDetailCode \u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            UccCostContractDetailPO check = new UccCostContractDetailPO();
            check.setSpuContractDetailCode(detailBO.getSpuContractDetailCode());
            int checkBy1 = this.uccCostContractDetailMapper.getCheckBy(check);
            if (checkBy1 > 0) {
                throw new BusinessException("8888", "\u5408\u540c\u660e\u7ec6\u7f16\u7801\u3010" + detailBO.getSpuContractDetailCode() + "\u3011\u5df2\u7ecf\u5b58\u5728\uff01");
            }
            Long skuId = this.uccSkuMapper.getSkuIdByCode(detailBO.getSkuCode());
            if (ObjectUtils.isEmpty((Object)skuId)) {
                throw new BusinessException("8888", "\u5165\u53c2 skuCode\u3010" + detailBO.getSkuCode() + "\u3011 \u672a\u627e\u5230\u5bf9\u5e94\u5355\u54c1\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2\u5408\u6cd5\u6027\uff01");
            }
            detailBO.setSkuId(skuId);
        }
    }

    private Long addMessage(UccCostContractAddAbilityReqBO reqBO) {
        UccCostContractMessageAtomReqBO messageAtomReqBO = new UccCostContractMessageAtomReqBO();
        messageAtomReqBO.setStatus(UccConstants.COST_2);
        messageAtomReqBO.setContent(JSON.toJSONString((Object)reqBO));
        UccCostContractMessageAtomRspBO rspBO = this.uccCostContractMessageAtomService.costContractMessageAdd(messageAtomReqBO);
        return rspBO.getMessageId();
    }
}

