/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccCostContractMessageAtomService;
import com.tydic.commodity.busibase.atom.bo.UccCostContractMessageAtomReqBO;
import com.tydic.commodity.dao.UccCostContractMapper;
import com.tydic.commodity.po.UccCostContractPO;
import com.tydic.commodity.zone.ability.api.UccCostContractCancelAbilityService;
import com.tydic.commodity.zone.ability.bo.UccCostContractCancelAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccCostContractCancelAbilityRspBO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.zone.ability.api.UccCostContractCancelAbilityService"})
public class UccCostContractCancelAbilityServiceImpl
implements UccCostContractCancelAbilityService {
    @Autowired
    private UccCostContractMapper uccCostContractMapper;
    @Autowired
    private UccCostContractMessageAtomService uccCostContractMessageAtomService;

    @PostMapping(value={"costContractCancel"})
    public UccCostContractCancelAbilityRspBO costContractCancel(@RequestBody UccCostContractCancelAbilityReqBO reqBO) {
        UccCostContractMessageAtomReqBO messageAtomReqBO = new UccCostContractMessageAtomReqBO();
        messageAtomReqBO.setMessageId(Long.valueOf(Sequence.getInstance().nextId()));
        messageAtomReqBO.setContent(JSON.toJSONString((Object)reqBO));
        messageAtomReqBO.setStatus(UccConstants.COST_3);
        this.uccCostContractMessageAtomService.costContractMessageAdd(messageAtomReqBO);
        this.validate(reqBO);
        try {
            UccCostContractPO where = new UccCostContractPO();
            where.setSpuContractCode(reqBO.getSpuContractCode());
            UccCostContractPO set = new UccCostContractPO();
            set.setStatus(UccConstants.COST_CONTRACT_CANCEL);
            set.setUpdateTime(reqBO.getUpdateTime());
            this.uccCostContractMapper.updateBy(set, where);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("8888", "\u5408\u540c\u4f5c\u5e9f\u5f02\u5e38\uff01" + e.getMessage());
        }
        UccCostContractCancelAbilityRspBO rspBO = new UccCostContractCancelAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        UccCostContractMessageAtomReqBO atomReqBO = new UccCostContractMessageAtomReqBO();
        atomReqBO.setStrDes(JSON.toJSONString((Object)rspBO));
        atomReqBO.setMessageId(messageAtomReqBO.getMessageId());
        this.uccCostContractMessageAtomService.costContractMessageUpdate(atomReqBO);
        return rspBO;
    }

    private void validate(UccCostContractCancelAbilityReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getSpuContractCode())) {
            throw new BusinessException("8888", "\u5165\u53c2 spuContractCode \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getUpdateTime())) {
            throw new BusinessException("8888", "\u5165\u53c2 updateTime \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        UccCostContractPO contractPO = new UccCostContractPO();
        contractPO.setSpuContractCode(reqBO.getSpuContractCode());
        int checkBy = this.uccCostContractMapper.getCheckBy(contractPO);
        if (checkBy <= 0) {
            throw new BusinessException("8888", "\u5408\u540c\u7f16\u7801\u4e3a\u3010" + reqBO.getSpuContractCode() + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
    }
}

