/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccCostContractMessageAtomService;
import com.tydic.commodity.busibase.atom.bo.UccCostContractMessageAtomReqBO;
import com.tydic.commodity.dao.UccCostContractDetailEditMapper;
import com.tydic.commodity.dao.UccCostContractDetailMapper;
import com.tydic.commodity.dao.UccCostContractMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccCostContractDetailEditPO;
import com.tydic.commodity.po.UccCostContractDetailPO;
import com.tydic.commodity.po.UccCostContractPO;
import com.tydic.commodity.utils.MoneyUtils;
import com.tydic.commodity.zone.ability.api.UccCostContractChangeAbilityService;
import com.tydic.commodity.zone.ability.bo.UccCostApprovalInfoBO;
import com.tydic.commodity.zone.ability.bo.UccCostContractChangeAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccCostContractChangeAbilityRspBO;
import com.tydic.commodity.zone.ability.bo.UccCostContractChangeApprovalReqBO;
import com.tydic.commodity.zone.ability.bo.UccCostContractDetailChangeBO;
import com.tydic.commodity.zone.busi.api.UccCostContractApprovalChangeBusiService;
import com.tydic.commodity.zone.busi.api.UccCostContractChangeApprovalBusiService;
import com.tydic.commodity.zone.busi.api.UccCostContractChangeBusiService;
import com.tydic.commodity.zone.busi.api.UccCostContractDeleteBusiService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.zone.ability.api.UccCostContractChangeAbilityService"})
public class UccCostContractChangeAbilityServiceImpl
implements UccCostContractChangeAbilityService {
    @Autowired
    private UccCostContractMessageAtomService uccCostContractMessageAtomService;
    @Autowired
    private UccCostContractChangeBusiService uccCostContractChangeBusiService;
    @Autowired
    private UccCostContractChangeApprovalBusiService uccCostContractChangeApprovalBusiService;
    @Autowired
    private UccCostContractApprovalChangeBusiService uccCostContractApprovalChangeBusiService;
    @Autowired
    private UccCostContractDeleteBusiService uccCostContractDeleteBusiService;
    @Autowired
    private UccCostContractMapper uccCostContractMapper;
    @Autowired
    private UccCostContractDetailMapper uccCostContractDetailMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCostContractDetailEditMapper uccCostContractDetailEditMapper;

    @PostMapping(value={"costContractChange"})
    public UccCostContractChangeAbilityRspBO costContractChange(@RequestBody UccCostContractChangeAbilityReqBO reqBO) {
        UccCostContractChangeAbilityRspBO rspBO;
        UccCostContractMessageAtomReqBO messageAtomReqBO = new UccCostContractMessageAtomReqBO();
        messageAtomReqBO.setMessageId(Long.valueOf(Sequence.getInstance().nextId()));
        messageAtomReqBO.setContent(JSON.toJSONString((Object)reqBO));
        messageAtomReqBO.setStatus(UccConstants.COST_6);
        this.uccCostContractMessageAtomService.costContractMessageAdd(messageAtomReqBO);
        this.validate(reqBO);
        switch (reqBO.getAudit()) {
            case 1: {
                rspBO = this.uccCostContractChangeBusiService.dealContractChange(reqBO);
                break;
            }
            case 2: 
            case 4: {
                UccCostContractChangeApprovalReqBO approvalReqBO = new UccCostContractChangeApprovalReqBO();
                UccCostApprovalInfoBO approvalInfoBO = new UccCostApprovalInfoBO();
                approvalInfoBO.setAudit(reqBO.getAudit());
                approvalInfoBO.setSpuContractCode(reqBO.getSpuContractCode());
                approvalInfoBO.setSupplyCode(reqBO.getSupplyCode());
                ArrayList<UccCostApprovalInfoBO> objects = new ArrayList<UccCostApprovalInfoBO>();
                objects.add(approvalInfoBO);
                approvalReqBO.setApprovalInfos(objects);
                rspBO = this.uccCostContractChangeApprovalBusiService.dealContractChangeApproval(approvalReqBO);
                break;
            }
            case 3: {
                rspBO = this.uccCostContractApprovalChangeBusiService.dealApprovalChange(reqBO);
                break;
            }
            case 5: {
                rspBO = this.uccCostContractDeleteBusiService.dealDeleteDetails(reqBO);
                break;
            }
            default: {
                throw new BusinessException("8888", "\u5165\u53c2 audit \u4e0d\u5408\u6cd5\uff01");
            }
        }
        UccCostContractMessageAtomReqBO messageAtomReqBO1 = new UccCostContractMessageAtomReqBO();
        messageAtomReqBO1.setMessageId(Long.valueOf(Sequence.getInstance().nextId()));
        messageAtomReqBO1.setStrDes(JSON.toJSONString((Object)rspBO));
        this.uccCostContractMessageAtomService.costContractMessageUpdate(messageAtomReqBO1);
        return rspBO;
    }

    private void validate(UccCostContractChangeAbilityReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getSpuContractCode())) {
            throw new BusinessException("8888", "\u534f\u8bae\u53d8\u66f4/\u7ec8\u6b62/\u8865\u5145\u5165\u53c2 spuContractCode \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getSupplyCode())) {
            throw new BusinessException("8888", "\u534f\u8bae\u53d8\u66f4/\u7ec8\u6b62/\u8865\u5145\u5165\u53c2 supplyCode \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getSupplyType())) {
            throw new BusinessException("8888", "\u534f\u8bae\u53d8\u66f4/\u7ec8\u6b62/\u8865\u5145\u5165\u53c2 supplyType \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getAudit())) {
            throw new BusinessException("8888", "\u534f\u8bae\u53d8\u66f4/\u7ec8\u6b62/\u8865\u5145\u5165\u53c2 audit \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getDetailChanges()) && UccConstants.COST_CONTRACT_CANCEL_AUDIT.equals(reqBO.getAudit())) {
            throw new BusinessException("8888", "\u534f\u8bae\u53d8\u66f4/\u7ec8\u6b62/\u8865\u5145\u5165\u53c2 detailChanges \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        UccCostContractPO contractPO = new UccCostContractPO();
        contractPO.setSpuContractCode(reqBO.getSpuContractCode());
        UccCostContractPO modelBy = this.uccCostContractMapper.getModelBy(contractPO);
        if (ObjectUtils.isEmpty((Object)modelBy)) {
            throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u5408\u540c\u7f16\u7801\u4e3a\u3010" + reqBO.getSpuContractCode() + "\u3011\u5408\u540c\u4fe1\u606f\uff01");
        }
        if (UccConstants.COST_CONTRACT_SUBMIT_AUDIT.equals(reqBO.getAudit())) {
            UccCostContractDetailEditPO editPO = new UccCostContractDetailEditPO();
            editPO.setSupplyCode(reqBO.getSupplyCode());
            int checkBy = this.uccCostContractDetailEditMapper.getCheckBy(editPO);
            if (checkBy > 0) {
                throw new BusinessException("8888", "\u63d0\u4ea4\u72b6\u6001\u7684 supplyCode:" + reqBO.getSupplyCode() + "\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u63d0\u4ea4\uff01");
            }
        }
        reqBO.setSpuContractId(modelBy.getSpuContractId());
        if (!CollectionUtils.isEmpty((Collection)reqBO.getDetailChanges())) {
            for (UccCostContractDetailChangeBO change : reqBO.getDetailChanges()) {
                if (ObjectUtils.isEmpty((Object)change.getSpuContractDetailCode())) {
                    throw new BusinessException("8888", "\u534f\u8bae\u53d8\u66f4/\u7ec8\u6b62/\u8865\u5145\u5165\u53c2 spuContractDetailCode \u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (ObjectUtils.isEmpty((Object)change.getSkuCode())) {
                    throw new BusinessException("8888", "\u534f\u8bae\u53d8\u66f4/\u7ec8\u6b62/\u8865\u5145\u5165\u53c2 skuCode \u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                Long skuId = this.uccSkuMapper.getSkuIdByCode(change.getSkuCode());
                if (ObjectUtils.isEmpty((Object)skuId)) {
                    throw new BusinessException("8888", "\u5408\u540c\u660e\u7ec6\u7f16\u7801\u3010" + change.getSpuContractDetailCode() + "\u3011\u7684\u5355\u54c1\u7f16\u7801\u3010" + change.getSkuCode() + "\u3011\u672a\u67e5\u8be2\u5230\u5355\u54c1\u4fe1\u606f\uff01");
                }
                change.setSkuId(skuId);
                if (ObjectUtils.isEmpty((Object)change.getSalePrice())) {
                    throw new BusinessException("8888", "\u534f\u8bae\u53d8\u66f4/\u7ec8\u6b62/\u8865\u5145\u5165\u53c2 salePrice \u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (ObjectUtils.isEmpty((Object)change.getAgreementPrice())) {
                    throw new BusinessException("8888", "\u534f\u8bae\u53d8\u66f4/\u7ec8\u6b62/\u8865\u5145\u5165\u53c2 agreementPrice \u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (ObjectUtils.isEmpty((Object)change.getNum())) {
                    throw new BusinessException("8888", "\u534f\u8bae\u53d8\u66f4/\u7ec8\u6b62/\u8865\u5145\u5165\u53c2 num \u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!UccConstants.COST_CONTRACT_SUBMIT_AUDIT.equals(reqBO.getAudit()) && !UccConstants.COST_CONTRACT_UPDATE_AUDIT.equals(reqBO.getAudit()) || new BigDecimal("0").compareTo(change.getNum()) <= 0) continue;
                UccCostContractDetailPO detailPO = new UccCostContractDetailPO();
                detailPO.setSpuContractDetailCode(change.getSpuContractDetailCode());
                UccCostContractDetailPO detailMapperModelBy = this.uccCostContractDetailMapper.getModelBy(detailPO);
                if (ObjectUtils.isEmpty((Object)detailMapperModelBy) || MoneyUtils.haoToYuan((Long)detailMapperModelBy.getPurchaseNum()).compareTo(change.getNum().abs()) >= 0) continue;
                throw new BusinessException("8888", "\u5408\u540c\u660e\u7ec6\u7f16\u7801\u4e3a\u3010" + change.getSpuContractDetailCode() + "\u3011\u8c03\u51cf\u6570\u91cf\u5927\u4e8e\u5269\u4f59\u91c7\u8d2d\u91cf\uff01");
            }
        }
    }
}

