/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.dao.UccCostContractDetailMapper;
import com.tydic.commodity.po.UccCostContractDetailPO;
import com.tydic.commodity.utils.MoneyUtils;
import com.tydic.commodity.zone.ability.api.UccCostContractDetailListAbilityService;
import com.tydic.commodity.zone.ability.bo.UccCostContractDetailBO;
import com.tydic.commodity.zone.ability.bo.UccCostContractDetailListAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccCostContractDetailListAbilityRspBO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.zone.ability.api.UccCostContractDetailListAbilityService"})
public class UccCostContractDetailListAbilityServiceImpl
implements UccCostContractDetailListAbilityService {
    @Autowired
    private UccCostContractDetailMapper uccCostContractDetailMapper;
    @Autowired
    private UccBaseDictionaryAtomService uccBaseDictionaryAtomService;

    @PostMapping(value={"costContractDetailList"})
    public UccCostContractDetailListAbilityRspBO costContractDetailList(@RequestBody UccCostContractDetailListAbilityReqBO reqBO) {
        this.validate(reqBO);
        UccCostContractDetailListAbilityRspBO rspBO = new UccCostContractDetailListAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        UccCostContractDetailPO detailPO = new UccCostContractDetailPO();
        detailPO.setSkuCode(reqBO.getSkuCode());
        detailPO.setSkuName(reqBO.getSkuName());
        detailPO.setSpuContractId(reqBO.getSpuContractId());
        detailPO.setDetailStatus(UccConstants.COST_DETAIL_ENABLE);
        detailPO.setOrderBy("uccd.CREATE_TIME DESC");
        List listPage = this.uccCostContractDetailMapper.getListPageJoinSku(detailPO, page);
        Map skuStatusMap = this.uccBaseDictionaryAtomService.queryBypCodeBackMap("SKU_STATUS");
        if (!CollectionUtils.isEmpty((Collection)listPage)) {
            List collect = listPage.stream().map(e -> {
                UccCostContractDetailBO uccCostContractDetailBO = (UccCostContractDetailBO)JSONObject.parseObject((String)JSON.toJSONString((Object)e), UccCostContractDetailBO.class);
                uccCostContractDetailBO.setNum(MoneyUtils.haoToYuan((Long)e.getNum()));
                uccCostContractDetailBO.setPurchaseNum(MoneyUtils.haoToYuan((Long)e.getPurchaseNum()));
                uccCostContractDetailBO.setAgreementPrice(MoneyUtils.haoToYuan((Long)e.getAgreementPrice()));
                uccCostContractDetailBO.setSalePrice(MoneyUtils.haoToYuan((Long)e.getSalePrice()));
                uccCostContractDetailBO.setSkuStatusDes((String)skuStatusMap.get(e.getSkuStatus().toString()));
                return uccCostContractDetailBO;
            }).collect(Collectors.toList());
            rspBO.setRows(collect);
            rspBO.setTotal(page.getTotalPages());
            rspBO.setRecordsTotal(page.getTotalCount());
            rspBO.setPageNo(page.getPageNo());
        }
        return rspBO;
    }

    private void validate(UccCostContractDetailListAbilityReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getSpuContractId())) {
            throw new BusinessException("8888", "\u5165\u53c2 spuContractId \u4e0d\u80fd\u7a7a\uff01");
        }
    }
}

