/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.dao.UccCostContractDetailMapper;
import com.tydic.commodity.dao.UccCostContractDetailOrderMapper;
import com.tydic.commodity.dao.UccCostContractMapper;
import com.tydic.commodity.po.UccCostContractDetailOrderPo;
import com.tydic.commodity.po.UccCostContractPO;
import com.tydic.commodity.po.UccCostPurCountPO;
import com.tydic.commodity.utils.MoneyUtils;
import com.tydic.commodity.zone.ability.api.UccCostContractListAbilityService;
import com.tydic.commodity.zone.ability.bo.UccCostContractBO;
import com.tydic.commodity.zone.ability.bo.UccCostContractDetailOrderBo;
import com.tydic.commodity.zone.ability.bo.UccCostContractListAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccCostContractListAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.zone.ability.api.UccCostContractListAbilityService"})
public class UccCostContractListAbilityServiceImpl
implements UccCostContractListAbilityService {
    @Autowired
    private UccCostContractMapper uccCostContractMapper;
    @Autowired
    private UccCostContractDetailMapper uccCostContractDetailMapper;
    @Autowired
    private UccBaseDictionaryAtomService uccBaseDictionaryAtomService;
    @Autowired
    private UccCostContractDetailOrderMapper uccCostContractDetailOrderMapper;

    @PostMapping(value={"costContractList"})
    public UccCostContractListAbilityRspBO costContractList(@RequestBody UccCostContractListAbilityReqBO reqBO) {
        UccCostContractListAbilityRspBO rspBO = new UccCostContractListAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        UccCostContractPO contractPO = (UccCostContractPO)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), UccCostContractPO.class);
        List listPage = this.uccCostContractMapper.getListPage(contractPO, page);
        if (!CollectionUtils.isEmpty((Collection)listPage)) {
            ArrayList spuContractIdList = new ArrayList();
            List collect = listPage.stream().map(e -> {
                UccCostContractBO uccCostContractBO = (UccCostContractBO)JSONObject.parseObject((String)JSON.toJSONString((Object)e), UccCostContractBO.class);
                if (UccConstants.COST_CONTRACT_ENABLE.equals(e.getStatus())) {
                    uccCostContractBO.setStatusDes("\u751f\u6548");
                }
                if (UccConstants.COST_CONTRACT_STOP.equals(e.getStatus())) {
                    uccCostContractBO.setStatusDes("\u7ec8\u6b62");
                }
                if (UccConstants.COST_CONTRACT_CANCEL.equals(e.getStatus())) {
                    uccCostContractBO.setStatusDes("\u4f5c\u5e9f");
                }
                Integer count = this.uccCostContractDetailMapper.countByContractId(e.getSpuContractId());
                uccCostContractBO.setDetailNum(count);
                uccCostContractBO.setAmount(MoneyUtils.haoToYuan((Long)e.getAmount()));
                uccCostContractBO.setPurStatus(Integer.valueOf(0));
                uccCostContractBO.setPurStatusStr("\u5f85\u4e0b\u5355");
                spuContractIdList.add(e.getSpuContractId());
                return uccCostContractBO;
            }).collect(Collectors.toList());
            UccCostContractDetailOrderPo costContractDetailOrderPo = new UccCostContractDetailOrderPo();
            costContractDetailOrderPo.setSpuContractIdList(spuContractIdList);
            List costContractDetailOrderPoList = this.uccCostContractDetailOrderMapper.getList(costContractDetailOrderPo);
            if (!CollectionUtils.isEmpty((Collection)costContractDetailOrderPoList)) {
                Map<Long, List<UccCostContractDetailOrderPo>> groupedBySpuContractId = costContractDetailOrderPoList.stream().collect(Collectors.groupingBy(UccCostContractDetailOrderPo::getSpuContractId));
                for (UccCostContractBO costContractBO : collect) {
                    List<UccCostContractDetailOrderPo> costContractDetailOrderPos = groupedBySpuContractId.get(costContractBO.getSpuContractId());
                    if (CollectionUtils.isEmpty(costContractDetailOrderPos)) continue;
                    costContractBO.setOrderBoList(JSON.parseArray((String)JSON.toJSONString(costContractDetailOrderPos), UccCostContractDetailOrderBo.class));
                }
            }
            rspBO.setRecordsTotal(page.getTotalCount());
            rspBO.setRows(collect);
            rspBO.setTotal(page.getTotalPages());
            rspBO.setPageNo(page.getPageNo());
            this.translateState(rspBO);
        }
        return rspBO;
    }

    private void translateState(UccCostContractListAbilityRspBO rspBO) {
        Map purStatusMap = this.uccBaseDictionaryAtomService.queryBypCodeBackMap("UCC_COST_DETAIL_PUR_STATUS");
        List contractIds = rspBO.getRows().stream().map(UccCostContractBO::getSpuContractId).collect(Collectors.toList());
        List purCountPOS = this.uccCostContractDetailMapper.getPurCount(contractIds);
        if (!CollectionUtils.isEmpty((Collection)purCountPOS)) {
            Map<Long, UccCostPurCountPO> saleNumPoMap = purCountPOS.stream().collect(Collectors.toMap(UccCostPurCountPO::getSpuContractId, costPurCountPO -> costPurCountPO));
            for (UccCostContractBO row : rspBO.getRows()) {
                if (!saleNumPoMap.containsKey(row.getSpuContractId())) continue;
                UccCostPurCountPO uccCostPurCountPO = saleNumPoMap.get(row.getSpuContractId());
                if (uccCostPurCountPO.getPurchaseNumTotal().compareTo(0L) == 0) {
                    row.setPurStatus(Integer.valueOf(1));
                    row.setPurStatusStr((String)purStatusMap.get("1"));
                    continue;
                }
                if (uccCostPurCountPO.getNumTotal().compareTo(uccCostPurCountPO.getPurchaseNumTotal()) == 0) {
                    row.setPurStatus(Integer.valueOf(0));
                    row.setPurStatusStr((String)purStatusMap.get("0"));
                    continue;
                }
                if (uccCostPurCountPO.getNumTotal().compareTo(uccCostPurCountPO.getPurchaseNumTotal()) <= 0) continue;
                row.setPurStatus(Integer.valueOf(2));
                row.setPurStatusStr((String)purStatusMap.get("2"));
            }
        }
        for (UccCostContractBO row : rspBO.getRows()) {
            if (MapUtils.isEmpty((Map)purStatusMap)) continue;
        }
    }
}

