/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.agreement.ability.api.AgrQryAgreementSubjectDetailsAbilityService;
import com.tydic.agreement.ability.bo.AgrAgreementBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementSubjectDetailsAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementSubjectDetailsAbilityRspBO;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccCostContractMessageAtomService;
import com.tydic.commodity.busibase.atom.bo.UccCostContractMessageAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccCostContractMessageAtomRspBO;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.MoneyUtils;
import com.tydic.commodity.zone.ability.api.UccCostContractQryAgrSkuDetailAbilityService;
import com.tydic.commodity.zone.ability.bo.UccCostContractQryAgrSkuDetailAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccCostContractQryAgrSkuDetailAbilityRspBO;
import com.tydic.commodity.zone.ability.bo.UccSkuDetailBO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.zone.ability.api.UccCostContractQryAgrSkuDetailAbilityService"})
public class UccCostContractQryAgrSkuDetailAbilityServiceImpl
implements UccCostContractQryAgrSkuDetailAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccCostContractQryAgrSkuDetailAbilityServiceImpl.class);
    @Autowired
    private UccCostContractMessageAtomService uccCostContractMessageAtomService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private AgrQryAgreementSubjectDetailsAbilityService agrQryAgreementSubjectDetailsAbilityService;

    @PostMapping(value={"contContractskuDetails"})
    public UccCostContractQryAgrSkuDetailAbilityRspBO contContractskuDetails(@RequestBody UccCostContractQryAgrSkuDetailAbilityReqBO reqBO) {
        UccCostContractQryAgrSkuDetailAbilityRspBO abilityRspBO = new UccCostContractQryAgrSkuDetailAbilityRspBO();
        abilityRspBO.setRespCode("0000");
        abilityRspBO.setRespDesc("\u6210\u529f");
        Long messageId = this.message(reqBO);
        this.validate(reqBO);
        AgrAgreementBO agrInfo = this.getAgrInfo(reqBO.getEntAgreementCode());
        abilityRspBO.setAgreementName(agrInfo.getAgreementName());
        abilityRspBO.setEntAgreementCode(agrInfo.getEntAgreementCode());
        abilityRspBO.setVendorName(agrInfo.getVendorName());
        abilityRspBO.setVendorId(agrInfo.getVendorId());
        UccSkuPo get = new UccSkuPo();
        get.setAgreementId(agrInfo.getAgreementId());
        get.setSkuCode(reqBO.getSkuCode());
        get.setSkuName(reqBO.getSkuName());
        List skuByCostPos = this.uccSkuMapper.querySkuByCost(get);
        if (!CollectionUtils.isEmpty((Collection)skuByCostPos)) {
            List skuDetailBOS = skuByCostPos.stream().map(e -> {
                UccSkuDetailBO uccSkuDetailBO = (UccSkuDetailBO)JSONObject.parseObject((String)JSON.toJSONString((Object)e), UccSkuDetailBO.class);
                uccSkuDetailBO.setAgreementPrice(MoneyUtils.haoToYuan((BigDecimal)e.getAgreementPrice()));
                uccSkuDetailBO.setSalePrice(MoneyUtils.haoToYuan((BigDecimal)e.getSalePrice()));
                uccSkuDetailBO.setAdjustPrice(agrInfo.getAdjustPrice());
                return uccSkuDetailBO;
            }).collect(Collectors.toList());
            abilityRspBO.setSkuDetailBOs(skuDetailBOS);
        }
        this.updateMessage(JSON.toJSONString((Object)abilityRspBO), messageId);
        return abilityRspBO;
    }

    private AgrAgreementBO getAgrInfo(String entAgreementCode) {
        AgrQryAgreementSubjectDetailsAbilityReqBO getAgr = new AgrQryAgreementSubjectDetailsAbilityReqBO();
        getAgr.setEntAgreementCode(entAgreementCode);
        log.info("===============\u67e5\u8be2\u534f\u8bae\u5165\u53c2=================");
        log.info(JSON.toJSONString((Object)getAgr));
        log.info("===============\u67e5\u8be2\u534f\u8bae\u5165\u53c2=================");
        AgrQryAgreementSubjectDetailsAbilityRspBO abilityRspBO = this.agrQryAgreementSubjectDetailsAbilityService.qryAgreementSubjectDetails(getAgr);
        log.info("===============\u67e5\u8be2\u534f\u8bae\u51fa\u53c2=================");
        log.info(JSON.toJSONString((Object)abilityRspBO));
        log.info("===============\u67e5\u8be2\u534f\u8bae\u51fa\u53c2=================");
        if (!"0000".equals(abilityRspBO.getRespCode())) {
            throw new BusinessException("8888", "\u534f\u8bae\u4e2d\u5fc3\u67e5\u8be2\u534f\u8bae\u5f02\u5e38!" + abilityRspBO.getRespDesc());
        }
        AgrAgreementBO agrAgreementBO = abilityRspBO.getAgrAgreementBO();
        if (ObjectUtils.isEmpty((Object)agrAgreementBO)) {
            throw new BusinessException("8888", "\u534f\u8bae\u8fd4\u56de\u4e3b\u4f53\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        if (!ObjectUtils.isEmpty((Object)agrAgreementBO.getAgreementSrc()) && agrAgreementBO.getAgreementSrc() != 6) {
            throw new BusinessException("8888", "\u534f\u8bae\u7f16\u53f7\u4e3a\u3010" + entAgreementCode + "\u3011\u4e0d\u662f \u5408\u540c\u4e0b\u5355 \u534f\u8bae\uff01\u8bf7\u786e\u8ba4\u534f\u8bae\u4fe1\u606f\u662f\u5426\u5f55\u5165\u6b63\u786e\uff01");
        }
        if (ObjectUtils.isEmpty((Object)agrAgreementBO.getAgreementName())) {
            throw new BusinessException("8888", "\u534f\u8bae\u8fd4\u56de \u534f\u8bae\u540d\u79f0 \u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)agrAgreementBO.getAgreementId())) {
            throw new BusinessException("8888", "\u534f\u8bae\u8fd4\u56de \u534f\u8baeid \u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)agrAgreementBO.getPlaAgreementCode())) {
            throw new BusinessException("8888", "\u534f\u8bae\u8fd4\u56de \u5e73\u53f0\u534f\u8bae\u7f16\u7801 \u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)agrAgreementBO.getEntAgreementCode())) {
            throw new BusinessException("8888", "\u534f\u8bae\u8fd4\u56de \u4f01\u4e1a\u534f\u8bae\u7f16\u7801 \u4e3a\u7a7a\uff01");
        }
        if (ObjectUtil.isEmpty((Object)agrAgreementBO.getAdjustPrice())) {
            throw new BusinessException("8888", "\u534f\u8bae\u8fd4\u56de \u8c03\u4ef7\u6a21\u5f0f \u4e3a\u7a7a\uff01");
        }
        return abilityRspBO.getAgrAgreementBO();
    }

    private void updateMessage(String resultStr, Long messageId) {
        UccCostContractMessageAtomReqBO messageAtomReqBO = new UccCostContractMessageAtomReqBO();
        messageAtomReqBO.setStrDes(resultStr);
        messageAtomReqBO.setMessageId(messageId);
        this.uccCostContractMessageAtomService.costContractMessageUpdate(messageAtomReqBO);
    }

    private Long message(UccCostContractQryAgrSkuDetailAbilityReqBO reqBO) {
        UccCostContractMessageAtomReqBO messageAtomReqBO = new UccCostContractMessageAtomReqBO();
        messageAtomReqBO.setContent(JSON.toJSONString((Object)reqBO));
        messageAtomReqBO.setStatus(UccConstants.COST_1);
        UccCostContractMessageAtomRspBO rspBO = this.uccCostContractMessageAtomService.costContractMessageAdd(messageAtomReqBO);
        return rspBO.getMessageId();
    }

    private void validate(UccCostContractQryAgrSkuDetailAbilityReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getEntAgreementCode())) {
            throw new BusinessException("8888", "\u53c2\u6570 entAgreementCode \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

