/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.po.UccCommdPropDefPo;
import com.tydic.commodity.po.UccCommodityTypePo;
import com.tydic.commodity.zone.ability.api.UccTypeMdmStrListAbilityService;
import com.tydic.commodity.zone.ability.bo.UccEMdmCatalogLevelBO;
import com.tydic.commodity.zone.ability.bo.UccTypeMdmStrListAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccTypeMdmStrListAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.zone.ability.api.UccTypeMdmStrListAbilityService"})
public class UccTypeMdmStrListAbilityServiceImpl
implements UccTypeMdmStrListAbilityService {
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;

    @PostMapping(value={"typeMdmStrList"})
    public UccTypeMdmStrListAbilityRspBO typeMdmStrList(@RequestBody UccTypeMdmStrListAbilityReqBO reqBO) {
        UccTypeMdmStrListAbilityRspBO rspBO = new UccTypeMdmStrListAbilityRspBO();
        List levelPOS = this.uccEMdmCatalogMapper.qryStrBylevel3AndTypeId(reqBO.getTypeIds());
        if (!CollectionUtils.isEmpty((Collection)levelPOS)) {
            List typeIds;
            List defPos;
            List uccEMdmCatalogLevelBOS = JSONObject.parseArray((String)JSON.toJSONString((Object)levelPOS), UccEMdmCatalogLevelBO.class);
            rspBO.setMdmCatalogLevelBOList(uccEMdmCatalogLevelBOS);
            rspBO.setRespCode("0000");
            ArrayList<String> notExistTypes = new ArrayList<String>();
            List<String> notModelSpec = new ArrayList<String>();
            List catalogNames = uccEMdmCatalogLevelBOS.stream().map(UccEMdmCatalogLevelBO::getL3Name).collect(Collectors.toList());
            List types = this.uccCommodityTypeMapper.getTypesJoinCategorys(catalogNames);
            Map<Long, List<UccCommodityTypePo>> typeMap = types.stream().collect(Collectors.groupingBy(UccCommodityTypePo::getCommodityTypeId));
            if (!CollectionUtils.isEmpty((Collection)types) && !CollectionUtils.isEmpty((Collection)(defPos = this.uccCommodityTypeMapper.qryPropByTypeIds(typeIds = types.stream().map(UccCommodityTypePo::getCommodityTypeId).distinct().collect(Collectors.toList()))))) {
                Map<Long, List<UccCommdPropDefPo>> typeIdMap = defPos.stream().collect(Collectors.groupingBy(UccCommdPropDefPo::getCommodityTypeId));
                for (Long typeId : typeIds) {
                    if (!typeIdMap.containsKey(typeId)) {
                        notExistTypes.add(typeMap.get(typeId).get(0).getCommodityTypeName());
                        continue;
                    }
                    List defNames = typeIdMap.get(typeId).stream().map(UccCommdPropDefPo::getPropName).collect(Collectors.toList());
                    if (defNames.contains("\u89c4\u683c") && defNames.contains("\u578b\u53f7")) continue;
                    notModelSpec.add(typeMap.get(typeId).get(0).getCommodityTypeName());
                }
            }
            if (!CollectionUtils.isEmpty(notExistTypes)) {
                notModelSpec.addAll(notExistTypes);
            }
            if (!CollectionUtils.isEmpty(notModelSpec)) {
                if (notModelSpec.size() > 50) {
                    notModelSpec = notModelSpec.subList(0, 50);
                }
                throw new BusinessException("8888", "\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff0c\u60a8\u7b7e\u7ea6\u7533\u8bf7\u6d89\u53ca\u5546\u54c1\u7c7b\u578b[" + notModelSpec + "]\u672a\u5173\u8054\u89c4\u683c\u3001\u578b\u53f7\u9500\u552e\u5c5e\u6027\uff0c\u8bf7\u8054\u7cfb\u8fd0\u8425\u6dfb\u52a0");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)rspBO.getMdmCatalogLevelBOList()) && rspBO.getMdmCatalogLevelBOList().size() > 400) {
            rspBO.setMdmCatalogLevelBOList(rspBO.getMdmCatalogLevelBOList().stream().limit(400L).collect(Collectors.toList()));
        }
        return rspBO;
    }
}

