/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.api.AgrQryAgreementSubjectDetailsAbilityService;
import com.tydic.agreement.ability.bo.AgrAgreementBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementSubjectDetailsAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementSubjectDetailsAbilityRspBO;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccWmsMessageMapper;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccWmsMessagePO;
import com.tydic.commodity.utils.MoneyUtils;
import com.tydic.commodity.zone.ability.api.UccWmsSkuDetailListAbilityService;
import com.tydic.commodity.zone.ability.bo.UccAgreementSkuBO;
import com.tydic.commodity.zone.ability.bo.UccWmsSkuDetailBO;
import com.tydic.commodity.zone.ability.bo.UccWmsSkuDetailListAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccWmsSkuDetailListAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.zone.ability.api.UccWmsSkuDetailListAbilityService"})
public class UccWmsSkuDetailListAbilityServiceImpl
implements UccWmsSkuDetailListAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccWmsSkuDetailListAbilityServiceImpl.class);
    @Autowired
    private UccWmsMessageMapper uccWmsMessageMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private AgrQryAgreementSubjectDetailsAbilityService agrQryAgreementSubjectDetailsAbilityService;
    @Value(value="#{'${WMS_SUPPLIER_IDS:305775845729763336}'.split(',')}")
    private List<String> WMS_SUPPLIER_IDS;

    @PostMapping(value={"skuDetailList"})
    public UccWmsSkuDetailListAbilityRspBO skuDetailList(@RequestBody UccWmsSkuDetailListAbilityReqBO reqBO) {
        UccWmsSkuDetailListAbilityRspBO abilityRspBO = new UccWmsSkuDetailListAbilityRspBO();
        abilityRspBO.setRespCode("0000");
        abilityRspBO.setRespDesc("\u6210\u529f");
        Long messageId = this.message(reqBO);
        ArrayList<UccAgreementSkuBO> uccAgreementSkuBOS = new ArrayList<UccAgreementSkuBO>();
        for (String shopId : this.WMS_SUPPLIER_IDS) {
            UccAgreementSkuBO agreementSkuBO = new UccAgreementSkuBO();
            UccSkuPo get = new UccSkuPo();
            get.setSupplierShopId(Long.valueOf(Long.parseLong(shopId)));
            get.setSkuCode(reqBO.getSkuCode());
            get.setSkuName(reqBO.getSkuName());
            get.setTimeStart(reqBO.getTimeStart());
            get.setTimeEnd(reqBO.getTimeEnd());
            List skuByCostPos = this.uccSkuMapper.querySkuByWms(get);
            if (!CollectionUtils.isEmpty((Collection)skuByCostPos)) {
                List skuDetailBOS = skuByCostPos.stream().map(e -> {
                    UccWmsSkuDetailBO uccSkuDetailBO = (UccWmsSkuDetailBO)JSONObject.parseObject((String)JSON.toJSONString((Object)e), UccWmsSkuDetailBO.class);
                    uccSkuDetailBO.setAgreementPrice(MoneyUtils.haoToYuan((BigDecimal)e.getAgreementPrice()));
                    uccSkuDetailBO.setSalePrice(MoneyUtils.haoToYuan((BigDecimal)e.getSalePrice()));
                    return uccSkuDetailBO;
                }).collect(Collectors.toList());
                agreementSkuBO.setSkuDetailBOs(skuDetailBOS);
                agreementSkuBO.setVendorId(((UccWmsSkuDetailBO)skuDetailBOS.get(0)).getSupplierShopId());
                agreementSkuBO.setVendorName(((UccWmsSkuDetailBO)skuDetailBOS.get(0)).getShopName());
            }
            uccAgreementSkuBOS.add(agreementSkuBO);
        }
        this.updateMessage(JSON.toJSONString((Object)abilityRspBO), messageId);
        abilityRspBO.setAgreements(uccAgreementSkuBOS);
        return abilityRspBO;
    }

    private AgrAgreementBO getAgrInfo(String plaAgreementCode) {
        AgrQryAgreementSubjectDetailsAbilityReqBO getAgr = new AgrQryAgreementSubjectDetailsAbilityReqBO();
        getAgr.setPlaAgreementCode(plaAgreementCode);
        log.info("===============\u67e5\u8be2\u534f\u8bae\u5165\u53c2=================");
        log.info(JSON.toJSONString((Object)getAgr));
        log.info("===============\u67e5\u8be2\u534f\u8bae\u5165\u53c2=================");
        AgrQryAgreementSubjectDetailsAbilityRspBO abilityRspBO = this.agrQryAgreementSubjectDetailsAbilityService.qryAgreementSubjectDetails(getAgr);
        log.info("===============\u67e5\u8be2\u534f\u8bae\u51fa\u53c2=================");
        log.info(JSON.toJSONString((Object)abilityRspBO));
        log.info("===============\u67e5\u8be2\u534f\u8bae\u51fa\u53c2=================");
        if (!"0000".equals(abilityRspBO.getRespCode())) {
            throw new BusinessException("8888", "\u534f\u8bae\u4e2d\u5fc3\u67e5\u8be2\u534f\u8bae\u5f02\u5e38!" + abilityRspBO.getRespDesc());
        }
        AgrAgreementBO agrAgreementBO = abilityRspBO.getAgrAgreementBO();
        if (ObjectUtils.isEmpty((Object)agrAgreementBO)) {
            throw new BusinessException("8888", "\u534f\u8bae\u8fd4\u56de\u4e3b\u4f53\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)agrAgreementBO.getAgreementName())) {
            throw new BusinessException("8888", "\u534f\u8bae\u8fd4\u56de \u534f\u8bae\u540d\u79f0 \u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)agrAgreementBO.getAgreementId())) {
            throw new BusinessException("8888", "\u534f\u8bae\u8fd4\u56de \u534f\u8baeid \u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)agrAgreementBO.getPlaAgreementCode())) {
            throw new BusinessException("8888", "\u534f\u8bae\u8fd4\u56de \u5e73\u53f0\u534f\u8bae\u7f16\u7801 \u4e3a\u7a7a\uff01");
        }
        return abilityRspBO.getAgrAgreementBO();
    }

    private void updateMessage(String resultStr, Long messageId) {
        try {
            UccWmsMessagePO messageAtomReqBO = new UccWmsMessagePO();
            messageAtomReqBO.setStrDes(resultStr);
            messageAtomReqBO.setMessageId(messageId);
            this.uccWmsMessageMapper.updateById(messageAtomReqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u65e5\u5fd7\u8bb0\u5f55\u5f02\u5e38\uff01@");
        }
    }

    private Long message(UccWmsSkuDetailListAbilityReqBO reqBO) {
        try {
            UccWmsMessagePO wmsMessagePO = new UccWmsMessagePO();
            wmsMessagePO.setStatus(UccConstants.COST_1);
            wmsMessagePO.setContent(JSON.toJSONString((Object)reqBO));
            wmsMessagePO.setCreateTime(new Date());
            wmsMessagePO.setMessageId(Long.valueOf(Sequence.getInstance().nextId()));
            wmsMessagePO.setStrDes("\u5904\u7406\u4e2d");
            this.uccWmsMessageMapper.insert(wmsMessagePO);
            return wmsMessagePO.getMessageId();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u65b0\u589e\u6d88\u606f\u5f02\u5e38\uff01");
            return null;
        }
    }

    private void validate(UccWmsSkuDetailListAbilityReqBO reqBO) {
    }
}

