/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.busi.impl;

import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.utils.MoneyUtils;
import com.tydic.commodity.zone.busi.api.UccAgrGoodsPriceMarkupRateUpdateBusiService;
import com.tydic.commodity.zone.busi.bo.UccAgrGoodsPriceMarkupRateUpdateBusiServiceReqBO;
import com.tydic.commodity.zone.busi.bo.UccAgrGoodsPriceMarkupRateUpdateBusiServiceRspBO;
import java.math.BigDecimal;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class UccAgrGoodsPriceMarkupRateUpdateBusiServiceImpl
implements UccAgrGoodsPriceMarkupRateUpdateBusiService {
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;

    @Override
    public UccAgrGoodsPriceMarkupRateUpdateBusiServiceRspBO dealUpdatePriceMarkUpRate(UccAgrGoodsPriceMarkupRateUpdateBusiServiceReqBO reqBO) {
        this.validate(reqBO);
        try {
            reqBO.getUpdateBOList().forEach(e -> {
                UccSkuPricePo skuPricePo = new UccSkuPricePo();
                skuPricePo.setSalePrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)e.getSalePrice())));
                skuPricePo.setSkuId(e.getSkuId());
                skuPricePo.setAddCoefficient(e.getMarkupRate());
                skuPricePo.setUpdateOperId(reqBO.getName());
                skuPricePo.setUpdateTime(new Date());
                if (!ObjectUtils.isEmpty((Object)e.getAgreementPrice())) {
                    skuPricePo.setAgreementPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)e.getAgreementPrice())));
                }
                this.uccSkuPriceMapper.updatePriceNew(skuPricePo);
            });
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new BusinessException("8888", "\u66f4\u65b0\u4ef7\u683c\u4fe1\u606f\u5931\u8d25\uff01" + e2.getMessage());
        }
        UccAgrGoodsPriceMarkupRateUpdateBusiServiceRspBO rateUpdateBusiServiceRspBO = new UccAgrGoodsPriceMarkupRateUpdateBusiServiceRspBO();
        rateUpdateBusiServiceRspBO.setRespCode("0000");
        rateUpdateBusiServiceRspBO.setRespDesc("\u6210\u529f");
        return rateUpdateBusiServiceRspBO;
    }

    private void validate(UccAgrGoodsPriceMarkupRateUpdateBusiServiceReqBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getUpdateBOList())) {
            throw new BusinessException("8888", "\u534f\u8bae\u5546\u54c1\u52a0\u4ef7\u4ef7\u683c\u66f4\u65b0\u5165\u53c2 updateBOList  \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (UccAgrGoodsPriceMarkupRateUpdateBusiServiceReqBO.UccAgrGoodsPriceMarkupRateUpdateBO rateUpdateBO : reqBO.getUpdateBOList()) {
            if (ObjectUtils.isEmpty((Object)rateUpdateBO.getMarkupRate())) {
                throw new BusinessException("8888", "\u534f\u8bae\u5546\u54c1\u52a0\u4ef7\u4ef7\u683c\u66f4\u65b0\u5165\u53c2 markupRate  \u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (ObjectUtils.isEmpty((Object)rateUpdateBO.getSalePrice())) {
                throw new BusinessException("8888", "\u534f\u8bae\u5546\u54c1\u52a0\u4ef7\u4ef7\u683c\u66f4\u65b0\u5165\u53c2 salePrice  \u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!ObjectUtils.isEmpty((Object)rateUpdateBO.getSkuId())) continue;
            throw new BusinessException("8888", "\u534f\u8bae\u5546\u54c1\u52a0\u4ef7\u4ef7\u683c\u66f4\u65b0\u5165\u53c2 skuId  \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

