/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccCommodityPropDefMapper;
import com.tydic.commodity.dao.UccCommodityPropGrpMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccPropValueListMapper;
import com.tydic.commodity.dao.UccRelPropGrpPropMapper;
import com.tydic.commodity.po.UccCommdPropDefPo;
import com.tydic.commodity.po.UccCommodityPropGrpPo;
import com.tydic.commodity.po.UccCommodityTypePo;
import com.tydic.commodity.po.UccPropValueListPo;
import com.tydic.commodity.po.UccRelPropGrpPropPo;
import com.tydic.commodity.zone.ability.bo.UccExcelForAgrTypeGroupBO;
import com.tydic.commodity.zone.busi.api.UccBatchImportAgrCommodityTypeGrpPropBusiService;
import com.tydic.commodity.zone.busi.bo.UccBatchImportAgrCommodityTypeGrpPropBusiReqBO;
import com.tydic.commodity.zone.busi.bo.UccBatchImportAgrCommodityTypeGrpPropBusiRspBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccBatchImportAgrCommodityTypeGrpPropBusiServiceImpl
implements UccBatchImportAgrCommodityTypeGrpPropBusiService {
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccCommodityPropGrpMapper uccCommodityPropGrpMapper;
    @Autowired
    private UccCommodityPropDefMapper uccCommodityPropDefMapper;
    @Autowired
    private UccPropValueListMapper uccPropValueListMapper;
    @Autowired
    private UccRelPropGrpPropMapper uccRelPropGrpPropMapper;
    private static final Sequence SEQUENCE = Sequence.getInstance();

    @Override
    public UccBatchImportAgrCommodityTypeGrpPropBusiRspBO dealBatchImportAgrCommodityTypeGrpProp(UccBatchImportAgrCommodityTypeGrpPropBusiReqBO reqBO) {
        UccBatchImportAgrCommodityTypeGrpPropBusiRspBO rspBO = new UccBatchImportAgrCommodityTypeGrpPropBusiRspBO();
        Date time = new Date();
        try {
            List commodityTypeNames = reqBO.getTypeGroupBOS().stream().map(UccExcelForAgrTypeGroupBO::getCommodityTypeName).distinct().collect(Collectors.toList());
            List commodityTypePos = commodityTypeNames.stream().map(typeName -> {
                UccCommodityTypePo commodityTypePo = new UccCommodityTypePo();
                commodityTypePo.setCommodityTypeName(typeName);
                commodityTypePo.setCommodityTypeId(Long.valueOf(SEQUENCE.nextId()));
                commodityTypePo.setCommodityTypeStatus(Integer.valueOf(1));
                commodityTypePo.setCreateOperId(reqBO.getUsername());
                commodityTypePo.setCreateTime(time);
                return commodityTypePo;
            }).collect(Collectors.toList());
            this.uccCommodityTypeMapper.batchInsert(commodityTypePos);
            Map<String, List<UccCommodityTypePo>> commodityTypeNameMap = commodityTypePos.stream().collect(Collectors.groupingBy(UccCommodityTypePo::getCommodityTypeName));
            ArrayList<UccCommodityPropGrpPo> uccCommodityPropGrpPos = new ArrayList<UccCommodityPropGrpPo>();
            for (UccExcelForAgrTypeGroupBO typeGroupBO : reqBO.getTypeGroupBOS()) {
                UccCommodityPropGrpPo propGrpPo = new UccCommodityPropGrpPo();
                propGrpPo.setCommodityTypeId(commodityTypeNameMap.get(typeGroupBO.getCommodityTypeName()).get(0).getCommodityTypeId());
                propGrpPo.setCommodityPropGrpId(Long.valueOf(SEQUENCE.nextId()));
                propGrpPo.setCommodityPropGrpCode(propGrpPo.getCommodityPropGrpId().toString());
                propGrpPo.setCommodityPropGrpName(typeGroupBO.getCommodityPropGrpName());
                propGrpPo.setCommodityPropGrpType(typeGroupBO.getCommodityPropGrpType());
                propGrpPo.setCreateOperId(reqBO.getUsername());
                propGrpPo.setCreateTime(time);
                propGrpPo.setPropGrpStatus(Integer.valueOf(1));
                uccCommodityPropGrpPos.add(propGrpPo);
            }
            this.uccCommodityPropGrpMapper.batchInsert(uccCommodityPropGrpPos);
            Map<String, List<UccCommodityPropGrpPo>> commodityPropGrpMap = uccCommodityPropGrpPos.stream().collect(Collectors.groupingBy(UccCommodityPropGrpPo::getCommodityPropGrpName));
            List propDefPos = reqBO.getGrpPropBOS().stream().map(e -> {
                UccCommdPropDefPo propDefPo = new UccCommdPropDefPo();
                propDefPo.setCommodityPropDefId(Long.valueOf(SEQUENCE.nextId()));
                propDefPo.setPropCode(propDefPo.getCommodityPropDefId().toString());
                propDefPo.setShowName(e.getPropName());
                propDefPo.setPropName(e.getPropName());
                propDefPo.setPropTag(((UccCommodityPropGrpPo)((List)commodityPropGrpMap.get(e.getCommodityPropGrpName())).get(0)).getCommodityPropGrpType());
                propDefPo.setPropType(Integer.valueOf(0));
                propDefPo.setInputType(Integer.valueOf(1));
                propDefPo.setFilterFlag(Integer.valueOf(1));
                propDefPo.setMultiFlag(Integer.valueOf(1));
                propDefPo.setPropertyLink(Integer.valueOf(1));
                propDefPo.setShowOrder(Integer.valueOf(0));
                propDefPo.setRequiredFlag(Integer.valueOf(0));
                propDefPo.setCreateTime(time);
                propDefPo.setCreateOperName(reqBO.getUsername());
                propDefPo.setCreateOperId(reqBO.getUsername());
                propDefPo.setPropLen(Integer.valueOf(100));
                return propDefPo;
            }).collect(Collectors.toList());
            this.uccCommodityPropDefMapper.batchInsert(propDefPos);
            Map<String, List<UccCommdPropDefPo>> commodityPropMap = propDefPos.stream().collect(Collectors.groupingBy(UccCommdPropDefPo::getPropName));
            List propGrpPropPos = reqBO.getGrpPropBOS().stream().map(e -> {
                UccRelPropGrpPropPo uccRelPropGrpPropPo = new UccRelPropGrpPropPo();
                uccRelPropGrpPropPo.setRelId(Long.valueOf(SEQUENCE.nextId()));
                uccRelPropGrpPropPo.setCommodityPropGrpId(((UccCommodityPropGrpPo)((List)commodityPropGrpMap.get(e.getCommodityPropGrpName())).get(0)).getCommodityPropGrpId());
                uccRelPropGrpPropPo.setCommodityPropDefId(((UccCommdPropDefPo)((List)commodityPropMap.get(e.getPropName())).get(0)).getCommodityPropDefId());
                uccRelPropGrpPropPo.setShowOrder(Integer.valueOf(0));
                uccRelPropGrpPropPo.setCreateOperId(reqBO.getUsername());
                uccRelPropGrpPropPo.setCreateTime(time);
                return uccRelPropGrpPropPo;
            }).collect(Collectors.toList());
            this.uccRelPropGrpPropMapper.batchInsert(propGrpPropPos);
            List uccPropValueListPos = reqBO.getPropValueListPos().stream().map(e -> {
                UccPropValueListPo valueListPo = new UccPropValueListPo();
                valueListPo.setPropValueListId(Long.valueOf(SEQUENCE.nextId()));
                valueListPo.setPropValueListCode(valueListPo.getPropValueListId().toString());
                valueListPo.setCommodityPropDefId(((UccCommdPropDefPo)((List)commodityPropMap.get(e.getPropName())).get(0)).getCommodityPropDefId());
                valueListPo.setPropValue(e.getPropValue());
                valueListPo.setCreateOperId(reqBO.getUsername());
                valueListPo.setCreateTime(time);
                valueListPo.setPropScope(Integer.valueOf(0));
                return valueListPo;
            }).collect(Collectors.toList());
            this.uccPropValueListMapper.batchInsert(uccPropValueListPos);
            Map<String, List<UccPropValueListPo>> propValueMap = uccPropValueListPos.stream().collect(Collectors.groupingBy(e -> e.getPropName() + "-" + e.getPropValue()));
            rspBO.setCommodityPropMap(commodityPropMap);
            rspBO.setCommodityPropGrpMap(commodityPropGrpMap);
            rspBO.setCommodityTypeNameMap(commodityTypeNameMap);
            rspBO.setPropValueMap(propValueMap);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new BusinessException("8888", "\u5904\u7406\u65b0\u589e\u7c7b\u578b\u5c5e\u6027\u4fe1\u606f\u5931\u8d25\uff01" + e2.getMessage());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

