/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.api.AgrQryAgreementSubjectDetailsAbilityService;
import com.tydic.agreement.ability.bo.AgrAgreementBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementSubjectDetailsAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementSubjectDetailsAbilityRspBO;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccCostContractAlterRecordMapper;
import com.tydic.commodity.dao.UccCostContractDetailMapper;
import com.tydic.commodity.dao.UccCostContractMapper;
import com.tydic.commodity.po.UccCostContractAlterRecordPO;
import com.tydic.commodity.po.UccCostContractDetailPO;
import com.tydic.commodity.po.UccCostContractPO;
import com.tydic.commodity.utils.MoneyUtils;
import com.tydic.commodity.zone.ability.bo.UccCostContractAddAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccCostContractAddAbilityRspBO;
import com.tydic.commodity.zone.busi.api.UccCostContractAddBusiService;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class UccCostContractAddBusiServiceImpl
implements UccCostContractAddBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccCostContractAddBusiServiceImpl.class);
    private static final Sequence SEQUENCE = Sequence.getInstance();
    @Autowired
    private AgrQryAgreementSubjectDetailsAbilityService agrQryAgreementSubjectDetailsAbilityService;
    @Autowired
    private UccCostContractMapper uccCostContractMapper;
    @Autowired
    private UccCostContractDetailMapper uccCostContractDetailMapper;
    @Autowired
    private UccCostContractAlterRecordMapper uccCostContractAlterRecordMapper;

    @Override
    public UccCostContractAddAbilityRspBO dealCostContractAdd(UccCostContractAddAbilityReqBO reqBO) {
        AgrAgreementBO agrInfo = this.getAgrInfo(reqBO.getEntAgreementCode());
        UccCostContractPO contractPO = this.dealAddContract(reqBO, agrInfo);
        this.dealAddContractDetails(reqBO, contractPO);
        UccCostContractAddAbilityRspBO rspBO = new UccCostContractAddAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealAddContractDetails(UccCostContractAddAbilityReqBO reqBO, UccCostContractPO contractPO) {
        try {
            List costContractDetailPOS = reqBO.getContractDetailBOList().stream().map(e -> {
                UccCostContractDetailPO po = new UccCostContractDetailPO();
                po.setSpuContractDetailId(Long.valueOf(SEQUENCE.nextId()));
                po.setSpuContractDetailCode(e.getSpuContractDetailCode());
                po.setSpuContractId(contractPO.getSpuContractId());
                po.setAgreementPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)e.getSalePrice())));
                po.setSalePrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)e.getSalePrice())));
                po.setPurchaseNum(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)e.getNum())));
                po.setNum(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)e.getNum())));
                po.setDetailStatus(UccConstants.COST_DETAIL_ENABLE);
                po.setSkuCode(e.getSkuCode());
                po.setSkuId(e.getSkuId());
                po.setExt1(e.getPreEnterTime());
                po.setExt2(e.getDesc());
                po.setCreateTime(reqBO.getCreateTime());
                po.setCancelNum(Long.valueOf(0L));
                po.setCreateId("sys");
                return po;
            }).collect(Collectors.toList());
            this.uccCostContractDetailMapper.insertBatch(costContractDetailPOS);
            long batchId = SEQUENCE.nextId();
            Date alterTime = new Date();
            List costContractAlterRecordPOS = costContractDetailPOS.stream().map(e -> {
                UccCostContractAlterRecordPO contractAlterRecordPO = new UccCostContractAlterRecordPO();
                contractAlterRecordPO.setAgreementPrice(e.getSalePrice());
                contractAlterRecordPO.setAlterBatchId(Long.valueOf(batchId));
                contractAlterRecordPO.setAlterNum(e.getNum());
                contractAlterRecordPO.setAlterRecordId(Long.valueOf(SEQUENCE.nextId()));
                contractAlterRecordPO.setAlterTime(alterTime);
                contractAlterRecordPO.setSalePrice(e.getSalePrice());
                contractAlterRecordPO.setSkuId(e.getSkuId());
                contractAlterRecordPO.setSkuCode(e.getSkuCode());
                contractAlterRecordPO.setSpuContractDetailId(e.getSpuContractDetailId());
                contractAlterRecordPO.setUccCostContractDetailCode(e.getSpuContractDetailCode());
                return contractAlterRecordPO;
            }).collect(Collectors.toList());
            this.uccCostContractAlterRecordMapper.insertBatch(costContractAlterRecordPOS);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            log.error("===============\u65b0\u589e\u534f\u8bae\u660e\u7ec6\u4fe1\u606f\u5f02\u5e38\uff01======================" + e2.getMessage());
        }
    }

    private UccCostContractPO dealAddContract(UccCostContractAddAbilityReqBO reqBO, AgrAgreementBO agrInfo) {
        UccCostContractPO contractPO = (UccCostContractPO)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), UccCostContractPO.class);
        contractPO.setProductCode(reqBO.getProductId());
        long contractId = SEQUENCE.nextId();
        contractPO.setAgreementId(agrInfo.getAgreementId());
        contractPO.setPlaAgreementCode(agrInfo.getPlaAgreementCode());
        contractPO.setEntAgreementCode(agrInfo.getEntAgreementCode());
        contractPO.setAgreementName(agrInfo.getAgreementName());
        contractPO.setSpuContractCode(reqBO.getSpuContractCode());
        contractPO.setSpuContractName(reqBO.getSpuContractName());
        contractPO.setSpuContractId(Long.valueOf(contractId));
        contractPO.setProducerId(reqBO.getProducerId());
        contractPO.setProducerOrgId(reqBO.getProducerOrgId());
        contractPO.setProducerOrgName(reqBO.getProducerOrgName());
        contractPO.setAmount(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)reqBO.getAmount())));
        contractPO.setStatus(reqBO.getStatus());
        contractPO.setCreateTime(reqBO.getCreateTime());
        contractPO.setSupplierId(agrInfo.getVendorId().toString());
        contractPO.setSupplierName(agrInfo.getVendorName());
        contractPO.setProductStatus(UccConstants.COST_PRODUCT_ENABLE);
        contractPO.setUpperProductId(reqBO.getUpperProductId());
        contractPO.setUpperProductName(reqBO.getUpperProductName());
        contractPO.setCreateId("sys");
        try {
            this.uccCostContractMapper.insert(contractPO);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("8888", "\u65b0\u589e\u534f\u8bae\u4e3b\u4f53\u4fe1\u606f\u5f02\u5e38\uff01" + e.getMessage());
        }
        return contractPO;
    }

    private AgrAgreementBO getAgrInfo(String entAgreementCode) {
        AgrQryAgreementSubjectDetailsAbilityReqBO getAgr = new AgrQryAgreementSubjectDetailsAbilityReqBO();
        getAgr.setEntAgreementCode(entAgreementCode);
        log.info("===============\u67e5\u8be2\u534f\u8bae\u5165\u53c2=================");
        log.info(JSON.toJSONString((Object)getAgr));
        log.info("===============\u67e5\u8be2\u534f\u8bae\u5165\u53c2=================");
        AgrQryAgreementSubjectDetailsAbilityRspBO abilityRspBO = this.agrQryAgreementSubjectDetailsAbilityService.qryAgreementSubjectDetails(getAgr);
        log.info("===============\u67e5\u8be2\u534f\u8bae\u51fa\u53c2=================");
        log.info(JSON.toJSONString((Object)abilityRspBO));
        log.info("===============\u67e5\u8be2\u534f\u8bae\u51fa\u53c2=================");
        if (!"0000".equals(abilityRspBO.getRespCode())) {
            throw new BusinessException("8888", "\u534f\u8bae\u4e2d\u5fc3\u67e5\u8be2\u534f\u8bae\u5f02\u5e38!" + abilityRspBO.getRespDesc());
        }
        AgrAgreementBO agrAgreementBO = abilityRspBO.getAgrAgreementBO();
        if (ObjectUtils.isEmpty((Object)agrAgreementBO)) {
            throw new BusinessException("8888", "\u534f\u8bae\u8fd4\u56de\u4e3b\u4f53\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)agrAgreementBO.getAgreementName())) {
            throw new BusinessException("8888", "\u534f\u8bae\u8fd4\u56de \u534f\u8bae\u540d\u79f0 \u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)agrAgreementBO.getAgreementId())) {
            throw new BusinessException("8888", "\u534f\u8bae\u8fd4\u56de \u534f\u8baeid \u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)agrAgreementBO.getPlaAgreementCode())) {
            throw new BusinessException("8888", "\u534f\u8bae\u8fd4\u56de \u5e73\u53f0\u534f\u8bae\u7f16\u7801 \u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)agrAgreementBO.getEntAgreementCode())) {
            throw new BusinessException("8888", "\u534f\u8bae\u8fd4\u56de \u4f01\u4e1a\u534f\u8bae\u7f16\u7801 \u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)agrAgreementBO.getVendorId())) {
            throw new BusinessException("8888", "\u534f\u8bae\u8fd4\u56de \u4f9b\u5e94\u5546id \u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)agrAgreementBO.getVendorName())) {
            throw new BusinessException("8888", "\u534f\u8bae\u8fd4\u56de \u4f9b\u5e94\u5546\u540d\u79f0 \u4e3a\u7a7a\uff01");
        }
        return abilityRspBO.getAgrAgreementBO();
    }
}

