/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccCostContractDetailEditLogMapper;
import com.tydic.commodity.dao.UccCostContractDetailEditMapper;
import com.tydic.commodity.dao.UccCostContractDetailMapper;
import com.tydic.commodity.po.UccCostContractDetailEditPO;
import com.tydic.commodity.po.UccCostContractDetailPO;
import com.tydic.commodity.utils.MoneyUtils;
import com.tydic.commodity.zone.ability.bo.UccCostContractChangeAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccCostContractChangeAbilityRspBO;
import com.tydic.commodity.zone.ability.bo.UccCostContractDetailChangeBO;
import com.tydic.commodity.zone.busi.api.UccCostContractApprovalChangeBusiService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccCostContractApprovalChangeBusiServiceImpl
implements UccCostContractApprovalChangeBusiService {
    @Autowired
    private UccCostContractDetailEditMapper uccCostContractDetailEditMapper;
    @Autowired
    private UccCostContractDetailMapper uccCostContractDetailMapper;
    @Autowired
    private UccCostContractDetailEditLogMapper uccCostContractDetailEditLogMapper;

    @Override
    public UccCostContractChangeAbilityRspBO dealApprovalChange(UccCostContractChangeAbilityReqBO reqBO) {
        UccCostContractDetailEditPO check = new UccCostContractDetailEditPO();
        check.setSupplyCode(reqBO.getSupplyCode());
        check.setSpuContractId(reqBO.getSpuContractId());
        List detailEditPOS = this.uccCostContractDetailEditMapper.getList(check);
        if (!CollectionUtils.isEmpty((Collection)detailEditPOS)) {
            UccCostContractDetailEditPO updateStatus = new UccCostContractDetailEditPO();
            updateStatus.setSupplyCode(reqBO.getSupplyCode());
            updateStatus.setSpuContractCode(reqBO.getSpuContractCode());
            updateStatus.setSpuContractId(reqBO.getSpuContractId());
            this.uccCostContractDetailMapper.updateStatusByChange(updateStatus);
            UccCostContractDetailEditPO where = new UccCostContractDetailEditPO();
            where.setSupplyCode(reqBO.getSupplyCode());
            where.setSpuContractId(reqBO.getSpuContractId());
            this.uccCostContractDetailEditMapper.deleteBy(where);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getDetailChanges())) {
            UccCostContractDetailPO detailWhere = new UccCostContractDetailPO();
            detailWhere.setSpuContractDetailCodes(reqBO.getDetailChanges().stream().map(UccCostContractDetailChangeBO::getSpuContractDetailCode).collect(Collectors.toList()));
            UccCostContractDetailPO set = new UccCostContractDetailPO();
            set.setDetailStatus(UccConstants.COST_DETAIL_STOP);
            this.uccCostContractDetailMapper.updateBy(set, detailWhere);
            Date time = new Date();
            long batchId = Sequence.getInstance().nextId();
            List editPOS = reqBO.getDetailChanges().stream().map(e -> {
                UccCostContractDetailEditPO editPO = (UccCostContractDetailEditPO)JSONObject.parseObject((String)JSON.toJSONString((Object)e), UccCostContractDetailEditPO.class);
                editPO.setSpuContractId(reqBO.getSpuContractId());
                editPO.setSupplyCode(reqBO.getSupplyCode());
                editPO.setSupplyType(reqBO.getSupplyType());
                editPO.setExt2(e.getDesc());
                editPO.setExt1(e.getPreEnterTime());
                editPO.setBatchId(Long.valueOf(batchId));
                editPO.setSpuContractDetailId(Long.valueOf(Sequence.getInstance().nextId()));
                editPO.setNum(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)e.getNum())));
                editPO.setSalePrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)e.getSalePrice())));
                editPO.setAgreementPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)e.getAgreementPrice())));
                editPO.setCreateTime(time);
                editPO.setUpdateTime(time);
                return editPO;
            }).collect(Collectors.toList());
            try {
                this.uccCostContractDetailEditMapper.insertBatch(editPOS);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                throw new BusinessException("8888", "\u65b0\u589e\u7f16\u8f91\u8868\u6570\u636e\u5931\u8d25\uff01" + e2.getMessage());
            }
        }
        UccCostContractChangeAbilityRspBO rspBO = new UccCostContractChangeAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

