/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccCostContractDetailEditLogMapper;
import com.tydic.commodity.dao.UccCostContractDetailEditMapper;
import com.tydic.commodity.dao.UccCostContractDetailMapper;
import com.tydic.commodity.po.UccCostContractDetailEditLogPO;
import com.tydic.commodity.po.UccCostContractDetailEditPO;
import com.tydic.commodity.po.UccCostContractDetailPO;
import com.tydic.commodity.utils.MoneyUtils;
import com.tydic.commodity.zone.ability.bo.UccCostApprovalInfoBO;
import com.tydic.commodity.zone.ability.bo.UccCostContractChangeAbilityRspBO;
import com.tydic.commodity.zone.ability.bo.UccCostContractChangeApprovalReqBO;
import com.tydic.commodity.zone.busi.api.UccCostContractChangeApprovalBusiService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccCostContractChangeApprovalBusiServiceImpl
implements UccCostContractChangeApprovalBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccCostContractChangeApprovalBusiServiceImpl.class);
    @Autowired
    private UccCostContractDetailEditMapper uccCostContractDetailEditMapper;
    @Autowired
    private UccCostContractDetailMapper uccCostContractDetailMapper;
    @Autowired
    private UccCostContractDetailEditLogMapper uccCostContractDetailEditLogMapper;

    @Override
    public UccCostContractChangeAbilityRspBO dealContractChangeApproval(UccCostContractChangeApprovalReqBO reqBO) {
        block4: for (UccCostApprovalInfoBO approvalInfo : reqBO.getApprovalInfos()) {
            switch (approvalInfo.getAudit()) {
                case 4: {
                    this.dealPass(approvalInfo.getSpuContractCode(), approvalInfo.getSupplyCode());
                    continue block4;
                }
                case 2: {
                    this.dealRollBack(approvalInfo.getSpuContractCode(), approvalInfo.getSupplyCode());
                    continue block4;
                }
            }
            throw new BusinessException("8888", "\u5165\u53c2 audit \u4e0d\u5408\u6cd5\uff01\u4ec5\u9650 1\u901a\u8fc7 2\u9a73\u56de");
        }
        UccCostContractChangeAbilityRspBO rspBO = new UccCostContractChangeAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealRollBack(String spuContractCode, String supplyCode) {
        UccCostContractDetailEditPO selectEdit = new UccCostContractDetailEditPO();
        selectEdit.setSpuContractCode(spuContractCode);
        selectEdit.setSupplyCode(supplyCode);
        List contractDetailEditPOList = this.uccCostContractDetailEditMapper.getListJoinContract(selectEdit);
        if (!CollectionUtils.isEmpty((Collection)contractDetailEditPOList)) {
            List uccCostContractDetailEditLogPOS = contractDetailEditPOList.stream().map(e -> {
                UccCostContractDetailEditLogPO uccCostContractDetailEditLogPO = (UccCostContractDetailEditLogPO)JSONObject.parseObject((String)JSON.toJSONString((Object)e), UccCostContractDetailEditLogPO.class);
                return uccCostContractDetailEditLogPO;
            }).collect(Collectors.toList());
            try {
                this.uccCostContractDetailEditLogMapper.insertBatch(uccCostContractDetailEditLogPOS);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                throw new BusinessException("8888", "\u5904\u7406\u65e5\u5fd7\u4fe1\u606f\u5931\u8d25\uff01" + e2.getMessage());
            }
            UccCostContractDetailEditPO delete = new UccCostContractDetailEditPO();
            try {
                if (((UccCostContractDetailEditPO)contractDetailEditPOList.get(0)).getSpuContractId() == null) {
                    throw new BusinessException("8888", "\u5408\u540cid\u4e3a\u7a7a\uff01" + JSON.toJSONString(contractDetailEditPOList.get(0)));
                }
                delete.setSpuContractId(((UccCostContractDetailEditPO)contractDetailEditPOList.get(0)).getSpuContractId());
                delete.setSupplyCode(supplyCode);
                this.uccCostContractDetailEditMapper.deleteBy(delete);
            }
            catch (Exception e3) {
                e3.printStackTrace();
                throw new BusinessException("8888", "\u5220\u9664\u5408\u540c\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff01" + e3.getMessage());
            }
            List detailCodes = contractDetailEditPOList.stream().map(UccCostContractDetailEditPO::getSpuContractDetailCode).collect(Collectors.toList());
            UccCostContractDetailPO where = new UccCostContractDetailPO();
            where.setSpuContractId(((UccCostContractDetailEditPO)contractDetailEditPOList.get(0)).getSpuContractId());
            where.setSpuContractDetailCodes(detailCodes);
            UccCostContractDetailPO set = new UccCostContractDetailPO();
            set.setDetailStatus(UccConstants.COST_DETAIL_ENABLE);
            try {
                if (where.getSpuContractId() == null) {
                    throw new BusinessException("8888", "\u5408\u540cid\u4e3a\u7a7a\uff01" + JSON.toJSONString((Object)where));
                }
                this.uccCostContractDetailMapper.updateBy(set, where);
            }
            catch (Exception e4) {
                e4.printStackTrace();
                throw new BusinessException("8888", "\u66f4\u65b0\u660e\u7ec6\u4fe1\u606f\u72b6\u6001\u5931\u8d25\uff01" + e4.getMessage());
            }
        }
    }

    private void dealPass(String spuContractCode, String supplyCode) {
        UccCostContractDetailEditPO selectEdit = new UccCostContractDetailEditPO();
        selectEdit.setSpuContractCode(spuContractCode);
        selectEdit.setSupplyCode(supplyCode);
        List contractDetailEditPOList = this.uccCostContractDetailEditMapper.getListJoinMain(selectEdit);
        ArrayList<String> detailCodes = new ArrayList<String>();
        if (!CollectionUtils.isEmpty((Collection)contractDetailEditPOList)) {
            for (UccCostContractDetailEditPO detailEditPO : contractDetailEditPOList) {
                UccCostContractDetailPO where = new UccCostContractDetailPO();
                where.setSpuContractDetailCode(detailEditPO.getSpuContractDetailCode());
                UccCostContractDetailPO set = new UccCostContractDetailPO();
                set.setExt1(detailEditPO.getExt1());
                set.setExt2(detailEditPO.getExt2());
                set.setDetailStatus(UccConstants.COST_DETAIL_ENABLE);
                set.setSalePrice(detailEditPO.getSalePrice());
                set.setAgreementPrice(detailEditPO.getAgreementPrice());
                try {
                    if (detailEditPO.getNum() < 0L) {
                        BigDecimal abs = MoneyUtils.haoToYuan((Long)detailEditPO.getNum()).abs();
                        set.setPurchaseNum(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)abs)));
                        set.setSubtractNum(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)abs)));
                        this.uccCostContractDetailMapper.updateBy(set, where);
                    } else {
                        set.setPurchaseNum(detailEditPO.getNum());
                        set.setNum(detailEditPO.getNum());
                        this.uccCostContractDetailMapper.addPurchase(set, where);
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    throw new BusinessException("8888", "\u540c\u6b65\u5df2\u5b58\u5728\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff01" + e2.getMessage());
                }
                detailCodes.add(detailEditPO.getSpuContractDetailCode());
            }
        }
        selectEdit.setExcludeDetailCodes(detailCodes);
        List contractNewDetailEditPOList = this.uccCostContractDetailEditMapper.getListJoinMainNotExsit(selectEdit);
        if (!CollectionUtils.isEmpty((Collection)contractNewDetailEditPOList)) {
            List detailNewPos = contractNewDetailEditPOList.stream().map(e -> {
                UccCostContractDetailPO detailPO = (UccCostContractDetailPO)JSONObject.parseObject((String)JSON.toJSONString((Object)e), UccCostContractDetailPO.class);
                detailPO.setSpuContractDetailId(Long.valueOf(Sequence.getInstance().nextId()));
                detailPO.setPurchaseNum(e.getNum());
                detailPO.setSpuContractId(e.getSpuContractId());
                detailPO.setNum(e.getNum());
                detailPO.setCreateTime(e.getCreateTime());
                detailPO.setDetailStatus(UccConstants.COST_DETAIL_ENABLE);
                detailPO.setCancelNum(Long.valueOf(0L));
                detailPO.setExt1(e.getExt1());
                detailPO.setExt2(e.getExt2());
                return detailPO;
            }).collect(Collectors.toList());
            try {
                this.uccCostContractDetailMapper.insertBatch(detailNewPos);
            }
            catch (Exception e3) {
                e3.printStackTrace();
                throw new BusinessException("8888", "\u5904\u7406\u65b0\u589e\u660e\u7ec6\u4fe1\u606f\u5f02\u5e38\uff01" + e3.getMessage());
            }
        }
        Long contractId = null;
        try {
            ArrayList editPOArrayList = new ArrayList();
            editPOArrayList.addAll(contractDetailEditPOList);
            editPOArrayList.addAll(contractNewDetailEditPOList);
            if (!CollectionUtils.isEmpty(editPOArrayList)) {
                contractId = ((UccCostContractDetailEditPO)editPOArrayList.get(0)).getSpuContractId();
                List uccCostContractDetailEditLogPOS = editPOArrayList.stream().map(e -> {
                    UccCostContractDetailEditLogPO editLogPO = (UccCostContractDetailEditLogPO)JSONObject.parseObject((String)JSON.toJSONString((Object)e), UccCostContractDetailEditLogPO.class);
                    return editLogPO;
                }).collect(Collectors.toList());
                this.uccCostContractDetailEditLogMapper.insertBatch(uccCostContractDetailEditLogPOS);
            }
        }
        catch (Exception e4) {
            e4.printStackTrace();
            log.error("\u65b0\u589e\u660e\u7ec6\u53d8\u52a8\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25\uff01" + e4.getMessage());
        }
        try {
            this.uccCostContractDetailEditMapper.deleteByContractId(contractId, supplyCode);
        }
        catch (Exception e5) {
            e5.printStackTrace();
            throw new BusinessException("8888", "\u5220\u9664\u7f16\u8f91\u8868\u5408\u540c\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff01" + e5.getMessage());
        }
    }
}

