/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccCostContractAlterRecordMapper;
import com.tydic.commodity.dao.UccCostContractDetailEditMapper;
import com.tydic.commodity.dao.UccCostContractDetailMapper;
import com.tydic.commodity.dao.UccCostContractMapper;
import com.tydic.commodity.po.UccCostContractAlterRecordPO;
import com.tydic.commodity.po.UccCostContractDetailEditPO;
import com.tydic.commodity.po.UccCostContractDetailPO;
import com.tydic.commodity.utils.MoneyUtils;
import com.tydic.commodity.zone.ability.bo.UccCostContractChangeAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccCostContractChangeAbilityRspBO;
import com.tydic.commodity.zone.ability.bo.UccCostContractDetailChangeBO;
import com.tydic.commodity.zone.busi.api.UccCostContractChangeBusiService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccCostContractChangeBusiServiceImpl
implements UccCostContractChangeBusiService {
    @Autowired
    private UccCostContractDetailMapper uccCostContractDetailMapper;
    @Autowired
    private UccCostContractAlterRecordMapper uccCostContractAlterRecordMapper;
    @Autowired
    private UccCostContractDetailEditMapper uccCostContractDetailEditMapper;
    @Autowired
    private UccCostContractMapper uccCostContractMapper;

    @Override
    public UccCostContractChangeAbilityRspBO dealContractChange(UccCostContractChangeAbilityReqBO reqBO) {
        if (!CollectionUtils.isEmpty((Collection)reqBO.getDetailChanges())) {
            this.dealChangeStatus(reqBO);
            List<UccCostContractDetailEditPO> uccCostContractDetailEditPOS = this.dealAddEdit(reqBO);
            this.dealAddAlterRecord(uccCostContractDetailEditPOS);
        }
        UccCostContractChangeAbilityRspBO rspBO = new UccCostContractChangeAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealAddAlterRecord(List<UccCostContractDetailEditPO> uccCostContractDetailEditPOS) {
        Date time = new Date();
        List alterRecordPOS = uccCostContractDetailEditPOS.stream().map(e -> {
            UccCostContractAlterRecordPO recordPO = (UccCostContractAlterRecordPO)JSONObject.parseObject((String)JSON.toJSONString((Object)e), UccCostContractAlterRecordPO.class);
            recordPO.setUccCostContractDetailCode(e.getSpuContractDetailCode());
            recordPO.setSpuContractDetailId(e.getSpuContractDetailId());
            recordPO.setSkuCode(e.getSkuCode());
            recordPO.setSkuId(e.getSkuId());
            recordPO.setAlterTime(time);
            recordPO.setAlterNum(e.getNum());
            recordPO.setAlterBatchId(e.getBatchId());
            recordPO.setAlterRecordId(Long.valueOf(Sequence.getInstance().nextId()));
            recordPO.setSupplyCode(recordPO.getSupplyCode());
            recordPO.setSupplyType(recordPO.getSupplyType());
            return recordPO;
        }).collect(Collectors.toList());
        try {
            this.uccCostContractAlterRecordMapper.insertBatch(alterRecordPOS);
        }
        catch (Exception e2) {
            throw new BusinessException("8888", "\u65b0\u589e\u53d8\u66f4\u8bb0\u5f55\u4fe1\u606f\u5931\u8d25\uff01" + e2.getMessage());
        }
    }

    private List<UccCostContractDetailEditPO> dealAddEdit(UccCostContractChangeAbilityReqBO reqBO) {
        Date time = new Date();
        long batchId = Sequence.getInstance().nextId();
        List<UccCostContractDetailEditPO> costContractDetailEditPOS = reqBO.getDetailChanges().stream().map(e -> {
            UccCostContractDetailEditPO editPO = (UccCostContractDetailEditPO)JSONObject.parseObject((String)JSON.toJSONString((Object)e), UccCostContractDetailEditPO.class);
            editPO.setAgreementPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)e.getAgreementPrice())));
            editPO.setSalePrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)e.getSalePrice())));
            editPO.setNum(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)e.getNum())));
            editPO.setSpuContractId(reqBO.getSpuContractId());
            editPO.setCreateTime(time);
            editPO.setUpdateTime(time);
            editPO.setBatchId(Long.valueOf(batchId));
            editPO.setSpuContractDetailId(Long.valueOf(Sequence.getInstance().nextId()));
            editPO.setExt1(e.getPreEnterTime());
            editPO.setExt2(e.getDesc());
            editPO.setSkuCode(e.getSkuCode());
            editPO.setSkuId(e.getSkuId());
            editPO.setDetailStatus(UccConstants.COST_DETAIL_ENABLE);
            editPO.setSupplyCode(reqBO.getSupplyCode());
            editPO.setSupplyType(reqBO.getSupplyType());
            return editPO;
        }).collect(Collectors.toList());
        try {
            this.uccCostContractDetailEditMapper.insertBatch(costContractDetailEditPOS);
        }
        catch (Exception e2) {
            throw new BusinessException("8888", "\u65b0\u589e\u53d8\u66f4\u6570\u636e\u5931\u8d25\uff01" + e2.getMessage());
        }
        return costContractDetailEditPOS;
    }

    private void dealChangeStatus(UccCostContractChangeAbilityReqBO reqBO) {
        try {
            List spuContractDetailCodes = reqBO.getDetailChanges().stream().map(UccCostContractDetailChangeBO::getSpuContractDetailCode).collect(Collectors.toList());
            UccCostContractDetailPO set = new UccCostContractDetailPO();
            set.setDetailStatus(UccConstants.COST_DETAIL_STOP);
            UccCostContractDetailPO where = new UccCostContractDetailPO();
            where.setSpuContractDetailCodes(spuContractDetailCodes);
            int n = this.uccCostContractDetailMapper.updateBy(set, where);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("8888", "\u66f4\u65b0\u534f\u8bae\u660e\u7ec6\u72b6\u6001\u5931\u8d25\uff01" + e.getMessage());
        }
    }
}

