/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.busi.impl;

import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccCommdStatusRecordMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccCommdStatusRecordPO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.zone.ability.bo.UccUmcBlackMessageBo;
import com.tydic.commodity.zone.busi.api.UccDealUmcBlackBusiService;
import com.tydic.commodity.zone.busi.bo.UccBlackDealRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
@Transactional(propagation=Propagation.REQUIRES_NEW)
public class UccDealUmcBlackBusiServiceImpl
implements UccDealUmcBlackBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccDealUmcBlackBusiServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccCommdStatusRecordMapper uccCommdStatusRecordMapper;

    @Override
    public UccBlackDealRspBO dealUmcBlack(UccUmcBlackMessageBo messageBo) {
        Date time = new Date();
        if (messageBo.getFreeze() == 1) {
            for (Long supplierId : messageBo.getSupplierIds()) {
                this.dealStatusRecord(supplierId, messageBo.getOperId(), messageBo.getOperName(), time);
                this.dealStatucChange(supplierId, messageBo.getOperId(), messageBo.getOperName(), time);
            }
        } else {
            for (Long supplierId : messageBo.getSupplierIds()) {
                this.dealStatusRollBack(supplierId, messageBo.getOperId(), messageBo.getOperName(), time);
            }
        }
        Map<Long, List<Long>> skuMap = this.dealCollectSkuInfo(messageBo.getSupplierIds());
        UccBlackDealRspBO rspUccBo = new UccBlackDealRspBO();
        rspUccBo.setSkuMap(skuMap);
        rspUccBo.setRespCode("0000");
        rspUccBo.setRespDesc("\u6210\u529f");
        return rspUccBo;
    }

    private Map<Long, List<Long>> dealCollectSkuInfo(List<Long> supplierIds) {
        HashMap<Long, List<Long>> skuMap = new HashMap<Long, List<Long>>();
        List skuPos = this.uccSkuMapper.querySkuIds(supplierIds);
        Map<Long, List<UccSkuPo>> listMap = skuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
        for (Long id : listMap.keySet()) {
            List<UccSkuPo> uccSkuPos = listMap.get(id);
            List skuIds = uccSkuPos.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
            skuMap.put(id, skuIds);
        }
        return skuMap;
    }

    private void dealStatusRollBack(Long supplierId, Long operId, String operName, Date time) {
        try {
            this.uccSkuMapper.updateStatusRollBack(supplierId, operId, operName, time);
            this.uccCommodityMapper.updateStatusRollBack(supplierId, operId, operName, time);
            UccCommdStatusRecordPO recordPO = new UccCommdStatusRecordPO();
            recordPO.setSupplierShopId(supplierId);
            this.uccCommdStatusRecordMapper.deleteBy(recordPO);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("8888", "\u5546\u54c1\u72b6\u6001\u56de\u9000\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    private void dealStatucChange(Long supplierId, Long operId, String operName, Date time) {
        try {
            this.uccSkuMapper.updateSkuBySupId(supplierId, operId, operName, time);
            this.uccCommodityMapper.updateCommodityBySupId(supplierId, operId, operName, time);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("8888", "\u66f4\u65b0\u72b6\u6001\u4e3a\u51bb\u7ed3\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    private void dealStatusRecord(Long supplierId, Long operId, String operName, Date time) {
        ArrayList statusRecordPOS = new ArrayList();
        List skuPos = this.uccSkuMapper.queryStatusBySupId(supplierId);
        List spuPos = this.uccCommodityMapper.queryStatusBySupId(supplierId);
        if (!CollectionUtils.isEmpty((Collection)skuPos)) {
            List commdStatusRecordPOS = skuPos.stream().map(e -> {
                UccCommdStatusRecordPO uccCommdStatusRecordPO = new UccCommdStatusRecordPO();
                if (!ObjectUtils.isEmpty((Object)operId)) {
                    uccCommdStatusRecordPO.setOperId(operId.toString());
                }
                uccCommdStatusRecordPO.setSourceId(e.getSkuId());
                uccCommdStatusRecordPO.setOperName(operName);
                uccCommdStatusRecordPO.setOperTime(time);
                uccCommdStatusRecordPO.setType(Integer.valueOf(2));
                uccCommdStatusRecordPO.setApprovalStatus(e.getApprovalStatus());
                uccCommdStatusRecordPO.setStatus(e.getSkuStatus());
                uccCommdStatusRecordPO.setSupplierShopId(e.getSupplierShopId());
                return uccCommdStatusRecordPO;
            }).collect(Collectors.toList());
            statusRecordPOS.addAll(commdStatusRecordPOS);
        }
        if (!CollectionUtils.isEmpty((Collection)spuPos)) {
            List uccCommdStatusRecordPOS = spuPos.stream().map(e -> {
                UccCommdStatusRecordPO uccCommdStatusRecordPO = new UccCommdStatusRecordPO();
                if (!ObjectUtils.isEmpty((Object)operId)) {
                    uccCommdStatusRecordPO.setOperId(operId.toString());
                }
                uccCommdStatusRecordPO.setSourceId(e.getCommodityId());
                uccCommdStatusRecordPO.setOperName(operName);
                uccCommdStatusRecordPO.setOperTime(time);
                uccCommdStatusRecordPO.setType(Integer.valueOf(1));
                uccCommdStatusRecordPO.setApprovalStatus(e.getApprovalStatus());
                uccCommdStatusRecordPO.setStatus(e.getCommodityStatus());
                uccCommdStatusRecordPO.setSupplierShopId(e.getSupplierShopId());
                return uccCommdStatusRecordPO;
            }).collect(Collectors.toList());
            statusRecordPOS.addAll(uccCommdStatusRecordPOS);
        }
        if (!CollectionUtils.isEmpty(statusRecordPOS)) {
            try {
                this.uccCommdStatusRecordMapper.insertBatch(statusRecordPOS);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                throw new BusinessException("8888", "\u65b0\u589e\u5546\u54c1\u3001\u5355\u54c1\u72b6\u6001\u8bb0\u5f55\u5f02\u5e38\uff01" + e2.getMessage());
            }
        }
    }
}

